#!/bin/bash

COMM_SCRIPTDIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
NOTE_INFO="#eReplication_TO_oc"
CONFIG_TOOL="${SCRIPTDIR}/../ha/module/hacom/tools/ha_config_tool"
COMM_BCMANAGER_PATH="${COMM_SCRIPTDIR}/../.."
G_IFCONFIG="$(which ifconfig)"
G_ARPING="$(which arping)"
G_RUNNING=0
G_STOPED=2
G_STARTING=4
G_STOPING=5
G_RUNNING_ACTIVE=6
G_RUNNING_STANDBY=7
ha_properties="$COMM_SCRIPTDIR/../ha/local/conf/ha.properties"
NODE_PROPERTIES_FILE="${COMM_SCRIPTDIR}/../NodeAgent/conf/nodeAgent.properties"

declare CURDIR=`dirname $0`
declare CURPATH=`readlink -f $CURDIR`

function changePermissionIfDiff() {
    local permission=`stat -c %a "$1"`
    if [ "$permission" = "600" ] ;then
      return
    else
      sudo -u "$2" -S chmod 600 "$1"  &>/dev/null
    fi
}

function changeLogsAuth()
{
    local userFile=$COMM_SCRIPTDIR/config/conf/startInfo.properties
    local wccLog4j=$COMM_SCRIPTDIR/../LegoRuntime/conf/wcc/log4j.properties
    local nodeAgentProperties=$COMM_SCRIPTDIR/../NodeAgent/conf/nodeAgent.properties
    local nodeAgentPwdProperties=$COMM_SCRIPTDIR/../NodeAgent/conf/nodeAgent-pwd.properties
    local RuntimePath=$COMM_BCMANAGER_PATH/Runtime/logs
    local binPath=$COMM_BCMANAGER_PATH/Runtime/bin/logs
    local arbLog=$COMM_BCMANAGER_PATH/Runtime/LegoRuntime/logs/Arb
    local groupName=`cat "$userFile" | grep -v '^#' | grep "custom.user.group" | awk -F = '{print $2}' | tr -d '\r\n'`
    local sysUser=`cat "$userFile" | grep -v '^#' | grep custom.user.name |awk -F = '{print $2}'| tr -d '\r\n'`

    if [ -d "$binPath" ];then
        chmod g+s "$binPath" &>/dev/null
        chmod -R 750 "$binPath" &>/dev/null
        chmod 640 `find "$binPath" -type f` &>/dev/null
        chgrp -R "$groupName" "$binPath" &>/dev/null
    fi
  
    if [ -d "$RuntimePath" ];then
        chmod g+s "$RuntimePath" &>/dev/null
        chmod 750 "$RuntimePath" &>/dev/null
        chmod -R 750 "$RuntimePath"/* &>/dev/null 
        chmod 640 `find "$RuntimePath" -type f` &>/dev/null
        chmod 440 `find "${RuntimePath}" -name "ha*.log.*.gz"` &>/dev/null
        chmod 660 "$RuntimePath"/DataCollectRun.log &>/dev/null
        chgrp -R "$groupName" "$RuntimePath" &>/dev/null
    fi

    #wcc log file will be writed by Tomcat,ICUser and root
    local wccLogFile=`cat "$wccLog4j" | grep appender.rolling.fileName | awk -F= '{print $2}'`
    if [ ! -f "$wccLogFile" ];then
        touch "$wccLogFile" &>/dev/null
    fi
	
    chgrp "$groupName" "$wccLogFile" &>/dev/null
    sudo -u $sysUser -S chmod 660 "$wccLogFile"  &>/dev/null
    sudo -u $sysUser -S chmod 600 "$nodeAgentProperties"  &>/dev/null
    changePermissionIfDiff "$nodeAgentPwdProperties" "$sysUser"

    if [[ -d "${arbLog}" ]]; then
        sudo -u $sysUser -S chmod 440 `find "$arbLog" -name "*.zip"` &>/dev/null
    fi
}

function zipLog()
{
    local logName=$1
    if [ ! -f "$logName" ];then
        return
    fi

    local MAXLOGSIZE=10485760
    local LOGFILE_SUFFIX="gz"
    local LOG_FILE_PATH=`dirname "$logName"`
    local LOG_FILE_NAME_USE=`basename "$logName"`
    local BACKLOGCOUNT=`ls -l ${LOG_FILE_PATH} | grep "${LOG_FILE_NAME_USE}" | grep ${LOGFILE_SUFFIX}$ |wc -l`

    local LOGFILESIZE=`ls -l "$logName" | awk -F " " '{print $5}'`
    if [ ${LOGFILESIZE} -gt ${MAXLOGSIZE} ]
    then
        gzip -f -q -9 "$logName"
        local FILENAME_DATE=`date +"%y-%m-%d-%H:%M:%S"`
        local srcName="$logName.${LOGFILE_SUFFIX}"
        local destName="$logName.${FILENAME_DATE}.${LOGFILE_SUFFIX}" 
        mv "$srcName" "$destName"
        chmod 440 "$destName" &>/dev/null 
    fi
    
    if [ $BACKLOGCOUNT -gt 10 ]
    then
        local cur_path=`pwd`
        cd "${LOG_FILE_PATH}"
        local deleteLogName=`ls ${LOG_FILE_NAME_USE}* |sort | sed -n "2p"`
        rm -rf ${deleteLogName}
        pushd "$cur_path" &>/dev/null
    fi
}

function Log()
{
    local log_file_path=`dirname ${LOG_FILE_NAME}`
    if [ ! -x "${log_file_path}" ]
    then
        mkdir ${log_file_path}
        chmod 750 "${log_file_path}"
        chmod g+s "${log_file_path}"
    fi
    
    if [ ! -f "${LOG_FILE_NAME}" ]
    then
        touch "${LOG_FILE_NAME}"
        chmod 640 "${LOG_FILE_NAME}"
    fi

    local permission=`stat -c %a ${LOG_FILE_NAME} | head -n 1`
    if [ "${permission}" != 640 ];then
        chmod 640 "${LOG_FILE_NAME}"
    fi

    DATE=[`date +"%Y/%m/%d %H:%M:%S"`]
    local user_name=`whoami`
    echo "${DATE}:[$$][${user_name}] $1" >> "${LOG_FILE_NAME}"
    zipLog "$LOG_FILE_NAME"
}

function getLegoFile()
{
    local legoFile=/etc/profile.d/lego.sh
    local installFile=/home/ICUser/RDInstalled.xml
    if [ -z "${LEGO_HOME}" ] || [ ! -d "${LEGO_HOME}" ];
    then
        if [ -f "$legoFile" ];
        then
            . $legoFile
        elif [ -f "$installFile" ];
        then
            LEGO_HOME=`cat $installFile | grep installpath | cut -f2 -d "\""`
        else
            echo "get LEGO_HOME failed." 1>> "$LOG_FILE_NAME" 2>&1
        fi
    fi
    legoHome=${LEGO_HOME}
    #find properties in config/conf/startInfo.properties while install eReplication
    local confileFile=config/conf/startInfo.properties
    #find properties in $COMM_SCRIPTDIR while management eReplication
    if [ -f "$COMM_SCRIPTDIR/$confileFile" ];then
        confileFile=$COMM_SCRIPTDIR/$confileFile
    fi
    
    if [ ! -f "$confileFile" ];then
        return
    fi
    G_SYS_USER_NAME=`cat "$confileFile" | grep -v '^#' | grep "custom.user.name" | awk -F = '{print $2}' | tr -d '\r\n'`
    G_USER_GROUP_NAME=`cat "$confileFile" | grep -v '^#' | grep "custom.user.group" | awk -F = '{print $2}' | tr -d '\r\n'`
    G_TOMCAT_USER_NAME=`cat "$confileFile" | grep -v '^#' | grep tomcat.user.name | awk -F = '{print $2}'| tr -d '\r\n'`
}

function GetFloatIP()
{
    if [ -z "${G_BCMANAGER_RUNTIME_PATH}" ]
    then
        G_BCMANAGER_RUNTIME_PATH="${COMM_SCRIPTDIR}/../"
    fi
    local HAARB_XML=$G_BCMANAGER_RUNTIME_PATH/ha/module/haarb/conf/haarb.xml

    local L_IP=$(sed -n "s/.*arpip.*value=\"\(.*\)\".*/\1/p" ${HAARB_XML})
    echo "$L_IP"
}

function GetHAMode()
{
    if [ -z "${G_BCMANAGER_RUNTIME_PATH}" ]
    then
        G_BCMANAGER_RUNTIME_PATH="${COMM_SCRIPTDIR}/../"
    fi
    local HACOM_XML=$G_BCMANAGER_RUNTIME_PATH/ha/module/hacom/conf/hacom.xml
    
    local L_HA_MODE=$(sed -n 's/.*hamode.*value=\"\(.*\)\".*/\1/p' ${HACOM_XML})
    echo "$L_HA_MODE"
}

function getHARole()
{
    if [ -z "${G_BCMANAGER_RUNTIME_PATH}" ]
    then
        G_BCMANAGER_RUNTIME_PATH="${COMM_SCRIPTDIR}/../"
    fi
    
    local L_HA_ROLE=`${G_BCMANAGER_RUNTIME_PATH}/ha/module/hacom/script/get_harole.sh`
    echo "$L_HA_ROLE"
}

checkPortFormat()
{
  local port=$1
  echo "$port" | grep '^[[:digit:]]*$' &>/dev/null;iRet=$?
  if [ -z "$port" ] || [ $iRet != 0 ];then
      Log "Port is error, port=$port"
      return 1
  fi

  if [ $port -lt 1 ] || [ $port -gt 65535 ];then
      Log "Port is error, port=$port"
      return 1
  fi
  return 0
}

checkPortUsed()
{
    usedPortFile="$COMM_SCRIPTDIR"/usedPortTmp
    if [ -f "$usedPortFile" ];then
        rm -f usedPortFile
    fi
    inUse="false"
    portsList=`cat "$PortFile" | grep -v '^#' | grep -v 'windows'`
    for str in $portsList
    do
       Lport=`echo $str | awk -F = '{print $2}' | tr -d '\r\n'`
       keyName=`echo $str | awk -F = '{print $1}' | tr -d '\r\n'`
       gaussPort=`echo $keyName | grep "gauss"`
       if [ -z "$Lport" ] || [ ! -z "$gaussPort" ];then
           continue
       fi
       ports=(`netstat -ntul | awk '{print $4}' | awk -F: '{print $2 $4}' | grep $Lport`)
       for port in "${ports[@]}"
       do
           if [ "$port" = "$Lport" ]; then
               echo $keyName=$port  >> "$usedPortFile"
               break
           fi
       done       

    done

    if [ -f "$usedPortFile" ];then
       Log "$1"
       Log "used port: `cat $usedPortFile`" 
       rm -f $usedPortFile 1>/dev/null 2>&1
       return 1
    fi
    return 0
}

function getClassPath()
{
    local LIBS="$1"
    local LIBS_PATH="$2"
    classList=
    if [ "$LIBS_PATH" = "" ]
    then
        LIBS_PATH=lib
    fi
    
    if [ -z "$LIBS" ];then
        return 1
    fi 
    local cur=`pwd`
    pushd "$COMM_SCRIPTDIR" &>/dev/null
    libsList=`echo $LIBS | sed 's/ /\*/g' | sed 's/;/ /g'`
    for libFile in  $libsList
    do
        fileName=`ls "$LIBS_PATH/$libFile"*`
        for file in $fileName
        do
            classList=$classList:$file    
        done
    done
    CLASSPATH=`echo ${classList:1}`
    pushd "$cur" &>/dev/null
}


function checkPort()
{
    #Isure the server of eReplication was stopped before check port.
    local startInfoFile="$COMM_SCRIPTDIR/config/conf/startInfo.properties"
    local OSGI_USER=`cat "$startInfoFile" | grep -v '^#' | grep "custom.user.name" | awk -F = '{print $2}' | tr -d '\r\n'`
    local installPath=`cat "$COMM_SCRIPTDIR/config/conf/config.properties" | grep linux.default.install.path | awk -F= '{print $2}'`
    local backPid=`ps -efww | grep java | grep "$OSGI_USER" | grep jre6.0.18 | grep equinox | awk  '{print $2}'`
    local frontPid=`ps -efww | grep java | grep Tomcat  | awk '{print $2}'`
    if [ ! -z "$backPid" ];then
        Log "[INFO] find the back progress[$backPid] is running, kill it before check port."
        kill -9 $backPid 1>> "$LOG_FILE_NAME"  2>&1
    fi
    if [ ! -z "$frontPid" ];then
        Log "[INFO] find the front progress[$frontPid] is running, kill it before check port."
        kill -9 $frontPid 1>> "$LOG_FILE_NAME"  2>&1
    fi

    local CUR_PATH=`pwd`
    local PortFile=$COMM_SCRIPTDIR/config/conf/port.ini
    local confFile=$COMM_SCRIPTDIR/lego.properties
    local language=$COMM_SCRIPTDIR/config/lauguages/common_en.properties
    local illegalFile="$COMM_SCRIPTDIR/illegalTmpFile"
    local oldPort=`cat "$confFile" | grep -v '^#' | grep http.port |awk -F = '{print $2}'| tr -d '\r\n'`
    local oldRedirectPort=`cat "$confFile" | grep -v '^#' | grep http.redirect.port |awk -F = '{print $2}'| tr -d '\r\n'`
    local newHttpPort=`cat "$PortFile"| grep -v '^#' | grep http.port |awk -F = '{print $2}'| tr -d '\r\n'`
    local newHttpRedirectPort=`cat "$PortFile"| grep -v '^#' | grep linux.http.to.https.redirect.port |awk -F = '{print $2}'| tr -d '\r\n'`
    local port_illegal=`cat "$language"| grep -v '^#' | grep start.err.10011 |awk -F = '{print $2}'| tr -d '\r\n'`
    local port_used=`cat "$language"| grep -v '^#' | grep start.err.10012 |awk -F = '{print $2}'| tr -d '\r\n'`
    local updatePortFailed=`cat "$language"| grep -v '^#' | grep start.err.10013 |awk -F = '{print $2}'| tr -d '\r\n'`
    local CHECK_CLASSPATH="install;commons-codec;slf4j-api;one-track-4-kmc;wcc_helper;slf4j-reload4j;commons-lang3;dom4j;jaxen;legoLog;log4j-api;log4j-core;log4j-1.2-api;disruptor;Lego-Core-Log-Bundle;Lego-Core-SDK-Bundle;commons-logging;lombok;httpclient5;httpcore5;spring-jcl;spring-core;jackson-databind;jackson-core;jackson-annotations"
    getClassPath "$CHECK_CLASSPATH"
    rm -fr "$illegalFile" 1>/dev/null 2>&1
    cd "$COMM_SCRIPTDIR"
    "$COMM_SCRIPTDIR/../jre6.0.18/bin/java" -cp "$CLASSPATH" com.huawei.lego.common.changeport.ChangePort checkPort 1>/dev/null 2>&1
    if [ $? != 0 ];then
        if [ -f "$illegalFile" ];then
            Log "checkPort failed, port: `cat $illegalFile`"
            rm -fr "$illegalFile" 1>/dev/null 2>&1
            return 1
        fi
    fi

    checkPortUsed "$port_used"
    if [ $? != 0 ];then
        return 1
    fi
    "$COMM_SCRIPTDIR/../jre6.0.18/bin/java" -cp "$CLASSPATH" com.huawei.lego.common.changeport.ChangePort updatePort 1>/dev/null 2>&1
    if [ $? != 0 ];then
        Log "$updatePortFailed"
        return 1
    fi

    if [ "$oldPort" != "$newHttpPort" ] || [ "$oldRedirectPort" != "$newHttpRedirectPort" ];then
        iptables -D PREROUTING -t nat -p tcp --dport $oldPort -j REDIRECT --to-port $oldRedirectPort >/dev/null 2>&1
        iptables -t nat -A PREROUTING -p tcp --dport $newHttpPort -j REDIRECT --to-port $newHttpRedirectPort
        sed -i -r "/http.port=/s/(http.port=)[^ ](.*)/\1$newHttpPort/" "$confFile"
        sed -i -r "/http.redirect.port=/s/(http.redirect.port=)[^ ](.*)/\1$newHttpRedirectPort/" "$confFile"
    fi
    cd "$CUR_PATH"
    return 0
}

#####################################################################
## @Usage Report_alarm
## @Return 0 
## @Description 上报告警，打印相应日志,不能上报是否成功都应该给HA返回0
#####################################################################
function Report_alarm()
{
    Log "report alarm: --type $TYPE --severity $SEVERITY --alarmId $ALARMID --createTime $CREATETIME --param $PARAM --peerRestore $peerRestore"
    if [ -z "$TYPE" ];then
        Log "TYPE is null."
        return 0
    fi

    local peerRestore=false
    [ ! -z "$IS_PEER_RESTORE" ] && peerRestore=$IS_PEER_RESTORE
    pushd ${CURPATH}/../../../../../bin/
    nohup sh reportAlarm.sh --type $TYPE --severity $SEVERITY --alarmId $ALARMID --createTime $CREATETIME --param "$PARAM" --peerRestore "$peerRestore" &
    popd

    Log "Report_alarm over  $CREATETIME" 
    return 0
}

######################################################################
#   DESCRIPTION: 校验IP是否合法
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function validIP()
{
    if [ -z "$1" ]; then
        Log "[Error] The IP address is null."
        return 1
    fi
    
    if [ "127.0.0.1" = "$1" ];then
        Log "[Error] The IP address $1 is invaild."
        return 1
    fi
    
    checkIPFormat "$1"
    if [ $? -ne 0 ]; then
        Log "[Error] The IP address $1 is invalid. check ip format failed."
        return 1
    fi
    
    ${CONFIG_TOOL} "-c" "$1"
    if [ $? -ne 0 ]; then 
        Log "[Error] The IP address $1 is invalid. config tool check error."
        return 1
    fi
    
    return 0
}

function Substr()
{
    from=$2
    if [ $# -eq 2 ]
    then
        echo $1 | awk -v bn="$from" '{print substr($1,bn)}'
    elif [ $# -eq 3 ]
    then
        len=$3
        echo $1 | awk -v bn="$from" -v ln="$len" '{print substr($1,bn,ln)}'
    fi
}

function CheckString()
{
    local strParam="$1"
    local Ret=0
    echo "$strParam" | grep '[[:digit:]]' > /dev/null 2>&1
    [ $? -eq 0 ] && Ret=`expr $Ret + 1`
    echo "$strParam" | grep '[[:lower:]]' > /dev/null 2>&1
    [ $? -eq 0 ] && Ret=`expr $Ret + 1`
    echo "$strParam" | grep '[[:upper:]]' > /dev/null 2>&1
    [ $? -eq 0 ] && Ret=`expr $Ret + 1`
    echo "$strParam" | grep -E "[~]|[!]|[@]|[#]|[$]|[%]|[\^]|[&]|[*]|[(]|[)]|[-]|[_]|[=]|[+]|[|]|[\]|[[]|[]]|[;]|[{]|[}]|[:]|[']|[\"]|[,]|[<]|[.]|[>]|[/]|[?]" > /dev/null 2>&1
    [ $? -eq 0 ] && Ret=`expr $Ret + 1`
    
    return $Ret
}

function checkInputNumberLength()
{
    if [ `echo "$1" | wc -c` -gt 6 ]; then   # -gt 6 maybe means biger than 65536
        return 1
    fi
    return 0
}

function echoInfo()
{
    echo "$(date +'%Z %Y-%m-%d %H:%M:%S')   $1" 
    return 0
}

# this function is being used after the eReplication Server was installed successfully.
function getLocalIpAddr()
{
    local current_ip=`getInstallInfo | grep INSTALL1_IP | awk -F= '{print $2}'`
    checkIPV4Address "$current_ip"
    if [ $? -eq 0 ];then
        echo `getAllIPv4Address | grep ALL_IP4 | awk -F= '{print $2}'`
    else
        echo `getAllIPv6Address | grep ALL_IPV6 | awk -F= '{print $2}'`
    fi
}

function IsEuler2()
{
    #is not euler
    if [ ! -f /etc/euleros-release ]; then
      return 0
    fi
    
    #euler
    LINE=`cat /etc/euleros-release`
    OS_VERSION=`echo "$LINE" | awk -F '.' '{print $1}'|awk '{print $NF}'`
    if [ "$OS_VERSION" = "2" ]; then
        return 1
    fi
    
    NETMASK=`ifconfig | grep -iw netmask`
    if [ ! -z "$NETMASK" ]; then
        return 1
    fi
    return 0
}

function getAdapterInfoByDeviceName()
{
    local deviceName=$1
    if [ -z "$deviceName" ];then
        Log "Failed to get device info by name, the name is empty."
        return 1
    fi
    Log "start getAdapterInfoByDeviceName, name: $deviceName"
    IsEuler2
    if [ $? -eq 1 ];then
        DEVICE_NAME=$deviceName
        DEVICE_MAC=`ifconfig $DEVICE_NAME | grep "ether" | awk '{print $2}'`
        IPV6_ADDRESS=`ifconfig $DEVICE_NAME | grep -w inet6 | grep -iv "scope.*link" | grep -wi prefixlen | awk '{print $2,$4}' | sed 's/ /=/g'`
        IPV4_ADDRESS=`ifconfig $DEVICE_NAME | grep -w inet | grep -wi netmask | awk '{print $2,$4}' | sed 's/ /=/g'`
    else
        DEVICE_NAME=$deviceName
        DEVICE_MAC=`ifconfig $DEVICE_NAME | grep "HWaddr " | awk '{print $5}'`
        IPV4_ADDRESS=`ifconfig $DEVICE_NAME | grep "inet addr:" | grep -wi Mask| awk '{print $2,$4}' | sed 's/ //g' | sed 's/[a-zA-Z]//g' | sed 's/^://g' | sed 's/:/=/g'`
        IPV6_ADDRESS=`ifconfig $DEVICE_NAME | grep "inet6 addr:" | grep -iv "scope.*link" | awk '{print $3}' | sed 's/\//=/g'`
    fi
    Log "get adapter info successfully, DEVICE_NAME[$DEVICE_NAME], IPV4_ADDRESS[$IPV4_ADDRESS], IPV6_ADDRESS[`echo $IPV6_ADDRESS`]"
}

function getAdapterInfoByIp()
{
    local inPutIp=$1
    Log "get adapter info by ip: $inPutIp"
    IsEuler2
    if [ $? -eq 1 ]; then
        local AllNetAdapter=`ifconfig | grep -v ^" " | sed '/^$/d' | grep -vw lo | awk '{print $1}' | sed 's/:$//g'`
        NetAdapter=""
        NetAdapterMac=""
        for ethi in $AllNetAdapter
        do
            for ip in `ifconfig $ethi | grep -wE "inet|inet6" | awk '{print $2}'`; do [ "$ip" == "$inPutIp" ] && NetAdapter="$ethi" && break 2; done
        done
        [ "$NetAdapter" = "" ] && return 1
        NetAdapterMac=`ifconfig $NetAdapter | grep "ether" | awk '{print $2}'`
        IPV6_ADDR_TMP=`ifconfig $NetAdapter | grep inet6 | awk '{print $2,$4}' | sed 's/ /=/g'`
        ifconfig $NetAdapter | grep -w "$inPutIp" | grep -w inet6 &>/dev/null
        if [ $? -eq 0 ];then
            for ipTmp in $IPV6_ADDR_TMP; do [ "`echo $ipTmp | awk -F= '{print $1}'`" == "$inPutIp" ] && NetMask=`echo $ipTmp | awk -F= '{print $2}'` && break;done
        else
            NetMask=`ifconfig $NetAdapter |  grep "netmask" |  awk -F " " '{print $4}'`
        fi
    else
        local AllNetAdapter=`ifconfig | grep -v ^" " | sed '/^$/d' | grep -vw lo | awk '{print $1}' | sed 's/:$//g'`
        NetAdapter=""
        NetAdapterMac=""
        for ethi in $AllNetAdapter
        do
            ifconfig $ethi | grep "inet addr:" | grep -w "$inPutIp" &>/dev/null
            if [ $? -eq 0 ]; then
                NetAdapter="$ethi"
                break
            fi
            for tempip in `ifconfig $ethi | grep "inet6" | awk '{print $3}' | awk -F / '{print $1}'`;do [ "$tempip" == "$inPutIp" ] && NetAdapter="$ethi" && break 2; done
        done
        [ "$NetAdapter" = "" ] && return 1
        NetAdapterMac=`ifconfig $NetAdapter | grep "HWaddr " | awk '{print $5}'`
        IPV6_ADDR_TMP=`ifconfig $NetAdapter | grep inet6 | awk '{print $3}' | sed 's/\//=/g'`
        ifconfig $NetAdapter | grep -w "$inPutIp" | grep -w inet6 &>/dev/null
        if [ $? -eq 0 ];then
            for ipTmp in $IPV6_ADDR_TMP; do [ "`echo $ipTmp | awk -F= '{print $1}'`" == "$inPutIp" ] && NetMask=`echo $ipTmp | awk -F= '{print $2}'` && break;done
        else
            NetMask=`ifconfig $NetAdapter | grep "inet addr:" | awk '{print $4}' | awk -F ":" '{print $2}'`
        fi
    fi
    Log "adapter info: NetMask=$NetMask, NetAdapter=$NetAdapter, IPV6_ADDR_TMP=`echo $IPV6_ADDR_TMP`"
    return 0
}

modifyHostConfig()
{
    local hostFile=/etc/hosts
    if [ ! -f $hostFile ];then
        Log "host file not exists, return."
        return
    fi
    local hostName=`hostname`
    local listenIp1=`getInstallInfo | grep INSTALL1_IP | awk -F= '{print $2}'`
    local listenIp2=`getInstallInfo | grep INSTALL2_IP | awk -F= '{print $2}'`
    Log "start modify host config, hostName=$hostName, listenip1=$listenIp1, listenip2=$listenIp2"
    cat $hostFile | grep -w "$hostName" | grep -w "$listenIp1" &>/dev/null
    if [ $? -ne 0 ] && [ ! -z "$listenIp1" ];then
        echo "$listenIp1 $hostName" >> "$hostFile"
    fi

    cat $hostFile | grep -w "$hostName" | grep -w "$listenIp2" &>/dev/null
    if [ $? -ne 0 ] && [ ! -z "$listenIp2" ];then
        echo "$listenIp2 $hostName" >> "$hostFile"
    fi
}

######################################################################
#   DESCRIPTION: 校验端口是否合法
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function validPort()
{   
    if [ -z "$1" ]; then
        Log "[Error] The port is null."
        return 1
    fi
    #检查端口的第一个数字是否是0
    echo "$1" | grep -E "^[1-9][0-9]*$" >/dev/null
    if [ $? -ne 0 ]; then
        Log "[Error] The port $1 is invalid."
        return 1
    fi
    
    checkInputNumberLength "$1"
    [ $? -eq 1 ] && return 1
    
    if [ "$1" -lt 1024 ] || [ "$1" -gt 65535 ]; then
        Log "[Error] The port $1 is invalid."
        echo "The port number cannot be smaller than 1024 or greater than 65535."
        return 1
    fi    
    
    return 0
}


function checkUsePort()
{
    local inputPort=$1
    local chgWebMode=$2
    if [ "$chgWebMode" != "" ] && [ "$G_CLICHANGEWEB_FLAG" = "true" ];then
        local CHECK_CLASSPATH="install;commons-codec;slf4j-api;one-track-4-kmc;wcc_helper;slf4j-reload4j;commons-lang3;dom4j;jaxen;legoLog;log4j-api;log4j-core;log4j-1.2-api;disruptor;Lego-Core-Log-Bundle;Lego-Core-SDK-Bundle;spring;commons-logging;gsjdbc;lombok;httpclient5;httpcore5;spring-jcl;spring-core;jackson-databind;jackson-core;jackson-annotations"
        getClassPath "$CHECK_CLASSPATH"
        ../jre6.0.18/bin/java -cp "$CLASSPATH" com.huawei.lego.common.changeweb.ChangeWebCommon $inputPort $chgWebMode
        if [ $? -ne 0 ];then
            echoInfo "ERROR: The port $inputPort is occupied."
            echo "Please try again."
            echo -ne "\n"
            return 1
        fi
        return 0
    fi
    
    if [ "$DATEBASE_PORT" != "" ] && [ "$inputPort" = "$DATEBASE_PORT" ];then
        echoInfo "ERROR: The port $inputPort is occupied."
        echo "Please try again."
        echo -ne "\n"
        return 1
    fi
    
    if [ "$TaskPlanePort" != "" ] && [ "$inputPort" = "$TaskPlanePort" ];then
        echoInfo "ERROR: The port $inputPort is occupied."
        echo "Please try again."
        echo -ne "\n"
        return 1
    fi
    
    if [ "$RunPlanePort" != "" ] && [ "$inputPort" = "$RunPlanePort" ];then
        echoInfo "ERROR: The port $inputPort is occupied."
        echo "Please try again."
        echo -ne "\n"
        return 1
    fi
    
 
    
    return 0
}

function checkIniPort()
{
    local inputPort=$1
    local whoUsed="$2"
    local PORT_INI_PATH="${COMM_BCMANAGER_PATH}/Runtime/bin/config/conf/port.ini"
    local portInIni=""
    if [ ! -f $PORT_INI_PATH ];then
        PORT_INI_PATH="${COMM_BCMANAGER_PATH}/Runtime/../config/conf/port.ini"
    fi
    
    if [ "$whoUsed" = "TaskManagePlane" ];then
        local OM_PLANE_PORT=`cat $PORT_INI_PATH | grep  "omplane.https.port" | awk -F "=" '{print $2}'`
        if [ "$inputPort" = "$OM_PLANE_PORT" ];then
            echoInfo "ERROR: The port $inputPort is occupied."
            echo "Please try again."
            echo -ne "\n"
            return 1
        fi
    fi
    
    if [ "$DATEBASE_PORT" = "" ];then
        portInIni=`cat $PORT_INI_PATH | grep "=" | grep -v "#" | grep -v "https.port"| awk -F "=" '{print $2}'`
        for iPort in $portInIni
        do
            if [ "$inputPort" = "$iPort" ];then
                echoInfo "ERROR: The port $inputPort is occupied."
                echo "Please try again."
                echo -ne "\n"
                return 1
            fi
        done
    else
        if [ "$inputPort" = "$DATEBASE_PORT" ];then
            echoInfo "ERROR: The port $inputPort is occupied."
            echo "Please try again."
            echo -ne "\n"
            return 1
        fi
        
        portInIni=`cat $PORT_INI_PATH | grep "=" | grep -v "#" | grep -v "https.port" | grep -v "gauss.port" | awk -F "=" '{print $2}'`
        for iPort in $portInIni
        do
            if [ "$inputPort" = "$iPort" ];then
                echoInfo "ERROR: The port $inputPort is occupied."
                echo "Please try again."
                echo -ne "\n"
                return 1
            fi
        done
    fi
    
    return 0
}

function getUserInputPort()
{
    local whoUsed="$1"
    local chgWebMode="$2"
    local TaskManagePlanePort=9443
    local Ret=0
    local port=0
    while [ 1 ]
    do
        echo -n "Please input the management listening port [$TaskManagePlanePort]:"
        echo ""

        if [ "true" == "$ISAUTODEP" ];then
            port=9443
        else
            read port
        fi 

        if [ "$port" = "" ]; then
            port=$TaskManagePlanePort
        fi
        
        validPort $port
        if [ $? -ne 0 ]; then
            echoInfo "ERROR: Your input is invalid."
            echo "Please try again."
            echo -ne "\n"
            sleep 1
            continue
        fi
        
        Ret=`lsof -i:$port`
        if [ -n "$Ret" ]
        then
            echoInfo "ERROR: The port $port is occupied."
            echo "Please try again."
            echo -ne "\n"
            sleep 1
            continue
        fi
        
        checkIniPort $port $whoUsed
        if [ $? -ne 0 ];then
            sleep 1
            continue
        fi
        
        checkUsePort $port $chgWebMode
        if [ $? -ne 0 ];then
            sleep 1
            continue
        fi
        
        Port=$port
        echo -ne "\n"
        break
    done
    return 0
}

function checkSelect()
{
    local userSelect=$1
    local max=$2
    local tmpstr=`echo "$userSelect" | sed 's/ //g'`
    if [ -z "$tmpstr" ];then
        echoInfo "ERROR: Your input is invalid."
        echo "Please try again."
        echo -ne "\n"
        return 1
    fi
    
    echo "$userSelect" | grep -E "^[0-9 ]*$" &>/dev/null
    if [ $? != 0 ];then
        echoInfo "ERROR: Your input is invalid."
        echo "Please try again."
        echo -ne "\n"
        return 1
    fi

    declare -i iCount=0
    for check in $userSelect
    do
        iCount=`expr $iCount + 1`
        if [ $check -lt 1 ] || [ $check -gt $max ];then
            echoInfo "ERROR: Your input is invalid."
            echo "Please try again."
            echo -ne "\n"
            return 1
        fi
    done

    if [ $iCount -gt 2 ];then
        echoInfo "ERROR: Your input is invalid."
        echo "Please try again."
        echo -ne "\n"
        return 1
    fi

    local tmpValue=($userSelect)
    if [ ${#tmpValue[@]} -eq 2 ] && [ "${tmpValue[0]}" == "${tmpValue[1]}" ];then
        echoInfo "ERROR: Your input is invalid."
        echo "Please try again."
        echo -ne "\n"
        return 1
    fi

    return 0
}

function getAllNetAdapter()
{
    ip addr | grep -v ^" " | sed '/^$/d' | grep -vw lo | awk '{print $2}' | sed 's/:$//g'
}

function getUserInputPlane()
{
    local index
    local ip
    local localIpArraySize
    local right
    declare -a localAdapterInfoArry
    while [ 1 ]
    do
        echo "Select 1 or 2 IP addresses as the management IP addresses of the DR system. Use a space to separate the IP addresses, for example, 1 2."
        index=1
        local i=0
        echo -e "================================================================================="
        for device_name in $(getAllNetAdapter)
        do
            getAdapterInfoByDeviceName "$device_name"
            [ "$DEVICE_MAC" = "" ] && continue
            local ipv4=`echo $IPV4_ADDRESS | awk -F= '{print $1}'`
            local ipv4_mask=`echo $IPV4_ADDRESS | awk -F= '{print $2}'`
            if [ ! -z "$ipv4" ] && [ ! -z "$ipv4_mask" ];then
                if [ "${ipv4}" == "${local_IP}" ];then
                    ipIndex_auto=${index}
                    Log "local_ip is same as ${ipv4}, and ipIndex_auto is ${ipIndex_auto}."
                fi
                localAdapterInfoArry[$i]="$DEVICE_NAME  MAC=$DEVICE_MAC  IPv4=$ipv4  NetMask=$ipv4_mask"
                echo " [$index] ${localAdapterInfoArry[$i]}"
                i=`expr $i + 1`
                index=`expr $index + 1`
            fi

            for ipv6_tmp in $IPV6_ADDRESS
            do
                local ipv6=`echo $ipv6_tmp | awk -F= '{print $1}'`
                local ipv6_mask=`echo $ipv6_tmp | awk -F= '{print $2}'`
                if [ ! -z "$ipv6" ] && [ ! -z "$ipv6_mask" ];then
                    if [ "${ipv6}" == "${local_IP}" ];then
                        ipIndex_auto=${index}
                        Log "local_ip is same as ${ipv6}, and ipIndex_auto is ${ipIndex_auto}."
                    fi
                    localAdapterInfoArry[$i]="$DEVICE_NAME  MAC=$DEVICE_MAC  IPv6=$ipv6  Prefixlen=$ipv6_mask"
                    echo " [$index] ${localAdapterInfoArry[$i]}"
                    i=`expr $i + 1`
                    index=`expr $index + 1`
                fi
            done
        done
        echo -e "================================================================================="

        if [ "true" == "$ISAUTODEP" ];then
            ipIndex=${ipIndex_auto}
            if [ -z ${ipIndex} ];then
                Log "Query ipIndex failed. please check the ip address, make sure we can find ${local_IP} here."
                exit 1
            fi
            Log "auto choice is ${ipIndex}."
        else
            read ipIndex
        fi
        localIpArraySize=${#localAdapterInfoArry[@]}
        checkSelect "$ipIndex" $localIpArraySize
        if [ $? != 0 ];then
            continue
        fi
        Log "localIpArraySize: $localIpArraySize, index: $index, i: $i"
        ManageIP_LIST=""
        for number in $ipIndex
        do
            local count=`expr $number - 1`
            if [ "true" == "$ISAUTODEP" ];then
                ManageIP_LIST=$local_IP
                break
            fi
            local ManageIP=`echo "${localAdapterInfoArry[$count]}" | awk -F "IPv4=" '{print $2}' | awk '{print $1}'`
            echo "${localAdapterInfoArry[$count]}" | grep IPv6 &>/dev/null
            if [ $? -eq 0 ];then
                local ManageIP=`echo "${localAdapterInfoArry[$count]}" | awk -F "IPv6=" '{print $2}' | awk '{print $1}'`
            fi
            if [ -z "$ManageIP_LIST" ];then
                ManageIP_LIST=$ManageIP
            else
                ManageIP_LIST="${ManageIP_LIST} $ManageIP"
            fi
        done

        Log "choose the ip is : $ManageIP_LIST"
        echo -ne "\n"
        break
    done
    return 0
}

function showCurrentPlaneSetting()
{
    local TaskManagePlaneIP=$1
    echo "Current IP configuration:"
    echo "----------------------------------------------------------------------------------------"
    echo -ne "\n"
    declare -i iCount=1
    for ip in $TaskManagePlaneIP
    do
        getAdapterInfoByIp "$ip"
        echo "[$iCount] MAC=$NetAdapterMac  Listening IP=$ip"
        iCount=`expr $iCount + 1`
    done
    echo -ne "\n"
    echo "----------------------------------------------------------------------------------------"
}

function DeleteTaskManageIp() #打印除业务平面网卡上绑定的IP之外的IP
{
    local TaskManagedIp=$1
    local exist_falg=0
    LOCALIPARRAY=`getLocalIpAddr`
    getAdapterInfoByIp "$TaskManagedIp"
    local ManagedNetEthIps=`ip addr show "$NetAdapter" | grep "inet " |awk '{print $2}' | awk -F "/" '{print $1}'`

    for ip in $LOCALIPARRAY
    do
        getAdapterInfoByIp "$ip"
        [ "$NetAdapterMac" = "" ] && continue
        for taskIp in $ManagedNetEthIps
        do
            if [ "$ip" = "$taskIp" ]; then
                Log "Delete the $taskIp...task managed ip bind on this ip's netcard."
                exist_falg=1
                break;
            fi
        done
        
        if [ $exist_falg -eq 1 ]; then
            exist_falg=0
            continue
        fi
        echo "$ip"
    done
}


######################################################################
#   DESCRIPTION: 检查网关是否配置在本地IP上 
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function isLocalIp()
{
    local ip_list=$(ip addr show | grep -ow "$1");ret=$?
    if [[ $ret -ne 0 ]]; then
        return $ret
    fi
    
    for ip in $ip_list
    do
        if [[ "$ip" = "$1" ]]; then
            return 0
        fi
    done
    Log "the ip is not found in local. ip=[$1]"
    return 1
}

function ip2Integer()  
{  
    echo $1 | awk '{c=256;split($0,ip,".");print ip[4]+ip[3]*c+ip[2]*c^2+ip[1]*c^3}'  
}

######################################################################
#   DESCRIPTION: 获取网络监听配置
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function getNetworkInfo()
{
    getUserInputPlane
    [ $? -ne 0 ] && return 1
    TaskManageIP=$ManageIP_LIST

    getUserInputPort "TaskManagePlane"
    [ $? -eq 1 ] && return 1
    TaskManagePort=$Port
    TaskPlanePort=$TaskManagePort

    showCurrentPlaneSetting "$TaskManageIP"
}

function checkSameIPVersion()
{
    local ipList=($@)
    if [ ${#ipList[@]} -lt 2 ];then
        Log "The numbers of ip address is less than 2"
        return 1
    fi

    local IPv6=""
    local IPv4=""
    for ip in ${ipList[@]};do
        if echo "$ip" | grep ":" &>/dev/null;then IPv6=$ip,$IPv6;else IPv4=$ip,$IPv4;fi
    done
    [ ! -z "$IPv6" -a ! -z "$IPv4" ] && return 1
    return 0
}

# get the float ip address from user input
# if is new install, the ip must be provided, format: ip1 ip2
function getFloatIPInfo()
{
    Log "getFloatIPInfo: $@"
    NETWORK1=""
    NETWORK2=""
    local ip_array=($@)
    local len=${#ip_array[@]}
    if [ $len -eq 0 ];then
        getUserInputPlane
        ip_array=($ManageIP_LIST)
    fi
    
    Log "get float ip info for ${ip_array[@]}"
    local len=${#ip_array[@]}
    if [ $len -eq 0 ];then
        Log "failed to get float ip info."
        exit 1
    fi

    getAdapterInfoByIp "${ip_array[0]}"
    while [ 1 ]
    do
        echo -e "Enter the management floating IP address 1. (Management floating IP address 1 replaces management IP address 1 to provide DR management services. Management floating IP address 1 is bound to the network adapter corresponding to management IP address 1. The protocol type of management floating IP address 1 must be the same as that of management IP address 1. The information about the network adapter where management IP address 1 resides is as follows: \n ${ip_array[0]} network adapter: $NetAdapter)"
        local floatIp1=""
        if [ "true" == "$ISAUTODEP" ];then
            floatIp1=$floatIp
        else
            read floatIp1
        fi
        floatIp1=`echo "${floatIp1}" | sed 's/^\[//g' | sed 's/\]$//g'`
        isLocalIp "${floatIp1}"
        if [ $? -eq 0 ];then 
            echoInfo "ERROR: Local IP addresses cannot be used as floating IP addresses."; echo "Please try again."; echo -ne "\n"; sleep 1; continue
        fi

        validIP "${floatIp1}" 
        if [ $? -ne 0 ];then
            echoInfo "ERROR: Your input is invalid."; echo "Please try again."; echo -ne "\n" ;sleep 1; continue
        fi

        checkSameIPVersion "${ip_array[0]}" "$floatIp1"
        if [ $? != 0 ];then
            echoInfo "ERROR: Your input is invalid. The protocol type of management floating IP address must be the same as that of management IP address."; echo "Please try again."; echo -ne "\n" ;sleep 1; continue
        fi

        NETWORK1="${ip_array[0]}|${floatIp1}"
        break
    done

    if [ $len -eq 2 ];then
        getAdapterInfoByIp "${ip_array[1]}"
        while [ 1 ]
        do
            local floatIP2=""
            echo -e "Enter the management floating IP address 2. (Management floating IP address 2 replaces management IP address 2 to provide DR management services. Management floating IP address 2 is bound to the network adapter corresponding to management IP address 2. The protocol type of management floating IP address 2 must be the same as that of management IP address 2. The information about the network adapter where management IP address 2 resides is as follows: \n ${ip_array[1]} network adapter: $NetAdapter)"
            read floatIP2
            floatIP2=`echo "${floatIP2}" | sed 's/^\[//g' | sed 's/\]$//g'`
            isLocalIp "${floatIP2}"
            if [ $? -eq 0 ];then 
                echoInfo "ERROR: Local IP addresses cannot be used as floating IP addresses."; echo "Please try again."; echo -ne "\n"; sleep 1; continue
            fi
            validIP "${floatIP2}" 
            if [ $? -ne 0 ];then
                echoInfo "ERROR: Your input is invalid."; echo "Please try again."; echo -ne "\n" ;sleep 1; continue
            fi

            checkSameIPVersion "${ip_array[1]}" "$floatIP2"
            if [ $? != 0 ];then
                echoInfo "ERROR: Your input is invalid. The protocol type of management floating IP address must be the same as that of management IP address."; echo "Please try again."; echo -ne "\n" ;sleep 1; continue
            fi
            NETWORK2="${ip_array[1]}|${floatIP2}"
            break
        done
    fi
    FloatIP=${floatIp1}
    if [ ! -z "$floatIP2" ];then
        FloatIP=${floatIp1},${floatIP2}
    fi
}

# This method is used to set the https port located in all RDInstalled.xml and port.ini, and must be called after installed.
function SetHttpsPort()
{
    local port1=$1
    local port2=$2
    [ -z "$port2" ] && port2=$port1

    local install_file1=${COMM_SCRIPTDIR}/RDInstalled.xml
    local install_file2=/home/ICUser/RDInstalled.xml
    local install_file3=${COMM_SCRIPTDIR}/../monitor/RDInstalled.xml
    sed -i "s/<httpsport>.*\(<.*\)/<httpsport>${port1}\1/g" "$install_file1"
    sed -i "s/<httpsport>.*\(<.*\)/<httpsport>${port1}\1/g" "$install_file2"
    sed -i "s/<httpsport>.*\(<.*\)/<httpsport>${port1}\1/g" "$install_file3"

    local tmp_value=`cat "$install_file1" | grep shttpsport | awk -F 'shttpsport=\"' '{print $2}' | awk -F \" '{print $1}'`
    sed -i "s/shttpsport=\"${tmp_value}\"/shttpsport=\"${port2}\"/g" "$install_file1"
    local tmp_value=`cat "$install_file2" | grep shttpsport | awk -F 'shttpsport=\"' '{print $2}' | awk -F \" '{print $1}'`
    sed -i "s/shttpsport=\"${tmp_value}\"/shttpsport=\"${port2}\"/g" "$install_file2"
    local tmp_value=`cat "$install_file3" | grep shttpsport | awk -F 'shttpsport=\"' '{print $2}' | awk -F \" '{print $1}'`
    sed -i "s/shttpsport=\"${tmp_value}\"/shttpsport=\"${port2}\"/g"  "$install_file3"
    local portIni=${COMM_SCRIPTDIR}/config/conf/port.ini
    sed -i "s/https.port=.*/https.port=${port1}/g" "$portIni"
}

# This method is used to set the device ip located in all RDInstalled.xml, and must be called after installed.
function SetDeviceIPAddress()
{
    local listenIP1=$1
    local listenIP2=$2
    Log "start set listen ip address, ip1=$listenIP1, ip2=$listenIP2"
    local install_file1=${COMM_SCRIPTDIR}/RDInstalled.xml
    local install_file2=/home/ICUser/RDInstalled.xml
    local install_file3=${COMM_SCRIPTDIR}/../monitor/RDInstalled.xml

    getAdapterInfoByIp "$listenIP1"

    if [ ! -z "$listenIP1" ];then
        Log "start set network 1. [$listenIP1]"
        sed -i "/<httpsip>/c \  <httpsip>${listenIP1}<\/httpsip>" "$install_file1"
        sed -i "/<httpsip>/c \  <httpsip>${listenIP1}<\/httpsip>" "$install_file2"
        sed -i "/<httpsip>/c \  <httpsip>${listenIP1}<\/httpsip>" "$install_file3"
    fi

    if [ ! -z "$listenIP2" ];then
        Log "start set network 2. [$listenIP2]"
        local tmp_value=`cat "$install_file1" | grep -w sip | awk -F 'sip=\"' '{print $2}' | awk -F \" '{print $1}'`
        sed -i "s/sip=\"${tmp_value}\"/sip=\"${listenIP2}\"/g" "$install_file1"
        local tmp_value=`cat "$install_file2" | grep -w sip | awk -F 'sip=\"' '{print $2}' | awk -F \" '{print $1}'`
        sed -i "s/sip=\"${tmp_value}\"/sip=\"${listenIP2}\"/g" "$install_file2"
        local tmp_value=`cat "$install_file3" | grep -w sip | awk -F 'sip=\"' '{print $2}' | awk -F \" '{print $1}'`
        sed -i "s/sip=\"${tmp_value}\"/sip=\"${listenIP2}\"/g"  "$install_file3"
    fi
}

function SetFloatIPAddress()
{
    local floatIP1=$1
    local floatIP2=$2
    Log "start set listen ip address, floatIP1=$floatIP1, floatIP2=$floatIP2"
    local install_file1=${COMM_SCRIPTDIR}/RDInstalled.xml
    local install_file2=/home/ICUser/RDInstalled.xml
    local install_file3=${COMM_SCRIPTDIR}/../monitor/RDInstalled.xml
    if [ ! -z "$floatIP1" ];then
        Log "start set float ip 1. [$floatIP1]"
        sed -i "/<floatip>/c \  <floatip>${floatIP1}<\/floatip>" "$install_file1"
        sed -i "/<floatip>/c \  <floatip>${floatIP1}<\/floatip>" "$install_file2"
        sed -i "/<floatip>/c \  <floatip>${floatIP1}<\/floatip>" "$install_file3"
    fi

    if [ ! -z "$floatIP2" ];then
        Log "start set float ip 2. [$floatIP2]"
        local tmp_value=`cat "$install_file1" | grep -w sfloatip | awk -F 'sfloatip=\"' '{print $2}' | awk -F \" '{print $1}'`
        sed -i "s/sfloatip=\"${tmp_value}\"/sfloatip=\"${floatIP2}\"/g" "$install_file1"
        local tmp_value=`cat "$install_file2" | grep -w sfloatip | awk -F 'sfloatip=\"' '{print $2}' | awk -F \" '{print $1}'`
        sed -i "s/sfloatip=\"${tmp_value}\"/sfloatip=\"${floatIP2}\"/g" "$install_file2"
        local tmp_value=`cat "$install_file3" | grep -w sfloatip | awk -F 'sfloatip=\"' '{print $2}' | awk -F \" '{print $1}'`
        sed -i "s/sfloatip=\"${tmp_value}\"/sfloatip=\"${floatIP2}\"/g"  "$install_file3"
    fi
}

function deleteFloatIP()
{
    local install_file1=${COMM_SCRIPTDIR}/RDInstalled.xml
    local install_file2=/home/ICUser/RDInstalled.xml
    local install_file3=${COMM_SCRIPTDIR}/../monitor/RDInstalled.xml

    Log "start delete float ip 1."
    sed -i "/<floatip>/c \  <floatip><\/floatip>" "$install_file1"
    sed -i "/<floatip>/c \  <floatip><\/floatip>" "$install_file2"
    sed -i "/<floatip>/c \  <floatip><\/floatip>" "$install_file3"

    Log "start delete float ip 2. "
    local tmp_value=`cat "$install_file1" | grep -w sfloatip | awk -F 'sfloatip=\"' '{print $2}' | awk -F \" '{print $1}'`
    sed -i "s/sfloatip=\"${tmp_value}\"/sfloatip=\"\"/g" "$install_file1"
    local tmp_value=`cat "$install_file2" | grep -w sfloatip | awk -F 'sfloatip=\"' '{print $2}' | awk -F \" '{print $1}'`
    sed -i "s/sfloatip=\"${tmp_value}\"/sfloatip=\"\"/g" "$install_file2"
    local tmp_value=`cat "$install_file3" | grep -w sfloatip | awk -F 'sfloatip=\"' '{print $2}' | awk -F \" '{print $1}'`
    sed -i "s/sfloatip=\"${tmp_value}\"/sfloatip=\"\"/g"  "$install_file3"
}

function enableSecondNetwork()
{
    local enable=$1
    Log "enableSecondNetwork: $enable"
    echo "$enable" | grep -wE "true|false" &>/dev/null
    if [ $? != 0 ];then
        Log "the value is error."
        exit 1
    fi

    local install_file1=${COMM_SCRIPTDIR}/RDInstalled.xml
    local install_file2=/home/ICUser/RDInstalled.xml
    local install_file3=${COMM_SCRIPTDIR}/../monitor/RDInstalled.xml
    local tmp_value=`cat "$install_file1" | grep -w isEnable | awk -F 'isEnable=\"' '{print $2}' | awk -F \" '{print $1}'`
    sed -i "s/isEnable=\"${tmp_value}\"/isEnable=\"${enable}\"/g" "$install_file1"
    local tmp_value=`cat "$install_file2" | grep -w isEnable | awk -F 'isEnable=\"' '{print $2}' | awk -F \" '{print $1}'`
    sed -i "s/isEnable=\"${tmp_value}\"/isEnable=\"${enable}\"/g" "$install_file2"
    local tmp_value=`cat "$install_file3" | grep -w isEnable | awk -F 'isEnable=\"' '{print $2}' | awk -F \" '{print $1}'`
    sed -i "s/isEnable=\"${tmp_value}\"/isEnable=\"${enable}\"/g"  "$install_file3"
}

function CheckFileExist()
{
    if [ ! -f "$1" ]
    then
        Log "[Error] $1 is not exist, Configure HA failed."
        echoInfo "ERROR: $1 is not exist,Configure HA failed."
        exit 1
    fi
}

function getYesOrNo
{
    local L_YES_NO=""
    read L_YES_NO
    L_YES_NO="$(echo $L_YES_NO | tr '[:upper:]' '[:lower:]')"
    while [ "$L_YES_NO" != "yes" ] && [ "$L_YES_NO" != "no" ] && [ "$L_YES_NO" != "y" ] && [ "$L_YES_NO" != "n" ]
    do
        echo "Please input yes or no"
        read L_YES_NO
        L_YES_NO="$(echo $L_YES_NO | tr '[:upper:]' '[:lower:]')"
    done
    
    if [ "$L_YES_NO" == "yes" ] || [ "$L_YES_NO" == "y" ]
    then
        return 0
    else
        return 1
    fi
}

function bkLock()
{    
    local lockCount=0
    while [ ${lockCount} -lt 3 ]
    do
        let "lockCount=lockCount+1"
        
        exec 3<>"${COMM_SCRIPTDIR}/../ha/local/hacom/conf/bklock"
        flock -x -w 10 3
        if [ $? -ne 0 ]
        then
            if [ ${lockCount} -eq 3 ]
            then
                return 1
            else
                sleep 0.01
                continue
            fi
        else
            return 0
        fi
    done
}

function bkUnlock()
{
    flock -u 3
    if [ $? -ne 0 ]
    then
        return 1
    else 
        return 0
    fi
}

function GeteReplicationModeConfig()
{
    local BCMANAGER_PATH="$COMM_BCMANAGER_PATH"
    local CONFIG_FILE="${BCMANAGER_PATH}/Runtime/ha/module/hacom/conf/hacom.xml"
    g_eReplicationHAMode=`cat $CONFIG_FILE | grep "<hamode value=\"" | awk -F "\"" '{print $2}'`
    g_eReplicationActiveStandbyMode=`cat $CONFIG_FILE | grep "<cascade value=\"" | awk -F "\"" '{print $2}'`
    Log "g_eReplicationHAMode: $g_eReplicationHAMode, g_eReplicationActiveStandbyMode: $g_eReplicationActiveStandbyMode"
    if [ "$g_eReplicationHAMode" = "double" ]; then
        g_eReplicationMode="HA"
    elif [ "$g_eReplicationActiveStandbyMode" = "active" ]; then
        g_eReplicationMode="Active-Standby"
    elif [ "$g_eReplicationActiveStandbyMode" = "standby" ]; then
        g_eReplicationMode="Active-Standby"
    else
        g_eReplicationMode="Single"
    fi
    Log "g_eReplicationMode: $g_eReplicationMode"
}

function getGsSyncLinckConnection()
{
    local SCRIPTDIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
    local INSTALLXML="$SCRIPTDIR"/RDInstalled.xml
    local installHome=`getInstallInfo "$INSTALLXML" | grep INSTALL_PATH | awk -F= '{print $2}'`
    local jreBin=$installHome/Runtime/jre6.0.18/bin/java
    local cur_path=`pwd`
    cd "$SCRIPTDIR"
    local dbActionClass="install.jar;haTool.jar;commons-codec;jaxen-;one-track-4-kmc;wcc_helper;dom4j-;legoLog.jar;slf4j-reload4j;slf4j-api;log4j-api-;log4j-core-;log4j-1.2-api-;disruptor-;Lego-Core-SDK-Bundle;commons-lang3;lombok;httpclient5;httpcore5;spring-jcl;spring-core;jackson-databind;jackson-core;jackson-annotations"
    getClassPath "$dbActionClass"
    local dbinfo=`"$jreBin" -cp $CLASSPATH com.huawei.dbtool.DBTool query `
    changeLogsAuth
    cd "$cur_path"
    local num=`echo "$dbinfo" | grep "No information" | wc -l`
    if [ "$num" != "1" ]; then
        Log "Gs Sync Linck disConnection"
        return 1
    fi
    
    g_GsSyncLink="`echo "$dbinfo" | grep CHANNEL | sed -n '1p' | awk -F ": " '{print $2}'`"
    return 0
}

function getGsdbSyncStatus()
{
    local PGCTL=/usr/local/gaussdb/bin/gs_ctl
    local cmd="$PGCTL querybuild -u GaussDB -D /opt/gs/app/data/"
    local GsStatus="`$cmd 2>$LOG_FILE_NAME`"
    if [ "$GsStatus" = "" ]; then
        Log "Get gs status failed."
        return 1
    fi
    GsSyncState="`$cmd 2>$LOG_FILE_NAME | grep "DB_STATE" | awk -F ": " '{print $2}'`"
    GsSyncPercent="`$cmd 2>$LOG_FILE_NAME | grep "DETAIL_INFORMATION" | awk -F ": " '{print $2}'`"
    return 0
}

# update listen ip address before upgrade BCManager
# 适配V200R001C50之前的版本升级,在之前的版本中,HA会同步RDInstslled.xml, 但该文件中记录了当前节点的IP,因此会导致备端此文件中的IP不正确,升级时做此处理,恢复真实IP
function updateListenerIpAddress()
{
    local xml1=/home/ICUser/RDInstalled.xml
    if [ ! -f "$xml1" ];then
        Log "can not find the RDInstalled.xml return."
        return
    fi
    local old_server_ip=`getInstallInfo | grep INSTALL1_IP | awk -F= '{print $2}'`
    local allLocalIp=`getAllLocalIP | grep IP_LIST= | awk -F= '{print $2}'`
    [ -z "$allLocalIp" ] && (Log "updateListenerIpAddress, can not find the local ip address.";return)

    for ip in $allLocalIp
    do 
        if [ "$ip" == "$old_server_ip" ] ;then
            Log "find the serverip in local ip list. no need update."
            return
        fi
    done

    local installPath=`getInstallInfo | grep INSTALL_PATH | awk -F= '{print $2}'`
    local haConf="$installPath/Runtime/ha/local/conf/ha.properties"
    if [ -f "$haConf" ];then
        local real_ip=`cat "$haConf" | grep "BCMProductManagementPlane" | awk -F= '{print $2}' | awk -F\| '{print $1}'`
        Log "old server ip is $old_server_ip, start update it to $real_ip"
    else
        # adapter UltraVR V100R003C10SPC200 for VHD
        local real_ip=`ifconfig | grep "inet " | awk  '{print $2}' | awk -F: '{print $NF}' | grep -v ^127.0 | sed -n '1p'`
        Log "start update ip, find a local ip address: $real_ip, old ip is $old_server_ip"
    fi
    local xml2=$installPath/Runtime/bin/RDInstalled.xml
    local xml3=$installPath/Runtime/monitor/RDInstalled.xml
    sed -i "s/\(.*httpsip>\).*\(<.*\)/\1${real_ip}\2/g" "$xml1"
    [ -f "$xml2" ] && sed -i "s/\(.*httpsip>\).*\(<.*\)/\1${real_ip}\2/g" "$xml2"
    [ -f "$xml3" ] && sed -i "s/\(.*httpsip>\).*\(<.*\)/\1${real_ip}\2/g" "$xml3"
}

function checkIPFormat()
{
    if [ -z "$1" ];then
        Log "checkIPFormat failed, ip is null."
        return 1
    fi

    checkIPV4Address "$1";local ipv4_result=$?
    if [ $ipv4_result -eq 0 ];then
        return 0
    fi

    checkIPV6Address "$1";local ipv6_result=$?
    if [ $ipv6_result -eq 0 ];then
        return 0
    fi
    return 1
}

function getIpType()
{
    local ip=$1
    if [ -z "$ip" ];then
        Log "get ip type failed, ip is null."
        return 1
    fi
    
    checkIPV6Address "$ip"
    if [ $? -eq 0 ];then
        echo Type=IPv6
    fi

    checkIPV4Address "$ip"
    if [ $? -eq 0 ];then
        echo Type=IPv4
    fi
    Log "getIpType is error, ip=$ip"
    return 1
}

function checkIPV6Address()
{
    local ipaddr=$1
    if [ -z "`echo "$ipaddr" | sed 's/ //g'`" ];then
        Log "The ipv6 addr is empty."
        return 1
    fi
    echo "$ipaddr" | grep -E '^((([0-9a-fA-F]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9a-fA-F]{1,4}:){6}((([0-9]{1,3}\.){3}[0-9]{1,4})|([0-9a-fA-F]{1,4})|:))|(([0-9a-fA-F]{1,4}:){5}:((([0-9a-fA-F]{1,4})?)|([0-9a-fA-F]{1,4}:[0-9a-fA-F]{1,4})|(([0-9]{1,3}\.){3}[0-9]{1,4})))|(([0-9a-fA-F]{1,4}:){4}:((([0-9a-fA-F]{1,4})?)|(([0-9a-fA-F]{1,4}:){1,2}[0-9a-fA-F]{1,4})|(([0-9a-fA-F]{1,4}:)?([0-9]{1,3}\.){3}[0-9]{1,4})))|(([0-9a-fA-F]{1,4}:){3}:((([0-9a-fA-F]{1,4}:){0,2}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,3}[0-9a-fA-F]{1,4})|$))|(([0-9a-fA-F]{1,4}:){2}:((([0-9a-fA-F]{1,4}:){0,3}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,4}[0-9a-fA-F]{1,4})|$))|(([0-9a-fA-F]{1,4}:){1}:((([0-9a-fA-F]{1,4}:){0,4}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,5}[0-9a-fA-F]{1,4})|$))|(::((([0-9a-fA-F]{1,4}:){0,5}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,6}[0-9a-fA-F]{1,4})|$)))$' &>/dev/null
    if [ $? != 0 ];then
        Log "ipv6 address is error, ip: $ipaddr"
        return 1
    fi
    return 0
}

function checkIPV4Address()
{
    local ipaddr=$1
    digstr=`expr match "$ipaddr" "[0-9.]*$"`
    if [ $digstr -eq 0 ];then
        Log "ipv4 format is illegal, ip: [$ipaddr]"
        return 1
    fi
    echo "$ipaddr" | sed 's/ //g' | grep -E "\.\.|\.$" &>/dev/null
    if [ $? -eq 0 ];then
        Log "ipv4 format is illegal, ip: [$ipaddr]"
        return 1
    fi
    
    if [ $(echo ${ipaddr} | awk -F "." '{print NF}') -eq "4" ];then
        local a=$(echo ${ipaddr} | awk -F "." '{print $1}')
        local b=$(echo ${ipaddr} | awk -F "." '{print $2}')
        local c=$(echo ${ipaddr} | awk -F "." '{print $3}')
        local d=$(echo ${ipaddr} | awk -F "." '{print $4}')

        if [[ "${a}" -gt "0" && "${a}" -le "255" ]] && [[ "${b}" -ge "0" && "${b}" -le "255" ]] \
            && [[ "${c}" -ge "0" && "${c}" -le "255" ]] && [[ "${d}" -ge "0" && "${d}" -le "255" ]]; then
            return 0
        else
            Log "ipv4 format is illegal, ip is $ipaddr"
            return 1
        fi
    fi

    Log "ipv4 format is error, ip is $ipaddr "
    return 1
}

####################################################
# This function is used to config or update        #
# oc routes while install or update eReplication   #
####################################################
function configOCRoutes()
{
    local local_ip=$1
    local oc_ip=$2
    local bootFile=/etc/rc.d/rc.local
    Log "start config oc routes, local_ip[$local_ip], oc_ip[$oc_ip]"
    # check if '#eReplication_TO_oc' is exists
    local result=`cat "$bootFile" | grep "$NOTE_INFO" | sed -n '1p'`
    if [ -z "$result" ];then
        Log "can not find the eReplication_TO_oc note, add it to auto command, local_ip=$local_ip, oc_ip=$oc_ip"
        echo "iptables -t nat -A POSTROUTING -j SNAT --to-source $local_ip -d $oc_ip   ${NOTE_INFO}, do not change this note" >> "$bootFile"
    else
        local cur_routes=`iptables -t nat -nL POSTROUTING --line-numbers | grep -iw snat`
        local old_local_ip=`echo "$result" | awk -F '--to-source' '{print $2}' | awk '{print $1}'`
        local old_oc_ip=`echo "$result" | awk -F ' -d ' '{print $2}' | awk '{print $1}'`
        Log "already exists in rc.local, current_routes[$cur_routes], old_local_ip[$old_local_ip], old_oc_ip[$old_oc_ip]"

        if [ -z "$oc_ip" ];then
            Log "oc_ip is null, use old_oc_ip[$old_oc_ip]"
            oc_ip=$old_oc_ip
        fi
        local lineTotal=`iptables -t nat -nL POSTROUTING --line-numbers | grep -iw snat | grep "to:$local_ip" | awk '{print $1}' | wc -l`
        for ((i=lineTotal;i>0;i--));do
            local destStr=`iptables -t nat -nL POSTROUTING $i`
            Log "start delete $destStr before start it"
            iptables -t nat -D POSTROUTING $i
        done
        sed -i "/${NOTE_INFO}/d" "$bootFile"
        echo "iptables -t nat -A POSTROUTING -j SNAT --to-source $local_ip -d $oc_ip   ${NOTE_INFO}, do not change this note" >> "$bootFile"
    fi
}

####################################################
# This function is used to config or update        #
# oc routes while install or update eReplication   #
# only support redhat or Euler system.             #
####################################################
function routes_config()
{
    case "$1" in
        "config")
            # only be used to install or upgrade operation.
            Log "start routes config: $1 $2 $3"
            configOCRoutes "$2" "$3"
            ;;
        "stop")
            Log "stop routes config: $1"
            local bootFile=/etc/rc.d/rc.local
            if [ ! -f "$bootFile" ];then
                Log "rc.local file not found. return."
                return 0
            fi
            local result=`cat "$bootFile" | grep "$NOTE_INFO" | sed -n '1p'`
            if [ -z "$result" ];then
                Log "not find the $NOTE_INFO in rc.local, no need stop it"
                return 0
            fi
            local local_ip=`echo "$result" | awk -F '--to-source' '{print $2}' | awk '{print $1}'`
            local oc_ip=`echo "$result" | awk -F ' -d ' '{print $2}' | awk '{print $1}'`
            if [ -z "$local_ip" ] || [ -z "$oc_ip" ];then
                Log "the local ip or oc_ip is empty, localIP[$local_ip], OCIP[$oc_ip]"
                return 0
            fi
            local lineTotal=`iptables -t nat -nL POSTROUTING --line-numbers | grep -iw snat | grep "to:$local_ip" | awk '{print $1}' | wc -l`
            for ((i=lineTotal;i>0;i--));do
                local destStr=`iptables -t nat -nL POSTROUTING $i`
                Log "start delete $destStr before start it"
                iptables -t nat -D POSTROUTING $i
            done
            ;;
        "start")
            Log "start routes config"
            local bootFile=/etc/rc.d/rc.local
            if [ ! -f "$bootFile" ];then
                Log "rc.local file not found. return."
                return 0
            fi
            local result=`cat "$bootFile" | grep "$NOTE_INFO" | sed -n '1p'`
            if [ -z "$result" ];then
                Log "not find the $NOTE_INFO in rc.local, no need start it"
                return 0
            fi
            local local_ip=`echo "$result" | awk -F '--to-source' '{print $2}' | awk '{print $1}'`
            local oc_ip=`echo "$result" | awk -F ' -d ' '{print $2}' | awk '{print $1}'`
            if [ -z "$local_ip" ] || [ -z "$oc_ip" ];then
                Log "the local ip or oc_ip is empty, localIP[$local_ip], OCIP[$oc_ip]"
                return 0
            fi
            local lineTotal=`iptables -t nat -nL POSTROUTING --line-numbers | grep -iw snat | grep "to:$local_ip" | awk '{print $1}' | wc -l`
            for ((i=lineTotal;i>0;i--));do
                local destStr=`iptables -t nat -nL POSTROUTING $i`
                Log "start delete $destStr before start it"
                iptables -t nat -D POSTROUTING $i
            done
            iptables -t nat -A POSTROUTING -j SNAT --to-source $local_ip -d $oc_ip
            ;;
        "uninstall")
            local bootFile=/etc/rc.d/rc.local
            if [ ! -f "$bootFile" ];then
                return 0
            fi
            local result=`cat "$bootFile" | grep "$NOTE_INFO" | sed -n '1p'`
            if [ -z "$result" ];then
                return 0
            fi
            local local_ip=`echo "$result" | awk -F '--to-source' '{print $2}' | awk '{print $1}'`
            local oc_ip=`echo "$result" | awk -F ' -d ' '{print $2}' | awk '{print $1}'`
            if [ -z "$local_ip" ] || [ -z "$oc_ip" ];then
                return 0
            fi

            local lineTotal=`iptables -t nat -nL POSTROUTING --line-numbers | grep -iw snat | grep "to:$local_ip" | awk '{print $1}' | wc -l`
            for ((i=lineTotal;i>0;i--));do
                local destStr=`iptables -t nat -nL POSTROUTING $i`
                Log "start delete $destStr before start it"
                iptables -t nat -D POSTROUTING $i
            done

            sed -i "/${NOTE_INFO}/d" "$bootFile"
            ;;
    esac
}

#############################################################
# This function is used by cliChangeweb.sh and changeweb.sh #
# only support redhat or Euler system.                      #
#############################################################
function change_web_xml()
{
    local listenIp=$1
    local port=$2
    checkIPFormat "$listenIp"
    if [ $? != 0 ];then
        Log "changeWebXml failed, the ip is error: $listenIp"
        return
    fi
    echo "$port" | grep '^[[:digit:]]*$' &>/dev/null;iRet=$?
    if [ -z "$port" ] || [ $iRet != 0 ];then
        Log "changeWebXml failed, port is error, port=$port"
        return
    fi

    local webXml=$COMM_SCRIPTDIR/../Tomcat6/Lego-UI-Plat/WEB-INF/web.xml
    if [ ! -f "$webXml" ];then
        Log "change web.xml failed, can not find the web.xml"
        return
    fi

    local bootFile=/etc/rc.d/rc.local
    if [ ! -f "$bootFile" ];then
        Log "rc.local file not found."
        return
    fi
    local is_need=`cat "$bootFile" | grep "$NOTE_INFO" | sed -n '1p'`
    if [ ! -z "$is_need" ];then
        Log "find the note in rc.local, need check if need update web.xml"
        local result=`cat "$webXml" | grep -w "sso.address.client" | grep -w "https://${listenIp}:${port}" | wc -l`
        if [ "$result" != "1" ];then
            Log "need change web.xml"
            sed -i "s#\(.*-name>sso.address.client.*value>\).*\(<\/param-value.*\)#\1https://${listenIp}:${port}\2#g" "$webXml"
        fi
        routes_config config "$listenIp"
    fi

}

function checkBCMServiceRunning()
{
    local file1=/opt/BCManager/Runtime/ha/module/hamon/script/status_ha_monitor.sh
    local file2=/opt/ReplicationDirectory/Runtime/ha/module/hamon/script/status_ha_monitor.sh
    if [ -f "$file1" ];then
        sh "$file1" | grep -iw "normal" &>/dev/null
        if [ $? -eq 0 ];then
            Log "ha status is normal, service is running."
            return 0
        fi
    fi

    if [ -f "$file2" ];then
        sh "$file2" | grep -iw "normal" &>/dev/null
        if [ $? -eq 0 ];then
            Log "ha status is normal, service is running."
            return 0
        fi
    fi

    ps -ef |grep ha.bin | grep BCManager &>/dev/null
    if [ $? -eq 0 ];then
        Log "ha.bin exists, service is running."
        return 0
    fi

    ps -ef |grep java | grep -wE "ICUser|Tomcat" &>/dev/null
    if [ $? -eq 0 ];then
        Log "java exists, service is running."
        return 0
    fi

    ps -ef | grep gaussdb | grep -w GaussDB &>/dev/null
    if [ $? -eq 0 ];then
        Log "gaussdb exists, service is running."
        return 0
    fi

    return 1
}

# query all the ipv4 and ipv6 address.
function getAllLocalIP()
{
    local ipv6=`getAllIPv6Address | grep ALL_IPV6 | awk -F= '{print $2}'`
    local ipv4=`getAllIPv4Address | grep ALL_IP4 | awk -F= '{print $2}'`
    echo IP_LIST="$ipv4 $ipv6"
}

function getAllIPv6Address()
{
    ifconfig | grep "inet6 addr:" &>/dev/null
    if [ $? != 0 ];then
        echo ALL_IPV6=$(for ip in $(ifconfig | grep -w inet6 | awk '{print $2}');do [ "$ip" != "::1" ] && echo $ip;done)
    else
        echo ALL_IPV6=$(for ip in $(ifconfig | grep "inet6 addr:" | awk '{print $3}' | awk -F/ '{print $1}');do [ "$ip" != "::1" ] && echo $ip;done)
    fi
}

function find_ipv6_address() {
    local listen_ip=$(xmllint --xpath "/install/floatip/text()" "${COMM_SCRIPTDIR}/RDInstalled.xml" 2>/dev/null)
    if [ -z "${listen_ip}" ]; then
      listen_ip=$(xmllint --xpath "/install/httpsip/text()" "${COMM_SCRIPTDIR}/RDInstalled.xml" 2>/dev/null)
    fi
    checkIPV6Address "${listen_ip}" && return 0
    local second_net_enable=$(xmllint --xpath "string(/install/secondnet/@isEnable)" "${COMM_SCRIPTDIR}/RDInstalled.xml" 2>/dev/null | tr [:upper:] [:lower:])
    if [ "${second_net_enable}" == "true" ]; then
      local second_listen_ip=$(xmllint --xpath "string(/install/secondnet/@sfloatip)" "${COMM_SCRIPTDIR}/RDInstalled.xml" 2>/dev/null)
      if [ -z "${second_listen_ip}" ]; then
        second_listen_ip=$(xmllint --xpath "string(/install/secondnet/@sip)" "${COMM_SCRIPTDIR}/RDInstalled.xml" 2>/dev/null)
      fi
      checkIPV6Address "${second_listen_ip}" && return 0
    fi
    return 1
}

function setRpcAddressForHA()
{
    GeteReplicationModeConfig
    if [ "$g_eReplicationMode" != "Single" ];then
        Log "is not single mode, no need set rpc address for ha."
        return
    fi

    #In a single scenario, if the listening IP address is IPv6, the RPC address of the HA is set to '::1', otherwise it is set to '127.0.0.1'.
    local hacomxml=$COMM_BCMANAGER_PATH/Runtime/ha/module/hacom/conf/hacom.xml
    if [ ! -f "$hacomxml" ];then
        Log "can not find the hacom.xml, setRpcAddressForHA failed."
        return
    fi

    find_ipv6_address
    if [ $? -eq 0 ];then
        Log "find the ipv6 address, start change 127.0.0.1 to ::1 in hacom.xml file."
        sed -i "s/127.0.0.1/::1/g" "$hacomxml"
    else
        Log "can not find the ipv6 address, start change ::1 to 127.0.0.1 in hacom.xml file."
        sed -i "s/::1/127.0.0.1/g" "$hacomxml"
    fi
}

function getAllIPv4Address()
{
    echo ALL_IP4=`ifconfig | grep -w inet | awk '{print $2}' | awk -F: '{print $NF}' | grep -v ^127.0.0`
}

function getInstallInfo()
{
    local installFile=$1
    if [ -z "$installFile" ] || [ ! -f "$installFile" ];then
        installFile=/home/ICUser/RDInstalled.xml
    fi

    local installPath=`cat "$installFile" | grep installpath | awk -F\" '{print $2}'`
    echo INSTALL_PATH=$installPath
    echo INSTALL1_IP=`cat "$installFile" | grep -w httpsip | awk -F [\>\<] '{print $3}'`
    echo FLOAT1_IP=`cat "$installFile" | grep -w floatip | awk -F [\>\<] '{print $3}'`
    echo HTTP1_PORT=`cat "$installFile" | grep -w httport | awk -F [\>\<] '{print $3}'`
    echo HTTPS1_PORT=`cat "$installFile" | grep -w httpsport | awk -F [\>\<] '{print $3}'`
    echo INSTALL2_IP=`cat "$installFile" | grep -w sip | awk -F 'sip=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo FLOAT2_IP=`cat "$installFile" | grep sfloatip | awk -F 'sfloatip=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo NET2_ENABLE=`cat "$installFile" | grep isEnable | awk -F 'isEnable=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo HTTP2_PORT=`cat "$installFile" | grep shttpport | awk -F 'shttpport=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo HTTPS2_PORT=`cat "$installFile" | grep shttpsport | awk -F 'shttpsport=\"' '{print $2}' | awk -F\" '{print $1}'`
    local dbconfigfile=$installFile
    cat "$installFile" | grep database &>/dev/null
    if [ $? != 0 ];then
        local xmlFile=`cat "$installPath/Runtime/bin/config/conf/config.properties" | grep db.config.file= | awk -F= '{print $2}' | tr -d '\r\n'`
        dbconfigfile=$installPath/$xmlFile
    fi
    echo DB_HOST=`cat "$dbconfigfile" | grep dbhost | awk -F 'dbhost=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo DB_PORT=`cat "$dbconfigfile" | grep dbport | awk -F 'dbport=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo DB_USER=`cat "$dbconfigfile" | grep dbuserName | awk -F 'dbuserName=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo DB_USER_PWD=`cat "$dbconfigfile" | grep dbpassword | awk -F 'dbpassword=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo DB_MANAGE_USER=`cat "$dbconfigfile" | grep manageruserName | awk -F 'manageruserName=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo DB_MANAGE_PWD=`cat "$dbconfigfile" | grep managerpassword | awk -F 'managerpassword=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo DB_FILE_PATH=`cat "$dbconfigfile" | grep dbfilepath | awk -F 'dbfilepath=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo DB_PATH=`cat "$dbconfigfile" | grep dbpath | awk -F 'dbpath=\"' '{print $2}' | awk -F\" '{print $1}'`
    echo DB_TYPE=`cat "$dbconfigfile" | grep database | grep type | awk -F 'type=\"' '{print $2}' | awk -F\" '{print $1}'`
}

function setEnvironmentPath()
{
    local commonValue="/usr/local/sbin /usr/local/bin /usr/sbin /usr/bin /root/bin /bin /sbin"
    local pathValue=$PATH
    local value=""
    for value in $commonValue
    do
        if ! echo "$PATH" | grep -E ":$value:|$value:|:$value" &>/dev/null;then
            [ -d "$value" ] && pathValue=$pathValue:$value
        fi
    done
    export PATH=$pathValue
}



function getLocalAndPeerIPList()
{
    local localName=$1
    local peerName=$2
    localIPList=""
    peerIPList=""
    local syncPairList=`echo "$SYNC" | sed 's/ //g' | sed 's/;/ /g'`
    for syncPair in $syncPairList;do
        for link in `echo "$syncPair" | sed 's/,/ /g'`;do
            local name=`echo $link | awk -F: '{print $1}'`
            local ip=`echo $link | awk -F: '{print $2}'`
            echo "$link" | grep "\[" &>/dev/null
            if [ $? -eq 0 ];then
                ip=`echo "$link" | awk -F '[' '{print $2}' | awk -F ']' '{print $1}'`
            fi
            if [ "$name" = "$localName" ];then
                localIPList="$localIPList $ip"
            fi
            if [ "$name" = "$peerName" ];then
                peerIPList="$peerIPList $ip"
            fi
        done
    done
}

function dealwithTempAlarm()
{
    local alarmtmp=$COMM_SCRIPTDIR/../ha/local/hacom/conf/alarmtmp.properties
    local lockfile=$COMM_SCRIPTDIR/../ha/local/hacom/conf/alarm_bclock
    local alarmtmpcheck=$COMM_SCRIPTDIR/../ha/local/hacom/conf/alarm_check_tmp_`date +"%s"`
    local action=$1

    if [ "$action" == "report" ];then
        local result_check=`cat "$alarmtmp" | awk -F= '{print $2}' | sed '/^$/d'`
        # no alarm need report.
        [ -z "$result_check" ] && return
    fi

    exec 110<>"$lockfile"
    flock -x 110
    Log "enter dealwith temp alarm. action=$action, time: `date +"%Y-%m-%d %H:%M:%S"`"
    if [ "$action" == "modify" ];then
        Params="--type $TYPE --severity $SEVERITY --alarmId $ALARMID --createTime $CREATETIME --param $PARAM --peerRestore $IS_PEER_RESTORE"
        Log "[INFO] $Params"
        if [ -z $TYPE ] || [ -z $SEVERITY ] || [ -z $ALARMID ] || [ -z $CREATETIME ] || [ -z $PARAM ];then
            flock -u 110
            return 0
        fi
        
        #HA心跳中断告警
        if [ "$ALARMID" = "52625456" ];then
            sed -i "/HEART_BEAT_ALARM=/c HEART_BEAT_ALARM=\"$Params\"" "$alarmtmp"
        fi 
        #HA同步失败告警
        if [ "$ALARMID" = "52625457" ];then
            sed -i "/SYNC_ALARM=/c SYNC_ALARM=\"$Params\"" "$alarmtmp"
        fi 
        #HA仲裁倒换告警
        if [ "$ALARMID" = "52625458" ];then
            sed -i "/SWITCH_ALARM=/c SWITCH_ALARM=\"$Params\"" "$alarmtmp"
        fi

        #HA链路中断告警
        if [ "$ALARMID" = "52625459" ] && [ "$IS_PEER_RESTORE" != "true" ];then
            local count=`cat "$alarmtmp" | grep -w LINK_INTERRUPT_ALARM | awk -F= '{print $2}' | grep -o "|" | wc -l`
            cat "$alarmtmp" | grep -w LINK_INTERRUPT_ALARM | awk -F= '{print $2}' | awk -F\| -v iCount=$count '{for(i=1;i<=iCount+1;i++){print $i}}' > "$alarmtmpcheck"
            local existData=`cat "$alarmtmpcheck" | grep -w "$ALARMID" | grep "$PARAM" | sed -n '1p'`
            if [ ! -z "$existData" ];then
                Log "replace link alarm: [$existData]--[$Params]"
                sed -i "s/${existData}/${Params}/g" "$alarmtmp"
            else
                Log "add link alarm: [$Params]"
                local currentLinkValue=`cat "$alarmtmp" | grep -w LINK_INTERRUPT_ALARM | awk -F= '{print $2}' | sed 's/ //g'`
                [ -z "$currentLinkValue" ] && sed -i "s/\(LINK_INTERRUPT_ALARM=.*\)/\1${Params}/g" "$alarmtmp"
                [ ! -z "$currentLinkValue" ] && sed -i "s/\(LINK_INTERRUPT_ALARM=.*\)/\1|${Params}/g" "$alarmtmp"
            fi
        fi 
        #HA网关不通告警
        if [ "$ALARMID" = "52625460" ];then
            local count=`cat "$alarmtmp" | grep -w GATEWAY_ALARM | awk -F= '{print $2}' | grep -o "|" | wc -l`
            cat "$alarmtmp" | grep -w GATEWAY_ALARM | awk -F= '{print $2}' | awk -F\| -v iCount=$count '{for(i=1;i<=iCount+1;i++){print $i}}' > "$alarmtmpcheck"
            local existData=`cat "$alarmtmpcheck" | grep -w "$ALARMID" | grep "$PARAM" | sed -n '1p'`
            if [ ! -z "$existData" ];then
                Log "replace gateway alarm: [$existData]--[$Params]"
                sed -i "s/${existData}/${Params}/g" "$alarmtmp"
            else
                Log "add gateway alarm: [$Params]"
                local currentdbValue=`cat "$alarmtmp" | grep -w GATEWAY_ALARM | awk -F= '{print $2}' | sed 's/ //g'`
                [ -z "$currentdbValue" ] && sed -i "s/\(GATEWAY_ALARM=.*\)/\1${Params}/g" "$alarmtmp"
                [ ! -z "$currentdbValue" ] && sed -i "s/\(GATEWAY_ALARM=.*\)/\1|${Params}/g" "$alarmtmp"
            fi
        fi 
        
        #gaussdb复制中断
        if [ "$ALARMID" = "52625475" ] && [ "$IS_PEER_RESTORE" != "true" ];then
            local count=`cat "$alarmtmp" | grep -w GAUSSDB_REP_ALARM | awk -F= '{print $2}' | grep -o "|" | wc -l`
            cat "$alarmtmp" | grep -w GAUSSDB_REP_ALARM | awk -F= '{print $2}' | awk -F\| -v iCount=$count '{for(i=1;i<=iCount+1;i++){print $i}}' > "$alarmtmpcheck"
            local existData=`cat "$alarmtmpcheck" | grep -w "$ALARMID" | grep "$PARAM" | sed -n '1p'`
            if [ ! -z "$existData" ];then
                Log "replace db alarm: [$existData]--[$Params]"
                sed -i "s/${existData}/${Params}/g" "$alarmtmp"
            else
                Log "add db alarm: [$Params]"
                local currentdbValue=`cat "$alarmtmp" | grep -w GAUSSDB_REP_ALARM | awk -F= '{print $2}' | sed 's/ //g'`
                [ -z "$currentdbValue" ] && sed -i "s/\(GAUSSDB_REP_ALARM=.*\)/\1${Params}/g" "$alarmtmp"
                [ ! -z "$currentdbValue" ] && sed -i "s/\(GAUSSDB_REP_ALARM=.*\)/\1|${Params}/g" "$alarmtmp"
            fi
        fi 
        
        # restore peer alarm.
        if [ "$IS_PEER_RESTORE" == "true" ];then
            local count=`cat "$alarmtmp" | grep -w REMOTE_RESTORE_ALARM_LIST | awk -F= '{print $2}' | grep -o "|" | wc -l`
            cat "$alarmtmp" | grep -w REMOTE_RESTORE_ALARM_LIST | awk -F= '{print $2}' | awk -F\| -v iCount=$count '{for(i=1;i<=iCount+1;i++){print $i}}' > "$alarmtmpcheck"
            local existData=`cat "$alarmtmpcheck" | grep -w "$ALARMID" | grep "$PARAM" | sed -n '1p'`
            if [ -z "$existData" ];then
                Log "add restore peer node alarms ${Params}"
                local curentValue=`cat "$alarmtmp" | grep REMOTE_RESTORE_ALARM_LIST | awk -F= '{print $2}' | sed 's/ //g'`
                [ -z "$curentValue" ] && sed -i "s/\(REMOTE_RESTORE_ALARM_LIST=.*\)/\1${Params}/g" "$alarmtmp"
                [ ! -z "$curentValue" ] && sed -i "s/\(REMOTE_RESTORE_ALARM_LIST=.*\)/\1|${Params}/g" "$alarmtmp"
            fi
        fi
        rm -f "$alarmtmpcheck"
    fi

    if [ "$action" == "report" ];then
        local web_port=$(xmllint --xpath "/install/httpsport/text()" "${COMM_SCRIPTDIR}/RDInstalled.xml" 2>/dev/null)
        if [ ! -z "$web_port" ];then
            local check_result=`lsof -i:$web_port`
            if [ -z "$check_result" ];then
                Log "web port is not listened. action=$action, time: `date +"%Y-%m-%d %H:%M:%S"`"
                flock -u 110
                return
            fi
        else
            ps -efww | grep java | grep Tomcat &>/dev/null;local check_result=$?
            if [ $check_result -ne 0 ];then
                Log "tomcat progress not found. action=$action, time: `date +"%Y-%m-%d %H:%M:%S"`"
                flock -u 110
                return
            fi
        fi

        HEART_BEAT_ALARM=`grep HEART_BEAT_ALARM "$alarmtmp" | grep -v HEART_BEAT_ALARM_FLAG | awk -F\" '{ print $2 }'`
        SYNC_ALARM=`grep SYNC_ALARM "$alarmtmp" | grep -v SYNC_ALARM_FLAG | awk -F\" '{ print $2 }'`
        SWITCH_ALARM=`grep SWITCH_ALARM "$alarmtmp" | grep -v SWITCH_ALARM_FLAG | awk -F\" '{ print $2 }'`
        LINK_INTERRUPT_ALARM=`grep LINK_INTERRUPT_ALARM "$alarmtmp" | grep -v LINK_INTERRUPT_ALARM_FLAG | awk -F= '{ print $2 }'`
        GATEWAY_ALARM=`grep GATEWAY_ALARM "$alarmtmp" | grep -v GATEWAY_ALARM_FLAG | awk -F= '{ print $2 }'`
        GAUSSDB_REP_ALARM=`grep GAUSSDB_REP_ALARM "$alarmtmp" | grep -v GAUSSDB_REP_ALARM_FLAG | awk -F= '{ print $2 }'`
        REMOTE_RESTORE_ALARM_LIST=`grep REMOTE_RESTORE_ALARM_LIST "$alarmtmp" | awk -F= '{ print $2 }'`
        if [ ! -z "$HEART_BEAT_ALARM" ];then
            sed -i "/HEART_BEAT_ALARM=/c HEART_BEAT_ALARM=" "$alarmtmp"
            Log "reissue alarm $HEART_BEAT_ALARM"
            pushd "$COMM_SCRIPTDIR"
            nohup sh reportAlarm.sh $HEART_BEAT_ALARM &
            popd
        fi
        
        if [ ! -z "$SYNC_ALARM" ];then
            sed -i "/SYNC_ALARM=/c SYNC_ALARM=" "$alarmtmp"
            Log "reissue alarm $SYNC_ALARM"
            pushd "$COMM_SCRIPTDIR"
            nohup sh reportAlarm.sh $SYNC_ALARM &
            popd
        fi
        
        if [ ! -z "$SWITCH_ALARM" ];then
            sed -i "/SWITCH_ALARM=/c SWITCH_ALARM=" "$alarmtmp"
            Log "reissue alarm $SWITCH_ALARM"
            pushd "$COMM_SCRIPTDIR"
            nohup sh reportAlarm.sh $SWITCH_ALARM &
            popd
        fi
        
        if [ ! -z "$LINK_INTERRUPT_ALARM" ];then
            local count=`cat "$alarmtmp" | grep -w LINK_INTERRUPT_ALARM | awk -F= '{print $2}' | grep -o "|" | wc -l`
            cat "$alarmtmp" | grep -w LINK_INTERRUPT_ALARM | awk -F= '{print $2}'  | awk -F\| -v iCount=$count '{for(i=1;i<=iCount+1;i++){print $i}}' > "$alarmtmpcheck"
            while read alarmdata;do
                [ -z "$alarmdata" ] && continue
                sed -i "s/$alarmdata//g" "$alarmtmp"
                sed -i "s/=|/=/g" "$alarmtmp"
                Log "start reissue link alarm. [$alarmdata]"
                pushd "$COMM_SCRIPTDIR"
                nohup sh reportAlarm.sh $alarmdata &
                popd
            done < "$alarmtmpcheck"
            rm -f "$alarmtmpcheck"
        fi
        
        if [ ! -z "$GATEWAY_ALARM" ];then
            local count=`cat "$alarmtmp" | grep -w GATEWAY_ALARM | awk -F= '{print $2}' | grep -o "|" | wc -l`
            cat "$alarmtmp" | grep -w GATEWAY_ALARM | awk -F= '{print $2}'  | awk -F\| -v iCount=$count '{for(i=1;i<=iCount+1;i++){print $i}}' > "$alarmtmpcheck"
            while read alarmdata;do
                [ -z "$alarmdata" ] && continue
                sed -i "s/$alarmdata//g" "$alarmtmp"
                sed -i "s/=|/=/g" "$alarmtmp"
                Log "start reissue gateway alarm. [$alarmdata]"
                pushd "$COMM_SCRIPTDIR"
                nohup sh reportAlarm.sh $alarmdata &
                popd
            done < "$alarmtmpcheck"
            rm -f "$alarmtmpcheck"
        fi
        
        # gaussdb replication alarm
        if [ ! -z "$GAUSSDB_REP_ALARM" ];then
            local count=`cat "$alarmtmp" | grep -w GAUSSDB_REP_ALARM | awk -F= '{print $2}' | grep -o "|" | wc -l`
            cat "$alarmtmp" | grep -w GAUSSDB_REP_ALARM | awk -F= '{print $2}'  | awk -F\| -v iCount=$count '{for(i=1;i<=iCount+1;i++){print $i}}' > "$alarmtmpcheck"
            while read alarmdata;do
                [ -z "$alarmdata" ] && continue
                sed -i "s/$alarmdata//g" "$alarmtmp"
                sed -i "s/=|/=/g" "$alarmtmp"
                Log "start reissue db alarm. [$alarmdata]"
                pushd "$COMM_SCRIPTDIR"
                nohup sh reportAlarm.sh $alarmdata &
                popd
            done < "$alarmtmpcheck"
            rm -f "$alarmtmpcheck"
        fi
        
        if [ ! -z "$REMOTE_RESTORE_ALARM_LIST" ];then
            local count=`echo "$REMOTE_RESTORE_ALARM_LIST" | grep -o "|" | wc -l`
            echo "$REMOTE_RESTORE_ALARM_LIST" | awk -F\| -v iCount=$count '{for(i=1;i<=iCount+1;i++){print $i}}' > "$alarmtmpcheck"
            while read alarmdata;do 
                [ -z "$alarmdata" ] && continue
                sed -i "s/$alarmdata//g" "$alarmtmp"
                sed -i "s/=|/=/g" "$alarmtmp"
                Log "start restore peer alarm. [$alarmdata]"
                pushd "$COMM_SCRIPTDIR"
                nohup sh reportAlarm.sh $alarmdata &
                popd
            done < "$alarmtmpcheck"
            rm -f "$alarmtmpcheck"
        fi
    fi
    Log "end dealwith temp alarm. action=$action, time: `date +"%Y-%m-%d %H:%M:%S"`"
    flock -u 110
}


Chattr() {
	opt="$1"
	if [ "$opt" = "" ]; then
		exit 1
	fi
	shift
	path=`echo "$1"|sed 's/\/$//'`
	shift
	if [ ! -d "$path" ]; then
		exit 1
	fi
	find "$path" -user root -type f -executable | grep -v '/ha/module/' | while read line
	do
		chattr "$opt" "$line"
	done
}
LockRootScript() {
	trap "" EXIT
	for path in "$@"
	do
		Chattr +i $path
	done
}
UnlockRootScript() {
	for path in "$@"
	do
		Chattr -i $path
	done
}

LockNodeAgentAndJreFile() {
    trap "" EXIT
    path="$@"
    #chattr +i "$path"/NodeAgent
    chattr +i "$path"/NodeAgent/bin
    chattr +i "$path"/NodeAgent/bin/*
    chattr +i "$path"/NodeAgent/lib
    chattr +i "$path"/NodeAgent/lib/*

    chattr +i "$path"/jre6.0.18
    chattr +i "$path"/jre6.0.18/bin
    chattr +i "$path"/jre6.0.18/lib
    chattr +i "$path"/jre6.0.18/bin/*

    if [ -e "$path"/jre6.0.18/lib/amd64 ]; then
        chattr +i -R "$path"/jre6.0.18/lib/amd64
    fi
    if [ -e "$path"/jre6.0.18/lib/aarch64 ]; then
        chattr +i -R "$path"/jre6.0.18/lib/aarch64
    fi

    if [ -e "$path"/Tomcat6/Lego-UI-Plat/WEB-INF/lib/ws_om.jar ]; then
        chattr +i "$path"/Tomcat6/Lego-UI-Plat/WEB-INF/lib/ws_om.jar
    fi
	
    chattr +i "$path"/ha
    chattr +i -R "$path"/ha/libs
    chattr +i -R "$path"/bin/lib
    chattr +i "$path"/bin/reportAlarm.sh
}

UnLockNodeAgentAndJreFile() {
    trap "" EXIT
    path="$@"

    #chattr -i "$path"/NodeAgent
    chattr -i "$path"/NodeAgent/bin
    chattr -i "$path"/NodeAgent/bin/*
    chattr -i "$path"/NodeAgent/lib
    chattr -i "$path"/NodeAgent/lib/*

    chattr -i "$path"/jre6.0.18
    chattr -i "$path"/jre6.0.18/bin
    chattr -i "$path"/jre6.0.18/lib
    chattr -i "$path"/jre6.0.18/bin/*

    if [ -e "$path"/jre6.0.18/lib/amd64 ]; then
        chattr -i -R "$path"/jre6.0.18/lib/amd64
    fi
    if [ -e "$path"/jre6.0.18/lib/aarch64 ]; then
        chattr -i -R "$path"/jre6.0.18/lib/aarch64
    fi

    if [ -e "$path"/Tomcat6/Lego-UI-Plat/WEB-INF/lib/ws_om.jar ]; then
        chattr -i "$path"/Tomcat6/Lego-UI-Plat/WEB-INF/lib/ws_om.jar
    fi
	
    chattr -i "$path"/ha
    chattr -i -R "$path"/ha/libs
    chattr -i -R "$path"/bin/lib
    chattr -i "$path"/bin/reportAlarm.sh
}

######################################################################
#   DESCRIPTION: 停止Server服务
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function StopServer()
{
    local installPath=`getInstallInfo | grep INSTALL_PATH | awk -F= '{print $2}'`
    local binPath=$installPath/Runtime/bin
    local curPath=`pwd`
    pushd "$binPath" &>/dev/null
    echo y|sh shutdownSystem.sh 1>> "$LOG_FILE_NAME" 2>> "$LOG_FILE_NAME"
    pushd "$curPath"  &>/dev/null
}

######################################################################
#   DESCRIPTION: 启动Server服务
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function StartServer()
{
    local BCMANAGER_PATH="$COMM_BCMANAGER_PATH"
    local StartSystemScript="${BCMANAGER_PATH}/Runtime/bin/startSystem.sh"
    CheckFileExist "${StartSystemScript}"
    "${StartSystemScript}" 
    if [ $? -ne 0 ];then 
        Log "Start the software failed."
        echo "Start the software failed."
       
    else 
        echo "Start the software successfully."
        
    fi
    
}
######################################################################
#   DESCRIPTION: 提示用户启动系统服务
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function RemindUserStart()
{   
    Log "Prompt to start"
    local Ret=""
    while [ 1 ]
    do
        echo -ne "\n"
        echo "Are you sure to start up the software immediately? (y/n):"
        if [ "true" == "$ISAUTODEP" ] || [ "true" == "$IS_ACTIVE_STANDBY_AUTO" ] || [ "true" == "$ISAUTOCONF" ];then
            Ret=n
        else
            read Ret
        fi
        
        if [ "${Ret}" = "y" ] || [ "${Ret}" = "n" ] || [ "${Ret}" = "Y" ] || [ "${Ret}" = "N" ];then
            break
        else
            echoInfo "ERROR: Your input is invalid."
            echo "Please try again."
            echo -ne "\n"
            continue    
        fi  
        break
    done  
    if [ "${Ret}" = "y" ] || [ "${Ret}" = "Y" ];then
        #echo "The DR system is starting."
        Log "[Info] The DR system is starting."
        StartServer
    else 
        echo "You chosen not to start the software."    
    fi            
    return 0
}

######################################################################
#   DESCRIPTION: 提示用户停止系统服务
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function RemindUserStop()
{
    checkBCMServiceRunning
    if [ $? != 0 ];then
        return
    fi
    Log "Prompt to stop"
    local Ret=""
    while [ 1 ]
    do
        if [ "true" == "$ISAUTODEP" ] || [ "true" == "$IS_ACTIVE_STANDBY_AUTO" ] || [ "true" == "$ISAUTOCONF" ] || [ "true" == "$ISAUTOUPGRADE" ];then
            Ret=y
        else
            read -p "Are you sure you want to stop the DR system? (y/n):" Ret
        fi

        if [ "${Ret}" = "y" ] || [ "${Ret}" = "n" ] || [ "${Ret}" = "Y" ] || [ "${Ret}" = "N" ];then
            break
        else
            echoInfo "ERROR: Your input is invalid."
            echo "Please try again."
            echo -ne "\n"
            continue    
        fi  
        break
    done
    if [ "${Ret}" = "y" ] || [ "${Ret}" = "Y" ];then
        echo "The DR system is stopping."
        Log "[Info] The DR system is stopping."
        StopServer
        return 0
    else 
        echo "The configuration has been canceled."
        return 1
    fi            
    
}

function setKeyValueForFile()
{
    local fileName=$1
    local key=$2
    local value=$3

    if [[ -f "$fileName" && -n "${key}" ]]; then
        cat "$fileName" | grep -Ev "^$|^[[:space:]]*[#]|^[[:space:]]*$" | grep "^$key" &>/dev/null
        if [[ $? -eq 0 ]]; then
            if [[ -n ${value} ]]; then
                value=`echo ${value} | sed 's#/#\\\/#g'`
            fi
            sed -i "s#^$key=.*#$key=$value#g" "$fileName"
        else
            echo -e "\n$key=$value" >> "$fileName"
        fi
        return 0
    else
        Log "[ERROR] $FUNCNAME param error, fileName=${fileName}, key=${key}"
        return 1
    fi
}

function getKeyValueFromFile()
{
    local fileName=$1
    local key=$2
    local value=""
    if [[ -f "$fileName" && -n "${key}" ]]; then
        local findStr=`cat "$fileName" | grep -v '^#' | grep "^$key"`
        if [[ -n ${findStr} ]]; then
            value=`echo "${findStr#*=}" | tr -d '\r\n'`
        fi
    else
        Log "[ERROR] $FUNCNAME param error, fileName=${fileName}, key=${key}"
    fi
    echo "${value}"
}


######################################################################
#   DESCRIPTION: 判断当前节点所在站点类型
#   RETURN     : 0：非一主三备场景，无此key值
#                1：站点为主站点
#                2：站点为备站点
#   CHANGE DIR : 无
######################################################################
function isActiveSite()
{
    is_active_site=`cat $NODE_PROPERTIES_FILE | grep -v '^#' | grep is_active_site | awk -F = '{print $2}' | tr -d '\r\n'`
    echo "$is_active_site" | grep -wE "true|false" &>/dev/null
    if [ -z "$is_active_site" ]; then
        Log "[INFO] is_active_site is empty"
        return 0
    elif [ "$is_active_site" = "true" ]; then
        Log "[INFO] is_active_site is true"
        return 1
    elif [ "$is_active_site" = "false" ]; then
        Log "[INFO] is_active_site is false"
        return 2
    else
        Log "[ERROR] is_active_site error ${is_active_site}"
        exit 1
    fi
}

######################################################################
#   DESCRIPTION: 打印换行以及分割线
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function printLine()
{
    echo -ne "\n"
    echo "------------------------------------------------------------------------------------------------------------"
    echo -ne "\n" 
}


######################################################################
#   DESCRIPTION: 删除定时任务
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function delete_monitor_from_crontab()
{
    local DAEMON_SCRIPT=$1
    Log "start remove monitor task. ${DAEMON_SCRIPT}"
    if [[ -z "${DAEMON_SCRIPT}" ]]; then
        return 1
    fi
    local CRONTAB_FILE="/etc/crontab"
    local CRONTAB_FILE_BK="/etc/crontab_1"
    local sysTypeFile="/etc/redhat-release"
    if [ -f "$sysTypeFile" ]
    then
        local CRON_SERVICE_CMD="service crond restart"
        if [ "$DAEMON_SCRIPT" == "scan_large_log_files.sh" ]; then
            CRONTAB_FILE="/var/spool/cron/root"
            CRONTAB_FILE_BK="/var/spool/cron/root_1"
        else
            CRONTAB_FILE="/var/spool/cron/ICUser"
            CRONTAB_FILE_BK="/var/spool/cron/ICUser_1"
        fi
        [ ! -f "${CRONTAB_FILE}" ] && touch "${CRONTAB_FILE}" && chmod 600 "${CRONTAB_FILE}"
    else
        local CRON_SERVICE_CMD="service cron restart"
    fi

    cat "${CRONTAB_FILE}" | grep "${DAEMON_SCRIPT}" &>/dev/null
    local result=$?
    if [ "$result" -ne 0 ]            #already not exist in crontab.
    then
        Log "${CRONTAB_FILE} is no target."
        return 0
    fi

    sed "/${DAEMON_SCRIPT}/d" "${CRONTAB_FILE}" > ${CRONTAB_FILE_BK}
    if [ $? -ne 0 ]
    then
        Log "sed failed."
        return 1
    fi
    mv ${CRONTAB_FILE_BK} ${CRONTAB_FILE}
    ps -ef | grep ${DAEMON_SCRIPT} | grep -v grep | awk '{print $2}' | xargs kill -9 1>> "$LOG_FILE_NAME" 2>> "$LOG_FILE_NAME"   #if not kill the script, HA will restarted by script.
    $CRON_SERVICE_CMD 1>> "$LOG_FILE_NAME" 2>> "$LOG_FILE_NAME"
    if [ $? -ne 0 ]
    then
        Log "restart cron failed."
        return 1
    fi
    Log "remove monitor task success.${DAEMON_SCRIPT}"
    return 0
}

######################################################################
#   DESCRIPTION: 添加或删除SSH监听IP
#   RETURN     : 无
#   CHANGE DIR : 无
######################################################################
function setListenAddressForSsh()
{
    local action=$1
    local listenIp=$2
    local sshConfigFile="/etc/ssh/sshd_config"
    if [[ ${action} = "add" ]]; then
        cat "$sshConfigFile" | grep -v '^#' | grep "^ListenAddress \+${listenIp}" &>/dev/null
        if [[ $? -ne 0 ]]; then
            echo -e "\nListenAddress ${listenIp}" >> "$sshConfigFile"
            service sshd restart >/dev/null 2>&1
        fi
    elif [[ ${action} = "delete" ]]; then
        cat "$sshConfigFile" | grep -v '^#' | grep "^ListenAddress \+${listenIp}" &>/dev/null
        if [[ $? -eq 0 ]]; then
            sed -i "/^ListenAddress \+${listenIp}/d" "$sshConfigFile"
            service sshd restart >/dev/null 2>&1
        fi
    elif [[ ${action} = "clean" ]]; then
        cat "$sshConfigFile" | grep -v '^#' | grep "^ListenAddress" &>/dev/null
        if [[ $? -eq 0 ]]; then
            sed -i "/^ListenAddress/d" "$sshConfigFile"
        fi
    else
        Log "setListenAddressForSsh action ERROR:${action}"
    fi
}

changeFilePermission()
{
    SYS_USER_NAME=`cat ${LEGO_HOME}/Runtime/bin/config/conf/startInfo.properties| grep -v '^#' | grep custom.user.name |awk -F = '{print $2}'| tr -d '\r\n'`
    TOMCAT_USER_NAME=`cat ${LEGO_HOME}/Runtime/bin/config/conf/startInfo.properties| grep -v '^#' | grep tomcat.user.name |awk -F = '{print $2}'| tr -d '\r\n'`
    USER_GROUP_NAME=`cat ${LEGO_HOME}/Runtime/bin/config/conf/startInfo.properties| grep -v '^#' | grep custom.user.group |awk -F = '{print $2}'| tr -d '\r\n'`

    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/LegoRuntime/conf/lego.properties 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/LegoRuntime/conf/account.properties 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/bin/config/conf/config.properties 1>/dev/null 2>&1
    chown -h "$TOMCAT_USER_NAME":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/Tomcat6/conf/server.xml 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/ha/local/conf/ha.properties 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/LegoRuntime/conf/ha.properties 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/NodeAgent/conf/nodeAgent.properties 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/NodeAgent/conf/nodeAgent-pwd.properties 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/bin/config/system.xml 1>/dev/null 2>&1

    sudo -u ${SYS_USER_NAME} -S chmod 600 ${LEGO_HOME}/Runtime/LegoRuntime/conf/lego.properties 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 600 ${LEGO_HOME}/Runtime/LegoRuntime/conf/account.properties 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 400 ${LEGO_HOME}/Runtime/bin/config/conf/config.properties 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 640 ${LEGO_HOME}/Runtime/Tomcat6/conf/server.xml 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 600 ${LEGO_HOME}/Runtime/ha/local/conf/ha.properties 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 600 ${LEGO_HOME}/Runtime/NodeAgent/conf/nodeAgent.properties 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 600 ${LEGO_HOME}/Runtime/NodeAgent/conf/nodeAgent-pwd.properties 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 640 ${LEGO_HOME}/Runtime/bin/config/system.xml 1>/dev/null 2>&1

    ## sign file permission change
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/LegoRuntime/tools/esn.sh.sign 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/LegoRuntime/run.sh.sign 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/bin/config/conf/*.sign 1>/dev/null 2>&1
    chown -h "${SYS_USER_NAME}":"$USER_GROUP_NAME" ${LEGO_HOME}/Runtime/gs/bin/gsService.sh.sign 1>/dev/null 2>&1

    sudo -u ${SYS_USER_NAME} -S chmod 400 ${LEGO_HOME}/Runtime/bin/*.sh.sign 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 400 ${LEGO_HOME}/Runtime/bin/config/conf/*.sign 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 400 ${LEGO_HOME}/Runtime/LegoRuntime/run.sh.sign 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 400 ${LEGO_HOME}/Runtime/LegoRuntime/tools/esn.sh.sign 1>/dev/null 2>&1
    sudo -u ${SYS_USER_NAME} -S chmod 400 ${LEGO_HOME}/Runtime/gs/bin/gsService.sh.sign 1>/dev/null 2>&1
}

function restorePeerRegionAlarm()
{
    local CREATETIME=`date "+%s"`000              #事件发生时间 
    local TYPE=2                      #HA告警类型
    local HEART_BEAT_ALARM_ID=52625456            #HA心跳中断告警ID，0x3230030
    local SYNC_ALARM_ID=52625457                  #HA同步失败告警ID，0x3230031
    local SWITCH_ALARM_ID=52625458                #HA仲裁倒换告警ID，0x3230032
    local LINK_INTERRUPT_ALARM_ID=52625459        #HA链路中断告警ID, 0x3230033
    local GATEWAY_ALARM_ID=52625460               #HA网关不通告警ID, 0x3230034
    # 网关ip存储位置ha/module/haarb/conf/haarb.xml
    local DB_ALARM_ID=52625475                    #高斯链路告警
	
	# 获取对端region的节点ip
    local node_prop="$COMM_SCRIPTDIR/../LegoRuntime/conf/node.properties"
    local global_region_key="config.hcs.node.region"
    local region_name=`getKeyValueFromFile ${node_prop} ${global_region_key}`

    Log "start restore peer region alarm, current region name:${region_name}"

    declare -a HaArbLk_Local_IP_Arr
    index=0
    for i in $(cat $COMM_SCRIPTDIR/../NodeAgent/conf/nodeAgent.properties | grep "node_" | awk -F '=' '{print $2}'|grep -v "$region_name" |awk -F ';' '{print $1}')
    do
          HaArbLk_Local_IP_Arr[$index]=$i
          echo $i
          let "index+=1"
    done

    # 获取本端region的节点ip
    declare -a HaArbLk_Region_IP_Arr
    index=0
    for i in $(cat ${COMM_SCRIPTDIR}/../NodeAgent/conf/nodeAgent.properties | grep "node_" | awk -F '=' '{print $2}'|grep "$region_name" |awk -F ';' '{print $1}')
    do
          HaArbLk_Region_IP_Arr[${index}]=$i
          echo $i
          let "index+=1"
    done
	 
    # 若取出两个ip,则分别设置为lop和peer
    if [ -n ${HaArbLk_Local_IP_Arr} ] && [ ${#HaArbLk_Local_IP_Arr[@]} -eq 2 ]; then
          local lop=${HaArbLk_Local_IP_Arr[0]}
          local peer=${HaArbLk_Local_IP_Arr[1]}
          Log "start send clear alarm:${lop}-${peer}"
	
          # 发送告警
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${HEART_BEAT_ALARM_ID} --createTime $CREATETIME --param "aa,$lop,bb,$peer" --peerRestore "false" &
	
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${SYNC_ALARM_ID} --createTime $CREATETIME --param "aa,$lop,bb,$peer" --peerRestore "false" &
	
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${LINK_INTERRUPT_ALARM_ID} --createTime $CREATETIME --param "bb,$lop,25321,aa,$peer" --peerRestore "false" &
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${LINK_INTERRUPT_ALARM_ID} --createTime $CREATETIME --param "bb,$peer,25321,aa,$lop" --peerRestore "false" &
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${LINK_INTERRUPT_ALARM_ID} --createTime $CREATETIME --param "bb,$lop,25221,aa,$peer" --peerRestore "false" &
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${LINK_INTERRUPT_ALARM_ID} --createTime $CREATETIME --param "bb,$peer,25221,aa,$lop" --peerRestore "false" &
	
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${GATEWAY_ALARM_ID} --createTime $CREATETIME --param "aa,$lop,active,51.6.131.1" --peerRestore "false" &
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${GATEWAY_ALARM_ID} --createTime $CREATETIME --param "aa,$peer,active,51.6.131.1" --peerRestore "false" &
	
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${DB_ALARM_ID} --createTime $CREATETIME --param "$lop,$peer" --peerRestore "true" &	
          nohup sh reportAlarm.sh --type $TYPE --severity 4 --alarmId ${DB_ALARM_ID} --createTime $CREATETIME --param "$peer,$lop" --peerRestore "true" &

          # 在管理面切换完成前，将原主region与备region间产生的高斯链路告警清除
          if [ -n ${HaArbLk_Region_IP_Arr} ] && [ ${#HaArbLk_Region_IP_Arr[@]} -eq 2 ]; then
              local regionLop=${HaArbLk_Region_IP_Arr[0]}
              local regionPeer=${HaArbLk_Region_IP_Arr[1]}

              Log "start send clear alarm:${lop}-${regionLop},${regionPeer}."
              nohup sh reportAlarm.sh --type ${TYPE} --severity 4 --alarmId ${DB_ALARM_ID} --createTime ${CREATETIME} --param "${lop},${regionLop}" --peerRestore "true" &
              nohup sh reportAlarm.sh --type ${TYPE} --severity 4 --alarmId ${DB_ALARM_ID} --createTime ${CREATETIME} --param "${lop},${regionPeer}" --peerRestore "true" &

              Log "start send clear alarm:${peer}-${regionLop},${regionPeer}."
              nohup sh reportAlarm.sh --type ${TYPE} --severity 4 --alarmId ${DB_ALARM_ID} --createTime ${CREATETIME} --param "${peer},${regionLop}" --peerRestore "true" &
              nohup sh reportAlarm.sh --type ${TYPE} --severity 4 --alarmId ${DB_ALARM_ID} --createTime ${CREATETIME} --param "${peer},${regionPeer}" --peerRestore "true" &
          fi
	fi

}

function validRegionId()
{
    local result=""
    local minlen=2
    local maxlen=256
    local curlen=0
    local regionId="$*"

    if [ -z "${regionId}" ]; then
        return 1
    fi

    curlen=$(echo "${regionId}" | wc -c)
    if [ ${curlen} -lt ${minlen} ]
    then
        echoInfo "The region ID must be a valid combination of letters, digits, hyphens (-), and dots (.). The maximum length is 255 characters."
        return 1
    fi

    if [ ${curlen} -gt ${maxlen} ]
    then
        echoInfo "The region ID must be a valid combination of letters, digits, hyphens (-), and dots (.). The maximum length is 255 characters."
        return 1
    fi
    result=$(echo "${regionId}" | grep "[^a-zA-Z0-9\.-]")
    if [ ! -z "${result}" ];  then
        echoInfo "The region ID must be a valid combination of letters, digits, hyphens (-), and dots (.). The maximum length is 255 characters."
        return 1
    fi
    return 0
}

function fileNameAndPathInvalidCheck()
{
    local fileName="$1"
    if [ -z "${fileName}" ]; then
        echoInfo "The file name is empty."
        return 1
    fi

    local result=$(echo "${fileName}" | grep "[^a-zA-Z0-9./+_-]")
    if [ ! -z "${result}" ];  then
        echoInfo "The file name contains invalid characters."
        return 1
    fi

    return 0
}

##############################################################
## @Usage lock [lock_name]
## @Return 0 : 成功
## @Description 获取文件锁
##############################################################
function lock() {
  local lock_name=$1
  if [ -z "${lock_name}" ]; then
      lock_name=$0
  fi

  Log "[INFO] Start lock ${lock_name}"
  local lock_dir="$(dirname "${LOG_FILE_NAME}")"
  if [ ! -d "${lock_dir}" ]; then
      lock_dir="${COMM_SCRIPTDIR}/logs"
  fi
  lock_file="${lock_dir}/${lock_name}.lock"

  for ((i = 0; i < 3; i++)); do
    exec 173<>"${lock_file}"
    flock -n 173
    if [ $? -eq 1 ]; then
      local pre_pid=$(cat "${lock_file}")
      if [ -n "${pre_pid}" ]; then
        local proc_count=$(ps -ef | grep -v "grep" | awk '{print $2}' | grep -w "${pre_pid}" | wc -l)
        if [ "${proc_count}" -ne "0" ]; then
          Log "[WARN] Another process is running. Lock failed."
          exec 173<&-
          return 1
        fi
      fi
      Log "[WARN] The previous process exited abnormally. Remove lock file."
      rm -f "${lock_file}"
    else
      echo "$$" > "${lock_file}"
      chmod 600 "${lock_file}"
      Log "[INFO] Lock success."
      return 0
    fi
  done
  Log "[ERROR] Lock failed unexpected."
  exec 173<&-
  return 1
}

##############################################################
## @Usage unlock
## @Return 0 : 成功
## @Description 释放文件锁
##############################################################
function unlock() {
  flock -u 173
  exec 173<&-
  Log "[INFO] Unlocked success."
}
