#!/bin/sh
SCRIPTDIR=$(cd `dirname "$0"` && pwd)
source "$SCRIPTDIR/log.sh" $0
echo "You are about to roll back a patch."
echo "This operation will stop the DR system. All protected groups and recovery plans will be stopped."
echo "To roll back a patch will restore the system configurations to the source status. All service data "
echo "generated after the patch was installed will be deleted."
echo ""
echo "Suggestion: This operation is only recommended when the eReplication services cannot be started normally. "
echo ""
while [ 1 ]
do
    read -p "Are you sure you want to continue? (y/n): " isSure
    echo "$isSure" | grep -Ew "y|Y|N|n" &>/dev/null
    if [ $? = 0 ];then
        break
    fi 
done

echo "$isSure" | grep -Ew "N|n" &>/dev/null
if [ $? = 0 ];then
    exit 0
fi

pushd "$SCRIPTDIR" &>/dev/null
LOG_FILE_NAME=$SCRIPTDIR/root_logs/rollBackPatch.log
source "$SCRIPTDIR/commfunc.sh" 1>>"$LOG_FILE_NAME" 2>> "$LOG_FILE_NAME"
startClassList="install;commons-codec;slf4j-api;one-track-4-kmc;wcc_helper;slf4j-reload4j;commons-lang3;dom4j;jaxen;legoLog;log4j-api;log4j-core;log4j-1.2-api;disruptor;Lego-Core-Log-Bundle;Lego-Core-SDK-Bundle;commons-logging;gsjdbc4;bcprov-jdk15on;lombok;httpclient5;httpcore5;spring-jcl;spring-core;jackson-databind;jackson-core;jackson-annotations"
getClassPath "$startClassList"
SYS_USER_NAME=`cat "$SCRIPTDIR/config/conf/startInfo.properties"| grep -v '^#' | grep custom.user.name |awk -F = '{print $2}'| tr -d '\r\n'`
USER_GROUP_NAME=`cat "$SCRIPTDIR/config/conf/startInfo.properties"| grep -v '^#' | grep custom.user.group |awk -F = '{print $2}'| tr -d '\r\n'`
TOMCAT_USER_NAME=`cat "$SCRIPTDIR/config/conf/startInfo.properties"| grep -v '^#' | grep tomcat.user.name |awk -F = '{print $2}'| tr -d '\r\n'`

echo ""
echo "Rolling back the patch... Please wait."
Log "Rolling back the patch... Please wait."
echo y|sh shutdownSystem.sh 1>>"$LOG_FILE_NAME" 2>&1
status=`/etc/init.d/gaussdb status | grep -w "PID"`
if [ -z "$status" ];then
    Log "gaussdb is not run, start gaussdb."
    /etc/init.d/gaussdb start 1>>"$LOG_FILE_NAME" 2>>"$LOG_FILE_NAME"
    isStartDB=true
    sleep 2
fi

chattr -i "${SCRIPTDIR}"/*.sh
../jre6.0.18/bin/java -cp $CLASSPATH com.huawei.lego.cli.patch.rollback.PatchRollBack 2>> "$LOG_FILE_NAME"
if [ $? != 0 ];then
    Log "roll back the patch failed."
else 
    echo ""
    echo "Patch rollback succeeded."
fi
chattr +i "${SCRIPTDIR}"/*.sh

if [ ! -z "$isStartDB" ] && [ "$isStartDB" = "true" ];then
    /etc/init.d/gaussdb stop 1>>"$LOG_FILE_NAME" 2>>"$LOG_FILE_NAME"
fi

find "$SCRIPTDIR"/../LegoRuntime/ -name "*.jar" -exec chattr -i {} \; >>"$LOG_FILE_NAME" 2>&1
chown -Rh "$SYS_USER_NAME":"$USER_GROUP_NAME" $(find "$SCRIPTDIR"/../LegoRuntime/ -name "*.jar") 1>>"$LOG_FILE_NAME" 2>>"$LOG_FILE_NAME"
chmod -R 400 $(find "$SCRIPTDIR"/../LegoRuntime/ -name "*.jar") 1>>"$LOG_FILE_NAME" 2>>"$LOG_FILE_NAME"
find "$SCRIPTDIR"/../Tomcat6/ -name "*.jar" -exec chattr -i {} \; >>"$LOG_FILE_NAME" 2>&1
chown -Rh "$TOMCAT_USER_NAME":"$USER_GROUP_NAME" $(find "$SCRIPTDIR"/../Tomcat6/ -name "*.jar") 1>>"$LOG_FILE_NAME" 2>>"$LOG_FILE_NAME"
chmod -R 400 $(find "$SCRIPTDIR"/../Tomcat6/ -name "*.jar") 1>>"$LOG_FILE_NAME" 2>>"$LOG_FILE_NAME"
chmod 640 "$SCRIPTDIR"/logs/*
