/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.template.sdk.service;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemlate;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractExtendPolicyTemlate
extends AbstractPolicyTemlate {
    private static final Log logger = LogFactory.getInstance(AbstractExtendPolicyTemlate.class);
    private IStorageService storageService;
    private IStorageResourceService storageResourceService;

    protected void filter3DcCascadePairMap(boolean existProtectGroupReplica, int type, int locationType, int templateType, Map<String, List<ReplicationPair>> devicesnPairMap) {
        Map<String, Map<String, List<ReplicationPair>>> recoverPairMap;
        if (DrmEnumDefine.ProtectLocation.A_B.getValue() != locationType) {
            return;
        }
        if (PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_ASYNC_ASYNC.getValue() == templateType || PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_SYNC_ASYNC.getValue() == templateType) {
            recoverPairMap = this.getRecoverPairMap(existProtectGroupReplica, devicesnPairMap);
            this.updateRecoverPairMap(true, devicesnPairMap, recoverPairMap);
        } else if (PolicyTemplateType.PolicyTemplateE.ARRAY_REPLICA_SYNC.getValue() == templateType || PolicyTemplateType.PolicyTemplateE.ARRAY_REPLICA_ASYNC.getValue() == templateType) {
            recoverPairMap = this.getRecoverPairMap(existProtectGroupReplica, devicesnPairMap);
            this.updateRecoverPairMap(false, devicesnPairMap, recoverPairMap);
        }
        if (null != devicesnPairMap && !existProtectGroupReplica) {
            for (List<ReplicationPair> pairList : devicesnPairMap.values()) {
                if (VerifyUtil.isEmpty(pairList)) continue;
                List<ReplicationPair> filterpairs = this.getValidStatusReplicationPairs(pairList);
                Iterator<ReplicationPair> it = pairList.iterator();
                while (it.hasNext()) {
                    ReplicationPair pair = it.next();
                    if (filterpairs.contains(pair)) continue;
                    it.remove();
                }
            }
        }
    }

    protected void updateRecoverPairMap(boolean needHasRepPair, Map<String, List<ReplicationPair>> devicesnPairMap, Map<String, Map<String, List<ReplicationPair>>> recoverPairMap) {
        if (null != devicesnPairMap && null != recoverPairMap) {
            for (List<ReplicationPair> pairList : devicesnPairMap.values()) {
                if (VerifyUtil.isEmpty(pairList) || pairList.size() <= 1) continue;
                ArrayList<ReplicationPair> removeList = new ArrayList<ReplicationPair>();
                for (ReplicationPair replicationPair : pairList) {
                    List repTgtLuns = replicationPair.getRepTgtLuns();
                    if (needHasRepPair && !this.hashRepPair(repTgtLuns, recoverPairMap)) {
                        removeList.add(replicationPair);
                        continue;
                    }
                    if (needHasRepPair || !this.hashRepPair(repTgtLuns, recoverPairMap)) continue;
                    removeList.add(replicationPair);
                }
                pairList.removeAll(removeList);
            }
        }
    }

    private boolean hashRepPair(List<ReplicationTargetLun> repTgtLuns, Map<String, Map<String, List<ReplicationPair>>> recoverPairMap) {
        boolean hashRepPair = true;
        if (VerifyUtil.isEmpty(repTgtLuns)) {
            return hashRepPair;
        }
        for (ReplicationTargetLun replicationTargetLun : repTgtLuns) {
            String tgtDevSN = replicationTargetLun.getTgtDevSN();
            String tgtLunId = replicationTargetLun.getTgtLunId();
            Map<String, List<ReplicationPair>> lunPairMap = recoverPairMap.get(tgtDevSN);
            if (null == lunPairMap) {
                hashRepPair = false;
                break;
            }
            List<ReplicationPair> list = lunPairMap.get(tgtLunId);
            if (null != list && !list.isEmpty()) continue;
            hashRepPair = false;
            break;
        }
        return hashRepPair;
    }

    protected Map<String, Map<String, List<ReplicationPair>>> getRecoverPairMap(boolean existProtectGroupReplica, Map<String, List<ReplicationPair>> devicesnPairMap) {
        HashMap<String, Map<String, List<ReplicationPair>>> pairMap = new HashMap<String, Map<String, List<ReplicationPair>>>();
        if (null != devicesnPairMap) {
            Map<String, Set<String>> lunSourceMap = this.getLunSourceMap(devicesnPairMap);
            for (Map.Entry<String, Set<String>> entry : lunSourceMap.entrySet()) {
                Set<String> resourceIdSet = entry.getValue();
                ArrayList<Lun> lunList = new ArrayList<Lun>();
                for (String lunId : resourceIdSet) {
                    Lun lun = new Lun();
                    lun.setDevSn(entry.getKey());
                    lun.setLunId(lunId);
                    lunList.add(lun);
                }
                Lun[] lunArray = new Lun[lunList.size()];
                lunList.toArray(lunArray);
                List<ReplicationPair> remotePairList = this.getPairsByLun(lunArray);
                if (null == remotePairList) continue;
                HashMap<String, List<ReplicationPair>> map = (HashMap<String, List<ReplicationPair>>)pairMap.get(entry.getKey());
                if (null == map) {
                    map = new HashMap<String, List<ReplicationPair>>();
                    pairMap.put(entry.getKey(), map);
                }
                this.updatePairMap(existProtectGroupReplica, remotePairList, map);
            }
        }
        return pairMap;
    }

    protected List<ReplicationPair> getPairsByLun(Lun ... luns) {
        return null;
    }

    private void updatePairMap(boolean existProtectGroupReplica, List<ReplicationPair> remotePairList, Map<String, List<ReplicationPair>> map) {
        for (ReplicationPair pair : remotePairList) {
            if ((!existProtectGroupReplica || this.isStandby(pair)) && !pair.isNormal()) continue;
            String srcLunId = pair.getSrcLunId();
            List<ReplicationPair> list = map.get(srcLunId);
            if (null == list) {
                list = new ArrayList<ReplicationPair>();
                map.put(srcLunId, list);
            }
            list.add(pair);
        }
    }

    private boolean isStandby(ReplicationPair pair) {
        for (ReplicationTargetLun tgtLun : pair.getRepTgtLuns()) {
            if (XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue() != tgtLun.getPairStatus().intValue()) continue;
            return true;
        }
        return false;
    }

    private Map<String, Set<String>> getLunSourceMap(Map<String, List<ReplicationPair>> devicesnPairMap) {
        HashMap<String, Set<String>> lunSourceMap = new HashMap<String, Set<String>>();
        for (List<ReplicationPair> pairList : devicesnPairMap.values()) {
            if (null == pairList) continue;
            for (ReplicationPair replicationPair : pairList) {
                this.updateLunSourceMap(lunSourceMap, replicationPair);
            }
        }
        return lunSourceMap;
    }

    private void updateLunSourceMap(Map<String, Set<String>> lunSourceMap, ReplicationPair replicationPair) {
        List replicationTargetLunList = replicationPair.getRepTgtLuns();
        if (null == replicationTargetLunList) {
            return;
        }
        for (ReplicationTargetLun replicationTargetLun : replicationTargetLunList) {
            String devSn = replicationTargetLun.getTgtDevSN();
            Set<String> resourceIdSet = lunSourceMap.get(devSn);
            if (null == resourceIdSet) {
                resourceIdSet = new HashSet<String>();
                lunSourceMap.put(devSn, resourceIdSet);
            }
            resourceIdSet.add(replicationTargetLun.getTgtLunId());
        }
    }

    protected List<ReplicationPair> getValidStatusReplicationPairs(List<ReplicationPair> pairList) {
        ArrayList<ReplicationPair> filterPairList = new ArrayList<ReplicationPair>();
        for (ReplicationPair pair : pairList) {
            if (!pair.isNormal()) continue;
            filterPairList.add(pair);
        }
        return filterPairList;
    }

    protected List<ReplicationPair> queryValidReplicationPairsBy(String devSn, List<String> lunIds, boolean isRealTime, Integer resourceType) {
        List<ReplicationPair> pairList = null;
        try {
            pairList = this.getStorageService().queryReplicationPairsByMasterLunId(devSn, lunIds, isRealTime, resourceType);
        }
        catch (Exception e) {
            logger.error((Object)("query replicationpairs error." + devSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        if (VerifyUtil.isEmpty(pairList)) {
            logger.warn((Object)"QueryValidReplicationPairs return empty list.");
            return new ArrayList<ReplicationPair>();
        }
        return this.filterValidStatus(pairList);
    }

    protected List<ReplicationPair> filterValidStatus(List<ReplicationPair> pairList) {
        ArrayList<ReplicationPair> filterPairList = new ArrayList<ReplicationPair>();
        for (ReplicationPair pair : pairList) {
            List tgtLuns = pair.getRepTgtLuns();
            if (VerifyUtil.isEmpty((Collection)tgtLuns) || tgtLuns.isEmpty()) continue;
            boolean isReplicationFault = false;
            for (ReplicationTargetLun tgtLun : tgtLuns) {
                int pairStatus = tgtLun.getPairStatus();
                if (XveEuumDefineParent.RUNNING_STATUS_E.INVALID.getValue() == pairStatus || ReplicationConstantDefine.PairStatus.INVALID.getValue() == pairStatus) {
                    isReplicationFault = true;
                    logger.error((Object)("the targetlun:" + tgtLun.getName() + " status :" + tgtLun.getPairStatus()), 90160758786816L);
                    break;
                }
                logger.debug((Object)("the targetlun:" + tgtLun.getName() + " status :" + tgtLun.getPairStatus()), 90160758786816L);
            }
            if (isReplicationFault) continue;
            filterPairList.add(pair);
        }
        return filterPairList;
    }

    public IStorageResourceService getStorageResourceService() {
        return this.storageResourceService;
    }

    public void setStorageResourceService(IStorageResourceService storageResourceService) {
        this.storageResourceService = storageResourceService;
    }

    public IStorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(IStorageService storageService) {
        this.storageService = storageService;
    }
}

