/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.action.util.VsphereTaskResultMonitor;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.discovery.util.PropertyCollectorUtil;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStoreDiskInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.AlreadyExistsFaultMsg;
import com.huawei.vmware.vim25.ArrayOfDatastoreHostMount;
import com.huawei.vmware.vim25.ArrayOfHostDatastoreBrowserSearchResults;
import com.huawei.vmware.vim25.ArrayOfManagedObjectReference;
import com.huawei.vmware.vim25.DatastoreHostMount;
import com.huawei.vmware.vim25.DatastoreInfo;
import com.huawei.vmware.vim25.DatastoreSummary;
import com.huawei.vmware.vim25.DuplicateNameFaultMsg;
import com.huawei.vmware.vim25.FileInfo;
import com.huawei.vmware.vim25.FileQueryFlags;
import com.huawei.vmware.vim25.FolderFileInfo;
import com.huawei.vmware.vim25.HostConfigFaultFaultMsg;
import com.huawei.vmware.vim25.HostConfigManager;
import com.huawei.vmware.vim25.HostDatastoreBrowserSearchResults;
import com.huawei.vmware.vim25.HostDatastoreBrowserSearchSpec;
import com.huawei.vmware.vim25.HostMountInfo;
import com.huawei.vmware.vim25.HostMountMode;
import com.huawei.vmware.vim25.HostNasVolumeSpec;
import com.huawei.vmware.vim25.HostScsiDiskPartition;
import com.huawei.vmware.vim25.HostSystemPowerState;
import com.huawei.vmware.vim25.HostUnresolvedVmfsResolutionResult;
import com.huawei.vmware.vim25.InsufficientResourcesFault;
import com.huawei.vmware.vim25.InvalidDatastore;
import com.huawei.vmware.vim25.InvalidNameFaultMsg;
import com.huawei.vmware.vim25.InvalidState;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.MethodFault;
import com.huawei.vmware.vim25.MigrationFault;
import com.huawei.vmware.vim25.NasDatastoreInfo;
import com.huawei.vmware.vim25.NoDiskSpace;
import com.huawei.vmware.vim25.NotFoundFaultMsg;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.ResourceInUseFaultMsg;
import com.huawei.vmware.vim25.RuntimeFaultFaultMsg;
import com.huawei.vmware.vim25.TraversalSpec;
import com.huawei.vmware.vim25.VimPortType;
import com.huawei.vmware.vim25.VirtualMachineMovePriority;
import com.huawei.vmware.vim25.VirtualMachineRelocateSpec;
import com.huawei.vmware.vim25.VirtualMachineRelocateSpecDiskLocator;
import com.huawei.vmware.vim25.VmConfigFault;
import com.huawei.vmware.vim25.VmfsDatastoreInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DataStoreAction {
    private static final String INFO_RESULT = "info.result";
    private static final int RETRY_TIMES = 10;
    private static final int SLEEP_TIME = 10000;
    private static final Log logger = LogFactory.getInstance(DataStoreAction.class);
    private Map<String, String> snapShotNguid = null;

    public static List<VmfsDatastoreInfo> getAllVmDsInfos(String vcenterUuid) {
        logger.debug((Object)"getVmDsInfos start");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        ArrayList<VmfsDatastoreInfo> res = new ArrayList<VmfsDatastoreInfo>();
        ArrayList<String> dsItems = new ArrayList<String>();
        dsItems.add("name");
        dsItems.add("info");
        dsItems.add("summary");
        Map<ManagedObjectReference, Map<String, Object>> dsDynamicProps = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "Datastore", dsItems);
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> dsPropEntry : dsDynamicProps.entrySet()) {
            Object infoObj = dsPropEntry.getValue().get("info");
            if (VerifyUtil.isEmpty((Object)infoObj) || !(infoObj instanceof VmfsDatastoreInfo)) continue;
            res.add((VmfsDatastoreInfo)infoObj);
        }
        return res;
    }

    public static List<HostUnresolvedVmfsResolutionResult> renameDataStore(List<HostUnresolvedVmfsResolutionResult> results, String vcenterUuid) {
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        VimPortType vimPort = conn.getVimPort();
        List<VmfsDatastoreInfo> datastoreInfos = DataStoreAction.getAllVmDsInfos(vcenterUuid);
        HashSet<String> datastoreNames = new HashSet<String>();
        for (VmfsDatastoreInfo datastoreInfo : datastoreInfos) {
            datastoreNames.add(datastoreInfo.getName());
        }
        DatastoreSummary datastoreSummary = null;
        String oldName = null;
        String newName = null;
        for (HostUnresolvedVmfsResolutionResult result : results) {
            try {
                datastoreSummary = DataStoreAction.retryGetDsSummary(result.getVmfs().getUuid(), vcenterUuid);
            }
            catch (Exception e) {
                logger.error((Object)("get datastoreSummary failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{""});
            }
            if (datastoreSummary == null) {
                logger.info((Object)"get datastoreSummary failed, don't rename the datastore.");
                continue;
            }
            oldName = datastoreSummary.getName();
            newName = oldName.replaceFirst("^snap-[0-9a-z]+-", "");
            if (VerifyUtil.isEmpty((String)newName) || datastoreNames.contains(newName)) continue;
            try {
                result.getVmfs().setName(newName);
                vimPort.renameTask(datastoreSummary.getDatastore(), newName);
                logger.info((Object)"rename Datastore success.oldName:[%s],newName:[%s]", new Object[]{oldName, newName});
            }
            catch (RuntimeFaultFaultMsg e) {
                logger.error((Object)"rename datastore failed.oldName:[%s], newName:[%s]", new Object[]{e, oldName, newName});
                throw new LegoCheckedException(1073948898L, (Throwable)e);
            }
            catch (DuplicateNameFaultMsg e) {
                logger.error((Object)"datastore new name is duplicate.duplicate name:[%s], ", new Object[]{e, newName});
                throw new LegoCheckedException(1073948151L, (Throwable)e);
            }
            catch (InvalidNameFaultMsg e) {
                logger.error((Object)"datastore new name is invalid.oldName:[%s], newName:[%s]", new Object[]{e, oldName, newName});
                throw new LegoCheckedException(1073948919L, (Throwable)e);
            }
        }
        return results;
    }

    public static DatastoreSummary retryGetDsSummary(String vmfsUuid, String vcenterUuid) {
        DatastoreSummary datastoreSummary = null;
        for (int i = 0; i < 10 && (datastoreSummary = new HostSystemAction().getDatastoreSummary(vcenterUuid, vmfsUuid)) == null; ++i) {
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Object)"Thread interrupted", (Throwable)e);
                throw new LegoCheckedException(1073948898L, (Throwable)e);
            }
        }
        return datastoreSummary;
    }

    public void setSnapShotNguid(Map<String, String> snapShotNguid) {
        this.snapShotNguid = snapShotNguid;
    }

    public List<VsphereDataStore> queryAllMountedDataStores(String vcenterUuid) {
        List<VsphereDataStore> dataStores = this.queryAllDsWithoutValidate(vcenterUuid);
        return dataStores.stream().filter(dataStore -> dataStore.isAccessible() && dataStore.isMounted()).collect(Collectors.toList());
    }

    public List<VsphereDataStore> queryAllValidDataStores(String vcenterUuid) {
        List<VsphereDataStore> dataStores = this.queryAllDsWithoutValidate(vcenterUuid);
        return dataStores.stream().filter(dataStore -> dataStore.isValid()).collect(Collectors.toList());
    }

    public List<VsphereDataStore> queryAllDsWithoutValidate(String vcenterUuid) {
        logger.debug((Object)"Start to query all dataStore without validate in vCenter[%s].", new Object[]{vcenterUuid});
        if (VerifyUtil.isEmpty((String)vcenterUuid)) {
            logger.error((Object)"Start to query all dataStore without validate, but vCenter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        if (null == conn) {
            logger.error((Object)"Start to query all dataStore without validate in vCenter[%s], but cannot get the connection.", new Object[]{vcenterUuid});
            throw new LegoCheckedException(1073947393L);
        }
        List<VsphereDataStore> result = this.queryDataStoreByContainer(conn.getServiceContent().getRootFolder(), conn);
        return result;
    }

    public List<VsphereDataStore> queryDataStoreByContainer(ManagedObjectReference containerMor, VmwareConnection conn) {
        logger.debug((Object)"QueryDataStoreByContainer start");
        if (Objects.isNull(conn)) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> dsList = new ArrayList<String>();
        dsList.add("Datastore");
        ManagedObjectReference containerView = PropertyCollectorUtil.createContainerView(conn, containerMor, dsList, true);
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(containerView);
        oSpec.setSkip(Boolean.valueOf(true));
        TraversalSpec tSpec = PropertyCollectorUtil.createTraversalSpec("traverseEntities", "ContainerView", "view");
        oSpec.getSelectSet().add(tSpec);
        ArrayList<String> pathSet = new ArrayList<String>();
        pathSet.add("name");
        pathSet.add("summary");
        pathSet.add("info");
        pathSet.add("host");
        PropertySpec dsSpec = PropertyCollectorUtil.createPropertySpec("Datastore", pathSet);
        ArrayList<ObjectSpec> objectSet = new ArrayList<ObjectSpec>();
        objectSet.add(oSpec);
        ArrayList<PropertySpec> propSet = new ArrayList<PropertySpec>();
        propSet.add(dsSpec);
        List<PropertyFilterSpec> filterSpecList = PropertyCollectorUtil.createPropertyFilterSpecList(objectSet, propSet);
        List<ObjectContent> queryResult = PropertyCollectorUtil.retrievePropertiesEx(conn, filterSpecList);
        VMAction.destroyContainerView(containerView, conn.getVimPort());
        return this.getDataStoreFromQueryResult(conn.getVcenterUuid(), queryResult);
    }

    private List<VsphereDataStore> getDataStoreFromQueryResult(String vcenterUuid, List<ObjectContent> queryResult) {
        ArrayList<VsphereDataStore> result = new ArrayList<VsphereDataStore>();
        if (VerifyUtil.isEmpty(queryResult)) {
            return result;
        }
        for (ObjectContent oc : queryResult) {
            VsphereDataStore ds = this.parseDataStore(oc, vcenterUuid);
            DatastoreHostMount hostMount = this.getDatastoreHostMount(oc);
            if (null == hostMount || null == hostMount.getMountInfo()) {
                ds.setValid(Boolean.valueOf(false));
                ds.setMounted(false);
                ds.setAccessible(false);
            } else {
                HostMountInfo mountInfo = hostMount.getMountInfo();
                ds.setValid(Boolean.valueOf(true));
                ds.setMounted(mountInfo.isMounted().booleanValue());
                ds.setAccessible(mountInfo.isAccessible().booleanValue());
            }
            result.add(ds);
        }
        return result;
    }

    public List<VsphereDataStore> getDsByMoIds(String vcenterUuid, Set<String> moIdList) {
        logger.debug((Object)"getDsByMoIds start");
        List<VsphereDataStore> dsList = this.queryAllDsWithoutValidate(vcenterUuid);
        ArrayList<VsphereDataStore> retList = new ArrayList<VsphereDataStore>();
        for (VsphereDataStore ds : dsList) {
            String moId = ds.getUuid().split(":")[1];
            if (moIdList.contains(moId)) {
                retList.add(ds);
            }
            if (retList.size() != moIdList.size()) continue;
            break;
        }
        return retList;
    }

    public List<VsphereDataStore> getDsByUrl(String vcenterUuid, Set<String> urlList) {
        logger.info((Object)"Get dataStores by url list[%s] in vCenter[%s].", new Object[]{urlList, vcenterUuid});
        List<VsphereDataStore> dsList = this.queryAllDsWithoutValidate(vcenterUuid);
        ArrayList<VsphereDataStore> retList = new ArrayList<VsphereDataStore>();
        for (VsphereDataStore ds : dsList) {
            String url = ds.getUrl();
            logger.debug((Object)"Get dataStore info: name[%s], url[%s].", new Object[]{ds.getName(), url});
            if (urlList.contains(url)) {
                retList.add(ds);
            }
            if (retList.size() != urlList.size()) continue;
            break;
        }
        return retList;
    }

    public boolean isMountedToAllHosts(String vcenterUuid, String dsMoId, Integer hostSize) {
        logger.debug((Object)"Check if the dataStore was mounted to all hosts, dsMoId[%s], vCenter[%s]", new Object[]{dsMoId, vcenterUuid});
        boolean ret = false;
        if (VerifyUtil.isEmpty((String)dsMoId) || VerifyUtil.isEmpty((String)vcenterUuid)) {
            logger.error((Object)"the dsMoId[%s] or vCenter[%s] is empty.", new Object[]{dsMoId, vcenterUuid});
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObjectReference dsMor = new ManagedObjectReference();
        dsMor.setType("Datastore");
        dsMor.setValue(dsMoId);
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        ArrayOfDatastoreHostMount mountedHosts = (ArrayOfDatastoreHostMount)GetMoPropsValueUtils.getInstance().entityProps(conn, dsMor, new String[]{"host"}).get("host");
        if (null == mountedHosts) {
            logger.error((Object)"mount hosts is null, dsMoId[%s], vCenter[%s]", new Object[]{dsMoId, vcenterUuid});
            return false;
        }
        List mountedList = mountedHosts.getDatastoreHostMount();
        if (hostSize > 0 && mountedList.size() != hostSize.intValue()) {
            logger.error((Object)("the datastore host mount is not ready:hostSize=" + hostSize + " mountedList Size=" + mountedList.size()));
            return false;
        }
        int counter = 0;
        for (DatastoreHostMount mount : mountedList) {
            HostMountInfo info = mount.getMountInfo();
            logger.info((Object)("dsMoId=" + dsMoId + "host:" + mount.getKey().getValue() + " isAccessible=" + info.isAccessible() + "isMounted=" + info.isMounted()));
            if (!info.isAccessible().booleanValue() || !info.isMounted().booleanValue()) {
                logger.info((Object)("datastore is not ready,dsMoId=" + dsMoId));
                break;
            }
            ++counter;
        }
        if (counter == mountedList.size()) {
            ret = true;
        }
        return ret;
    }

    private DatastoreHostMount getDatastoreHostMount(ObjectContent oc) {
        logger.debug((Object)"isValidDataStore start");
        Object obj = PropertyCollectorUtil.getPropertyByPath(oc, "host");
        if (null == obj || !(obj instanceof ArrayOfDatastoreHostMount)) {
            return null;
        }
        ArrayOfDatastoreHostMount host = (ArrayOfDatastoreHostMount)obj;
        List hostMounts = host.getDatastoreHostMount();
        if (VerifyUtil.isEmpty((Collection)hostMounts)) {
            return null;
        }
        DatastoreHostMount result = null;
        for (DatastoreHostMount hostMount : hostMounts) {
            if (null == hostMount.getMountInfo() || !hostMount.getMountInfo().isAccessible().booleanValue() || !hostMount.getMountInfo().isMounted().booleanValue()) continue;
            result = hostMount;
            break;
        }
        if (null == result) {
            result = (DatastoreHostMount)hostMounts.stream().findFirst().get();
        }
        return result;
    }

    private VsphereDataStore parseDataStore(ObjectContent oc, String vCenterUuid) {
        logger.debug((Object)"parseDataStore start");
        VsphereDataStore ds = new VsphereDataStore();
        ds.setUuid(vCenterUuid + ":" + oc.getObj().getValue());
        ds.setName(PropertyCollectorUtil.getPropertyByPath(oc, "name", String.class));
        DatastoreSummary summary = PropertyCollectorUtil.getPropertyByPath(oc, "summary", DatastoreSummary.class);
        ds.setCapacity(Long.valueOf(summary.getCapacity()));
        ds.setUrl(summary.getUrl());
        ds.setVolumeType(summary.getType());
        Object info = PropertyCollectorUtil.getPropertyByPath(oc, "info");
        if (info instanceof VmfsDatastoreInfo) {
            VmfsDatastoreInfo vmfsInfo = (VmfsDatastoreInfo)info;
            this.generateDataStoreDiskInfoByVMFS(ds, vmfsInfo, vCenterUuid);
        } else if (info instanceof NasDatastoreInfo) {
            VsphereDataStoreDiskInfo disk = new VsphereDataStoreDiskInfo();
            NasDatastoreInfo nasDataStoreInfo = (NasDatastoreInfo)info;
            String storagePathString = nasDataStoreInfo.getNas().getRemoteHost() + ":" + nasDataStoreInfo.getNas().getRemotePath();
            disk.setDiskName("NFS:UNKNOWN");
            disk.setPartition(Integer.valueOf(0));
            disk.setStorageWwn(storagePathString);
            disk.setUuid(vCenterUuid + ":NFSDISK:" + oc.getObj().getValue());
            disk.setParentMo((ManagedObject)ds);
            ds.addChildMo((ManagedObject)disk);
        } else {
            VsphereDataStoreDiskInfo disk = new VsphereDataStoreDiskInfo();
            disk.setDiskName("UNKNOWN");
            disk.setPartition(Integer.valueOf(0));
            disk.setStorageWwn("UNKNOWN:" + ds.getUuid());
            disk.setUuid(vCenterUuid + ":UNKNOWNDISK:" + oc.getObj().getValue());
            disk.setParentMo((ManagedObject)ds);
            ds.addChildMo((ManagedObject)disk);
        }
        return ds;
    }

    private void generateDataStoreDiskInfoByVMFS(VsphereDataStore ds, VmfsDatastoreInfo vmfsInfo, String ip) {
        logger.debug((Object)"generateDataStoreDiskInfoByVMFS start");
        List extent = vmfsInfo.getVmfs().getExtent();
        if (null != extent) {
            for (HostScsiDiskPartition hostScsiDisk : extent) {
                if (null == hostScsiDisk.getDiskName() || hostScsiDisk.getDiskName().isEmpty()) continue;
                VsphereDataStoreDiskInfo disk = new VsphereDataStoreDiskInfo();
                disk.setDiskName(hostScsiDisk.getDiskName());
                disk.setPartition(Integer.valueOf(hostScsiDisk.getPartition()));
                disk.setStorageWwn(HostSystemAction.processStorageWwn(hostScsiDisk.getDiskName(), null));
                disk.setUuid(ip + ":" + hostScsiDisk.getDiskName());
                disk.setParentMo((ManagedObject)ds);
                ds.addChildMo((ManagedObject)disk);
            }
        }
    }

    public boolean refreshDatastore(String vcenterUuid, VsphereDataStore datastore) {
        boolean ret = true;
        try {
            logger.debug((Object)("refreshDatastore:dsName=" + datastore.getName()), 90160758786988L);
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            ManagedObjectReference datastoreMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(datastore.getUuid(), "Datastore");
            VimPortType vimPort = conn.getVimPort();
            vimPort.refreshDatastore(datastoreMor);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("refreshDatastore failed:dsName" + datastore.getName()), (long)-1L, null, (Log)logger);
        }
        return ret;
    }

    public void removeDsFromCompRes(String vcenterUuid, String compResId, String datastoreId) {
        logger.debug((Object)"Start to remove dataStore from compute resource: vCenter[%s], compResId[%s], dataStoreId[%s].", new Object[]{vcenterUuid, compResId, datastoreId});
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        ManagedObjectReference compResMor = util.getMorByObjUuid(compResId, "ComputeResource");
        ArrayOfManagedObjectReference hostMorList = (ArrayOfManagedObjectReference)util.entityProps(conn, compResMor, new String[]{"host"}).get("host");
        if (null == hostMorList) {
            logger.error((Object)"hostMorList is null,computeResource moID[%s].", new Object[]{compResId});
            return;
        }
        for (ManagedObjectReference hostMor : hostMorList.getManagedObjectReference()) {
            HostSystemPowerState state = (HostSystemPowerState)util.entityProps(conn, hostMor, new String[]{"summary.runtime.powerState"}).get("summary.runtime.powerState");
            if (HostSystemPowerState.POWERED_ON != state) continue;
            this.removeDatastore(vcenterUuid, hostMor.getValue(), datastoreId);
        }
    }

    public void removeDatastore(String vcenterUuid, String hostId, String datastoreId) {
        try {
            logger.debug((Object)"Start to remove dataStore: vCenter[%s], hostId[%s], dataStoreId[%s].", new Object[]{vcenterUuid, hostId, datastoreId});
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
            ManagedObjectReference hostMor = util.getMorByObjUuid(hostId, "HostSystem");
            ManagedObjectReference dsMor = util.getMorByObjUuid(datastoreId, "Datastore");
            if (!this.isExistDatastore(conn, hostMor, dsMor)) {
                logger.debug((Object)"The dataStore is not existed.");
                return;
            }
            ManagedObjectReference hostDsSystemMor = (ManagedObjectReference)util.entityProps(conn, hostMor, new String[]{"configManager.datastoreSystem"}).get("configManager.datastoreSystem");
            vimPort.removeDatastore(hostDsSystemMor, dsMor);
        }
        catch (HostConfigFaultFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("removeDatastore failed:dsUuid=" + datastoreId + " hostMoId=" + hostId), (long)1073948153L, (String[])new String[0], (Log)logger);
        }
        catch (NotFoundFaultMsg e) {
            logger.info((Object)("removeDatastore:datastore has not found:dsUuid=" + datastoreId + " hostMoId=" + hostId + e.getLocalizedMessage()), 90160758786989L);
        }
        catch (ResourceInUseFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("removeDatastore failed:dsUuid=" + datastoreId + " hostMoId=" + hostId), (long)1073948878L, (String[])new String[0], (Log)logger);
        }
        catch (RuntimeFaultFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("removeDatastore failed:dsUuid=" + datastoreId + " hostMoId=" + hostId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("removeDatastore failed:dsUuid=" + datastoreId + " hostMoId=" + hostId), (long)-1L, null, (Log)logger);
        }
    }

    public void unmountVmfsDatastore(String vcenterUuid, VsphereDataStore datastore) {
        ArrayList<String> items = new ArrayList<String>();
        items.add("name");
        items.add("configManager");
        try {
            logger.debug((Object)("unmountVmfsDatastore:vcenterUuid=" + vcenterUuid + " dsName=" + datastore.getName()));
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            Map<ManagedObjectReference, Map<String, Object>> propsMap = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "HostSystem", items);
            for (Map<String, Object> propMap : propsMap.values()) {
                HostConfigManager hostCfgMgr;
                if (!datastore.getHosts().contains((String)propMap.get("name")) || null == (hostCfgMgr = (HostConfigManager)propMap.get("configManager"))) continue;
                String moid = GetMoPropsValueUtils.getInstance().getMoid(datastore.getUuid());
                vimPort.unmountVmfsVolume(hostCfgMgr.getStorageSystem(), moid);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unmountVmfsDatastore failed:dsName=" + datastore.getName()), (long)-1L, null, (Log)logger);
        }
    }

    public void mountVmfsDatastore(String vcenterUuid, VsphereDataStore datastore) {
        ArrayList<String> items = new ArrayList<String>();
        items.add("name");
        items.add("configManager");
        try {
            logger.debug((Object)("mountVmfsDatastore:dsName=" + datastore.getName()));
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            Map<ManagedObjectReference, Map<String, Object>> propsMap = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "HostSystem", items);
            for (Map<String, Object> propMap : propsMap.values()) {
                HostConfigManager hostCfgMgr;
                if (!datastore.getHosts().contains((String)propMap.get("name")) || null == (hostCfgMgr = (HostConfigManager)propMap.get("configManager"))) continue;
                String moid = GetMoPropsValueUtils.getInstance().getMoid(datastore.getUuid());
                vimPort.mountVmfsVolume(hostCfgMgr.getStorageSystem(), moid);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("mountVmfsDatastore failed:dsName=" + datastore.getName()), (long)-1L, null, (Log)logger);
        }
    }

    public List<String> getLunFromDataStore(String vcenterUuid, List<String> dsUuids) {
        logger.debug((Object)"getLunFromDataStore start");
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> items = new ArrayList<String>();
        items.add("name");
        items.add("info");
        items.add("summary");
        if (VerifyUtil.isEmpty(dsUuids)) {
            return result;
        }
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        Map<ManagedObjectReference, Map<String, Object>> propsMap = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "Datastore", items);
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> propMap : propsMap.entrySet()) {
            for (String dsUuid : dsUuids) {
                Object info = propMap.getValue().get("info");
                if (null == info) continue;
                result.addAll(this.compAndGetDsInfos(info, dsUuid));
            }
        }
        return result;
    }

    public List<String> getLunFromDsMoIds(String vcenterUuid, List<String> dsMoIds) {
        logger.debug((Object)"getLunFromDsMoIds start");
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> items = new ArrayList<String>();
        items.add("name");
        items.add("info");
        items.add("summary");
        if (VerifyUtil.isEmpty(dsMoIds)) {
            return result;
        }
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        Map<ManagedObjectReference, Map<String, Object>> propsMap = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "Datastore", items);
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> propMap : propsMap.entrySet()) {
            String dsMoId = propMap.getKey().getValue();
            if (!dsMoIds.contains(dsMoId)) continue;
            Object info = propMap.getValue().get("info");
            result.addAll(this.getLunInfoByDsMoId(info));
        }
        return result;
    }

    public Map<String, Map<String, Object>> getDsInfosByVm(String vcenterUuid, List<String> vmMoIds) {
        logger.debug((Object)"getDsInfosByVm start");
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        ArrayList<String> items = new ArrayList<String>();
        items.add("datastore");
        if (VerifyUtil.isEmpty(vmMoIds)) {
            return result;
        }
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        Map<ManagedObjectReference, Map<String, Object>> propsMap = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "VirtualMachine", items);
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> propMap : propsMap.entrySet()) {
            Object info;
            String vmMoId = propMap.getKey().getValue();
            if (!vmMoIds.contains(vmMoId) || null == (info = propMap.getValue().get("datastore"))) continue;
            result.putAll(this.getVmDsInfos(vcenterUuid, info));
        }
        return result;
    }

    private List<String> compAndGetDsInfos(Object info, String dsUuid) {
        VmfsDatastoreInfo vmfsInfo;
        List scsiDisks;
        logger.debug((Object)"compAndGetDsInfos start");
        ArrayList<String> result = new ArrayList<String>();
        if (info instanceof VmfsDatastoreInfo && dsUuid.equals(((VmfsDatastoreInfo)info).getVmfs().getUuid()) && !VerifyUtil.isEmpty((Collection)(scsiDisks = (vmfsInfo = (VmfsDatastoreInfo)info).getVmfs().getExtent()))) {
            for (HostScsiDiskPartition hostScsiDiskPartition : scsiDisks) {
                String diskName = hostScsiDiskPartition.getDiskName();
                result.add(HostSystemAction.processStorageWwn(diskName, null));
            }
        }
        return result;
    }

    private List<String> getLunInfoByDsMoId(Object info) {
        VmfsDatastoreInfo vmfsInfo;
        List scsiDisks;
        logger.debug((Object)"getLunInfoByDsMoId start");
        ArrayList<String> result = new ArrayList<String>();
        if (info instanceof VmfsDatastoreInfo && !VerifyUtil.isEmpty((Collection)(scsiDisks = (vmfsInfo = (VmfsDatastoreInfo)info).getVmfs().getExtent()))) {
            for (HostScsiDiskPartition hostScsiDiskPartition : scsiDisks) {
                String diskName = hostScsiDiskPartition.getDiskName();
                result.add(HostSystemAction.processStorageWwn(diskName, this.snapShotNguid));
            }
        }
        return result;
    }

    private Map<String, Map<String, Object>> getVmDsInfos(String vcenterUuid, Object info) {
        logger.debug((Object)"getVmDsInfos start");
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        ArrayOfManagedObjectReference dsInfos = (ArrayOfManagedObjectReference)info;
        for (ManagedObjectReference mor : dsInfos.getManagedObjectReference()) {
            String dsMoId = mor.getValue();
            result.put(dsMoId, this.getDataStoreInfos(vcenterUuid, dsMoId));
        }
        return result;
    }

    private Map<String, Object> getDataStoreInfos(String vcenterUuid, String dsMoId) {
        Object info;
        logger.debug((Object)"getDataStoreInfos start");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ManagedObjectReference mor = new ManagedObjectReference();
        mor.setType("DataStore");
        mor.setValue(dsMoId);
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        Map<String, Object> map = util.entityProps(conn, mor, new String[]{"name", "host", "info"});
        result.put("name", map.get("name"));
        VirtualizationCommonUtil commonUtil = VirtualizationCommonUtil.getInstance();
        ArrayOfDatastoreHostMount host = (ArrayOfDatastoreHostMount)map.get("host");
        if (null != host) {
            DatastoreHostMount mnt = (DatastoreHostMount)commonUtil.getElementFromCollection((Collection)host.getDatastoreHostMount());
            result.put("host", mnt.getKey().getValue());
        }
        if ((info = map.get("info")) instanceof VmfsDatastoreInfo) {
            VmfsDatastoreInfo vmfsInfo = (VmfsDatastoreInfo)info;
            result.put("uuid", vmfsInfo.getVmfs().getUuid());
        } else {
            result.put("uuid", "UNKNOWN");
        }
        return result;
    }

    public Set<String> getDataStoreMountHostMoId(String vcenterUuid, VsphereDataStore data) {
        logger.debug((Object)"getDataStoreMountHostMoId start");
        HashSet<String> hostMoId = new HashSet<String>();
        ArrayList<String> dsItems = new ArrayList<String>();
        dsItems.add("host");
        ArrayOfDatastoreHostMount dsHostMount = null;
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        Map<ManagedObjectReference, Map<String, Object>> dsDynamicProps = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "Datastore", dsItems);
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> dsPropEntry : dsDynamicProps.entrySet()) {
            if (!dsPropEntry.getKey().getValue().equals(data.getUuid().split(":")[1])) continue;
            dsHostMount = (ArrayOfDatastoreHostMount)dsPropEntry.getValue().get("host");
        }
        if (null == dsHostMount) {
            return hostMoId;
        }
        List hostMounts = dsHostMount.getDatastoreHostMount();
        for (DatastoreHostMount hostMount : hostMounts) {
            hostMoId.add(hostMount.getKey().getValue());
        }
        return hostMoId;
    }

    public ManagedObjectReference createNasDatastoreForCompRes(String vcenterUuid, String compResId, String nasStorageIp, String sharePath, String dsName) {
        logger.debug((Object)"createNasDatastoreForCompRes start");
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        ManagedObjectReference compResMor = util.getMorByObjUuid(compResId, "ComputeResource");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        ArrayOfManagedObjectReference hostArray = (ArrayOfManagedObjectReference)util.entityProps(conn, compResMor, new String[]{"host"}).get("host");
        if (null == hostArray) {
            logger.error((Object)("hostArray is null,compResId=" + compResId));
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObjectReference dsMor = null;
        for (ManagedObjectReference hostMor : hostArray.getManagedObjectReference()) {
            HostSystemPowerState state = (HostSystemPowerState)util.entityProps(conn, hostMor, new String[]{"summary.runtime.powerState"}).get("summary.runtime.powerState");
            if (HostSystemPowerState.POWERED_ON != state) continue;
            ManagedObjectReference tempDsMor = this.findNasDatastore(conn, hostMor, sharePath);
            if (VerifyUtil.isEmpty((Object)tempDsMor)) {
                dsMor = this.createNasDatastore(vcenterUuid, hostMor.getValue(), nasStorageIp, sharePath, dsName);
                continue;
            }
            dsMor = tempDsMor;
        }
        return dsMor;
    }

    private ManagedObjectReference findNasDatastore(VmwareConnection conn, ManagedObjectReference hostMor, String sharePath) {
        logger.debug((Object)"findNasDatastore start");
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        ArrayOfManagedObjectReference dsArray = (ArrayOfManagedObjectReference)util.entityProps(conn, hostMor, new String[]{"datastore"}).get("datastore");
        if (null == dsArray) {
            logger.error((Object)("hostArray is null,hostMoId=" + hostMor.getValue()));
            return null;
        }
        for (ManagedObjectReference dsMor : dsArray.getManagedObjectReference()) {
            String realPath;
            DatastoreInfo info = (DatastoreInfo)util.entityProps(conn, dsMor, new String[]{"info"}).get("info");
            if (!(info instanceof NasDatastoreInfo) || !(realPath = ((NasDatastoreInfo)info).getNas().getRemotePath()).equals(sharePath)) continue;
            return dsMor;
        }
        return null;
    }

    private boolean isExistDatastore(VmwareConnection conn, ManagedObjectReference hostMor, ManagedObjectReference dsMor) {
        logger.debug((Object)"isExistDatastore start");
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        ArrayOfManagedObjectReference dsArray = (ArrayOfManagedObjectReference)util.entityProps(conn, hostMor, new String[]{"datastore"}).get("datastore");
        if (null == dsArray) {
            logger.error((Object)("hostArray is null,hostMoId=" + hostMor.getValue()));
            return false;
        }
        for (ManagedObjectReference tempDsMor : dsArray.getManagedObjectReference()) {
            if (!tempDsMor.getValue().equals(dsMor.getValue())) continue;
            return true;
        }
        return false;
    }

    public ManagedObjectReference createNasDatastore(String vcenterUuid, String hostUuid, String nasStorageIp, String sharePath, String dsName) {
        logger.debug((Object)("createNasDatastore:dsName=" + dsName + " vcenterUuid=" + vcenterUuid + " hostUuid=" + hostUuid + " nasStorageIp=" + nasStorageIp + " sharePath=" + sharePath));
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        ManagedObjectReference hostMor = util.getMorByObjUuid(hostUuid, "HostSystem");
        ManagedObjectReference datastoreSystemMor = (ManagedObjectReference)util.entityProps(conn, hostMor, new String[]{"configManager.datastoreSystem"}).get("configManager.datastoreSystem");
        HostNasVolumeSpec spec = new HostNasVolumeSpec();
        spec.setAccessMode(HostMountMode.READ_WRITE.value());
        spec.setRemoteHost(nasStorageIp);
        spec.setRemotePath(sharePath);
        spec.setLocalPath(dsName);
        try {
            ManagedObjectReference dsMor = conn.getVimPort().createNasDatastore(datastoreSystemMor, spec);
            return dsMor;
        }
        catch (AlreadyExistsFaultMsg e) {
            logger.error((Object)("nas datastore already exist:dsName" + dsName), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948152L, (Throwable)e);
        }
        catch (DuplicateNameFaultMsg e) {
            logger.error((Object)("The new nas datastore name is duplicated:dsName" + dsName), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948151L, (Throwable)e);
        }
        catch (HostConfigFaultFaultMsg e) {
            logger.error((Object)("host config fault:dsName=" + dsName), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948153L, (Throwable)e);
        }
        catch (RuntimeFaultFaultMsg e) {
            logger.error((Object)("The new nas datastore name is duplicated:dsName=" + dsName), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public List<String> listDatastoreFiles(String vcenterUuid, String dsMoId, String dataStoreName) {
        logger.debug((Object)"List dataStore files: vCenter[%s], dsMoId[%s], dataStoreName[%s].", new Object[]{vcenterUuid, dsMoId, dataStoreName});
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)dsMoId) || VerifyUtil.isEmpty((String)dataStoreName)) {
            logger.error((Object)"List dataStore files, but parameter is empty: vCenter[%s], dsMoId[%s], dataStoreName[%s].", new Object[]{vcenterUuid, dsMoId, dataStoreName});
            throw new LegoCheckedException(-1L);
        }
        try {
            ManagedObjectReference dsMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid("datastoreBrowser-" + dsMoId, "HostDatastoreBrowser");
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            HostDatastoreBrowserSearchSpec searchSpec = new HostDatastoreBrowserSearchSpec();
            FileQueryFlags queryFlags = new FileQueryFlags();
            queryFlags.setFileOwner(Boolean.valueOf(false));
            queryFlags.setFileSize(false);
            queryFlags.setFileType(true);
            queryFlags.setModification(false);
            searchSpec.setDetails(queryFlags);
            searchSpec.setSearchCaseInsensitive(Boolean.valueOf(false));
            searchSpec.setSortFoldersFirst(Boolean.valueOf(false));
            searchSpec.getMatchPattern().add("*");
            return this.searchFile(dsMor, conn, searchSpec, "[" + dataStoreName + "]");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("listDatastoreFile error. dataStore name: " + dataStoreName));
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("listDatastoreFile error. dataStore name: " + dataStoreName), (long)-1L, null, (Log)logger);
            return Collections.emptyList();
        }
    }

    private List<String> searchFile(ManagedObjectReference dsMor, VmwareConnection conn, HostDatastoreBrowserSearchSpec searchSpec, String searchPath) {
        ArrayList<String> fullFilePaths = new ArrayList<String>();
        String[] props = new String[]{INFO_RESULT};
        ManagedObjectReference opTask = null;
        try {
            opTask = conn.getVimPort().searchDatastoreTask(dsMor, searchPath, searchSpec);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"searchFile error. ");
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"searchFile error. ", (long)-1L, null, (Log)logger);
        }
        MethodFault fault = new VsphereTaskResultMonitor(conn, opTask).monitorTaskResultAfterDone();
        if (!VerifyUtil.isEmpty((Object)fault)) {
            logger.error((Object)"search file error.");
            throw new LegoCheckedException(0x300001L);
        }
        Map<String, Object> propsMap = GetMoPropsValueUtils.getInstance().entityProps(conn, opTask, props);
        HostDatastoreBrowserSearchResults searchResults = (HostDatastoreBrowserSearchResults)propsMap.get(INFO_RESULT);
        if (VerifyUtil.isEmpty((Object)searchResults)) {
            return fullFilePaths;
        }
        List fileInfos = searchResults.getFile();
        if (VerifyUtil.isEmpty((Collection)fileInfos)) {
            return fullFilePaths;
        }
        for (FileInfo fileInfo : fileInfos) {
            if (FolderFileInfo.class.isInstance(fileInfo)) {
                fullFilePaths.addAll(this.searchFileInFolder(dsMor, conn, searchSpec, searchPath + fileInfo.getPath()));
                continue;
            }
            fullFilePaths.add(fileInfo.getPath());
        }
        return fullFilePaths;
    }

    private List<String> searchFileInFolder(ManagedObjectReference dsMor, VmwareConnection conn, HostDatastoreBrowserSearchSpec searchSpec, String searchPath) {
        String[] props = new String[]{INFO_RESULT};
        ArrayList<String> fullFilePaths = new ArrayList<String>();
        ManagedObjectReference opTask = null;
        try {
            opTask = conn.getVimPort().searchDatastoreSubFoldersTask(dsMor, searchPath, searchSpec);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"searchFileInFolder error. ");
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"searchFileInFolder error. ", (long)-1L, null, (Log)logger);
        }
        MethodFault fault = new VsphereTaskResultMonitor(conn, opTask).monitorTaskResultAfterDone();
        if (!VerifyUtil.isEmpty((Object)fault)) {
            logger.error((Object)"search file error.");
            throw new LegoCheckedException(0x300001L);
        }
        Map<String, Object> subPropsMap = GetMoPropsValueUtils.getInstance().entityProps(conn, opTask, props);
        ArrayOfHostDatastoreBrowserSearchResults subSearchResults = (ArrayOfHostDatastoreBrowserSearchResults)subPropsMap.get(INFO_RESULT);
        if (VerifyUtil.isEmpty((Object)subSearchResults)) {
            return fullFilePaths;
        }
        List subSearchFileResults = subSearchResults.getHostDatastoreBrowserSearchResults();
        if (VerifyUtil.isEmpty((Collection)subSearchFileResults)) {
            return fullFilePaths;
        }
        for (HostDatastoreBrowserSearchResults subSearchResult : subSearchFileResults) {
            List subFileInfos = subSearchResult.getFile();
            if (VerifyUtil.isEmpty((Collection)subFileInfos)) continue;
            for (FileInfo subFileInfo : subFileInfos) {
                if (FolderFileInfo.class.isInstance(subFileInfo)) {
                    fullFilePaths.addAll(this.searchFileInFolder(dsMor, conn, searchSpec, subSearchResult.getFolderPath() + subFileInfo.getPath()));
                    continue;
                }
                fullFilePaths.add(subSearchResult.getFolderPath() + subFileInfo.getPath());
            }
        }
        return fullFilePaths;
    }

    public void deleteDatastoreFiles(String vcenterUuid, String dsMoId, Set<String> deletePaths) {
        logger.debug((Object)"Delete dataStore files: vCenter[%s], dsMoId[%s], deletePaths[%s].", new Object[]{vcenterUuid, dsMoId, deletePaths});
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)dsMoId)) {
            logger.error((Object)"Delete dataStore files, but parameter is empty: vCenter[%s], dsMoId[%s].", new Object[]{vcenterUuid, dsMoId});
            throw new LegoCheckedException(-1L);
        }
        if (VerifyUtil.isEmpty(deletePaths)) {
            logger.info((Object)"deletePaths empty.");
            return;
        }
        ManagedObjectReference dsMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid("datastoreBrowser-" + dsMoId, "HostDatastoreBrowser");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        VimPortType vimPortType = conn.getVimPort();
        try {
            for (String path : deletePaths) {
                vimPortType.deleteFile(dsMor, path);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteDatastoreFiles error. ");
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"deleteDatastoreFiles error.", (long)-1L, null, (Log)logger);
        }
    }

    public boolean isMountedToHost(String vcenterUuid, String dsMoId, String hostMoId) {
        logger.debug((Object)"Check if the dataStore was mounted to host: vCenter[%s], dsMoId[%s], hostMoId[%s].", new Object[]{vcenterUuid, dsMoId, hostMoId});
        if (VerifyUtil.isEmpty((String)dsMoId) || VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)hostMoId)) {
            logger.error((Object)"Check dataSotre was mounted to host, parameter is empty: vCenter[%s], dsMoId[%s], hostMoId[%s].", new Object[]{vcenterUuid, dsMoId, hostMoId});
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObjectReference dsMor = new ManagedObjectReference();
        dsMor.setType("Datastore");
        dsMor.setValue(dsMoId);
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        ArrayOfDatastoreHostMount mountedHosts = (ArrayOfDatastoreHostMount)GetMoPropsValueUtils.getInstance().entityProps(conn, dsMor, new String[]{"host"}).get("host");
        if (null == mountedHosts) {
            logger.error((Object)"mount hosts is null: dsMoId[%s].", new Object[]{dsMoId});
            return false;
        }
        List mountedList = mountedHosts.getDatastoreHostMount();
        for (DatastoreHostMount mount : mountedList) {
            if (!mount.getKey().getValue().equals(hostMoId)) continue;
            HostMountInfo info = mount.getMountInfo();
            logger.info((Object)("dsMoId=" + dsMoId + "host:" + mount.getKey().getValue() + " isAccessible=" + info.isAccessible() + "isMounted=" + info.isMounted()));
            if (!info.isAccessible().booleanValue() || !info.isMounted().booleanValue()) continue;
            logger.info((Object)("datastore is  ready,dsMoId=" + dsMoId));
            return true;
        }
        return false;
    }

    public boolean isNeedMount(String vcenterUuid, VsphereDataStore datastore, Set<String> targetWwns) {
        ArrayList<String> uuidList = new ArrayList<String>();
        uuidList.add(datastore.getUuid().split(":")[1]);
        List<String> datastoreWwns = this.getLunFromDsMoIds(vcenterUuid, uuidList);
        if (VerifyUtil.isEmpty(datastoreWwns)) {
            return false;
        }
        logger.info((Object)"isNeedMount datastoreWwns:%s", new Object[]{datastoreWwns});
        logger.info((Object)"isNeedMount targetWwns:%s", new Object[]{targetWwns});
        for (String datastoreWwn : datastoreWwns) {
            if (targetWwns.contains(datastoreWwn)) continue;
            logger.info((Object)"isNeedMount result is false");
            return false;
        }
        return true;
    }

    public List<VsphereDataStore> filterDatastores(String vcenterUuid, List<VsphereDataStore> datastores, List<StorageResource> resources) {
        if (VerifyUtil.isEmpty(resources)) {
            return new ArrayList<VsphereDataStore>();
        }
        Set targetWwns = resources.stream().map(resource -> resource.getResourceIndentifier()).collect(Collectors.toSet());
        return datastores.stream().filter(dataStore -> this.isNeedMount(vcenterUuid, (VsphereDataStore)dataStore, targetWwns)).collect(Collectors.toList());
    }

    public boolean compareDatastore(List<VsphereDataStore> dataStores, List<VsphereDataStore> newDatastores) {
        Set oldNames = dataStores.stream().map(dataStore -> dataStore.getName()).collect(Collectors.toSet());
        Set newNames = newDatastores.stream().map(dataStore -> dataStore.getName()).collect(Collectors.toSet());
        logger.info((Object)("old datastore names:" + oldNames));
        logger.info((Object)("new datastore names:" + newNames));
        if (newDatastores.size() != dataStores.size()) {
            logger.error((Object)"datastore size is not match.");
            return false;
        }
        return true;
    }

    public boolean migrateVmByStorage(String vCenterUuid, String vmMoId, String destDsMoId, List<VirtualMachineRelocateSpecDiskLocator> diskSpecs) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[migrateVmByDatastore] vCenterUuid=%s, vmMoId=%s, destDsMoId=%s, diskSpecs=%s", new Object[]{vCenterUuid, vmMoId, destDsMoId, diskSpecs});
        }
        VmwareConnection connection = VmwareConnectionManager.getInstance().getVmwareConnection(vCenterUuid);
        GetMoPropsValueUtils propsValueUtils = GetMoPropsValueUtils.getInstance();
        ManagedObjectReference vmRef = propsValueUtils.getMorByObjUuid(vmMoId, "VirtualMachine");
        ManagedObjectReference datastoreRef = null;
        if (!VerifyUtil.isEmpty((String)destDsMoId)) {
            datastoreRef = propsValueUtils.getMorByObjUuid(destDsMoId, "Datastore");
        }
        VirtualMachineRelocateSpec relocateSpec = new VirtualMachineRelocateSpec();
        relocateSpec.setDatastore(datastoreRef);
        if (diskSpecs != null) {
            relocateSpec.getDisk().addAll(diskSpecs);
        }
        VimPortType vimPort = connection.getVimPort();
        try {
            ManagedObjectReference task = vimPort.relocateVMTask(vmRef, relocateSpec, VirtualMachineMovePriority.HIGH_PRIORITY);
            MethodFault methodFault = new VsphereTaskResultMonitor(connection, task).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)methodFault)) {
                logger.debug((Object)"migration succeed. vmMoId=%s, destDsMoId=%s", new Object[]{vmMoId, destDsMoId});
                return true;
            }
            this.dealMigrateFault(vmMoId, destDsMoId, methodFault);
        }
        catch (Exception ex) {
            if (ex instanceof LegoCheckedException) {
                throw (LegoCheckedException)((Object)ex);
            }
            logger.error((Object)"migration exception: %s, vmMoId=%s, destDsMoId=%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex), vmMoId, destDsMoId});
            throw new LegoCheckedException(1073948947L);
        }
        return true;
    }

    private void dealMigrateFault(String vmMoId, String destDsMoId, MethodFault methodFault) {
        if (methodFault instanceof NoDiskSpace) {
            NoDiskSpace noDiskSpace = (NoDiskSpace)methodFault;
            logger.error((Object)"fault: NoDiskSpace, vmMoId=%s, destDsMoId=%s, datastore=%s", new Object[]{vmMoId, destDsMoId, noDiskSpace.getDatastore()});
            throw new LegoCheckedException(1073948951L, new String[]{noDiskSpace.getDatastore()});
        }
        if (methodFault instanceof VmConfigFault) {
            logger.error((Object)"fault: VmConfigFault, vmMoId=%s, destDsMoId=%s", new Object[]{vmMoId, destDsMoId});
            throw new LegoCheckedException(1073948885L);
        }
        if (methodFault instanceof InsufficientResourcesFault) {
            logger.error((Object)"fault: InsufficientResourcesFault, vmMoId=%s, destDsMoId=%s", new Object[]{vmMoId, destDsMoId});
            throw new LegoCheckedException(1073948880L);
        }
        if (methodFault instanceof InvalidState) {
            logger.error((Object)"fault: InvalidState, vmMoId=%s, destDsMoId=%s", new Object[]{vmMoId, destDsMoId});
            throw new LegoCheckedException(1073948881L);
        }
        if (methodFault instanceof MigrationFault) {
            logger.error((Object)"fault: MigrationFault, vmMoId=%s, destDsMoId=%s", new Object[]{vmMoId, destDsMoId});
            throw new LegoCheckedException(1073948947L);
        }
        if (methodFault instanceof InvalidDatastore) {
            logger.error((Object)"fault: InvalidDatastore, vmMoId=%s, destDsMoId=%s", new Object[]{vmMoId, destDsMoId});
            throw new LegoCheckedException(1073948891L);
        }
        logger.error((Object)"unExcepted fault: %s, vmMoId=%s, destDsMoId=%s", new Object[]{methodFault.getClass().getName(), vmMoId, destDsMoId});
        throw new LegoCheckedException(1073948947L);
    }
}

