/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action.util;

import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.builder.ObjectSpecBuilder;
import com.huawei.ism.drm.vsphere.adapter.action.util.builder.PropertyFilterSpecBuilder;
import com.huawei.ism.drm.vsphere.adapter.action.util.builder.PropertySpecBuilder;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.discovery.util.PropertyCollectorUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.DynamicProperty;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.RuntimeFaultFaultMsg;
import com.huawei.vmware.vim25.ServiceContent;
import com.huawei.vmware.vim25.TraversalSpec;
import com.huawei.vmware.vim25.VimPortType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GetMoPropsValueUtils {
    private static final Log logger = LogFactory.getInstance(GetMoPropsValueUtils.class);
    private static final GetMoPropsValueUtils INSTANCE = new GetMoPropsValueUtils();

    private GetMoPropsValueUtils() {
    }

    public static GetMoPropsValueUtils getInstance() {
        return INSTANCE;
    }

    public Map<String, Object> entityProps(VmwareConnection connection, ManagedObjectReference entityMor, String[] props) {
        List<ObjectContent> oCont;
        if (null == connection || null == entityMor) {
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        PropertyFilterSpec[] propertyFilterSpecs = new PropertyFilterSpec[]{new PropertyFilterSpecBuilder().propSet(new PropertySpecBuilder().all(Boolean.FALSE).type(entityMor.getType()).pathSet(props)).objectSet(new ObjectSpecBuilder().obj(entityMor))};
        try {
            oCont = PropertyCollectorUtil.retrievePropertiesEx(connection, Arrays.asList(propertyFilterSpecs));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"retrievePropertiesEx error.", (Throwable)e, 90160758786989L);
            throw e;
        }
        if (oCont == null) {
            return retVal;
        }
        for (ObjectContent oc : oCont) {
            List dps = oc.getPropSet();
            for (DynamicProperty dp : dps) {
                retVal.put(dp.getName(), dp.getVal());
            }
        }
        return retVal;
    }

    public Map<ManagedObjectReference, Map<String, Object>> entityProps(VmwareConnection connection, List<ManagedObjectReference> entityMors, String[] props) {
        List<ObjectContent> listobjcontent;
        HashMap<ManagedObjectReference, Map<String, Object>> retVal = new HashMap<ManagedObjectReference, Map<String, Object>>();
        PropertyFilterSpecBuilder propertyFilterSpec = new PropertyFilterSpecBuilder();
        HashMap<String, String> typesCovered = new HashMap<String, String>();
        for (ManagedObjectReference mor : entityMors) {
            if (!typesCovered.containsKey(mor.getType())) {
                propertyFilterSpec.propSet(new PropertySpecBuilder().all(Boolean.FALSE).type(mor.getType()).pathSet(props));
                typesCovered.put(mor.getType(), "");
            }
            propertyFilterSpec.objectSet(new ObjectSpecBuilder().obj(mor));
        }
        ArrayList<PropertyFilterSpec> propertyFilterSpecs = new ArrayList<PropertyFilterSpec>();
        propertyFilterSpecs.add(propertyFilterSpec);
        try {
            listobjcontent = PropertyCollectorUtil.retrievePropertiesEx(connection, propertyFilterSpecs);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"retrievePropertiesEx error.", (Throwable)e, 90160758786989L);
            throw e;
        }
        if (null == listobjcontent) {
            return retVal;
        }
        for (ObjectContent oc : listobjcontent) {
            List dps = oc.getPropSet();
            HashMap<String, Object> propMap = new HashMap<String, Object>();
            if (dps != null) {
                for (DynamicProperty dp : dps) {
                    propMap.put(dp.getName(), dp.getVal());
                }
            }
            retVal.put(oc.getObj(), propMap);
        }
        return retVal;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<ManagedObjectReference, Map<String, Object>> getDynamicProps(VmwareConnection conn, String moType, List<String> items) {
        HashMap<ManagedObjectReference, Map<String, Object>> retVal = new HashMap<ManagedObjectReference, Map<String, Object>>();
        ServiceContent srvContent = conn.getServiceContent();
        VimPortType vimPort = conn.getVimPort();
        ManagedObjectReference viewMgrRef = srvContent.getViewManager();
        ArrayList<String> dirList = new ArrayList<String>();
        dirList.add(moType);
        ManagedObjectReference containerViewRef = null;
        try {
            containerViewRef = vimPort.createContainerView(viewMgrRef, srvContent.getRootFolder(), dirList, true);
            ObjectSpec objSpec = new ObjectSpec();
            objSpec.setObj(containerViewRef);
            objSpec.setSkip(Boolean.valueOf(true));
            TraversalSpec traSpec = new TraversalSpec();
            traSpec.setName("traverseEntities");
            traSpec.setPath("view");
            traSpec.setSkip(Boolean.valueOf(false));
            traSpec.setType("ContainerView");
            objSpec.getSelectSet().add(traSpec);
            PropertySpec propSpec = new PropertySpec();
            propSpec.setType(moType);
            propSpec.getPathSet().addAll(items);
            PropertyFilterSpec filterSpec = new PropertyFilterSpec();
            filterSpec.getObjectSet().add(objSpec);
            filterSpec.getPropSet().add(propSpec);
            ArrayList<PropertyFilterSpec> filterSpecList = new ArrayList<PropertyFilterSpec>();
            filterSpecList.add(filterSpec);
            List<ObjectContent> listobjcontent = PropertyCollectorUtil.retrievePropertiesEx(conn, filterSpecList);
            for (ObjectContent oc : listobjcontent) {
                List dps = oc.getPropSet();
                HashMap<String, Object> propMap = new HashMap<String, Object>();
                if (dps == null) continue;
                for (DynamicProperty dp : dps) {
                    propMap.put(dp.getName(), dp.getVal());
                }
                retVal.put(oc.getObj(), propMap);
            }
        }
        catch (RuntimeFaultFaultMsg e) {
            try {
                logger.error((Object)"Do getDynamicProps error.", (Throwable)e);
                throw new LegoCheckedException(-1L, (Throwable)e);
                catch (LegoCheckedException exception) {
                    logger.error((Object)"Do retrievePropertiesEx error.", (Throwable)exception);
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                VMAction.destroyContainerView(containerViewRef, vimPort);
                throw throwable;
            }
        }
        VMAction.destroyContainerView(containerViewRef, vimPort);
        return retVal;
    }

    public ManagedObjectReference getMorByObjUuid(String objUuid, String moType) {
        String moid = this.getMoid(objUuid);
        if (!VerifyUtil.isEmpty((String)moid)) {
            ManagedObjectReference moRef = new ManagedObjectReference();
            moRef.setType(moType);
            moRef.setValue(moid);
            return moRef;
        }
        return null;
    }

    public String getMoid(String objUuid) {
        String ret = objUuid;
        if (!VerifyUtil.isEmpty((String)objUuid) && objUuid.contains(":")) {
            ret = objUuid.split(":")[1].trim();
        }
        return ret;
    }
}

