/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action.util;

import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.action.util.builder.ObjectSpecBuilder;
import com.huawei.ism.drm.vsphere.adapter.action.util.builder.PropertyFilterSpecBuilder;
import com.huawei.ism.drm.vsphere.adapter.action.util.builder.PropertySpecBuilder;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.vmware.vim25.InvalidPropertyFaultMsg;
import com.huawei.vmware.vim25.LocalizedMethodFault;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.MethodFault;
import com.huawei.vmware.vim25.ObjectUpdate;
import com.huawei.vmware.vim25.PropertyChange;
import com.huawei.vmware.vim25.PropertyChangeOp;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertyFilterUpdate;
import com.huawei.vmware.vim25.RuntimeFaultFaultMsg;
import com.huawei.vmware.vim25.ServiceContent;
import com.huawei.vmware.vim25.TaskInfoState;
import com.huawei.vmware.vim25.UpdateSet;
import com.huawei.vmware.vim25.VimPortType;
import com.huawei.vmware.vim25.WaitOptions;
import java.util.Calendar;
import java.util.List;

public class VsphereTaskResultMonitor {
    private static final Log logger = LogFactory.getInstance(VsphereTaskResultMonitor.class);
    private static final long DEFAULT_OVER_TIME = LegoConfig.getInstance().getNumber("vmware.task.monitor.timeout", 600L) * 1000L;
    private static final long MAX_OVER_TIME = LegoConfig.getInstance().getNumber("vmware.task.monitor.uncancelable.timeout", 86400L) * 1000L;
    private final String[] filterProps = new String[]{"info.state", "info.error"};
    private final String[] endWaitProps = new String[]{"info.state"};
    private final TaskInfoState[][] expectedVals = new TaskInfoState[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}};
    private final ManagedObjectReference task;
    private final VmwareConnection connection;
    private final long overTimeInMillisecond;
    private boolean ingoreOverTimeFlag = false;
    private VimPortType vimPort;
    private ManagedObjectReference propertyColletcor = null;
    private boolean isTaskCancelable = true;

    public VsphereTaskResultMonitor(VmwareConnection connection, ManagedObjectReference task, long overTimeInMillisecond) {
        this.connection = connection;
        this.task = task;
        this.overTimeInMillisecond = overTimeInMillisecond;
        if (overTimeInMillisecond <= 0L) {
            this.ingoreOverTimeFlag = true;
        }
    }

    public VsphereTaskResultMonitor(VmwareConnection connection, ManagedObjectReference task) {
        this(connection, task, DEFAULT_OVER_TIME);
    }

    public MethodFault monitorTaskResultAfterDone() {
        try {
            this.vimPort = this.connection.getVimPort();
            ServiceContent ser = this.connection.getServiceContent();
            this.propertyColletcor = this.vimPort.createPropertyCollector(ser.getPropertyCollector());
            Object[] result = this.waitForTaskResult();
            if (result[0] instanceof TaskInfoState && TaskInfoState.SUCCESS == (TaskInfoState)result[0]) {
                return null;
            }
            if (result[1] instanceof LocalizedMethodFault) {
                logger.error((Object)((LocalizedMethodFault)result[1]).getLocalizedMessage(), 90160758786989L);
                MethodFault fault = ((LocalizedMethodFault)result[1]).getFault();
                return fault;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"getTaskResultAfterDone fault.", (Throwable)e, 90160758786989L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"getTaskResultAfterDone fault.", (long)-1L, null, (Log)logger);
        }
        return null;
    }

    private Object[] waitForTaskResult() {
        PropertyFilterSpec spec = this.propertyFilterSpec(this.task, this.filterProps);
        ManagedObjectReference filterSpecRef = this.createFilterSpecRef(spec);
        Boolean reached = false;
        UpdateSet updateset = null;
        String version = "";
        Object[] filterVals = new Object[this.filterProps.length];
        WaitOptions waitOption = new WaitOptions();
        waitOption.setMaxWaitSeconds(Integer.valueOf(60));
        long start = Calendar.getInstance().getTimeInMillis();
        while (!reached.booleanValue()) {
            try {
                updateset = this.vimPort.waitForUpdatesEx(this.propertyColletcor, version, waitOption);
                long nowTime = Calendar.getInstance().getTimeInMillis();
                long executeTime = nowTime - start;
                if (!this.ingoreOverTimeFlag && executeTime >= this.overTimeInMillisecond) {
                    this.cancelTaskAndUpdate();
                    if (this.isTaskCancelable) {
                        logger.error((Object)"task execute overtime. start time: %s.overtime time: %s", new Object[]{start, nowTime});
                        throw new LegoCheckedException(1073947433L, "task execute overtime");
                    }
                    if (executeTime > MAX_OVER_TIME) {
                        logger.error((Object)("task is not cancelable. execute over max time. plz check vcenter task status. task:" + this.task.getValue()));
                        throw new LegoCheckedException(1073947433L, "task execute overtime");
                    }
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e, 90160758786989L);
                throw e;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"waitForTaskResult fault.", (long)-1L, null, (Log)logger);
            }
            if (updateset == null || updateset.getFilterSet() == null) continue;
            version = updateset.getVersion();
            reached = this.handleUpdateData(updateset, filterVals, reached);
        }
        this.destroyPropertyFilter(filterSpecRef);
        return filterVals;
    }

    private Boolean handleUpdateData(UpdateSet updateset, Object[] filterVals, Boolean reached) {
        Object[] endWaitFilterPropsVals = new Object[this.endWaitProps.length];
        List filtupary = updateset.getFilterSet();
        for (PropertyFilterUpdate filtup : filtupary) {
            List objupary = filtup.getObjectSet();
            for (ObjectUpdate objup : objupary) {
                if (!objup.getObj().getType().equals(this.task.getType()) || !objup.getObj().getValue().equals(this.task.getValue())) continue;
                List propchgary = objup.getChangeSet();
                for (PropertyChange propchg : propchgary) {
                    this.updateValues(this.endWaitProps, endWaitFilterPropsVals, propchg);
                    this.updateValues(this.filterProps, filterVals, propchg);
                }
            }
        }
        for (int chgi = 0; chgi < endWaitFilterPropsVals.length && !reached.booleanValue(); ++chgi) {
            for (int vali = 0; vali < this.expectedVals[chgi].length && !reached.booleanValue(); ++vali) {
                TaskInfoState expctdval = this.expectedVals[chgi][vali];
                reached = expctdval.equals((Object)((TaskInfoState)endWaitFilterPropsVals[chgi]));
            }
        }
        return reached;
    }

    private void destroyPropertyFilter(ManagedObjectReference filterSpecRef) {
        try {
            this.vimPort.destroyPropertyFilter(filterSpecRef);
            this.vimPort.destroyPropertyCollector(this.propertyColletcor);
        }
        catch (RuntimeFaultFaultMsg e) {
            throw new LegoCheckedException("Destroy the filter.", (Throwable)e);
        }
    }

    private ManagedObjectReference createFilterSpecRef(PropertyFilterSpec spec) {
        ManagedObjectReference filterSpecRef;
        try {
            filterSpecRef = this.vimPort.createFilter(this.propertyColletcor, spec, true);
        }
        catch (InvalidPropertyFaultMsg e) {
            throw new LegoCheckedException("create filter error by InvalidPropertyFaultMsg.", (Throwable)e);
        }
        catch (RuntimeFaultFaultMsg e) {
            throw new LegoCheckedException("create filter error by RuntimeFaultFaultMsg.", (Throwable)e);
        }
        return filterSpecRef;
    }

    private PropertyFilterSpec propertyFilterSpec(ManagedObjectReference objmor, String[] filterPropsParam) {
        return new PropertyFilterSpecBuilder().objectSet(new ObjectSpecBuilder().obj(objmor).skip(Boolean.FALSE)).propSet(new PropertySpecBuilder().type(objmor.getType()).pathSet(filterPropsParam));
    }

    private void updateValues(String[] wantedProps, Object[] vals, PropertyChange propchg) {
        for (int findi = 0; findi < wantedProps.length; ++findi) {
            if (!propchg.getName().equals(wantedProps[findi])) continue;
            vals[findi] = propchg.getOp() == PropertyChangeOp.REMOVE ? "" : propchg.getVal();
        }
    }

    private void cancelTaskAndUpdate() {
        if (!this.isTaskCancelable) {
            return;
        }
        try {
            this.vimPort.cancelWaitForUpdates(this.propertyColletcor);
        }
        catch (Exception e) {
            logger.error((Object)("propertyColletcor cancelwaitforupdates  error:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        try {
            if (((Boolean)GetMoPropsValueUtils.getInstance().entityProps(this.connection, this.task, new String[]{"info.cancelable"}).get("info.cancelable")).booleanValue()) {
                this.isTaskCancelable = true;
                logger.info((Object)"start to cancel task. task: %s", new Object[]{this.task.getValue()});
                this.vimPort.cancelTask(this.task);
            } else {
                logger.error((Object)("task:  " + this.task.getValue() + " is uncancelable"), 90160758786989L);
                this.isTaskCancelable = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("task cancel  error : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }
}

