/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.discovery;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.sdk.service.IManagementProtocolService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceManager;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.discovery.service.impl.VsphereDiscoveryServiceImpl;
import com.huawei.ism.drm.vsphere.sdk.model.DrVsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.tools.FileHelperMgr;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;

public class VsphereResourceManager
implements IResourceManager {
    private static final long MAXPORTVALUE = 65535L;
    private static final int MAX_USERNAME_LENGTH = 255;
    private static final int MAX_PWD_LENGTH = 64;
    private static final Log logger = LogFactory.getInstance(VsphereDiscoveryServiceImpl.class);

    public NeMgrProtocolExtend getMgrProtocol(Long moId) {
        IManagementProtocolService service = (IManagementProtocolService)ServiceLocator.getInstance().getService(IManagementProtocolService.class);
        NeMgrProtocolExtend neMgrProtocolExtend = service.findByMoId(moId);
        return neMgrProtocolExtend;
    }

    public void validate(NeMgrProtocolExtend neMgrProtocol) {
        if (!CommUtil.isNullStr((String)neMgrProtocol.getNetworkIpAddress()) && !CommUtil.checkDrmIpParam((String)StringEscapeUtils.unescapeHtml4((String)neMgrProtocol.getNetworkIpAddress()))) {
            logger.error((Object)"Ip format error: %s", new Object[]{neMgrProtocol.getNetworkIpAddress()});
            throw new LegoCheckedException(1073947393L, "ip format error");
        }
        if (!this.varifyDiscParams(neMgrProtocol.getNetworkUserName(), neMgrProtocol.getNetworkPassword(), (String)neMgrProtocol.getExtendParams().get("port"))) {
            throw new LegoCheckedException(1073947393L, "uname, pwd, port format error");
        }
        IManagementProtocolService service = (IManagementProtocolService)ServiceLocator.getInstance().getService(IManagementProtocolService.class);
        NeMgrProtocolExtend oldMgrProtocol = service.findByMoId(neMgrProtocol.getMoId());
        if (Objects.equals(neMgrProtocol.getNetworkIpAddress(), oldMgrProtocol.getNetworkIpAddress())) {
            return;
        }
        if (!neMgrProtocol.isModifyAuthInfo()) {
            logger.error((Object)"The vsphere password does not change together with the IP address.");
            throw new LegoCheckedException(2099466L);
        }
    }

    private boolean varifyDiscParams(String userName, String pwd, String port) {
        if (DiscParamValidator.stringisNull((String)userName) || DiscParamValidator.stringisNull((String)pwd) || VerifyUtil.isEmpty((String)port)) {
            logger.error((Object)"userName, pwd or port is empty.", 90160758786989L);
            return false;
        }
        if (userName.length() > 255 || pwd.length() > 64) {
            logger.error((Object)"userName or pwd is more than max length.", 90160758786989L);
            return false;
        }
        try {
            return CommUtil.checkDrmPortParam((String)port);
        }
        catch (Exception e) {
            logger.error((Object)("check port is error . parm:" + port + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return false;
        }
    }

    public void updateMgrProtocol(NeMgrProtocolExtend neMgrProtocol) {
        long moId = neMgrProtocol.getMoId();
        VsphereCenter vcenter = this.getVcenterByMoId(moId);
        if (vcenter == null) {
            logger.error((Object)"Mo vCenter not found: moId=%s", new Object[]{String.valueOf(moId)});
            throw new LegoCheckedException(1073947393L);
        }
        String uuid = vcenter.getUuid();
        IManagementProtocolService service = (IManagementProtocolService)ServiceLocator.getInstance().getService(IManagementProtocolService.class);
        NeMgrProtocolExtend managementProtocol = service.findByMoId(Long.valueOf(moId));
        if (managementProtocol == null) {
            logger.error((Object)"NeMgrProtocolExtend not found: vCenter uuid=%s.", new Object[]{uuid});
            throw new LegoCheckedException(201L);
        }
        String oldIp = managementProtocol.getNetworkIpAddress();
        String oldPort = managementProtocol.getExtendParams().getOrDefault("port", null);
        Map mangementProtocolMap = managementProtocol.getExtendParams();
        boolean isIpChanged = false;
        if (this.verifyIpAndUpdate(managementProtocol, neMgrProtocol, vcenter)) {
            isIpChanged = true;
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)vcenter);
            this.saveOrUpdateDrVsphereCenter(vcenter);
        }
        if (this.verifyPortAndUpdate(mangementProtocolMap, neMgrProtocol) || this.verifyLoginInfoAndUpdate(managementProtocol, neMgrProtocol) || isIpChanged) {
            managementProtocol.setExtendParams(mangementProtocolMap);
            service.update(managementProtocol);
            this.summitUpdateConnectionTask(uuid);
        }
        FileHelperMgr.getInstance().removeFileHelper(oldIp, oldPort);
    }

    public String getResourceType() {
        return "ism.drm.deviceType.drvsphere.mainType";
    }

    private void checkStringLength(String textValue, int max) {
        if (DiscParamValidator.stringisNull((String)textValue)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (textValue.length() > max) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean verifyIpAndUpdate(NeMgrProtocolExtend managementProtocolExtend, NeMgrProtocolExtend neMgrProtocolExtend, VsphereCenter vcenter) {
        boolean isModify = false;
        String newIp = StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkIpAddress());
        String oldIp = managementProtocolExtend.getNetworkIpAddress();
        if (!CommUtil.isNullStr((String)newIp) && !oldIp.equals(newIp)) {
            managementProtocolExtend.setNetworkIpAddress(newIp);
            vcenter.setIpAddress(newIp);
            vcenter.setLinkIp(newIp);
            isModify = true;
        }
        return isModify;
    }

    private boolean verifyPortAndUpdate(Map<String, String> mangementProtocolMap, NeMgrProtocolExtend neMgrProtocolExtend) {
        String newPort;
        boolean isModify = false;
        String existedPort = mangementProtocolMap.getOrDefault("port", null);
        Map extendParams = neMgrProtocolExtend.getExtendParams();
        String string = newPort = extendParams != null ? (String)extendParams.get("port") : "";
        if (existedPort != null && !existedPort.equals(StringEscapeUtils.unescapeHtml4((String)newPort)) && CommUtil.checkDrmPortParam((String)newPort)) {
            mangementProtocolMap.put("port", StringEscapeUtils.unescapeHtml4((String)newPort));
            isModify = true;
        }
        return isModify;
    }

    private boolean verifyLoginInfoAndUpdate(NeMgrProtocolExtend mangementProtocol, NeMgrProtocolExtend neMgrProtocolExtend) {
        if (DiscParamValidator.stringisNull((String)neMgrProtocolExtend.getNetworkUserName()) || DiscParamValidator.stringisNull((String)neMgrProtocolExtend.getNetworkPassword())) {
            return false;
        }
        Boolean whetherModify = false;
        if (!mangementProtocol.getNetworkUserName().equals(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkUserName()))) {
            this.checkStringLength(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkUserName()), 255);
            mangementProtocol.setNetworkUserName(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkUserName()));
            whetherModify = true;
        }
        if (!mangementProtocol.getNetworkPassword().equals(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkPassword()))) {
            this.checkStringLength(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkPassword()), 64);
            mangementProtocol.setNetworkPassword(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkPassword()));
            whetherModify = true;
        }
        return whetherModify;
    }

    private VsphereCenter getVcenterByMoId(long moId) {
        VsphereCenter vcenter = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "moId", (Object)moId);
        return vcenter;
    }

    private void summitUpdateConnectionTask(final String uuid) {
        ExecutionService.submitTask((Runnable)new Runnable(){

            @Override
            public void run() {
                VmwareConnectionManager.getInstance().removeVmwareConnection(uuid);
            }
        });
    }

    private void saveOrUpdateDrVsphereCenter(VsphereCenter vc) {
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVsphereCenter where deviceSn = ? and siteId in (select siteId from Site where siteType = 0)", new Object[]{vc.getSn()});
        if (!VerifyUtil.isEmpty((Collection)resources)) {
            DrVsphereCenter drVcenter = (DrVsphereCenter)resources.get(0);
            drVcenter.setStatus(vc.getStatus() + "");
            drVcenter.setVersion(vc.getVersion());
            drVcenter.setName(vc.getName());
            drVcenter.setIpAddress(vc.getLinkIp());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)drVcenter);
        }
    }
}

