/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.discovery.msg;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshDelegate;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.sdk.model.DrVsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class VpshereMessageSubscriber
extends MessageTaskManager {
    private final Log logger = LogFactory.getInstance(VpshereMessageSubscriber.class);

    public VpshereMessageSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)2);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(105L);
        mrs[1].setMessageTopic(MessageTopic.COMMAND);
        mrs[1].addMessageCode(109L);
        mrs[1].addMessageCode(110L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        Object msg = mu.getObj();
        if (null == msg || !(msg instanceof Map)) {
            return;
        }
        long msgType = mu.getCmdcode();
        if (MessageTopic.DATA.equals((Object)mu.getMt()) && 105L == msgType) {
            this.deleteResource(msg);
        } else if (MessageTopic.COMMAND.equals((Object)mu.getMt()) && (109L == msgType || 110L == msgType)) {
            this.updateResourceStatus(msg);
        } else {
            this.logger.error((Object)("Message was not subscribed, msgType: " + msgType), 90160758786876L);
        }
    }

    private void deleteResource(Object msg) {
        Map objs = (Map)msg;
        for (Object obj : objs.values()) {
            if (!(obj instanceof VsphereCenter)) continue;
            NetworkEntity ne = (NetworkEntity)obj;
            DrVsphereCenter drResource = (DrVsphereCenter)((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySnInLocalSite(ne.getSn(), "ism.drm.deviceType.drvsphere.mainType");
            if (null == drResource) continue;
            this.logger.warn((Object)("resource(" + ne.getName() + ") is used."), 90160758786989L);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)drResource);
            String uuid = ne.getUuid();
            VmwareConnectionManager.getInstance().removeVmwareConnection(uuid);
        }
    }

    private void updateResourceStatus(Object msg) {
        Map objs = (Map)msg;
        for (Map.Entry entry : objs.entrySet()) {
            DrVsphereCenter drResource;
            ManagedObject mObject = (ManagedObject)CommonDAOLocator.getMoDao().get((Serializable)entry.getKey());
            if (null == mObject || !(mObject instanceof VsphereCenter) || null == (drResource = (DrVsphereCenter)((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySnInLocalSite(mObject.getUuid(), "ism.drm.deviceType.drvsphere.mainType"))) continue;
            drResource.setStatus(String.valueOf(entry.getValue()));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)drResource);
            if ((Integer)entry.getValue() == 0) continue;
            this.refreshProtectgroupStatus(drResource.getDeviceSn());
        }
    }

    private void refreshProtectgroupStatus(String uuid) {
        Set<String> forceRefreshSet = this.queryPgsByVcenterId(uuid);
        IProtectGroupRefreshDelegate delegate = (IProtectGroupRefreshDelegate)ServiceLocator.getInstance().getService(IProtectGroupRefreshDelegate.class);
        if (null != delegate) {
            try {
                delegate.refreshProtectGroup(uuid, forceRefreshSet);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"refresh ProtectGroup error, pguuids: %s", new Object[]{e, forceRefreshSet});
            }
            catch (Exception e) {
                this.logger.error((Object)"refresh ProtectGroup error, pguuids: %s, error: %s", new Object[]{forceRefreshSet, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> queryPgsByVcenterId(String uuid) {
        Session session = null;
        HashSet<String> forceRefreshSet = new HashSet<String>();
        try {
            session = this.getHibernateSession();
            String strSQL = "select pg.PGID from ti_protectgroup pg where pg.PGPROVIDERSN=:poProviderSN";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setString("poProviderSN", uuid);
            List results = query.list();
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || 1 != (values = (Object[])object).length) continue;
                forceRefreshSet.add(CommUtil.convertToString((Object)values[0]));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Querying Protectgroup failed, poProviderSN: %s, error: %s", new Object[]{uuid, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
        return forceRefreshSet;
    }

    private Session getHibernateSession() {
        HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        Session session = template.getSessionFactory().openSession();
        return session;
    }
}

