/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.discovery.processer;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.vsphere.sdk.model.VmDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;

public class SaveProcessor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(SaveProcessor.class);

    public void clean(AbstractContext arg0) {
    }

    public String getName() {
        return SaveProcessor.class.getName();
    }

    public void postProcess(AbstractContext arg0) {
    }

    public boolean process(AbstractContext context) {
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        VsphereCenter vc = (VsphereCenter)context.getAttribute("vCenterObj");
        String action = (String)context.getAttribute("DiscoveryType");
        if (null == vc || null == extend) {
            return false;
        }
        vc.setMainType("ism.drm.deviceType.drvsphere.mainType");
        vc.setSubType("ism.drm.deviceType.drvsphere.subType");
        vc.setProductModel("Dr_Vsphere");
        HashMap result = new HashMap();
        try {
            CommonDAOLocator.getMoDao().addMoAndSubMoWithoutMsg((ManagedObject)vc, result);
            if ("register".equals(action)) {
                INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
                NeMgrProtocolExtend existNe = neMgr.findByMoId(vc.getMoId());
                if (null != existNe) {
                    existNe.setExtendParams(extend.getExtendParams());
                    existNe.setNetworkIpAddress(extend.getNetworkIpAddress());
                    existNe.setNetworkUserName(extend.getNetworkUserName());
                    existNe.setNetworkPassword(extend.getNetworkPassword());
                    neMgr.update(existNe);
                } else {
                    extend.setMoId(vc.getMoId());
                    neMgr.save(extend);
                }
                Long userId = (Long)context.getAttribute("OperatorId");
                DiscoverUtil.grantUserNeAuthority((NetworkEntity)vc, (Long)userId);
            } else {
                Istatus devStatus = GlobalDeviceStatus.getStatus((String)vc.getUuid(), DefaultOnlineToOfflineStatus.class);
                devStatus.doAction((ManagedObject)vc, 0);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("save vcenter error:" + vc.getIpAddress()), (long)-1L, null, (Log)logger);
        }
        try {
            Set vmDataStores = (Set)context.getAttribute("vmDataStoreObj");
            this.updateVMStorageInfo(vmDataStores, vc.getUuid());
        }
        catch (Exception e) {
            logger.error((Object)("update dsg error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        this.updateProtectObjectInfo(vc.getUuid());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProtectObjectInfo(String vcenterUuid) {
        Session session;
        block7: {
            session = null;
            try {
                String sql;
                List list;
                Transaction transaction;
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String hql = "from ManagedObject where discriminator like 'VsphereVirtualMachine' and TOP_MO_UUID='" + vcenterUuid + "'";
                List mos = CommonDAOLocator.getBaseDao().find(hql, new Object[0]);
                if (mos != null && mos.size() != 0) {
                    transaction = session.beginTransaction();
                    String updateClause = "UPDATE ti_protectobject SET PONAME = ? WHERE MOUUID = ?";
                    NativeQuery query = session.createSQLQuery(updateClause);
                    for (ManagedObject managedObject : mos) {
                        query.setString(0, managedObject.getName()).setString(1, managedObject.getUuid());
                        query.executeUpdate();
                    }
                    transaction.commit();
                }
                if ((list = session.createSQLQuery(sql = "select dsmo.name, disk.storagewwn from ti_vs_datastorediskinfo disk, t_managedobject diskmo, t_managedobject dsmo where disk.mo_id = diskmo.moid and diskmo.parent_id = dsmo.moid and disk.storagewwn <> 'UNKNOWN';").list()) == null || list.size() == 0) break block7;
                transaction = session.beginTransaction();
                String updateClause = "UPDATE ti_hoststorageresource SET DEVNAME = ? WHERE LOWER(LUNWWN) = LOWER(?)";
                NativeQuery query = session.createSQLQuery(updateClause);
                for (Object[] obj : list) {
                    query.setString(0, obj[0].toString()).setString(1, obj[1].toString());
                    query.executeUpdate();
                }
                transaction.commit();
            }
            catch (Exception e) {
                try {
                    DBOperationUtil.rollbackSession((Session)session);
                    logger.error((Object)("excute procedure error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVMStorageInfo(Set<VmDataStore> infos, String vcUuid) {
        if (VerifyUtil.isEmpty(infos)) {
            return;
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Transaction tx = session.beginTransaction();
            Iterator<VmDataStore> iterator = infos.iterator();
            String hql = "delete from VmDataStore as vds where vds.id.vmUuid like :vCenteruuid";
            session.createQuery(hql).setString("vCenteruuid", vcUuid + "%").executeUpdate();
            while (iterator.hasNext()) {
                VmDataStore vmDataStore = iterator.next();
                session.saveOrUpdate((Object)vmDataStore);
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                logger.error((Object)"failed to update VmDataStore.", (Throwable)e, 90160758786989L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }
}

