/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsInitVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereComputeResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ClusterAttemptedVmInfo;
import com.huawei.vmware.vim25.ClusterNotAttemptedVmInfo;
import com.huawei.vmware.vim25.ClusterPowerOnVmResult;
import com.huawei.vmware.vim25.ClusterRecommendation;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsCfgResForVmsProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 3954317516106158247L;
    private static final int SLEEP_TIME = 15000;
    private static final Log logger = LogFactory.getInstance(VsCfgResForVmsProcessor.class);
    private String vcenterUuid;

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.createSubProcessors();
            this.waitConfigComplate();
        } else {
            this.updateSubProcessors();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        boolean disableAutoConn = this.optNetAutoConn(false);
        if (!disableAutoConn) {
            logger.error((Object)"disable auto connect failed");
            throw new LegoCheckedException(0x300001L);
        }
        this.powerOnMultiVms();
        return this.calcProcessResultBySubProc();
    }

    private boolean optNetAutoConn(boolean isAuto) {
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsInitVmSubProcessor.class);
        return VsphereRecoveryUtils.optNetAutoConn(processors, this.getContextRef(), this.getProcType(), this.vcenterUuid, isAuto);
    }

    private void createSubProcessors() {
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsInitVmSubProcessor.class);
        HashSet<VsCfgResForVmSubProcessor> subProcSet = new HashSet<VsCfgResForVmSubProcessor>();
        for (RecoveryProcessor proc : processors) {
            VsInitVmSubProcessor initSubProc = (VsInitVmSubProcessor)proc;
            if (initSubProc.isTemplateFlag()) continue;
            String poId = initSubProc.getPoId();
            boolean vmHasSnap = VsphereRecoveryUtils.getInstance().isVmHasSnapShotConfig(this.getContextRef());
            VsCfgResForVmSubProcessor subProc = new VsCfgResForVmSubProcessor();
            this.initProc((RecoveryProcessor)subProc);
            subProc.setVcenterUuid(this.vcenterUuid);
            subProc.setVmMoId(initSubProc.getVmMoId());
            subProc.setHasVmSnap(vmHasSnap);
            subProc.setVmxPath(initSubProc.getVmxFilePath());
            subProc.setPreResult(initSubProc.getProcStatus());
            subProc.setPoId(poId);
            subProc.setVmName(initSubProc.getVmName());
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void updateSubProcessors() {
        logger.debug((Object)"updateSubProcessors start");
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsInitVmSubProcessor.class);
        Set childProcSet = this.getChildProc();
        block0: for (RecoveryProcessor childProc : childProcSet) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == childProc.getProcStatus()) continue;
            VsCfgResForVmSubProcessor resSubProc = (VsCfgResForVmSubProcessor)childProc;
            resSubProc.setErrorCode(0L);
            resSubProc.setTaskId(null);
            String childProcVmxPath = resSubProc.getVmxPath();
            for (RecoveryProcessor preProc : processors) {
                VsInitVmSubProcessor initProc = (VsInitVmSubProcessor)preProc;
                String initVmxPath = initProc.getVmxFilePath();
                if (!initVmxPath.equals(childProcVmxPath)) continue;
                boolean vmHasSnap = VsphereRecoveryUtils.getInstance().isVmHasSnapShotConfig(this.getContextRef());
                resSubProc.setHasVmSnap(vmHasSnap);
                resSubProc.setPreResult(initProc.getProcStatus());
                resSubProc.setVmMoId(initProc.getVmMoId());
                continue block0;
            }
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void powerOnMultiVms() {
        HashMap<String, VsCfgResForVmSubProcessor> vmIdProcMap = new HashMap<String, VsCfgResForVmSubProcessor>();
        HashMap<Integer, List<ManagedObjectReference>> vmMap = new HashMap<Integer, List<ManagedObjectReference>>();
        this.getInfoFromChildProc(vmMap, vmIdProcMap);
        logger.info((Object)("will power on vms:moIds=" + vmIdProcMap.keySet()));
        VMAction action = new VMAction();
        Map settings = this.getContextRef().getRecoveryPlan().getGlobalSettings();
        String dcMoId = (String)settings.get("VSDATACENTERID");
        for (Map.Entry entry : vmMap.entrySet()) {
            List<VsCfgResForVmSubProcessor> procGroup = this.getProcGroup((List)entry.getValue(), vmIdProcMap);
            if (VerifyUtil.isEmpty(procGroup)) {
                logger.info((Object)"procGroup is empty");
                continue;
            }
            if ((Integer)entry.getKey() != Integer.MAX_VALUE) {
                try {
                    ClusterPowerOnVmResult result = action.powerOnMultiVm(this.vcenterUuid, dcMoId, (List)entry.getValue());
                    this.updateProcAfterPowerOn(result, vmIdProcMap);
                }
                catch (Exception e) {
                    logger.error((Object)("powerOnMultiVms failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                    this.updateProcAfterFailed(procGroup);
                }
            }
            RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(procGroup, (boolean)false);
            recoveryTemplate.process(this.getContextRef());
        }
    }

    private List<VsCfgResForVmSubProcessor> getProcGroup(List<ManagedObjectReference> morList, Map<String, VsCfgResForVmSubProcessor> procMap) {
        logger.debug((Object)"getProcGroup start");
        ArrayList<VsCfgResForVmSubProcessor> procGroup = new ArrayList<VsCfgResForVmSubProcessor>();
        for (ManagedObjectReference mor : morList) {
            String id = mor.getValue();
            procGroup.add(procMap.get(id));
        }
        return procGroup;
    }

    private void updateProcAfterFailed(List<VsCfgResForVmSubProcessor> procGroup) {
        logger.debug((Object)"updateProcAfterFailed start");
        for (VsCfgResForVmSubProcessor proc : procGroup) {
            proc.setErrorCode(1073948883L);
        }
    }

    private void getInfoFromChildProc(Map<Integer, List<ManagedObjectReference>> vmMap, Map<String, VsCfgResForVmSubProcessor> vmIdProcMap) {
        boolean isCluster = this.isClusterTgtCompRes();
        int batchStartNum = VsphereRecoveryUtils.getInstance().getBatchStartCeiling(isCluster);
        int counter = 0;
        Integer batchNo = 0;
        ArrayList<ManagedObjectReference> notPowerOnVmList = new ArrayList<ManagedObjectReference>();
        vmMap.put(Integer.MAX_VALUE, notPowerOnVmList);
        Set childProcSet = this.getChildProc();
        for (RecoveryProcessor proc : childProcSet) {
            List<Object> vmList;
            VsCfgResForVmSubProcessor cfgResForVmSubProc = (VsCfgResForVmSubProcessor)proc;
            ManagedObjectReference mor = new ManagedObjectReference();
            mor.setType("VirtualMachine");
            mor.setValue(VerifyUtil.isEmpty((String)cfgResForVmSubProc.getVmMoId()) ? cfgResForVmSubProc.getPoId() : cfgResForVmSubProc.getVmMoId());
            vmIdProcMap.put(mor.getValue(), cfgResForVmSubProc);
            if (!cfgResForVmSubProc.isHasVmSnap()) {
                logger.info((Object)("The vm " + cfgResForVmSubProc.getVmName() + "has no snapshot, wont be power on"));
                notPowerOnVmList.add(mor);
                continue;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != cfgResForVmSubProc.getPreResult() || DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == cfgResForVmSubProc.getProcStatus()) {
                logger.info((Object)("The vm" + cfgResForVmSubProc.getVmName() + "wont be power on"));
                notPowerOnVmList.add(mor);
                continue;
            }
            VMAction action = new VMAction();
            VirtualMachinePowerState status = action.getVMPowerState(this.vcenterUuid, cfgResForVmSubProc.getVmMoId());
            boolean isVmtoolInstalled = action.isVmToolInstalled(this.vcenterUuid, cfgResForVmSubProc.getVmMoId());
            if (null == status || VirtualMachinePowerState.POWERED_OFF != status || !isVmtoolInstalled) {
                logger.info((Object)("The vm" + cfgResForVmSubProc.getVmName() + "won't be power on"));
                notPowerOnVmList.add(mor);
                continue;
            }
            if (counter % batchStartNum == 0) {
                vmList = new ArrayList();
                Integer n = batchNo;
                Integer n2 = batchNo = Integer.valueOf(batchNo + 1);
                vmMap.put(batchNo, vmList);
            }
            vmList = vmMap.get(batchNo);
            vmList.add(mor);
            ++counter;
        }
    }

    private void dealRecommVms(List<ClusterRecommendation> recommList) {
        if (!VerifyUtil.isEmpty(recommList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm,recommand vms:");
            for (ClusterRecommendation recomm : recommList) {
                buffer.append(" vmMoId=" + recomm.getTarget().getValue());
            }
            logger.error((Object)buffer.toString(), 90160758786989L);
        }
    }

    private void dealNotAttemptedVms(Map<String, VsCfgResForVmSubProcessor> procMap, List<ClusterNotAttemptedVmInfo> notAttemptedList) {
        if (!VerifyUtil.isEmpty(notAttemptedList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm, not attempted vms:");
            for (ClusterNotAttemptedVmInfo info : notAttemptedList) {
                ManagedObjectReference vm = info.getVm();
                VsCfgResForVmSubProcessor proc = procMap.get(vm.getValue());
                if (null == proc) continue;
                proc.setErrorCode(1073948880L);
                buffer.append(" vmMoId=" + vm.getValue());
                buffer.append(" fault msg:" + info.getFault().getLocalizedMessage());
            }
            logger.info((Object)buffer.toString(), 90160758786988L);
        }
    }

    private void dealAttemptedVms(Map<String, VsCfgResForVmSubProcessor> procMap, List<ClusterAttemptedVmInfo> attemptedList) {
        if (!VerifyUtil.isEmpty(attemptedList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm,attempted vms:");
            for (ClusterAttemptedVmInfo info : attemptedList) {
                ManagedObjectReference vm = info.getVm();
                VsCfgResForVmSubProcessor proc = procMap.get(vm.getValue());
                if (null == proc) continue;
                proc.setTaskId(info.getTask().getValue());
                buffer.append(" moId=" + vm.getValue());
            }
            logger.info((Object)buffer.toString(), 90160758786988L);
        }
    }

    private void waitConfigComplate() {
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException e) {
            logger.info((Object)"waiting for creating datastore failed ", 90160758786988L);
        }
    }

    private void updateProcAfterPowerOn(ClusterPowerOnVmResult result, Map<String, VsCfgResForVmSubProcessor> procMap) {
        if (VerifyUtil.isEmpty((Object)result) || VerifyUtil.isEmpty(procMap)) {
            logger.error((Object)"result or procMap is empty", 90160758786989L);
            return;
        }
        List attemptedList = result.getAttempted();
        List notAttemptedList = result.getNotAttempted();
        List recommList = result.getRecommendations();
        this.dealAttemptedVms(procMap, attemptedList);
        this.dealNotAttemptedVms(procMap, notAttemptedList);
        this.dealRecommVms(recommList);
    }

    private boolean isClusterTgtCompRes() {
        logger.debug((Object)"isClusterTgtCompRes start");
        int planType = this.getProcType();
        boolean ret = false;
        if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
            ProtectGroup pg = this.getContextRef().getProtectGroup();
            String tempStr = (String)pg.getProps().get("pg_topo");
            JSONArray jsonArray = JSONArray.fromObject((Object)tempStr);
            JSONObject jsonObj = JSONObject.fromObject((Object)jsonArray.get(0));
            String compResUuid = jsonObj.getString("computResourceUuid");
            VsphereComputeResource compRes = (VsphereComputeResource)CommonDAOLocator.getMoDao().getMo(VsphereComputeResource.class, "uuid", (Object)compResUuid);
            if (null != compRes) {
                ret = compRes.getIsCluster();
            }
            return ret;
        }
        String key = "testHosts";
        if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
            key = "testHosts";
        } else if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            key = "recoveryHosts";
        }
        Map settings = this.getContextRef().getRecoveryPlan().getGlobalSettings();
        String setting = (String)settings.get(key);
        if (VerifyUtil.isEmpty((String)setting)) {
            return false;
        }
        JSONObject json = JSONObject.fromObject((Object)JSONArray.fromObject((Object)setting).get(0));
        String compResUuid = json.getString("remoteHostId");
        VsphereComputeResource compRes = (VsphereComputeResource)CommonDAOLocator.getMoDao().getMo(VsphereComputeResource.class, "uuid", (Object)compResUuid);
        if (null != compRes) {
            ret = compRes.getIsCluster();
        }
        return ret;
    }

    private void initProc(RecoveryProcessor proc) {
        logger.debug((Object)"initProc start");
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    protected String generateResultKey() {
        logger.debug((Object)"generateResultKey start");
        return ((Object)((Object)this)).getClass().getName();
    }
}

