/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.sdk.model.HostSystem;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreSubProcessor;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Set;

public class VsConfigRDMSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2692274132958650435L;
    private static final Log logger = LogFactory.getInstance(VsConfigRDMSubProcessor.class);
    private static final int SLEEP_TIME = 10000;
    private String lunOrSnapshotWwn;
    private Set<HostSystem> drHost;
    private String hostMoId;
    private String oldDataStoreUrl;
    private String newDataStoreUrl;
    private Boolean preResult = true;
    private String vcenterUuid;
    private String diskFileName;
    private int diskType;

    public String getDiskFileName() {
        return this.diskFileName;
    }

    public void setDiskFileName(String diskFileName) {
        this.diskFileName = diskFileName;
    }

    public String getLunOrSnapshotWwn() {
        return this.lunOrSnapshotWwn;
    }

    public void setLunOrSnapshotWwn(String lunOrSnapshotWwn) {
        this.lunOrSnapshotWwn = lunOrSnapshotWwn;
    }

    public Set<HostSystem> getDrHost() {
        return this.drHost;
    }

    public void setDrHost(Set<HostSystem> drHost) {
        this.drHost = drHost;
    }

    public String getHostMoId() {
        return this.hostMoId;
    }

    public void setHostMoId(String hostMoId) {
        this.hostMoId = hostMoId;
    }

    public String getOldDataStoreUrl() {
        return this.oldDataStoreUrl;
    }

    public void setOldDataStoreUrl(String oldDataStoreUrl) {
        this.oldDataStoreUrl = oldDataStoreUrl;
    }

    public String getNewDataStoreUrl() {
        return this.newDataStoreUrl;
    }

    public void setNewDataStoreUrl(String newDataStoreUrl) {
        this.newDataStoreUrl = newDataStoreUrl;
    }

    public Boolean getPreResult() {
        return this.preResult;
    }

    public void setPreResult(Boolean preResult) {
        this.preResult = preResult;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public int getDiskType() {
        return this.diskType;
    }

    public void setDiskType(int diskType) {
        this.diskType = diskType;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        block9: {
            logger.debug((Object)("Config rdm disk (" + this.getDiskFileName() + ") start."), 90160758786816L);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e1) {
                logger.debug((Object)"Processor of Config rdm disk sleep failed, maybe the  ", 90160758786989L);
            }
            this.updateProcessNameParams(new String[]{this.getDiskFileName().substring(this.getDiskFileName().lastIndexOf("/") + 1)});
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
                this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.rdm.already.config", new String[0]);
                return true;
            }
            if (this.preResult.booleanValue()) {
                this.getNewDatastoreUrl(context);
                try {
                    boolean result = this.configRdmDisk(context);
                    if (result) {
                        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                        logger.debug((Object)("Config RDM disk[" + this.diskFileName + "] success and finish."), 90160758786816L);
                        break block9;
                    }
                    this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                    this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigRDMSubProcessor.fail", null);
                    logger.debug((Object)("Config RDM disk[" + this.diskFileName + "] failed."), 90160758786816L);
                }
                catch (LegoCheckedException e) {
                    this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                    this.updateProcessDetail(e);
                    logger.error((Object)("Config RDM disk[" + this.diskFileName + "] failed."), (Throwable)e, 90160758786816L);
                }
                catch (Exception e) {
                    this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                    this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigRDMSubProcessor.fail", null);
                    logger.error((Object)("Config RDM disk[" + this.diskFileName + "] failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786816L);
                }
            } else {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            }
        }
        return true;
    }

    private boolean configRdmDisk(RecoveryProcessorContext context) {
        RecoveryPlan plan = context.getRecoveryPlan();
        String dcMoId = (String)plan.getGlobalSettings().get("VSDATACENTERID");
        String dataStoreMoId = "";
        String dataStorName = "";
        String rdmDiskFileName = this.diskFileName;
        DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E virtualDiskType = DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.getType((int)this.diskType);
        if (null == virtualDiskType) {
            logger.warn((Object)("diskType is error:" + this.diskType), 90160758786989L);
            return false;
        }
        DataStoreAction dsAction = new DataStoreAction();
        boolean flag = false;
        int loopCount = 3;
        block2: while (!flag && loopCount-- != 0) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e1) {
                logger.error((Object)"Processor of Config rdm disk sleep failed, maybe the  ", 90160758786989L);
            }
            List<VsphereDataStore> dataStores = dsAction.queryAllMountedDataStores(this.vcenterUuid);
            for (VsphereDataStore dataStore : dataStores) {
                if (!this.newDataStoreUrl.equals(dataStore.getUrl())) continue;
                dataStoreMoId = dataStore.getUuid().split(":")[1];
                dataStorName = dataStore.getName();
                flag = true;
                continue block2;
            }
        }
        if (VerifyUtil.isEmpty((String)dataStoreMoId) || VerifyUtil.isEmpty((String)dataStorName)) {
            logger.warn((Object)"Time out! the newDataStore info does not get", 90160758786989L);
            return false;
        }
        rdmDiskFileName = "[" + dataStorName + "]" + rdmDiskFileName.split("]")[1];
        HostSystemAction hostAction = new HostSystemAction();
        String lunPath = hostAction.queryScsiLunByHost(this.vcenterUuid, this.hostMoId, this.lunOrSnapshotWwn);
        logger.info((Object)("config RDM disk:dsMoId=" + dataStoreMoId + " lunPath=" + lunPath + " rdmDiskFileName=" + rdmDiskFileName));
        VMAction vmAction = new VMAction();
        vmAction.reconfigRdmDisk(this.vcenterUuid, dcMoId, dataStoreMoId, lunPath, rdmDiskFileName, virtualDiskType);
        return true;
    }

    private void getNewDatastoreUrl(RecoveryProcessorContext context) {
        List configDatastoreProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsConfigDataStoreSubProcessor.class);
        for (RecoveryProcessor processor : configDatastoreProcessors) {
            VsConfigDataStoreSubProcessor configDsProc = (VsConfigDataStoreSubProcessor)processor;
            if (!this.oldDataStoreUrl.equals(configDsProc.getOldDataStoreUrl())) continue;
            this.setNewDataStoreUrl(configDsProc.getNewDataStoreUrl());
        }
    }

    protected String generateResultKey() {
        return null;
    }
}

