/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.sdk.model.DataStoreInfo;
import com.huawei.ism.drm.vsphere.recovery.process.VsCreateNasDsSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsDelNasDsSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class VsDelNasDsProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -4314261259305087950L;
    private static final Log logger = LogFactory.getInstance(VsDelNasDsProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.createSubProcessor(context);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        ArrayList subProcessors = new ArrayList();
        subProcessors.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessors, (boolean)false);
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void createSubProcessor(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        int procType = this.getProcType();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == procType || DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == procType) {
            this.createSubProcFromPo(pg);
        } else {
            this.createSubProcFromCreate();
        }
    }

    private void createSubProcFromPo(ProtectGroup pg) {
        String tempStr = (String)pg.getProps().get("pg_topo");
        JSONArray jsonArray = JSONArray.fromObject((Object)tempStr);
        JSONObject jsonObj = jsonArray.getJSONObject(0);
        String compResUuid = jsonObj.getString("computResourceUuid");
        String vcenterUuid = pg.getPoProviderSN();
        String dsInfosStr = (String)pg.getProps().get("pgDsInfo");
        JSONArray dsArray = JSONArray.fromObject((Object)dsInfosStr);
        HashSet dataStoreInfoSet = new HashSet(JSONArray.toCollection((JSONArray)dsArray, DataStoreInfo.class));
        HashSet<VsDelNasDsSubProcessor> subProcSet = new HashSet<VsDelNasDsSubProcessor>();
        for (DataStoreInfo dsInfo : dataStoreInfoSet) {
            String dsUuid = dsInfo.getDataStoreUuid();
            String dsName = dsInfo.getDataStoreName();
            VsDelNasDsSubProcessor delSubProc = new VsDelNasDsSubProcessor();
            this.initProc((RecoveryProcessor)delSubProc);
            delSubProc.setVcenterUuid(vcenterUuid);
            delSubProc.setCompResUuid(compResUuid);
            delSubProc.setDsUuid(dsUuid);
            delSubProc.setDsName(dsName);
            subProcSet.add(delSubProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void createSubProcFromCreate() {
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsCreateNasDsSubProcessor.class);
        HashSet<VsDelNasDsSubProcessor> subProcSet = new HashSet<VsDelNasDsSubProcessor>();
        for (RecoveryProcessor tempProc : createProcessors) {
            VsCreateNasDsSubProcessor createSubProc = (VsCreateNasDsSubProcessor)tempProc;
            VsDelNasDsSubProcessor subProc = new VsDelNasDsSubProcessor();
            this.initProc((RecoveryProcessor)subProc);
            subProc.setDsName(createSubProc.getDsName());
            subProc.setVcenterUuid(createSubProc.getVcenterUuid());
            subProc.setCompResUuid(createSubProc.getCompResUuid());
            subProc.setDsUuid(createSubProc.getDsUuid());
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void updateDescription() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsAndLunProcessor.pm.des");
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsAndLunProcessor.sr.des");
        }
    }
}

