/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.process.VsHangupNoncriticalVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsRecoveryNoncriticalVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ClusterAttemptedVmInfo;
import com.huawei.vmware.vim25.ClusterNotAttemptedVmInfo;
import com.huawei.vmware.vim25.ClusterPowerOnVmResult;
import com.huawei.vmware.vim25.ClusterRecommendation;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsRecoveryNoncriticalVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 3414055541253216269L;
    private static final Log logger = LogFactory.getInstance(VsRecoveryNoncriticalVmProcessor.class);
    private String vcenterUuid;

    protected boolean execute(RecoveryProcessorContext context) {
        logger.debug((Object)"Recovery NoncriticalVm Step:Ready to recovery vms.", 90160758786816L);
        this.vcenterUuid = VsphereRecoveryUtils.getInstance().getDisVcenterUuid(context, this.getProcType());
        if (VerifyUtil.isEmpty((String)this.vcenterUuid)) {
            logger.debug((Object)"get vcenter uuid failed: ", 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.createSubProcessors();
        } else {
            this.updateSubProcessors();
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            logger.debug((Object)"No vm need to recovery ", 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.powerOnMultiVms();
        ArrayList list = new ArrayList();
        list.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(list);
        executor.process(context);
        logger.debug((Object)"complete the process of recovery vms.", 90160758786816L);
        this.calcProcessResultBySubProc();
        return true;
    }

    private void createSubProcessors() {
        RecoveryProcessorContext context = this.getContextRef();
        List processors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, VsHangupNoncriticalVmSubProcessor.class);
        HashSet<VsRecoveryNoncriticalVmSubProcessor> subProcSet = new HashSet<VsRecoveryNoncriticalVmSubProcessor>();
        for (RecoveryProcessor proc : processors) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != proc.getProcStatus()) continue;
            VsHangupNoncriticalVmSubProcessor hangupSubProc = (VsHangupNoncriticalVmSubProcessor)proc;
            VsRecoveryNoncriticalVmSubProcessor subProc = new VsRecoveryNoncriticalVmSubProcessor();
            this.initProc((RecoveryProcessor)subProc);
            subProc.setVmUuid(hangupSubProc.getVmUuid());
            subProc.setVmName(hangupSubProc.getVmName());
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).deleteSubRecoveryProcessor(this.getProcId());
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void updateSubProcessors() {
        Set procs = this.getChildProc();
        for (RecoveryProcessor proc : procs) {
            VsRecoveryNoncriticalVmSubProcessor subProc = (VsRecoveryNoncriticalVmSubProcessor)proc;
            subProc.setErrorCode(0L);
            subProc.setTaskId(null);
        }
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    private void powerOnMultiVms() {
        try {
            ArrayList<ManagedObjectReference> vmList = new ArrayList<ManagedObjectReference>();
            HashMap<String, VsRecoveryNoncriticalVmSubProcessor> procMap = new HashMap<String, VsRecoveryNoncriticalVmSubProcessor>();
            this.getInfoFromChildProc(vmList, procMap);
            if (!VerifyUtil.isEmpty(vmList)) {
                logger.info((Object)("power on multi vms:vmList=" + procMap.keySet()));
                VMAction action = new VMAction();
                Map settings = this.getContextRef().getRecoveryPlan().getGlobalSettings();
                String dcMoId = (String)settings.get("VSDATACENTERID");
                ClusterPowerOnVmResult result = action.powerOnMultiVm(this.vcenterUuid, dcMoId, vmList);
                this.updateProcAfterPowerOn(result, procMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)("powerOnMultiVms failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    private void getInfoFromChildProc(List<ManagedObjectReference> vmList, Map<String, VsRecoveryNoncriticalVmSubProcessor> procMap) {
        Set childProcSet = this.getChildProc();
        for (RecoveryProcessor proc : childProcSet) {
            VMAction action;
            VirtualMachinePowerState status;
            VsRecoveryNoncriticalVmSubProcessor subProc = (VsRecoveryNoncriticalVmSubProcessor)proc;
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == subProc.getProcStatus() || null == (status = (action = new VMAction()).getVMPowerState(this.vcenterUuid, subProc.getVmUuid())) || VirtualMachinePowerState.POWERED_OFF != status) continue;
            ManagedObjectReference mor = new ManagedObjectReference();
            mor.setType("VirtualMachine");
            mor.setValue(subProc.getVmUuid().split(":")[1]);
            vmList.add(mor);
            procMap.put(mor.getValue(), subProc);
        }
    }

    private void updateProcAfterPowerOn(ClusterPowerOnVmResult result, Map<String, VsRecoveryNoncriticalVmSubProcessor> procMap) {
        if (VerifyUtil.isEmpty((Object)result) || VerifyUtil.isEmpty(procMap)) {
            logger.error((Object)"result or procMap is empty", 90160758786989L);
            return;
        }
        List attemptedList = result.getAttempted();
        List notAttemptedList = result.getNotAttempted();
        List recommList = result.getRecommendations();
        this.dealAttemptedVms(procMap, attemptedList);
        this.dealNotAttemptedVms(procMap, notAttemptedList);
        this.dealRecommVms(recommList);
    }

    private void dealRecommVms(List<ClusterRecommendation> recommList) {
        if (!VerifyUtil.isEmpty(recommList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm,recommand vms:");
            for (ClusterRecommendation recomm : recommList) {
                buffer.append(" vmMoId=" + recomm.getTarget().getValue());
            }
            logger.error((Object)buffer.toString(), 90160758786989L);
        }
    }

    private void dealNotAttemptedVms(Map<String, VsRecoveryNoncriticalVmSubProcessor> procMap, List<ClusterNotAttemptedVmInfo> notAttemptedList) {
        if (!VerifyUtil.isEmpty(notAttemptedList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm, not attempted vms:");
            for (ClusterNotAttemptedVmInfo info : notAttemptedList) {
                ManagedObjectReference vm = info.getVm();
                VsRecoveryNoncriticalVmSubProcessor proc = procMap.get(vm.getValue());
                if (null == proc) continue;
                proc.setErrorCode(1073948880L);
                buffer.append(" vmMoId=" + vm.getValue());
                buffer.append(" fault msg:" + info.getFault().getLocalizedMessage());
            }
            logger.info((Object)buffer.toString(), 90160758786988L);
        }
    }

    private void dealAttemptedVms(Map<String, VsRecoveryNoncriticalVmSubProcessor> procMap, List<ClusterAttemptedVmInfo> attemptedList) {
        if (!VerifyUtil.isEmpty(attemptedList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm,attempted vms:");
            for (ClusterAttemptedVmInfo info : attemptedList) {
                ManagedObjectReference vm = info.getVm();
                VsRecoveryNoncriticalVmSubProcessor proc = procMap.get(vm.getValue());
                if (null == proc) continue;
                proc.setTaskId(info.getTask().getValue());
                buffer.append(" moId=" + vm.getValue());
            }
            logger.info((Object)buffer.toString(), 90160758786988L);
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsRecoveryNoncriticalVmProcessor.des");
    }
}

