/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMGuestAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.action.util.VsphereTaskResultMonitor;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsInitVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VCenterNicIpInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.MethodFault;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VsStartVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 882307003604536807L;
    private static final Log logger = LogFactory.getInstance(VsStartVmSubProcessor.class);
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.";
    private static final String START_TIMEOUT = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.starttimeout";
    private static final String STOP_TIMEOUT = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.stoptimeout";
    private static final String STARTED_YET = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.havestarted";
    private static final String CONFIGIP_CONFIG_ERROR = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.configiperror";
    private String vmName = "";
    private String vcenterUuid = "";
    private String vmMoId = "";
    private String vmxPath;
    private String poId;
    private int preResult;
    private String taskId = "";
    private long errorCode = 0L;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != this.preResult) {
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmSubProcessor.failed", new String[]{this.vmName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.setPoRecoveryStatus();
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail(STARTED_YET, new String[0]);
            logger.debug((Object)("vm has already started" + this.vmName), 90160758786988L);
            this.setPoRecoveryStatus();
            return true;
        }
        if (0L != this.errorCode) {
            this.updateProcessDetail("lego.err." + this.errorCode, null);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.setPoRecoveryStatus();
            return false;
        }
        if (!VerifyUtil.isEmpty((String)this.taskId) && !this.monitorTask()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.setPoRecoveryStatus();
            return false;
        }
        boolean ret = this.waitForVmStarted();
        if (!ret) {
            logger.error((Object)("start VM failed " + this.vmName), 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.setPoRecoveryStatus();
            return false;
        }
        this.configIpForWindowsVm();
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        this.setPoRecoveryStatus();
        return true;
    }

    private void configIpForWindowsVm() {
        boolean ret;
        boolean result;
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsCfgVmSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)processors)) {
            return;
        }
        VsCfgVmSubProcessor cfgProcessor = null;
        for (RecoveryProcessor proc : processors) {
            VsCfgVmSubProcessor processor = (VsCfgVmSubProcessor)proc;
            if (!processor.getPoId().equals(this.poId)) continue;
            cfgProcessor = processor;
            cfgProcessor.setVmMoId(this.vmMoId);
            break;
        }
        if (null == cfgProcessor || !"windowsGuest".equals(cfgProcessor.getGuestOsType())) {
            this.optNetAutoConn(true);
            this.restartVM();
            logger.debug((Object)("vm type is not windows, don't need config ip " + this.vmName), 90160758786988L);
            return;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == cfgProcessor.getProcStatus()) {
            logger.error((Object)("config VM network failed " + this.vmName), 90160758786989L);
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.failed", new String[0]);
            return;
        }
        VMGuestAction action = new VMGuestAction();
        Map<String, VCenterNicIpInfo> adaptersMap = cfgProcessor.getConfigParamMap(this.getMacAndNetworkNameMap(cfgProcessor.getVmNetCardsInfo()), this.getContextRef().getRecoveryPlan());
        try {
            JSONObject authJson = VsphereRecoveryUtils.getInstance().getWindowsVmAuthJson(this.poId, this.getContextRef().getRecoveryPlan());
            if (!authJson.isEmpty() && authJson.containsKey((Object)"username") && authJson.containsKey((Object)"password")) {
                String username = authJson.getString("username");
                String password = authJson.getString("password");
                result = action.configWindowsVMIp(cfgProcessor.getVcenterUuid(), this.vmMoId, username, WccEncryptor.decrypt((String)password), adaptersMap);
            } else {
                logger.info((Object)("vm auth info is empty,no need to config ip: " + this.vmName), 90160758786988L);
                result = true;
            }
            this.optNetAutoConn(true);
            ret = this.restartVM();
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
            result = false;
            ret = false;
        }
        if (!result || !ret) {
            this.updateProcessDetail(CONFIGIP_CONFIG_ERROR, new String[]{this.vmName});
            logger.error((Object)("config ip failed " + this.vmName), 90160758786989L);
        } else {
            logger.debug((Object)("config ip success " + this.vmName), 90160758786988L);
        }
    }

    private boolean optNetAutoConn(boolean isAuto) {
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsInitVmSubProcessor.class);
        return VsphereRecoveryUtils.optNetAutoConn(processors, this.getContextRef(), this.getProcType(), this.vcenterUuid, isAuto);
    }

    private boolean restartVM() {
        boolean ret = false;
        VMAction action = new VMAction();
        try {
            action.shutdownGuest(this.vcenterUuid, this.vmMoId);
            for (int i = 0; i < 50; ++i) {
                VirtualMachinePowerState status = action.getVMPowerState(this.vcenterUuid, this.vmMoId);
                if (null != status && VirtualMachinePowerState.POWERED_OFF == status) {
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
            if (!ret) {
                this.updateProcessDetail(STOP_TIMEOUT, new String[0]);
            }
            action.powerOnVM(this.vcenterUuid, this.vmMoId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("restart vm start failed " + this.vmName), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            ret = false;
        }
        catch (Exception e) {
            logger.error((Object)("restart vm start failed " + this.vmName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return ret;
    }

    private Map<String, String> getMacAndNetworkNameMap(String vmNetCardsInfo) {
        HashMap<String, String> macMap = new HashMap<String, String>();
        JSONArray vmNetCfgJsonArr = JSONArray.fromObject((Object)vmNetCardsInfo);
        for (int i = 0; i < vmNetCfgJsonArr.size(); ++i) {
            JSONObject vmNetCfgJson = vmNetCfgJsonArr.getJSONObject(i);
            String vmMac = vmNetCfgJson.getString("macAddress");
            String vmNetName = vmNetCfgJson.getString("ethernetCardName");
            macMap.put(vmMac, vmNetName);
        }
        return macMap;
    }

    private boolean monitorTask() {
        ManagedObjectReference task = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.taskId, "Task");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(this.vcenterUuid);
        MethodFault fault = new VsphereTaskResultMonitor(conn, task).monitorTaskResultAfterDone();
        if (!VerifyUtil.isEmpty((Object)fault)) {
            VMAction action = new VMAction();
            LegoCheckedException legoExc = action.getPowerOnLegoException(fault);
            this.updateProcessDetail(legoExc);
            return false;
        }
        return true;
    }

    private boolean waitForVmStarted() {
        boolean ret = false;
        VMAction action = new VMAction();
        try {
            for (int i = 0; i < 50; ++i) {
                VirtualMachineToolsRunningStatus state = action.getGuestVMToolState(this.vcenterUuid, this.vmMoId);
                if (VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING == state) {
                    logger.debug((Object)("start VM " + this.vmName + " sucessfully"), 90160758786988L);
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
            if (!ret) {
                this.updateProcessDetail(START_TIMEOUT, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("start vm start failed " + this.vmName), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            ret = false;
        }
        catch (Exception e) {
            logger.error((Object)("start vm start failed " + this.vmName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return ret;
    }

    private void setPoRecoveryStatus() {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
            return;
        }
        String key = RecoveryProcessResult.getPoRecoveryStatusKey((int)this.getProcType(), (String)this.poId, (int)DrmEnumDefine.AppType.VM.getValue());
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.getContextRef().getProcessResult().addProcessResult(key, true);
        } else {
            this.getContextRef().getProcessResult().addProcessResult(key, false);
        }
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName() + ".R5";
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName() + this.vmMoId;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public String getVmMoId() {
        return this.vmMoId;
    }

    public void setVmMoId(String vmMoId) {
        this.vmMoId = vmMoId;
    }

    public int getPreResult() {
        return this.preResult;
    }

    public void setPreResult(int preResult) {
        this.preResult = preResult;
    }

    public String getVmxPath() {
        return this.vmxPath;
    }

    public void setVmxPath(String vmxPath) {
        this.vmxPath = vmxPath;
    }

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }
}

