/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.vsphere.recovery.process.VsStartVmsWithPriProcessor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VsStartVmsProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 476629710793254875L;
    private static final int DEFAULT_START_PRI = 10;
    private final Log logger = LogFactory.getInstance(VsStartVmsProcessor.class);
    private String vcenterUuid;

    protected boolean execute(RecoveryProcessorContext context) {
        boolean createRet;
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(createRet = this.createSubProcessors())) {
            this.logger.info((Object)"subprocessors is empty.all vms need not be started", 90160758786988L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            throw new LegoCheckedException(1073947394L);
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private boolean createSubProcessors() {
        HashSet<VsStartVmsWithPriProcessor> subProcSet = new HashSet<VsStartVmsWithPriProcessor>();
        Map<Integer, Set<String>> posWithPriority = this.getPosByPriority(this.getContextRef());
        if (VerifyUtil.isEmpty(posWithPriority)) {
            this.logger.info((Object)"All vms should not be started");
            return false;
        }
        ArrayList<Integer> priorityLevel = new ArrayList<Integer>();
        priorityLevel.addAll(posWithPriority.keySet());
        Collections.sort(priorityLevel, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        VsStartVmsWithPriProcessor preProc = null;
        for (int i = 0; i < priorityLevel.size(); ++i) {
            Integer startPriority = (Integer)priorityLevel.get(i);
            VsStartVmsWithPriProcessor startVmsWithPriProc = new VsStartVmsWithPriProcessor();
            this.initProc((RecoveryProcessor)startVmsWithPriProc);
            startVmsWithPriProc.setVcenterUuid(this.vcenterUuid);
            startVmsWithPriProc.setPriorityNum(startPriority);
            startVmsWithPriProc.setPoIdSet(posWithPriority.get(startPriority));
            startVmsWithPriProc.setPreviousProcessor((RecoveryProcessor)preProc);
            startVmsWithPriProc.setNextProcessor(null);
            if (null != preProc) {
                preProc.setNextProcessor((RecoveryProcessor)startVmsWithPriProc);
            }
            preProc = startVmsWithPriProc;
            subProcSet.add(startVmsWithPriProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return true;
    }

    private Map<Integer, Set<String>> getPosByPriority(RecoveryProcessorContext context) {
        ProtectGroup pg = RecoveryToolsUtil.getInstance().getHistoryProtectGroupFromContext(this.getContextRef());
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        HashMap<Integer, Set<String>> posWithPriority = new HashMap<Integer, Set<String>>();
        for (ProtectObject po : pg.getPolist()) {
            if (this.isTemplateVm(po) || ProtectObjectStatusEnum.INVALID.getValue() == po.getPoStatus() || ProtectObjectStatusEnum.UNSUPPORTED.getValue() == po.getPoStatus()) continue;
            String poId = po.getUuid();
            if (!VsphereRecoveryUtils.getInstance().isPoNeedStart(poId, context.getRecoveryPlan()).booleanValue()) {
                this.logger.info((Object)("The vm has been configured not start:vmName=" + po.getName()), 90160758786988L);
                continue;
            }
            Integer priValue = this.getStartPrimary(recoverySettings, poId);
            if (posWithPriority.containsKey(priValue)) {
                ((Set)posWithPriority.get(priValue)).add(poId);
                continue;
            }
            HashSet<String> processList = new HashSet<String>();
            processList.add(poId);
            posWithPriority.put(priValue, processList);
        }
        return posWithPriority;
    }

    private boolean isTemplateVm(ProtectObject po) {
        if (null == po || null == po.getProps().get("ISTEMPLATE")) {
            return Boolean.FALSE;
        }
        return Boolean.parseBoolean((String)po.getProps().get("ISTEMPLATE"));
    }

    private int getStartPrimary(Set<RecoverySetting> recoverySettings, String poId) {
        int priValue = 10;
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getOwnerId().equals(poId) || !setting.getName().equals("startOrder")) continue;
            try {
                priValue = Integer.parseInt(setting.getValue());
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)("parseInt error : " + setting.getValue() + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            }
            break;
        }
        return priValue;
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

