/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsInitVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereComputeResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ClusterAttemptedVmInfo;
import com.huawei.vmware.vim25.ClusterNotAttemptedVmInfo;
import com.huawei.vmware.vim25.ClusterPowerOnVmResult;
import com.huawei.vmware.vim25.ClusterRecommendation;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsStartVmsWithPriProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7335232136240603209L;
    private static final Log logger = LogFactory.getInstance(VsStartVmsWithPriProcessor.class);
    private String vcenterUuid;
    private int priorityNum;
    private String poIdsStr;
    private Set<String> poIdSet;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.priorityNum + ""});
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.createSubProcessors();
        } else {
            this.updateSubProcessors();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.optNetAutoConn(false);
        this.powerOnMultiVms();
        return this.calcProcessResultBySubProc();
    }

    private void createSubProcessors() {
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsCfgResForVmSubProcessor.class);
        HashSet<VsStartVmSubProcessor> subProcSet = new HashSet<VsStartVmSubProcessor>();
        for (RecoveryProcessor proc : processors) {
            VsCfgResForVmSubProcessor resSubProc = (VsCfgResForVmSubProcessor)proc;
            if (!this.poIdSet.contains(resSubProc.getPoId())) continue;
            VsStartVmSubProcessor startSubProcessor = new VsStartVmSubProcessor();
            this.initProc((RecoveryProcessor)startSubProcessor);
            startSubProcessor.setVcenterUuid(this.vcenterUuid);
            startSubProcessor.setVmName(resSubProc.getVmName());
            startSubProcessor.setPreResult(resSubProc.getProcStatus());
            startSubProcessor.setVmMoId(resSubProc.getVmMoId());
            startSubProcessor.setVmxPath(resSubProc.getVmxPath());
            startSubProcessor.setPoId(resSubProc.getPoId());
            subProcSet.add(startSubProcessor);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void updateSubProcessors() {
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsCfgResForVmSubProcessor.class);
        Set childProcSet = this.getChildProc();
        block0: for (RecoveryProcessor childProc : childProcSet) {
            VsStartVmSubProcessor startSubProc = (VsStartVmSubProcessor)childProc;
            String childProcVmxPath = startSubProc.getVmxPath();
            for (RecoveryProcessor tempProc : processors) {
                VsCfgResForVmSubProcessor resSubProc = (VsCfgResForVmSubProcessor)tempProc;
                String vmxPath = resSubProc.getVmxPath();
                if (!vmxPath.equals(childProcVmxPath)) continue;
                startSubProc.setPreResult(resSubProc.getProcStatus());
                startSubProc.setVmMoId(resSubProc.getVmMoId());
                continue block0;
            }
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private boolean optNetAutoConn(boolean isAuto) {
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsInitVmSubProcessor.class);
        return VsphereRecoveryUtils.optNetAutoConn(processors, this.getContextRef(), this.getProcType(), this.vcenterUuid, isAuto);
    }

    private void powerOnMultiVms() {
        HashMap<String, VsStartVmSubProcessor> vmIdProcMap = new HashMap<String, VsStartVmSubProcessor>();
        HashMap<Integer, List<ManagedObjectReference>> vmMap = new HashMap<Integer, List<ManagedObjectReference>>();
        this.getInfoFromChildProc(vmMap, vmIdProcMap);
        VMAction action = new VMAction();
        Map settings = this.getContextRef().getRecoveryPlan().getGlobalSettings();
        String dcMoId = (String)settings.get("VSDATACENTERID");
        for (Map.Entry entry : vmMap.entrySet()) {
            List<VsStartVmSubProcessor> procGroup = this.getProcGroup((List)entry.getValue(), vmIdProcMap);
            if (VerifyUtil.isEmpty(procGroup)) {
                logger.info((Object)"procGroup is empty");
                continue;
            }
            if ((Integer)entry.getKey() != Integer.MAX_VALUE) {
                try {
                    logger.info((Object)("will power on vms:moIds=" + entry.getValue()));
                    ClusterPowerOnVmResult result = action.powerOnMultiVm(this.vcenterUuid, dcMoId, (List)entry.getValue());
                    this.updateProcAfterPowerOn(result, vmIdProcMap);
                }
                catch (Exception e) {
                    logger.error((Object)("powerOnMultiVms failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                    this.updateProcAfterFailed(procGroup);
                }
            }
            RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(procGroup, (boolean)false);
            recoveryTemplate.process(this.getContextRef());
        }
    }

    private List<VsStartVmSubProcessor> getProcGroup(List<ManagedObjectReference> morList, Map<String, VsStartVmSubProcessor> procMap) {
        ArrayList<VsStartVmSubProcessor> procGroup = new ArrayList<VsStartVmSubProcessor>();
        for (ManagedObjectReference mor : morList) {
            String id = mor.getValue();
            procGroup.add(procMap.get(id));
        }
        return procGroup;
    }

    private void updateProcAfterFailed(List<VsStartVmSubProcessor> procGroup) {
        for (VsStartVmSubProcessor proc : procGroup) {
            proc.setErrorCode(1073948883L);
        }
    }

    private void getInfoFromChildProc(Map<Integer, List<ManagedObjectReference>> vmMap, Map<String, VsStartVmSubProcessor> vmIdProcMap) {
        boolean isCluster = this.isClusterTgtCompRes();
        int batchStartNum = VsphereRecoveryUtils.getInstance().getBatchStartCeiling(isCluster);
        int counter = 0;
        Integer batchNo = 0;
        ArrayList<ManagedObjectReference> notPowerOnVmList = new ArrayList<ManagedObjectReference>();
        vmMap.put(Integer.MAX_VALUE, notPowerOnVmList);
        Set childProcSet = this.getChildProc();
        for (RecoveryProcessor proc : childProcSet) {
            List<Object> vmList;
            VsStartVmSubProcessor startVmSubProc = (VsStartVmSubProcessor)proc;
            ManagedObjectReference mor = new ManagedObjectReference();
            mor.setType("VirtualMachine");
            mor.setValue(VerifyUtil.isEmpty((String)startVmSubProc.getVmMoId()) ? startVmSubProc.getPoId() : startVmSubProc.getVmMoId());
            vmIdProcMap.put(mor.getValue(), startVmSubProc);
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != startVmSubProc.getPreResult() || DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == startVmSubProc.getProcStatus()) {
                logger.info((Object)("The vm " + startVmSubProc.getVmName() + " wont be power on"));
                notPowerOnVmList.add(mor);
                continue;
            }
            VMAction action = new VMAction();
            VirtualMachinePowerState status = action.getVMPowerState(this.vcenterUuid, startVmSubProc.getVmMoId());
            boolean isVmtoolInstalled = action.isVmToolInstalled(this.vcenterUuid, startVmSubProc.getVmMoId());
            if (null == status || VirtualMachinePowerState.POWERED_OFF != status || !isVmtoolInstalled) {
                logger.info((Object)("The vm " + startVmSubProc.getVmName() + " wont be power on"));
                notPowerOnVmList.add(mor);
                continue;
            }
            if (counter % batchStartNum == 0) {
                vmList = new ArrayList();
                Integer n = batchNo;
                Integer n2 = batchNo = Integer.valueOf(batchNo + 1);
                vmMap.put(batchNo, vmList);
            }
            vmList = vmMap.get(batchNo);
            vmList.add(mor);
            ++counter;
        }
    }

    private void updateProcAfterPowerOn(ClusterPowerOnVmResult result, Map<String, VsStartVmSubProcessor> procMap) {
        if (VerifyUtil.isEmpty((Object)result) || VerifyUtil.isEmpty(procMap)) {
            logger.error((Object)"result or procMap is empty", 90160758786989L);
            return;
        }
        List attemptedList = result.getAttempted();
        List notAttemptedList = result.getNotAttempted();
        List recommList = result.getRecommendations();
        this.dealAttemptedVms(procMap, attemptedList);
        this.dealNotAttemptedVms(procMap, notAttemptedList);
        this.dealRecommVms(recommList);
    }

    private void dealRecommVms(List<ClusterRecommendation> recommList) {
        if (!VerifyUtil.isEmpty(recommList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm,recommand vms:");
            for (ClusterRecommendation recomm : recommList) {
                buffer.append(" vmMoId=" + recomm.getTarget().getValue());
            }
            logger.error((Object)buffer.toString(), 90160758786989L);
        }
    }

    private void dealNotAttemptedVms(Map<String, VsStartVmSubProcessor> procMap, List<ClusterNotAttemptedVmInfo> notAttemptedList) {
        if (!VerifyUtil.isEmpty(notAttemptedList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm, not attempted vms:");
            for (ClusterNotAttemptedVmInfo info : notAttemptedList) {
                ManagedObjectReference vm = info.getVm();
                VsStartVmSubProcessor proc = procMap.get(vm.getValue());
                if (null == proc) continue;
                proc.setErrorCode(1073948880L);
                buffer.append(" vmMoId=" + vm.getValue());
                buffer.append(" fault msg:" + info.getFault().getLocalizedMessage());
            }
            logger.info((Object)buffer.toString(), 90160758786988L);
        }
    }

    private void dealAttemptedVms(Map<String, VsStartVmSubProcessor> procMap, List<ClusterAttemptedVmInfo> attemptedList) {
        if (!VerifyUtil.isEmpty(attemptedList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm,attempted vms:");
            for (ClusterAttemptedVmInfo info : attemptedList) {
                ManagedObjectReference vm = info.getVm();
                VsStartVmSubProcessor proc = procMap.get(vm.getValue());
                if (null == proc) continue;
                proc.setTaskId(info.getTask().getValue());
                buffer.append(" moId=" + vm.getValue());
            }
            logger.info((Object)buffer.toString(), 90160758786988L);
        }
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    private boolean isClusterTgtCompRes() {
        int planType = this.getProcType();
        boolean ret = false;
        if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
            VirtualizationCommonUtil util = VirtualizationCommonUtil.getInstance();
            ProtectGroup pg = (ProtectGroup)util.getElementFromCollection((Collection)this.getContextRef().getRecoveryPlan().getProtectGroups());
            String tempStr = (String)pg.getProps().get("pg_topo");
            JSONArray jsonArray = JSONArray.fromObject((Object)tempStr);
            JSONObject jsonObj = JSONObject.fromObject((Object)jsonArray.get(0));
            String compResUuid = jsonObj.getString("computResourceUuid");
            VsphereComputeResource compRes = (VsphereComputeResource)CommonDAOLocator.getMoDao().getMo(VsphereComputeResource.class, "uuid", (Object)compResUuid);
            if (null != compRes) {
                ret = compRes.getIsCluster();
            }
            return ret;
        }
        String key = "testHosts";
        if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
            key = "testHosts";
        } else if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            key = "recoveryHosts";
        }
        Map settings = this.getContextRef().getRecoveryPlan().getGlobalSettings();
        String setting = (String)settings.get(key);
        if (VerifyUtil.isEmpty((String)setting)) {
            return false;
        }
        JSONObject json = JSONObject.fromObject((Object)JSONArray.fromObject((Object)setting).get(0));
        String compResUuid = json.getString("remoteHostId");
        VsphereComputeResource compRes = (VsphereComputeResource)CommonDAOLocator.getMoDao().getMo(VsphereComputeResource.class, "uuid", (Object)compResUuid);
        if (null != compRes) {
            ret = compRes.getIsCluster();
        }
        return ret;
    }

    public int getPriorityNum() {
        return this.priorityNum;
    }

    public void setPriorityNum(int priorityNum) {
        this.priorityNum = priorityNum;
    }

    public Set<String> getPoIdSet() {
        return this.poIdSet;
    }

    public void setPoIdSet(Set<String> poIdSet) {
        this.poIdSet = poIdSet;
    }

    public String getPoIdsStr() {
        if (null == this.poIdSet || this.poIdSet.isEmpty()) {
            return this.poIdsStr;
        }
        StringBuffer buffer = new StringBuffer();
        for (String poId : this.poIdSet) {
            buffer.append(poId);
            buffer.append(':');
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public void setPoIdsStr(String poIdsStr) {
        this.poIdsStr = poIdsStr;
        if (!VerifyUtil.isEmpty((String)poIdsStr)) {
            String[] poIdArr = poIdsStr.split(":");
            if (null == this.poIdSet) {
                this.poIdSet = new HashSet<String>();
            }
            for (String poId : poIdArr) {
                this.poIdSet.add(poId);
            }
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

