/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.provider;

import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.provider.BaseRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.sdk.model.NFSShare;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.adapter.action.DataCenterAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.VsphereReplicaChecker;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsCreateNasDsProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsDelNasDsProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsRescanHBAProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsAndLunProcessor;
import com.huawei.ism.drm.vsphere.recovery.task.AttachScsiLunTask;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigDatastoreTask;
import com.huawei.ism.drm.vsphere.recovery.task.DetachScsiLunTask;
import com.huawei.ism.drm.vsphere.recovery.task.RescanHbaTask;
import com.huawei.ism.drm.vsphere.recovery.task.RescanVmfsTask;
import com.huawei.ism.drm.vsphere.recovery.task.UmountDatastoreTask;
import com.huawei.ism.drm.vsphere.recovery.task.VmRecoveryCallbackTask;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.DrVsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsDataCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsVirtualEthernetCard;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;

public class VsphereVMRecoveryProcessProvider
extends BaseRecoveryProcessProvider {
    private static Log logger = LogFactory.getInstance(VsphereVMRecoveryProcessProvider.class);
    private static final String MOUNT_SETTINGS = "mountSettings";

    public List<String> getAppType() {
        logger.debug((Object)"getAppType start");
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add(DrmEnumDefine.AppType.VM.name());
        return appTypes;
    }

    public void resetRecoveryProcessDefinition(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, boolean isNeedSaveToDb) {
        logger.debug((Object)"resetRecoveryProcessDefinition start");
        if (null == recoveryPlan || null == recoveryPlan.getProtectGroups() || recoveryPlan.getProtectGroups().isEmpty()) {
            return;
        }
        ArrayList<Class<VsDelNasDsProcessor>> removeProcClsList = new ArrayList<Class<VsDelNasDsProcessor>>();
        boolean useNas = RecoveryProcessUtil.isProtectGroupUseNasFileSystem((ProtectGroup)((ProtectGroup)recoveryPlan.getProtectGroups().iterator().next()));
        if (useNas) {
            removeProcClsList.add(VsUnmountDsAndLunProcessor.class);
            removeProcClsList.add(VsConfigDataStoreProcessor.class);
            removeProcClsList.add(VsRescanHBAProcessor.class);
            removeProcClsList.add(ConfigDatastoreTask.class);
            removeProcClsList.add(UmountDatastoreTask.class);
            removeProcClsList.add(DetachScsiLunTask.class);
            removeProcClsList.add(RescanVmfsTask.class);
            removeProcClsList.add(RescanHbaTask.class);
            removeProcClsList.add(AttachScsiLunTask.class);
        } else {
            removeProcClsList.add(VsCreateNasDsProcessor.class);
            removeProcClsList.add(VsDelNasDsProcessor.class);
        }
        this.deleteRecoveryProcessors(rpDefinition, removeProcClsList, isNeedSaveToDb);
    }

    public Map<String, Object> checkRecoveryContext(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, User operator) {
        logger.debug((Object)("checkRecoveryContext start:planId=" + planId));
        if (null == recoveryContext || null == procType || null == planId) {
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        this.checkMacConflict(recoveryPlan, recoveryContext, procType);
        if (procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING) || procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION) || procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY) || procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA)) {
            return this.checkTestAndMotionContext(procType, recoveryContext, operator, recoveryPlan);
        }
        if (procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK)) {
            return this.checkSnapshotRollBackRecoveryContext(recoveryPlan, recoveryContext);
        }
        if (procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK)) {
            return this.checkVmRollBackRecoveryContext(recoveryPlan, recoveryContext);
        }
        return this.checkBaseRecoveryContext(recoveryPlan, procType, recoveryContext, operator);
    }

    private Map<String, Object> checkTestAndMotionContext(DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, User operator, RecoveryPlan recoveryPlan) {
        logger.debug((Object)"checkTestAndMotionContext start");
        String netWorkKey = "testNetwork";
        String disasterHostKey = "testHosts";
        String vCenterUuid = "";
        if (procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION) || procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY)) {
            netWorkKey = "recoveryNetwork";
            disasterHostKey = "recoveryHosts";
        }
        JSONArray disasterHostInfo = this.getRecoverySettingsByKey(recoveryContext, disasterHostKey);
        vCenterUuid = procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA) ? this.checkMountReplicaDisasterHostInfo(disasterHostInfo) : this.checkDisasterHostInfo(disasterHostInfo);
        DrVsphereCenter drResource = (DrVsphereCenter)((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(vCenterUuid, "ism.drm.deviceType.drvsphere.mainType");
        if (null == drResource) {
            throw new LegoCheckedException(1073947393L);
        }
        recoveryContext.put("disasterHostSn", drResource.getDeviceSn());
        Map<String, Object> result = this.checkBaseRecoveryContext(recoveryPlan, procType, recoveryContext, operator);
        result.put(disasterHostKey, disasterHostInfo);
        this.checkHostPowerState(disasterHostInfo);
        JSONArray netSettings = this.getRecoverySettingsByKey(recoveryContext, netWorkKey);
        this.checkNetSettings(netSettings);
        result.put(netWorkKey, netSettings);
        this.setNasInfo(recoveryContext, recoveryPlan, result);
        VsDataCenter dataCenter = this.getDataCenterByNetSetting(drResource, netSettings, "remoteNetworkId");
        if (dataCenter == null) {
            throw new LegoCheckedException(1073947393L, "datacenter not found.");
        }
        result.put("VSDATACENTERID", dataCenter.getMoId());
        result.put("VSDATACENTERNAME", dataCenter.getName());
        result.put("keepMac", recoveryContext.get("keepMac"));
        return result;
    }

    private void setNasInfo(Map<String, String> recoveryContext, RecoveryPlan recoveryPlan, Map<String, Object> result) {
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() != recoveryPlan.getPlanType()) {
            result.put("NoncritialVM", recoveryContext.get("NoncritialVM"));
            boolean useNas = RecoveryProcessUtil.isProtectGroupUseNasFileSystem((ProtectGroup)((ProtectGroup)recoveryPlan.getProtectGroups().iterator().next()));
            if (useNas) {
                if (!recoveryPlan.getProtectGroups().iterator().hasNext()) {
                    throw new LegoCheckedException(1073947393L);
                }
                ProtectGroup protectGroup = (ProtectGroup)recoveryPlan.getProtectGroups().iterator().next();
                this.checkShareExists(protectGroup);
                String shareIp = recoveryContext.get("nasSharePortIp");
                this.checkNasShareIp(shareIp);
                result.put("nasSharePortIp", shareIp);
            }
        }
    }

    private void checkMacConflict(RecoveryPlan recoveryPlan, Map<String, String> recoveryContext, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            logger.error((Object)"Plan is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(recoveryContext)) {
            return;
        }
        String isKeepMac = recoveryContext.get("keepMac");
        if (!(VerifyUtil.isEmpty((String)isKeepMac) || isKeepMac.equals(Boolean.TRUE.toString()) || isKeepMac.equals(Boolean.FALSE.toString()))) {
            logger.error((Object)"KeepMac is not boolean value:%s", new Object[]{isKeepMac});
            throw new LegoCheckedException(1073947393L);
        }
        if (Boolean.parseBoolean(isKeepMac)) {
            Set<String> macSet = this.isReplia(recoveryContext) ? this.getMacSet(recoveryContext, recoveryPlan) : this.getMacSet(recoveryPlan);
            String vCenterUuid = this.getRemoteSiteInfo(recoveryContext, procType, "remoteVcenterId");
            VMAction vmAction = new VMAction();
            VmwareConnection vmwareConnection = VmwareConnectionManager.getInstance().getVmwareConnection(vCenterUuid);
            List<VsphereVirtualMachine> vmFromVmware = vmAction.queryAllVms(vmwareConnection);
            Set<String> vmNameSet = this.getConflictVmNames(macSet, vmFromVmware);
            if (!vmNameSet.isEmpty()) {
                String vCenterName = this.getRemoteSiteInfo(recoveryContext, procType, "remoteVcenterName");
                String errorStr = String.join((CharSequence)",", vmNameSet);
                logger.error((Object)"MacAddress conflict, vm name list:%s", new Object[]{errorStr});
                throw new LegoCheckedException(1677929497L, new String[]{vCenterName, errorStr});
            }
        }
    }

    private Set<String> getConflictVmNames(Set<String> macSet, List<VsphereVirtualMachine> vmFromVmware) {
        HashSet<String> vmNameSet = new HashSet<String>();
        for (VsphereVirtualMachine vsphereVirtualMachine : vmFromVmware) {
            Set macAddressSet = vsphereVirtualMachine.getMacAddressSetFromVmConfig();
            if (VerifyUtil.isEmpty((Collection)macAddressSet)) continue;
            macAddressSet.forEach(macAddress -> {
                if (macSet.contains(macAddress)) {
                    vmNameSet.add(vsphereVirtualMachine.getName());
                }
            });
        }
        return vmNameSet;
    }

    private Set<String> getMacSet(RecoveryPlan recoveryPlan) {
        HashSet<String> macSet = new HashSet<String>();
        Set polist = recoveryPlan.getProtectGroup().getPolist();
        for (ProtectObject protectObject : polist) {
            VsphereVirtualMachine virtualMachine = VsphereVirtualMachineUtils.convertFrom(protectObject);
            Collection virtualEthernetCardList = virtualMachine.getVirtualEthernetCardList();
            for (VsVirtualEthernetCard vsVirtualEthernetCard : virtualEthernetCardList) {
                macSet.add(vsVirtualEthernetCard.getMacAddress());
            }
        }
        return macSet;
    }

    private Set<String> getMacSet(Map<String, String> recoveryContext, RecoveryPlan recoveryPlan) {
        String replicaId = recoveryContext.get("REPLICA_ID");
        HashSet<String> macSet = new HashSet<String>();
        if (VerifyUtil.isEmpty((String)replicaId)) {
            logger.error((Object)"ReplicaId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        this.getMacAddressByReplica(replica, macSet);
        Set<String> lastMountReplicaMacAddress = this.getLastMountReplicaMacAddress(recoveryContext, recoveryPlan);
        macSet.removeAll(lastMountReplicaMacAddress);
        return macSet;
    }

    private Set<String> getLastMountReplicaMacAddress(Map<String, String> recoveryContext, RecoveryPlan recoveryPlan) {
        String remoteHostId = this.getRemoteSiteInfo(recoveryContext, DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA, "remoteHostId");
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        Set replicaList = protectGroup.getReplicaList();
        HashSet<String> macSet = new HashSet<String>();
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        for (ProtectGroupReplica replica : replicaList) {
            if (!Integer.valueOf(ReplicaMountStatus.MOUNTED.getStatus()).equals(replica.getMountStatus()) || !replica.getMountedHost().equals(remoteHostId)) continue;
            this.getMacAddressByReplica(replica, macSet);
        }
        return macSet;
    }

    private void getMacAddressByReplica(ProtectGroupReplica replica, Set<String> macSet) {
        for (ProtectObjectReplica replicaReplica : replica.getReplicas()) {
            VsphereVirtualMachine virtualMachine = VsphereVirtualMachineUtils.convertFrom(replicaReplica.getProtectObject());
            Collection virtualEthernetCardList = virtualMachine.getVirtualEthernetCardList();
            for (VsVirtualEthernetCard vsVirtualEthernetCard : virtualEthernetCardList) {
                macSet.add(vsVirtualEthernetCard.getMacAddress());
            }
        }
    }

    private boolean isReplia(Map<String, String> recoveryContext) {
        if (VerifyUtil.isEmpty((String)recoveryContext.get("REPLICA_ID"))) {
            logger.info((Object)"Type is not replica.");
            return false;
        }
        return true;
    }

    private String getRemoteSiteInfo(Map<String, String> recoveryContext, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String key) {
        String info;
        block1: {
            Iterator it;
            if (recoveryContext == null || procType == null) {
                throw new LegoCheckedException(1073947393L);
            }
            String jsonKey = procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING || procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA ? "testHosts" : "recoveryHosts";
            JSONArray jsonArray = JSONArray.fromObject((Object)recoveryContext.get(jsonKey));
            info = null;
            if (jsonArray == null || jsonArray.size() <= 0 || !(it = jsonArray.iterator()).hasNext()) break block1;
            JSONObject jsonObject = JSONObject.fromObject(it.next());
            info = jsonObject.getString(key);
            logger.info((Object)"Get remote site info %s:%s", new Object[]{key, info});
        }
        return info;
    }

    private Map<String, Object> checkBaseRecoveryContext(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, User operator) {
        logger.debug((Object)"checkBaseRecoveryContext start");
        if (null == recoveryPlan || null == procType || VerifyUtil.isEmpty(recoveryContext) || null == recoveryContext.get("disasterHostSn")) {
            throw new LegoCheckedException(1073947393L);
        }
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource resource = resourceService.getDrResourceBySn(recoveryContext.get("disasterHostSn"));
        if (VerifyUtil.isEmpty((Object)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        IBizScopeManager scopeManager = (IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class);
        scopeManager.checkUserGrantedObject(operator.getUserId(), resource.getSiteId());
        scopeManager.checkUserGrantedMOObject(operator.getUserId(), resource.getDeviceSn());
        HashMap<String, String> hostSettings = new HashMap<String, String>();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            hostSettings.put(protectGroup.getUuid(), resource.getDeviceSn());
        }
        HashMap<String, Object> settings = new HashMap<String, Object>();
        String siteId = this.getDisterSiteId(resource.getSiteId(), (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups()));
        settings.put("DISASTER_SITE_ID", siteId);
        settings.put("PG_DISASTER_HOST", hostSettings);
        this.setMountPlanRdmGlobalSetting(settings, recoveryContext);
        return settings;
    }

    private void setMountPlanRdmGlobalSetting(Map<String, Object> settings, Map<String, String> recoveryContext) {
        if (recoveryContext.containsKey("mappingRdmsInfo")) {
            settings.put("mappingRdmsInfo", recoveryContext.get("mappingRdmsInfo"));
        }
        if (recoveryContext.containsKey("unregisterVmUuidList")) {
            settings.put("unregisterVmUuidList", recoveryContext.get("unregisterVmUuidList"));
        }
        if (recoveryContext.containsKey("noPoweredOnVmUuidList")) {
            settings.put("noPoweredOnVmUuidList", recoveryContext.get("noPoweredOnVmUuidList"));
        }
    }

    private Map<String, Object> checkSnapshotRollBackRecoveryContext(RecoveryPlan recoveryPlan, Map<String, String> recoveryContext) {
        VsDataCenter dataCenter;
        logger.debug((Object)"checkSnapshotRollBackRecoveryContext start");
        HashMap<String, Object> result = new HashMap<String, Object>();
        VirtualizationCommonUtil util = VirtualizationCommonUtil.getInstance();
        ProtectGroup pg = (ProtectGroup)util.getElementFromCollection((Collection)recoveryPlan.getProtectGroups());
        String networkId = "";
        for (ProtectObject po : pg.getPolist()) {
            String vmNetCardsInfo = (String)po.getProps().get("VirtualEthernetCard");
            if (!VerifyUtil.isEmpty((String)networkId) || VerifyUtil.isEmpty((String)vmNetCardsInfo)) continue;
            JSONArray vmNetCfgJsonArr = JSONArray.fromObject((Object)vmNetCardsInfo);
            if (vmNetCfgJsonArr.size() == 0) {
                logger.error((Object)"The virtual machine(name: %s) is not configured with network card information.", new Object[]{po.getName()});
                throw new LegoCheckedException(1073948120L, new String[]{po.getName()});
            }
            JSONObject vmNetCfgJson = vmNetCfgJsonArr.getJSONObject(0);
            networkId = vmNetCfgJson.getString("netWorkUuid").split(":")[1];
            break;
        }
        if (null != (dataCenter = this.getSnapshotDataCenterByNetSetting(pg.getPoProviderSN(), networkId))) {
            result.put("VSDATACENTERID", dataCenter.getMoId());
            result.put("VSDATACENTERNAME", dataCenter.getName());
        }
        result.put("DISASTER_SITE_ID", this.getDisterSiteId(recoveryContext.get("DISASTER_SITE_ID"), pg));
        return result;
    }

    private Map<String, Object> checkVmRollBackRecoveryContext(RecoveryPlan plan, Map<String, String> context) {
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups());
        String disasterSiteId = context.get("DISASTER_SITE_ID");
        if (!Objects.equals(pg.getProductSiteId(), disasterSiteId)) {
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            Site siteById = siteService.getSiteById(disasterSiteId);
            logger.error((Object)"vm rollback is just allowed in product site. productSiteId=%s, disasterSiteId=%s", new Object[]{pg.getProductSiteId(), disasterSiteId});
            throw new LegoCheckedException(1073949730L, new String[]{siteById.getName()});
        }
        VsphereReplicaChecker.checkSelectedVmInReplica(pg, context);
        return this.checkSnapshotRollBackRecoveryContext(plan, context);
    }

    private void checkHostPowerState(JSONArray hostJsonArr) {
        logger.debug((Object)"checkHostPowerState start");
        HostSystemAction action = new HostSystemAction();
        try {
            for (int i = 0; i < hostJsonArr.size(); ++i) {
                String compResUuid;
                JSONObject hostInfo = hostJsonArr.getJSONObject(i);
                String vcenterUuid = hostInfo.getString("remoteVcenterId");
                boolean flag = action.isPowerOnHostAtLeast(vcenterUuid, compResUuid = hostInfo.getString("remoteHostId"));
                if (flag) continue;
                throw new LegoCheckedException(1073948150L, "The compute resource has no host power on");
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"checkHostPowerState error!", (Throwable)e);
            throw e;
        }
    }

    private String checkDisasterHostInfo(JSONArray disasterHostInfo) {
        logger.debug((Object)"checkDisasterHostInfo start");
        if (null == disasterHostInfo) {
            throw new LegoCheckedException(1073947393L, "parse JSONArray error.");
        }
        String result = "";
        for (int i = 0; i < disasterHostInfo.size(); ++i) {
            try {
                JSONObject hostSetting = disasterHostInfo.getJSONObject(i);
                if (VerifyUtil.isEmpty((String)hostSetting.getString("remoteVcenterId")) || VerifyUtil.isEmpty((String)hostSetting.getString("remoteHostId")) || VerifyUtil.isEmpty((String)hostSetting.getString("remoteSiteId"))) {
                    throw new LegoCheckedException(1073947393L, "setting is error.");
                }
                if (hostSetting.getString("remoteHostId").equals(hostSetting.getString("srcHostId"))) {
                    String errMsg = String.format("Remote host id %s equals source host id %s", hostSetting.getString("remoteHostId"), hostSetting.getString("srcHostId"));
                    throw new LegoCheckedException(1073947393L, errMsg);
                }
                result = hostSetting.getString("remoteVcenterId");
                continue;
            }
            catch (LegoCheckedException e) {
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
        }
        return result;
    }

    private String checkMountReplicaDisasterHostInfo(JSONArray disasterHostInfo) {
        if (null == disasterHostInfo) {
            throw new LegoCheckedException(1073947393L, "parse disasterHostInfo to JSONArray failed.");
        }
        String remoteVcenterId = "";
        for (int i = 0; i < disasterHostInfo.size(); ++i) {
            try {
                JSONObject hostSetting = disasterHostInfo.getJSONObject(i);
                if (VerifyUtil.isEmpty((String)hostSetting.getString("remoteVcenterId")) || VerifyUtil.isEmpty((String)hostSetting.getString("remoteHostId"))) {
                    throw new LegoCheckedException(1073947393L, "hostSetting is null.");
                }
                remoteVcenterId = hostSetting.getString("remoteVcenterId");
                continue;
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("checkMountReplicaDisasterHostInfo error, " + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
        }
        return remoteVcenterId;
    }

    private void checkNasShareIp(String shareIp) {
        logger.debug((Object)"checkNasShareIp start");
        if (!CommUtil.checkDrmIpParam((String)shareIp)) {
            throw new LegoCheckedException(1073947393L, "shareIp is error.");
        }
    }

    private VsDataCenter getDataCenterByNetSetting(DrVsphereCenter drResource, JSONArray netSettings, String networkKey) {
        String remoteNetworkId;
        logger.debug((Object)"getDataCenterByNetSetting start");
        VsDataCenter dataCenter = null;
        try {
            remoteNetworkId = netSettings.getJSONObject(0).getString(networkKey);
            remoteNetworkId = remoteNetworkId.split(":")[1];
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"getDataCenterByNetSetting error.", (long)1073947393L, null, (Log)logger);
            remoteNetworkId = "";
        }
        DataCenterAction dcAction = new DataCenterAction();
        List<VsDataCenter> dcList = dcAction.queryVsphereDataCenter(drResource.getDeviceSn());
        for (VsDataCenter dc : dcList) {
            if (!dc.getNetWorks().contains(remoteNetworkId)) continue;
            dataCenter = dc;
            break;
        }
        return dataCenter;
    }

    private VsDataCenter getSnapshotDataCenterByNetSetting(String vCenterId, String remoteNetworkId) {
        logger.debug((Object)"getSnapshotDataCenterByNetSetting start");
        VsDataCenter dataCenter = null;
        DataCenterAction dcAction = new DataCenterAction();
        List<VsDataCenter> dcList = dcAction.queryVsphereDataCenter(vCenterId);
        for (VsDataCenter dc : dcList) {
            if (!dc.getNetWorks().contains(remoteNetworkId)) continue;
            dataCenter = dc;
            break;
        }
        return dataCenter;
    }

    private JSONArray getRecoverySettingsByKey(Map<String, String> recoveryContext, String settingKey) {
        if (VerifyUtil.isEmpty((String)recoveryContext.get(settingKey))) {
            logger.error((Object)"settingKey is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String jsonString = recoveryContext.get(settingKey);
        try {
            JSONArray netSettings = JSONArray.fromObject((Object)jsonString);
            return netSettings;
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }

    private void checkNetSettings(JSONArray netSettings) {
        logger.debug((Object)"checkNetSettings start");
        if (null == netSettings) {
            throw new LegoCheckedException(1073947393L, "parse JSONArray error.");
        }
        for (int i = 0; i < netSettings.size(); ++i) {
            try {
                JSONObject netSetting = netSettings.getJSONObject(i);
                if (!VerifyUtil.isEmpty((String)netSetting.getString("remoteNetworkId")) && !VerifyUtil.isEmpty((String)netSetting.getString("remoteNetworkName")) && !VerifyUtil.isEmpty((String)netSetting.getString("srcNetworkId")) && !VerifyUtil.isEmpty((String)netSetting.getString("srcNetworkName"))) continue;
                throw new LegoCheckedException(1073947393L, "setting is error.");
            }
            catch (LegoCheckedException e) {
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
        }
    }

    public String getRecoverySiteId(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        String disasterSiteId;
        block1: {
            Iterator it;
            logger.debug((Object)"getRecoverySiteId start");
            if (null == recoveryContext || null == procType) {
                throw new LegoCheckedException(1073947393L);
            }
            String jsonKey = DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING == procType ? "testHosts" : "recoveryHosts";
            JSONArray jsonArray = JSONArray.fromObject((Object)recoveryContext.get(jsonKey));
            disasterSiteId = null;
            if (null == jsonArray || jsonArray.size() <= 0 || !(it = jsonArray.iterator()).hasNext()) break block1;
            JSONObject jsonObject = JSONObject.fromObject(it.next());
            disasterSiteId = jsonObject.getString("remoteSiteId");
        }
        return disasterSiteId;
    }

    public void encryptProperties(RecoveryPlan recoveryPlan) {
        super.encryptProperties(recoveryPlan);
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getRecoverySettings())) {
            return;
        }
        this.updateGuestOsAuth(recoveryPlan, true);
    }

    public void decryptPropreties(RecoveryPlan recoveryPlan) {
        super.decryptPropreties(recoveryPlan);
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getRecoverySettings())) {
            return;
        }
        this.updateGuestOsAuth(recoveryPlan, false);
    }

    private void updateGuestOsAuth(RecoveryPlan recoveryPlan, boolean encrypt) {
        for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
            String password;
            JSONObject authJson;
            if (!"PO_OS_NAMEPASSWORD".equals(setting.getName()) || !(authJson = JSONObject.fromObject((Object)setting.getValue())).containsKey((Object)"password") || VerifyUtil.isEmpty((String)(password = authJson.getString("password")))) continue;
            if (encrypt) {
                authJson.put((Object)"password", (Object)WccEncryptor.encrypt((String)password));
            } else {
                authJson.put((Object)"password", (Object)WccEncryptor.decrypt((String)password));
            }
            setting.setValue(authJson.toString());
        }
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
        if (null == recoverySettingList || recoverySettingList.isEmpty()) {
            return;
        }
        this.checkStartConfig(recoverySettingList);
    }

    private void checkStartConfig(List<RecoverySetting> recoverySettingList) {
        for (RecoverySetting rs : recoverySettingList) {
            String name = rs.getName();
            String value = rs.getValue();
            if ("isStart".equals(name)) {
                if ("true".equals(value) || "false".equals(value)) continue;
                logger.error((Object)("invalid parameter!name:" + name + ", value:" + value));
                throw new LegoCheckedException(1073947393L);
            }
            if (!"startOrder".equals(name)) continue;
            int startOrder = NumberUtil.convertToInteger((Object)value, (LegoCheckedException)new LegoCheckedException(1073947393L));
            int maxValue = 512;
            if (startOrder >= 1 && startOrder <= maxValue) continue;
            logger.error((Object)("invalid parameter!name:" + name + ", value:" + value));
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkShareExists(ProtectGroup protectGroup) {
        Set set = protectGroup.getReplicaList();
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)CommonUtil.getFirstElement((Collection)set);
        if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            logger.error((Object)"protectGroupReplica is null");
            return;
        }
        ArrayList<Callable> taskList = new ArrayList<Callable>();
        HashSet<String> storageSet = new HashSet<String>();
        for (ProtectObjectReplica poReplica : protectGroupReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : poReplica.getStorageInfos()) {
                String devSn = storageInfo.getStorageProviderSN();
                String storageId = storageInfo.getStorageId();
                if (storageSet.contains(devSn + storageId)) continue;
                storageSet.add(devSn + storageId);
                taskList.add(this.generateGetNasShareTask(devSn, storageId));
            }
        }
        List result = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)10, (int)30);
        if (result.size() < taskList.size()) {
            logger.error((Object)"sharePath is not existed.");
            throw new LegoCheckedException(1073948769L, "sharePath is not existed.");
        }
    }

    private Callable generateGetNasShareTask(final String devSn, final String storageId) {
        Callable callable = new Callable(){

            public Boolean call() {
                String vstoreId;
                IStorageFileSystemManager storageFileSystemManager = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(devSn);
                NFSShare shareInfo = storageFileSystemManager.getNFSShare(devSn, storageId, vstoreId = RecoveryProcessUtil.getVstoreIdByResourceId((String)devSn, (String)storageId));
                if (null == shareInfo) {
                    logger.error((Object)("sharePath is not existed." + storageId));
                    throw new LegoCheckedException(1073948769L, "sharePath is not existed.");
                }
                return true;
            }
        };
        return callable;
    }

    public Set<RecoverySetting> getMountRecoverySettings(RecoveryPlan plan, ProtectGroupReplica protectGroupReplica, MountConfiguration mountConfigs) {
        if (null == plan || null == mountConfigs) {
            logger.error((Object)"plan or mountConfigs is null");
            throw new LegoCheckedException(1073947393L);
        }
        Set startSettings = super.getMountRecoverySettings(plan, protectGroupReplica, mountConfigs);
        HashSet<RecoverySetting> recoverySettings = new HashSet<RecoverySetting>();
        recoverySettings.addAll(startSettings);
        String mountSettings = (String)mountConfigs.getExtParameters().get(MOUNT_SETTINGS);
        if (VerifyUtil.isEmpty((String)mountSettings)) {
            logger.debug((Object)"mountSettings is null.");
            return recoverySettings;
        }
        JSONArray arrays = JSONArray.fromObject((Object)mountSettings);
        for (Object jsonString : arrays) {
            RecoverySetting recoverySetting = (RecoverySetting)JSONObject.toBean((JSONObject)JSONObject.fromObject(jsonString), RecoverySetting.class);
            if (null == recoverySetting) {
                logger.error((Object)"recoverySetting is null");
                throw new LegoCheckedException(1073947393L);
            }
            recoverySetting.setRecoveryPlan(plan);
            if ("PO_OS_NAMEPASSWORD".equals(recoverySetting.getName())) {
                this.updateOsAuthPwd(recoverySetting, plan);
            }
            recoverySettings.add(recoverySetting);
        }
        return recoverySettings;
    }

    public ICallBackExcuteRecoveryTask getRecoveryCallbackTask(DrmEnumDefine.RecoveryPlanExecuteTypeE executeTypeE) {
        if (executeTypeE == DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK) {
            return new VmRecoveryCallbackTask();
        }
        return super.getRecoveryCallbackTask(executeTypeE);
    }

    private void updateOsAuthPwd(RecoverySetting recoverySetting, RecoveryPlan plan) {
        JSONObject nameAndPwd = JSONObject.fromObject((Object)recoverySetting.getValue());
        if (!nameAndPwd.containsKey((Object)"password")) {
            return;
        }
        String pwd = nameAndPwd.getString("password");
        if (!VerifyUtil.isEmpty((String)pwd)) {
            nameAndPwd.put((Object)"password", (Object)WccEncryptor.encrypt((String)StringEscapeUtil.decode((String)pwd)));
        } else {
            nameAndPwd.put((Object)"password", (Object)this.getOldPassword(plan, recoverySetting.getOwnerId()));
        }
        recoverySetting.setValue(nameAndPwd.toString());
    }

    private String getOldPassword(RecoveryPlan rp, String poId) {
        JSONObject osObj = new JSONObject();
        RecoverySetting oldOsSetting = RecoveryUtil.getRecoverySetting((String)rp.getPlanId(), (String)poId, (String)"PO_OS_NAMEPASSWORD", (Set)rp.getRecoverySettings());
        if (!VerifyUtil.isEmpty((Object)oldOsSetting)) {
            osObj = JSONObject.fromObject((Object)oldOsSetting.getValue());
        }
        return osObj.getString("password");
    }
}

