/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCgCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotCgCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotSubProcessor;
import com.huawei.ism.drm.virtualization.recovery.process.DeleteSnapshotProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CleanSnapshotProcessor
extends DeleteSnapshotProcessor {
    private static final Log logger = LogFactory.getInstance(CleanSnapshotProcessor.class);
    private static final String SNAPSHOT_PROCESSOR_KEY = "snapshotCopyForVmRecovery";
    private static final String PROCESS_NAME = "com.huawei.ism.drm.storage.recovery.process.DeleteSnapshotCopyProcessor";
    private static final Class<? extends RecoveryProcessor> SNAPSHOT_COPY_SUB_PROCESSOR = CreateSnapshotCopySubProcessor.class;
    private static final Class<? extends RecoveryProcessor> SNAPSHOT_COPY_CG_SUB_PROCESSOR = CreateSnapshotCgCopySubProcessor.class;
    private final DrmEnumDefine.RecoveryPlanExecuteTypeE procType = DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK;

    public String getName() {
        return PROCESS_NAME;
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessName(PROCESS_NAME);
        List<RecoveryProcessor> targetProcessors = this.getCurrentExecutionSnapshotProcessors();
        Object cleanModeObj = context.getAttribute("cleanModeForVm");
        if (!VerifyUtil.isEmpty((Object)cleanModeObj)) {
            logger.info((Object)"get snapshot from db.");
            targetProcessors = this.getHistSnapshotProcessors();
        }
        if (VerifyUtil.isEmpty(targetProcessors)) {
            logger.info((Object)"no snapshot processors in db. no need to delete snapshot.");
            return this.success();
        }
        Set<RecoveryProcessor> deleteRecoveryProcessors = this.convertToDeleteSnapshotProcessor(targetProcessors);
        this.setChildProc(deleteRecoveryProcessors);
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList<RecoveryProcessor>(deleteRecoveryProcessors));
        executor.process(context);
        boolean result = this.calcProcessResultBySubProc();
        logger.info((Object)"delete snapshot result is: %s", new Object[]{result});
        return true;
    }

    private Set<RecoveryProcessor> convertToDeleteSnapshotProcessor(List<RecoveryProcessor> targetProcessors) {
        HashSet<RecoveryProcessor> subProcessor = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor process : targetProcessors) {
            if (process instanceof CreateSnapshotCgCopySubProcessor) {
                subProcessor.add(this.createDeleteSnapshotCgSubProcessor((CreateSnapshotCgCopySubProcessor)process));
            }
            if (!(process instanceof CreateSnapshotCopySubProcessor)) continue;
            CreateSnapshotCopySubProcessor copySubProcessor = (CreateSnapshotCopySubProcessor)process;
            String snapshotId = copySubProcessor.getSnapshotId();
            if (VerifyUtil.isEmpty((String)snapshotId)) {
                logger.info((Object)"snapshot id is empty, no need to delete.");
                continue;
            }
            subProcessor.add(this.createDeleteSnapshotSubProcessor((CreateSnapshotCopySubProcessor)process));
        }
        return subProcessor;
    }

    private RecoveryProcessor createDeleteSnapshotCgSubProcessor(CreateSnapshotCgCopySubProcessor processor) {
        DeleteSnapshotCgCopySubProcessor delProcessor = new DeleteSnapshotCgCopySubProcessor();
        delProcessor.setDeviceId(processor.getDeviceId());
        delProcessor.setCgGroupID(processor.getCgGroupID());
        delProcessor.setSrcCgGroupID(processor.getSrcCgGroupID());
        delProcessor.setProtectType(processor.getProtectType());
        delProcessor.setProcType(this.getProcType());
        delProcessor.setPlanId(this.getPlanId());
        delProcessor.setProcessId(this.getProcessId());
        delProcessor.setParentProc((RecoveryProcessor)this);
        return delProcessor;
    }

    private RecoveryProcessor createDeleteSnapshotSubProcessor(CreateSnapshotCopySubProcessor createSnapshotProcessor) {
        DeleteSnapshotSubProcessor processor = new DeleteSnapshotSubProcessor();
        processor.setLunId(createSnapshotProcessor.getSrcSnapshotId());
        processor.setLunName(createSnapshotProcessor.getSnapshotName());
        processor.setDeviceId(createSnapshotProcessor.getDeviceId());
        processor.setSnapshotId(createSnapshotProcessor.getSnapshotId());
        processor.setSnapshotName(createSnapshotProcessor.getSnapshotName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        return processor;
    }

    private List<RecoveryProcessor> getCurrentExecutionSnapshotProcessors() {
        RecoveryProcessorContext context = this.getContextRef();
        VerifyUtil.checkObject((Object)context);
        Set copySubProcessors = (Set)context.getAttribute(SNAPSHOT_PROCESSOR_KEY);
        ArrayList<RecoveryProcessor> copySubProcessorList = new ArrayList<RecoveryProcessor>();
        for (RecoveryProcessor copySubProcessor : copySubProcessors) {
            if (copySubProcessor instanceof CreateSnapshotCgCopySubProcessor) {
                return Collections.singletonList(copySubProcessor);
            }
            if (!(copySubProcessor instanceof CreateSnapshotCopySubProcessor)) continue;
            copySubProcessorList.add(copySubProcessor);
        }
        return copySubProcessorList;
    }

    private List<RecoveryProcessor> getHistSnapshotProcessors() {
        RecoveryProcessorContext context = this.getContextRef();
        VerifyUtil.checkObjs((Object[])new Object[]{context});
        List resourceList = (List)context.getAttribute("Target_Storage");
        if (VerifyUtil.isEmpty((Collection)resourceList)) {
            logger.warn((Object)"target storage resource is empty.");
            return Collections.emptyList();
        }
        Set snapshotWwnSet = resourceList.stream().map(StorageResource::getResourceIndentifier).collect(Collectors.toSet());
        ArrayList histRecoveryProcessors = new ArrayList();
        List snapshotCgProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), this.getProcTypeForQuery(), SNAPSHOT_COPY_CG_SUB_PROCESSOR);
        List snapshotCopySubProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), this.getProcTypeForQuery(), SNAPSHOT_COPY_SUB_PROCESSOR);
        histRecoveryProcessors.addAll(snapshotCgProcessors);
        histRecoveryProcessors.addAll(snapshotCopySubProcessors);
        String productArray = context.getProtectGroupReplica().getProductArray();
        ArrayList<RecoveryProcessor> result = new ArrayList<RecoveryProcessor>();
        for (RecoveryProcessor processor : histRecoveryProcessors) {
            CreateSnapshotCopySubProcessor copySubProcessor;
            CreateSnapshotCgCopySubProcessor cgCopySubProcessor;
            if (processor instanceof CreateSnapshotCgCopySubProcessor && Objects.equals((cgCopySubProcessor = (CreateSnapshotCgCopySubProcessor)processor).getDeviceId(), productArray)) {
                result.add((RecoveryProcessor)cgCopySubProcessor);
            }
            if (!(processor instanceof CreateSnapshotCopySubProcessor) || !snapshotWwnSet.contains((copySubProcessor = (CreateSnapshotCopySubProcessor)processor).getSnapshotWWN())) continue;
            result.add((RecoveryProcessor)copySubProcessor);
        }
        return result;
    }

    protected DrmEnumDefine.RecoveryPlanExecuteTypeE getProcTypeForQuery() {
        return this.procType;
    }

    public void endRecoveryProcessor() {
        RecoveryProcessorContext context = this.getContextRef();
        VerifyUtil.checkObject((Object)context);
        Object cleanModeObj = context.getAttribute("cleanModeForVm");
        if (!VerifyUtil.isEmpty((Object)cleanModeObj)) {
            this.deleteSnapshotCopyProcess(context);
            this.deleteSnapshotCopyCgProcess(context);
        }
        super.endRecoveryProcessor();
    }

    private void deleteSnapshotCopyCgProcess(RecoveryProcessorContext context) {
        Set childProc = Optional.ofNullable(this.getChildProc()).orElse(new HashSet());
        if (VerifyUtil.isEmpty(childProc = childProc.stream().filter(proc -> proc instanceof DeleteSnapshotCgCopySubProcessor).collect(Collectors.toSet()))) {
            return;
        }
        List<RecoveryProcessor> snapshotProcessors = this.getCurrentExecutionSnapshotProcessors();
        Set filterProcIdSet = snapshotProcessors.stream().filter(proc -> proc instanceof CreateSnapshotCgCopySubProcessor).filter(proc -> proc.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()).map(RecoveryProcessor::getProcId).collect(Collectors.toSet());
        List histCgCopyProcessor = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), this.getProcTypeForQuery(), SNAPSHOT_COPY_CG_SUB_PROCESSOR).stream().filter(proc -> !filterProcIdSet.contains(proc.getProcId())).collect(Collectors.toList());
        Set deletedCgKeySet = this.getChildProc().stream().filter(proc -> proc.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()).map(this::createKey).collect(Collectors.toSet());
        List<RecoveryProcessor> toDeleteList = histCgCopyProcessor.stream().filter(proc -> deletedCgKeySet.contains(this.createKey((RecoveryProcessor)proc))).collect(Collectors.toList());
        IRecoveryProcessService processService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        toDeleteList.forEach(arg_0 -> ((IRecoveryProcessService)processService).deleteRecoveryProcessor(arg_0));
    }

    private void deleteSnapshotCopyProcess(RecoveryProcessorContext context) {
        Set childProc = Optional.ofNullable(this.getChildProc()).orElse(new HashSet());
        if (VerifyUtil.isEmpty(childProc = childProc.stream().filter(proc -> proc instanceof DeleteSnapshotSubProcessor).collect(Collectors.toSet()))) {
            return;
        }
        List<RecoveryProcessor> snapshotProcessors = this.getCurrentExecutionSnapshotProcessors();
        Set filterProcIdSet = snapshotProcessors.stream().filter(proc -> proc instanceof CreateSnapshotCopySubProcessor).filter(proc -> proc.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()).map(RecoveryProcessor::getProcId).collect(Collectors.toSet());
        List histCopyProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), this.getProcTypeForQuery(), SNAPSHOT_COPY_SUB_PROCESSOR).stream().filter(proc -> !filterProcIdSet.contains(proc.getProcId())).collect(Collectors.toList());
        Set deletedSnapshotKeySet = childProc.stream().filter(proc -> proc.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()).map(this::createKey).collect(Collectors.toSet());
        List<RecoveryProcessor> toDeleteList = histCopyProcessors.stream().filter(proc -> deletedSnapshotKeySet.contains(this.createKey((RecoveryProcessor)proc))).collect(Collectors.toList());
        IRecoveryProcessService processService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        toDeleteList.forEach(arg_0 -> ((IRecoveryProcessService)processService).deleteRecoveryProcessor(arg_0));
    }

    private String createKey(RecoveryProcessor proc) {
        if (proc instanceof DeleteSnapshotSubProcessor) {
            DeleteSnapshotSubProcessor subProcessor = (DeleteSnapshotSubProcessor)proc;
            return subProcessor.getDeviceId() + ":" + subProcessor.getSnapshotId() + ":" + subProcessor.getLunId() + ":" + subProcessor.getSnapshotName();
        }
        if (proc instanceof CreateSnapshotCopySubProcessor) {
            CreateSnapshotCopySubProcessor subProcessor = (CreateSnapshotCopySubProcessor)proc;
            return subProcessor.getDeviceId() + ":" + subProcessor.getSnapshotId() + ":" + subProcessor.getSrcSnapshotId() + ":" + subProcessor.getSnapshotName();
        }
        if (proc instanceof DeleteSnapshotCgCopySubProcessor) {
            DeleteSnapshotCgCopySubProcessor subProcessor = (DeleteSnapshotCgCopySubProcessor)proc;
            return subProcessor.getDeviceId() + ":" + subProcessor.getCgGroupID() + ":" + subProcessor.getSrcCgGroupID();
        }
        if (proc instanceof CreateSnapshotCgCopySubProcessor) {
            CreateSnapshotCgCopySubProcessor subProcessor = (CreateSnapshotCgCopySubProcessor)proc;
            return subProcessor.getDeviceId() + ":" + subProcessor.getCgGroupID() + ":" + subProcessor.getSrcCgGroupID();
        }
        return "";
    }
}

