/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.task.CleanSnapshotMappingProcessor;
import com.huawei.ism.drm.vsphere.recovery.task.CleanSnapshotProcessor;
import com.huawei.ism.drm.vsphere.recovery.task.DeleteVmFromDiskTask;
import com.huawei.ism.drm.vsphere.recovery.task.DetachScsiLunTask;
import com.huawei.ism.drm.vsphere.recovery.task.RescanHbaTask;
import com.huawei.ism.drm.vsphere.recovery.task.RescanVmfsTask;
import com.huawei.ism.drm.vsphere.recovery.task.ShutdownVMTask;
import com.huawei.ism.drm.vsphere.recovery.task.UmountDatastoreTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CleanVmRecoveryProcessor
extends BaseRecoveryProcessor {
    public static final String LATEST_VMS_FROM_VCENTER = "latestVmsFromVCenter";
    public static final String VM_CLEAN_MODE = "cleanModeForVm";
    private static final Log logger = LogFactory.getInstance(CleanVmRecoveryProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        this.setChildProc(this.createCleanProcessors());
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"no child processors to handle.");
            return true;
        }
        VMAction vmAction = new VMAction();
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vCenterUuid);
        List<VsphereVirtualMachine> vsphereVirtualMachines = vmAction.queryAllVms(conn);
        context.setAttribute(LATEST_VMS_FROM_VCENTER, vsphereVirtualMachines);
        context.setAttribute(VM_CLEAN_MODE, (Object)Boolean.TRUE);
        return this.serialExcuteChildProc(context);
    }

    protected boolean serialExcuteChildProc(RecoveryProcessorContext context) {
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutorSort((Set)this.getChildProc());
        if (VerifyUtil.isEmpty((Object)executor)) {
            logger.error((Object)"create serial executor failed.");
            throw new LegoCheckedException(1073947393L);
        }
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != procStatus.getValue()) {
            logger.warn((Object)"clear recovery processor failed");
            return false;
        }
        return true;
    }

    private Set<RecoveryProcessor> createCleanProcessors() {
        HashSet<RecoveryProcessor> cleanProcessors = new HashSet<RecoveryProcessor>();
        List<Class<? extends BaseRecoveryProcessor>> recoveryProcessors = this.getRecoveryClasses();
        BaseRecoveryProcessor prev = null;
        for (Class<? extends BaseRecoveryProcessor> recoveryProcessorClass : recoveryProcessors) {
            try {
                BaseRecoveryProcessor baseRecoveryProcessor = recoveryProcessorClass.newInstance();
                if (prev != null) {
                    baseRecoveryProcessor.setPreviousProcessor((RecoveryProcessor)prev);
                    prev.setNextProcessor((RecoveryProcessor)baseRecoveryProcessor);
                }
                prev = baseRecoveryProcessor;
                baseRecoveryProcessor.setParentProc((RecoveryProcessor)this);
                baseRecoveryProcessor.setProcType(this.getProcType());
                cleanProcessors.add((RecoveryProcessor)baseRecoveryProcessor);
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error((Object)"construction new instance failed: %s", new Object[]{recoveryProcessorClass.getName()});
                throw new LegoCheckedException(1073947393L);
            }
        }
        return cleanProcessors;
    }

    private List<Class<? extends BaseRecoveryProcessor>> getRecoveryClasses() {
        RecoveryProcessorContext context = this.getContextRef();
        VerifyUtil.checkObjs((Object[])new Object[]{context});
        ArrayList<Class<? extends BaseRecoveryProcessor>> targetProcessorClasses = new ArrayList<Class<? extends BaseRecoveryProcessor>>();
        this.addProcessorIfNotEmpty(context, "Target_VM", targetProcessorClasses, Arrays.asList(ShutdownVMTask.class, DeleteVmFromDiskTask.class));
        this.addProcessorIfNotEmpty(context, "Target_Datastore", targetProcessorClasses, Collections.singletonList(UmountDatastoreTask.class));
        this.addProcessorIfNotEmpty(context, "Target_Host", targetProcessorClasses, Collections.singletonList(DetachScsiLunTask.class));
        this.addProcessorIfNotEmpty(context, "Target_Storage", targetProcessorClasses, Arrays.asList(CleanSnapshotMappingProcessor.class, CleanSnapshotProcessor.class));
        if (!targetProcessorClasses.isEmpty()) {
            targetProcessorClasses.add(RescanHbaTask.class);
            targetProcessorClasses.add(RescanVmfsTask.class);
        }
        logger.info((Object)"this clean processor classes: %s", new Object[]{targetProcessorClasses});
        return targetProcessorClasses;
    }

    private void addProcessorIfNotEmpty(RecoveryProcessorContext context, String attr, List<Class<? extends BaseRecoveryProcessor>> targetProcessorClasses, List<Class<? extends BaseRecoveryProcessor>> recoveryProcessorClass) {
        if (this.isAttrEmpty(context, attr)) {
            return;
        }
        targetProcessorClasses.addAll(recoveryProcessorClass);
    }

    private boolean isAttrEmpty(RecoveryProcessorContext context, String targetVm) {
        Object attribute = context.getAttribute(targetVm);
        if (VerifyUtil.isEmpty((Object)attribute)) {
            return true;
        }
        if (attribute instanceof Collection) {
            Collection collection = (Collection)attribute;
            return collection.isEmpty();
        }
        return false;
    }
}

