/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.observer.ObserverManager;
import com.huawei.ism.drm.virtualization.sdk.model.DataStoreInfo;
import com.huawei.ism.drm.virtualization.sdk.model.HostSystem;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.recovery.task.CheckDatastoreSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigDatastoreSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.MountDatastoreSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.RecoverySourcePreparer;
import com.huawei.ism.drm.vsphere.recovery.task.ResignatureDatastoreSubTask;
import com.huawei.ism.drm.vsphere.recovery.utils.DatastoreFinder;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.HostUnresolvedVmfsExtent;
import com.huawei.vmware.vim25.HostUnresolvedVmfsExtentUnresolvedReason;
import com.huawei.vmware.vim25.HostUnresolvedVmfsVolume;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ConfigDatastoreTask
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -3914128356096341006L;
    private static final String QUERYDATASTORE_RETRY_TYMES_KEY = "vmware.querydatastore.retrytimes";
    private static final Log logger = LogFactory.getInstance(ConfigDatastoreTask.class);
    private List<HostSystem> hostSystemList;
    private String vcenterUuid;
    private final Set<String> hostIds = new HashSet<String>();
    private final transient DataStoreAction dataStoreAction = new DataStoreAction();
    private final transient HostSystemAction hostSystemAction = new HostSystemAction();

    protected boolean execute(RecoveryProcessorContext context) {
        if (this.isOnlyMappingVmRdmDisk(context)) {
            return this.success();
        }
        this.initTaskData(context);
        this.updateSubProcessors();
        return this.serialExcuteChildProc(context);
    }

    private void initTaskData(RecoveryProcessorContext context) {
        new RecoverySourcePreparer(this).prepareTargetDatastore(context);
        this.vcenterUuid = (String)context.getAttribute("Target_vCenter");
        this.hostSystemList = context.getObjects("Target_Host", HostSystem.class);
        this.hostSystemList.forEach(hostSystem -> this.hostIds.add(hostSystem.getUuid().split(":")[1]));
    }

    private void updateSubProcessors() {
        List<VsphereDataStore> datastores;
        this.getChildProc().clear();
        List resources = this.getContextRef().getObjects("Target_Storage", StorageResource.class);
        if (VerifyUtil.isEmpty((Collection)resources)) {
            logger.error((Object)"query storage resource of target storage failed.");
            throw new LegoCheckedException(1073948897L);
        }
        List oldDatastores = this.getContextRef().getObjects("Target_Datastore", VsphereDataStore.class);
        if (!this.dataStoreAction.compareDatastore(oldDatastores, datastores = this.generateMountSubTask(resources))) {
            this.updateResignatureDatastoreSubTasks(resources);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"query unresolved datastore on esxi failed.");
            throw new LegoCheckedException(1073948897L);
        }
        this.getChildProc().add(new CheckDatastoreSubTask((RecoveryProcessor)this, this.vcenterUuid, this.hostIds));
    }

    private List<VsphereDataStore> generateMountSubTask(List<StorageResource> resources) {
        List<VsphereDataStore> datastores;
        long retryTimes = LegoConfig.getInstance().getNumber(QUERYDATASTORE_RETRY_TYMES_KEY, 1L);
        int count = 0;
        do {
            logger.info((Object)"GenerateMountSubTask: query dataStore %s times", new Object[]{String.valueOf(count)});
            if (count != 0) {
                CommonUtil.sleep((long)TimeUnit.SECONDS.toMillis(30L));
            }
            datastores = this.dataStoreAction.queryAllValidDataStores(this.vcenterUuid);
            if (!VerifyUtil.isEmpty(datastores = this.dataStoreAction.filterDatastores(this.vcenterUuid, datastores, resources))) {
                datastores.forEach(dataStore -> this.getChildProc().add(new MountDatastoreSubTask((RecoveryProcessor)this, (VsphereDataStore)dataStore)));
                break;
            }
            if ((long)(++count) != retryTimes) continue;
            logger.info((Object)"For last retry, do rescan vmfs.");
            this.refreshHostSystem();
        } while ((long)count <= retryTimes);
        return datastores;
    }

    private void refreshHostSystem() {
        if (VerifyUtil.isEmpty(this.hostSystemList)) {
            return;
        }
        for (HostSystem hostSystem : this.hostSystemList) {
            if (!(hostSystem instanceof VsphereHostSystem)) continue;
            VsphereHostSystem vsphereHostSystem = (VsphereHostSystem)hostSystem;
            this.hostSystemAction.rescanVmfs(this.vcenterUuid, vsphereHostSystem.getHostMoId());
        }
    }

    private void updateResignatureDatastoreSubTasks(List<StorageResource> resources) {
        HashSet<String> devicePaths = new HashSet<String>();
        Set<String> targetWwns = resources.stream().map(resource -> resource.getResourceIndentifier()).collect(Collectors.toSet());
        for (String hostId : this.hostIds) {
            List<HostUnresolvedVmfsVolume> vmfsVolumes = this.hostSystemAction.queryUnresolvedVmfsVolume(this.vcenterUuid, hostId);
            if (VerifyUtil.isEmpty(vmfsVolumes)) {
                logger.info((Object)"no unresolvedVmfsVolumes find in hostId:[%s]", new Object[]{hostId});
                continue;
            }
            for (HostUnresolvedVmfsVolume vmfsVolume : vmfsVolumes) {
                HashSet<String> conflictWwn;
                String devicePath = this.getDevPath(vmfsVolume, targetWwns, conflictWwn = new HashSet<String>());
                if (VerifyUtil.isEmpty((String)devicePath) || !devicePaths.add(devicePath)) continue;
                this.getChildProc().add(new ResignatureDatastoreSubTask((RecoveryProcessor)this, this.vcenterUuid, hostId, devicePath, vmfsVolume.getVmfsLabel(), conflictWwn));
            }
        }
    }

    private String getDevPath(HostUnresolvedVmfsVolume vol, Set<String> wwnSet, Set<String> conflictWwn) {
        String devPath = null;
        String conflictVmfsUUid = "";
        List extendList = vol.getExtent();
        for (HostUnresolvedVmfsExtent extend : extendList) {
            if (!extend.isIsHeadExtent()) {
                logger.debug((Object)"The hostUnresolvedVmfsExtent is not headExtent.");
                continue;
            }
            String diskName = extend.getDevice().getDiskName();
            if (null == diskName) {
                logger.error((Object)"diskName is null");
                throw new LegoCheckedException(0x300001L);
            }
            Map euiToIscsiMap = (Map)this.getContextRef().getAttribute("snapShotNguid");
            String tempWwn = HostSystemAction.processStorageWwn(diskName, euiToIscsiMap);
            logger.info((Object)("tempwwn=" + tempWwn));
            if (wwnSet.contains(tempWwn)) {
                devPath = extend.getDevicePath();
                continue;
            }
            conflictWwn.add(tempWwn);
            conflictVmfsUUid = extend.getVmfsUuid();
        }
        if (conflictWwn.size() == 0) {
            return devPath;
        }
        this.addAdditionalToConflictWwn(wwnSet, conflictWwn, conflictVmfsUUid, extendList);
        return devPath;
    }

    private void addAdditionalToConflictWwn(Set<String> wwnSet, Set<String> conflictWwn, String conflictVmfsUUid, List<HostUnresolvedVmfsExtent> extendList) {
        for (HostUnresolvedVmfsExtent unresolvedVmfsExtent : extendList) {
            Map euiToIscsiMap;
            String diskName;
            String wwn;
            if (unresolvedVmfsExtent.isIsHeadExtent() || !HostUnresolvedVmfsExtentUnresolvedReason.UUID_CONFLICT.value().equals(unresolvedVmfsExtent.getReason()) || !unresolvedVmfsExtent.getVmfsUuid().equals(conflictVmfsUUid) || wwnSet.contains(wwn = HostSystemAction.processStorageWwn(diskName = (String)CommonUtil.requireNonNull((Object)unresolvedVmfsExtent.getDevice().getDiskName(), (long)0x300001L, (String[])new String[0]), euiToIscsiMap = (Map)this.getContextRef().getAttribute("snapShotNguid")))) continue;
            conflictWwn.add(wwn);
        }
    }

    public void endRecoveryProcessor() {
        Set subTasks = this.getChildProc();
        if (!VerifyUtil.isEmpty((Collection)subTasks) && DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            ProtectGroup pg = this.getContextRef().getProtectGroup();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            HashMap<String, String> dsChangeMap = new HashMap<String, String>();
            HashMap<String, String> dsIdChangeMap = new HashMap<String, String>();
            dataMap.put("pgobj", pg);
            String dsInfosStr = (String)pg.getProps().get("pgDsInfo");
            JSONArray dsArray = JSONArray.fromObject((Object)dsInfosStr);
            HashSet<DataStoreInfo> dataStoreInfoSet = new HashSet<DataStoreInfo>(JSONArray.toCollection((JSONArray)dsArray, DataStoreInfo.class));
            IRecoveryProcessService processService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            try {
                DatastoreFinder finder = new DatastoreFinder(this.getContextRef());
                for (RecoveryProcessor task : subTasks) {
                    if (!(task instanceof ConfigDatastoreSubTask)) continue;
                    ConfigDatastoreSubTask configDatastore = (ConfigDatastoreSubTask)task;
                    if (null == configDatastore.getTargetDatastoreUuid()) {
                        logger.info((Object)"newDatastoreUuid is null.", new Object[]{configDatastore.getName()});
                        continue;
                    }
                    VsphereDataStore dataStore = finder.findDatastore(configDatastore.getTargetDatastoreUuid());
                    if (null == dataStore) {
                        logger.info((Object)"can not find oldDatastore by newDatastoreUuid:%s, newDatastoreName", new Object[]{configDatastore.getTargetDatastoreUuid(), configDatastore.getName()});
                        continue;
                    }
                    this.updateConfigDatastore(dsIdChangeMap, configDatastore, dataStore);
                    processService.updateRecoveryProcessor((RecoveryProcessor)configDatastore);
                    this.replaceVirtualMachinePath(dataStore, configDatastore);
                    this.solveDataStoreChangeMap(dsChangeMap, dataStoreInfoSet, finder, configDatastore.getTargetDatastoreUuid(), dataStore);
                }
                processService.updateRecoveryProcessor((RecoveryProcessor)this);
            }
            catch (Exception e) {
                logger.error((Object)"excute endRecoveryProcessor error!", (Throwable)e);
            }
            dataMap.put("dsmap", dsChangeMap);
            dataMap.put("ProcType", DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()));
            this.getContextRef().setAttribute("datastoreChangeMap", dsChangeMap);
            this.getContextRef().setAttribute("datastoreIdChangeMap", dsIdChangeMap);
            ObserverManager.getInstance((String)"RE_CREATE_DATASTORE_MANAGER").syncNotifyAllObservers(dataMap);
        }
        super.endRecoveryProcessor();
    }

    private void updateConfigDatastore(Map<String, String> dsIdChangeMap, ConfigDatastoreSubTask configDatastore, VsphereDataStore dataStore) {
        configDatastore.setSourceDatastoreUuid(dataStore.getUuid());
        configDatastore.setSourceDatastoreName(dataStore.getName());
        configDatastore.setSourceDatastoreMoId(dataStore.getDsMoId());
        dsIdChangeMap.put(dataStore.getUuid(), configDatastore.getTargetDatastoreUuid());
    }

    private void solveDataStoreChangeMap(Map<String, String> dsChangeMap, Set<DataStoreInfo> dataStoreInfoSet, DatastoreFinder finder, String newDatastoreUuid, VsphereDataStore dataStore) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue()) {
            String originDsId = dataStore.getUuid();
            VsphereDataStore originDataStore = finder.getDatastore(originDsId);
            VsphereDataStore newDataStore = finder.getDatastore(newDatastoreUuid);
            if (VerifyUtil.isEmpty((Object)originDataStore) || VerifyUtil.isEmpty((String)originDataStore.getUuid())) {
                logger.error((Object)"find originDataStore uuid failed, originDsId:%s", new Object[]{originDsId});
                return;
            }
            if (VerifyUtil.isEmpty((Object)newDataStore) || VerifyUtil.isEmpty((String)newDataStore.getUuid())) {
                logger.error((Object)"find newDataStore uuid failed, newDataStore:%s", new Object[]{newDatastoreUuid});
                return;
            }
            dsChangeMap.put(originDataStore.getUuid(), newDataStore.getUuid());
            logger.info((Object)"find dsChangeMap success, originDataStore:%s, newDataStore:%s", new Object[]{originDataStore.getUuid(), newDataStore.getUuid()});
            return;
        }
        String oldDsUuid = null;
        for (DataStoreInfo dsinfo : dataStoreInfoSet) {
            if (!dataStore.getName().equals(dsinfo.getDataStoreName())) continue;
            oldDsUuid = dsinfo.getDataStoreUuid();
        }
        if (VerifyUtil.isEmpty(oldDsUuid)) {
            logger.error((Object)"Old dataStore's uuid is emtpy, can not get mapping info.");
            return;
        }
        VsphereDataStore newDataStore = finder.getDatastore(newDatastoreUuid);
        dsChangeMap.put(oldDsUuid, newDataStore.getUuid());
    }

    private void replaceVirtualMachinePath(VsphereDataStore dataStore, ConfigDatastoreSubTask configDatastore) {
        List vsphereVirtualMachineList = this.getContextRef().getObjects("Target_VM", VsphereVirtualMachine.class);
        for (VsphereVirtualMachine virtualMachine : vsphereVirtualMachineList) {
            String vmPath = virtualMachine.getVmPath();
            logger.info((Object)"old vmPath:%s, old datastoreName:%s", new Object[]{vmPath, dataStore.getName()});
            String dsName = VsphereCommUtil.getDatastoreName(vmPath);
            if (!dsName.equals(dataStore.getName())) continue;
            String newVmPath = vmPath.replaceFirst(dataStore.getName(), configDatastore.getTargetDatastoreName());
            virtualMachine.setVmPath(newVmPath);
        }
    }

    protected boolean serialExcuteChildProc(RecoveryProcessorContext context) {
        Set subProcessors = this.getChildProc();
        if (null == subProcessors || subProcessors.isEmpty()) {
            return true;
        }
        ArrayList<RecoveryProcessor> list = new ArrayList<RecoveryProcessor>();
        RecoveryProcessor checkDatastoreSubTask = null;
        for (RecoveryProcessor recoveryProcessor : subProcessors) {
            if (!(recoveryProcessor instanceof CheckDatastoreSubTask)) {
                list.add(recoveryProcessor);
                continue;
            }
            checkDatastoreSubTask = recoveryProcessor;
        }
        list.add(checkDatastoreSubTask);
        DrmEnumDefine.RecoveryPlanExecuteTypeE execType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(list, (DrmEnumDefine.RecoveryPlanExecuteTypeE)execType);
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        logger.debug((Object)"calcProcessResultBySubProc start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    private boolean isOnlyMappingVmRdmDisk(RecoveryProcessorContext context) {
        List vmList = context.getObjects("Target_VM", VsphereVirtualMachine.class);
        List mappingVms = context.getObjects("Rdm_Target_VM", VsphereVirtualMachine.class);
        return CollectionUtils.isEmpty((Collection)vmList) && !CollectionUtils.isEmpty((Collection)mappingVms);
    }
}

