/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigVMIpAddressSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VCenterNicIpInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;

public class ConfigLinuxVMIpAddressSubTask
extends ConfigVMIpAddressSubTask {
    private static final Log logger = LogFactory.getInstance(ConfigLinuxVMIpAddressSubTask.class);

    public ConfigLinuxVMIpAddressSubTask() {
    }

    public ConfigLinuxVMIpAddressSubTask(VsphereVirtualMachine virtualMachine, RecoveryProcessor parentProc) {
        super(virtualMachine, parentProc);
    }

    @Override
    public boolean configVmIpAddr(RecoveryProcessorContext context, Map<String, VCenterNicIpInfo> configMap) {
        String vcenterUuid = (String)context.getAttribute("Target_vCenter");
        String vmMoId = this.getVirtualMachine().getVmMoId();
        String vmName = this.getVirtualMachine().getName();
        String hostName = this.getVirtualMachine().getHostName();
        if (!this.shutdownVm(context)) {
            logger.error((Object)("shutdownVm failed " + vmName), 90160758786989L);
            return false;
        }
        boolean ret = false;
        try {
            VMAction action = new VMAction();
            ret = action.configLinuxVMIp(vcenterUuid, vmMoId, configMap, hostName);
            if (!ret) {
                this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.configiperror", new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
        }
        catch (Exception e) {
            logger.error((Object)"configVmIp failed--->");
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.configiperror", new String[0]);
            return false;
        }
        return ret;
    }
}

