/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigLinuxVMIpAddressSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigUnknowGuestOsIpAddressSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigVMIpAddressSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigWindowsVMIpAddressSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConfigVMIpAddressTask
extends BaseRecoveryProcessor {
    protected static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.";
    protected static final String LINUX_GUEST_FAMILY_KEY = "linuxGuest";
    protected static final String WINDOWS_GUEST_FAMILY_KEY = "windowsGuest";

    protected boolean execute(RecoveryProcessorContext context) {
        List vmList = context.getObjects("Target_VM", VsphereVirtualMachine.class);
        if (VerifyUtil.isEmpty((Collection)vmList)) {
            return this.success();
        }
        Set<RecoveryProcessor> subTasks = this.createSubTask(context);
        this.setChildProc(subTasks);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return this.executeSubProcessor(context);
    }

    private Set<RecoveryProcessor> createSubTask(RecoveryProcessorContext context) {
        List virtualMachineList = context.getObjects("Target_VM", VsphereVirtualMachine.class);
        HashSet<RecoveryProcessor> subTasks = new HashSet<RecoveryProcessor>();
        for (VsphereVirtualMachine vm : virtualMachineList) {
            ConfigVMIpAddressSubTask task = null;
            task = LINUX_GUEST_FAMILY_KEY.equals(vm.getGuestFamily()) ? new ConfigLinuxVMIpAddressSubTask(vm, (RecoveryProcessor)this) : (WINDOWS_GUEST_FAMILY_KEY.equals(vm.getGuestFamily()) ? new ConfigWindowsVMIpAddressSubTask(vm, (RecoveryProcessor)this) : new ConfigUnknowGuestOsIpAddressSubTask(vm, (RecoveryProcessor)this));
            subTasks.add((RecoveryProcessor)task);
        }
        return subTasks;
    }
}

