/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMSnapshotAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;

public class DeleteVMSnapshotSubTask
extends OperateVsphereVmSubTask {
    private static final long serialVersionUID = 1367523723233527083L;
    private static final Log logger = LogFactory.getInstance(DeleteVMSnapshotSubTask.class);
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.task.DeleteVMSnapshotSubTask.";
    private static final String FAILED = "com.huawei.ism.drm.vsphere.recovery.task.DeleteVMSnapshotSubTask.failed";
    private String vcenterUuid;

    public DeleteVMSnapshotSubTask() {
    }

    public DeleteVMSnapshotSubTask(VsphereVirtualMachine vm, RecoveryProcessor parentProc) {
        super(vm, parentProc);
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Object)this.getVm())) {
            logger.error((Object)"vm is null");
            throw new LegoCheckedException(1073947393L);
        }
        String vmMoId = this.getVm().getVmMoId();
        String vmName = this.getVm().getName();
        String dcMoId = this.getVm().getDcMoId();
        String vmPath = this.getVm().getVmPath();
        if (VerifyUtil.isMultiEmpty((Object[])new Object[]{vmMoId, vmName, dcMoId, vmPath})) {
            logger.error((Object)"contain null params.vmMoid:[%s],vmName:[%s],dcMoId:[%s],vmPath:[%s]", new Object[]{vmMoId, vmName, dcMoId, vmPath});
            throw new LegoCheckedException(1073947393L);
        }
        this.vcenterUuid = (String)context.getAttribute("Target_vCenter");
        if (VerifyUtil.isEmpty((String)this.vcenterUuid)) {
            logger.error((Object)"contain null params.vcenterUuid:[%s]", new Object[]{this.vcenterUuid});
            throw new LegoCheckedException(1073947393L);
        }
        VMAction action = new VMAction();
        ManagedObjectReference tempMor = action.findVmByPath(this.vcenterUuid, dcMoId, vmPath);
        if (null == tempMor) {
            logger.info((Object)"Vm[%s] not exist, cannot delete vm Snapshot.", new Object[]{vmName});
            return this.success("ism.drm.recovery.vsphere.vm.unregister.already", new String[]{vmName});
        }
        this.updateProcessNameParams(new String[]{vmName});
        String poId = this.getVm().getUuid();
        boolean preResultSuccess = this.getPoRecoveryStatus(poId);
        if (!preResultSuccess) {
            this.updateProcessDetail(FAILED, new String[]{vmName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        boolean res = this.operateVm(context);
        if (!res) {
            this.updateProcessDetail(FAILED, new String[]{vmName});
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        this.setPoRecoveryStatus(poId);
        return true;
    }

    @Override
    protected boolean operateVm(RecoveryProcessorContext context) {
        return this.deleteVmSnapshot();
    }

    private boolean deleteVmSnapshot() {
        logger.debug((Object)"delete vmware snapshot. vmName:[%s],vcenterUuid:[%s]", new Object[]{this.getVm().getName(), this.vcenterUuid});
        ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.getVm().getVmMoId(), "VirtualMachine");
        VMSnapshotAction snapshotAction = new VMSnapshotAction();
        if (null == vmMor) {
            logger.error((Object)"remove snapshot faild ", 90160758786989L);
            return false;
        }
        boolean revertRet = snapshotAction.removeAllRdSnapshotReferenceOfVM(this.vcenterUuid, vmMor);
        logger.debug((Object)(this.getVm().getName() + "remove snapshot result=" + revertRet), 90160758786988L);
        return revertRet;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }
}

