/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.recovery.task.HandleScsiLunTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class DetachScsiLunSubTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(DetachScsiLunSubTask.class);
    private StorageResource storageResource;
    private VsphereHostSystem hostSystem;

    public DetachScsiLunSubTask() {
    }

    public DetachScsiLunSubTask(RecoveryProcessor parentProc, VsphereHostSystem hostSystem, StorageResource storageResource) {
        this.setParentProc(parentProc);
        this.storageResource = storageResource;
        this.hostSystem = hostSystem;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String lunWwn = this.storageResource.getResourceIndentifier();
        this.updateProcessNameParams(new String[]{lunWwn});
        String paramsInfoStr = HandleScsiLunTask.getHandleParameter(context, this.hostSystem, this.storageResource);
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            logger.debug((Object)"lun has already detached[%s]", new Object[]{paramsInfoStr});
            return this.success();
        }
        try {
            logger.debug((Object)("into execute detachSiciLun, params->" + paramsInfoStr));
            String vcenterUuid = (String)context.getAttribute("Target_vCenter");
            this.doDetachScsiLunInLocal(vcenterUuid);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("detach lun failed, params[%s]:" + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{paramsInfoStr});
            return this.failure(e);
        }
        catch (Exception e) {
            logger.error((Object)("detach lun failed: %s, " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{paramsInfoStr});
            this.updateProcessDetail("ism.drm.recovery.vsphere.lun.unmount.failed", new String[]{lunWwn});
            return this.failure("ism.drm.recovery.vsphere.lun.unmount.failed", new String[]{lunWwn});
        }
        logger.info((Object)"DetachScsiLunSubTask successfully: %s", new Object[]{paramsInfoStr});
        return this.success();
    }

    private void doDetachScsiLunInLocal(String vcenterUuid) {
        HostSystemAction hostAction = new HostSystemAction();
        String lunWwn = this.storageResource.getResourceIndentifier();
        hostAction.unmountScsiLunByWwn(vcenterUuid, this.hostSystem.getHostMoId(), lunWwn);
        logger.debug((Object)("doDetachScsiLunInLocal successful:wwn=" + this.storageResource.getResourceIndentifier()));
    }

    public StorageResource getStorageResource() {
        return this.storageResource;
    }
}

