/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public abstract class OperateVsphereVmSubTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(OperateVsphereVmSubTask.class);
    private VsphereVirtualMachine vm;

    public OperateVsphereVmSubTask() {
    }

    public OperateVsphereVmSubTask(VsphereVirtualMachine vm, RecoveryProcessor parentProc) {
        this.vm = vm;
        this.setParentProc(parentProc);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        String vmUuid = this.vm.getUuid();
        String vmName = this.vm.getName();
        String dcMoId = this.vm.getDcMoId();
        String vmPath = this.vm.getVmPath();
        logger.debug((Object)"Start to operate vm[%s], vmName[%s], dcMoID[%s], vmxFilePath[%s], vCenterUuid[%s]", new Object[]{vmUuid, vmName, dcMoId, vmPath, vCenterUuid});
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.vsphere.vm.already.operated", new String[]{vmName});
            logger.info((Object)"the operation in vm[%s] has been done.", new Object[]{vmName});
            return true;
        }
        try {
            VerifyUtil.checkObjs((Object[])new Object[]{vmUuid, vmName, dcMoId, vmPath, vCenterUuid});
        }
        catch (Exception e) {
            logger.error((Object)"Operate vm failed. parameter: vm[%s], vmName[%s], dcMoID[%s], vmxFilePath[%s], vCenterUuid[%s]", new Object[]{vmUuid, vmName, dcMoId, vmPath, vCenterUuid});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        boolean result = this.operateVm(context);
        logger.info((Object)"Operate vm result: [%s]", new Object[]{result});
        return result;
    }

    public VsphereVirtualMachine getVm() {
        return this.vm;
    }

    public void setVm(VsphereVirtualMachine vm) {
        this.vm = vm;
    }

    protected void setPoRecoveryStatus(String poId) {
        String key = RecoveryProcessResult.getPoRecoveryStatusKey((int)this.getProcType(), (String)poId, (int)DrmEnumDefine.AppType.VM.getValue());
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.getContextRef().getProcessResult().addProcessResult(key, true);
        } else {
            this.getContextRef().getProcessResult().addProcessResult(key, false);
        }
    }

    protected boolean getPoRecoveryStatus(String poId) {
        String key = RecoveryProcessResult.getPoRecoveryStatusKey((int)this.getProcType(), (String)poId, (int)DrmEnumDefine.AppType.VM.getValue());
        return this.getContextRef().getProcessResult().getProcessResult(key);
    }

    protected abstract boolean operateVm(RecoveryProcessorContext var1);
}

