/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class OperateVsphereVmTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(OperateVsphereVmTask.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        List vmList = context.getObjects("Target_VM", VsphereVirtualMachine.class);
        if (VerifyUtil.isEmpty((Collection)vmList)) {
            logger.info((Object)"Operate vm in vCenter, but vm list is empty.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.createOperateVmSubTask(context);
        return this.doExecute(context);
    }

    protected boolean doExecute(RecoveryProcessorContext context) {
        return this.serialExcuteChildProc(context);
    }

    protected void createOperateVmSubTask(RecoveryProcessorContext context) {
        List vmList = context.getObjects("Target_VM", VsphereVirtualMachine.class);
        HashSet<OperateVsphereVmSubTask> subProcessorSet = new HashSet<OperateVsphereVmSubTask>();
        for (VsphereVirtualMachine vm : vmList) {
            OperateVsphereVmSubTask operateVsphereVmSubTask = this.createSubTask(context, vm);
            if (null == operateVsphereVmSubTask) continue;
            this.initProcessor((RecoveryProcessor)operateVsphereVmSubTask);
            subProcessorSet.add(operateVsphereVmSubTask);
        }
        if (subProcessorSet.isEmpty()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        this.setChildProc(subProcessorSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    protected abstract OperateVsphereVmSubTask createSubTask(RecoveryProcessorContext var1, VsphereVirtualMachine var2);
}

