/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.recovery.task.RegisterVMSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.VMwareRecoveryTaskInterceptor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class RegisterVmPostInterceptor
extends VMwareRecoveryTaskInterceptor {
    private static final Log logger = LogFactory.getInstance(RegisterVmPostInterceptor.class);

    public RegisterVmPostInterceptor(BaseRecoveryProcessor processor) {
        super(processor);
    }

    public boolean after() {
        if (null == this.getInterceptTask()) {
            logger.error((Object)"Intercept task is null.");
            throw new LegoCheckedException(2117645L);
        }
        logger.debug((Object)"After processor execute method is called. processor is %s", new Object[]{this.getInterceptTask().getClass()});
        RecoveryProcessorContext context = this.getInterceptTask().getContextRef();
        if (null == context) {
            logger.error((Object)"Recovery context of intercept task is null.");
            throw new LegoCheckedException(2117645L);
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan) {
            logger.error((Object)"Connot find recovery plan from recovery context.");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)context.getRecoveryPlan().getProtectGroups());
        if (null == pg) {
            logger.error((Object)"Protect group of recovery plan is null, recoveryPlan's uuid: %s.", new Object[]{recoveryPlan.getUuid()});
            throw new LegoCheckedException(2117645L);
        }
        logger.info((Object)"Updating protect group %s after register vm(s).", new Object[]{pg.getUuid()});
        ProtectGroup protectGroupInDb = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pg.getUuid(), false);
        if (null == protectGroupInDb) {
            logger.error((Object)"Protect group which queried from database is null, pg's uuid: %s.", new Object[]{pg.getUuid()});
            throw new LegoCheckedException(2117645L);
        }
        List registerVmProcesses = BaseRecoveryProcessor.getRecoveryPlanRecoveryProcessors((RecoveryPlan)recoveryPlan, (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)Integer.parseInt(this.getRefProcType())), RegisterVMSubTask.class);
        logger.info((Object)"Register vm size: %s", new Object[]{String.valueOf(registerVmProcesses.size())});
        block0: for (RecoveryProcessor processor : registerVmProcesses) {
            if (!(processor instanceof RegisterVMSubTask)) continue;
            RegisterVMSubTask task = (RegisterVMSubTask)processor;
            String vmMoId = task.getVmMoId();
            String vmName = task.getVmName();
            logger.info((Object)"Registered vm info, VmMoId: %s, VmName: %s.", new Object[]{vmMoId, vmName});
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != processor.getProcStatus()) {
                logger.info((Object)"Register vm[%s] sub task failed, do not need to unregister.", new Object[]{vmName});
                continue;
            }
            for (ProtectObject protectObject : protectGroupInDb.getPolist()) {
                logger.info((Object)"Protect object info, name: %s, moUuid: %s", new Object[]{protectObject.getName(), protectObject.getMoUuid()});
                if (!protectObject.getName().equals(vmName) || VerifyUtil.isEmpty((String)vmMoId)) continue;
                String vCenterUuid = (String)context.getAttribute("Target_vCenter");
                String newMoUuid = vCenterUuid + ":" + vmMoId;
                protectObject.setMoUuid(newMoUuid);
                logger.info((Object)"update protect object: %s, moUuid: %s", new Object[]{vmName, newMoUuid});
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectObject);
                continue block0;
            }
        }
        return super.after();
    }
}

