/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.recovery.task.UmountDatastoreSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UmountDatastoreTask
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(UmountDatastoreTask.class);

    public void beforeExecRecoveryProcessor() {
        super.beforeExecRecoveryProcessor();
        RecoveryProcessorContext context = this.getContextRef();
        Map moIdOfSelectedDatastore = (Map)context.getAttribute("datastoreChangeMap");
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue() == this.getProcType()) {
            this.updateTargetDatastore(moIdOfSelectedDatastore);
        }
    }

    private void updateTargetDatastore(Map<String, String> moIdOfSelectedDatastore) {
        if (VerifyUtil.isEmpty(moIdOfSelectedDatastore)) {
            return;
        }
        Collection<String> newDatastoreUuIds = moIdOfSelectedDatastore.values();
        if (VerifyUtil.isEmpty(newDatastoreUuIds)) {
            return;
        }
        LOGGER.info((Object)"ready to update target datastore with mounted datastore moId: %s", new Object[]{moIdOfSelectedDatastore});
        RecoveryProcessorContext context = this.getContextRef();
        DataStoreAction datastoreFinder = new DataStoreAction();
        Set<String> newDatastoreUuIdSet = newDatastoreUuIds.stream().map(GetMoPropsValueUtils.getInstance()::getMoid).collect(Collectors.toSet());
        List<VsphereDataStore> newDataStoreList = datastoreFinder.getDsByMoIds((String)context.getAttribute("Target_vCenter"), newDatastoreUuIdSet);
        newDataStoreList.forEach(datastore -> datastore.setUuid(datastore.getUrl().substring("ds:///vmfs/volumes/".length(), datastore.getUrl().length() - 1)));
        context.setAttribute("Target_Datastore", newDataStoreList);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        List dataStoreList = context.getObjects("Target_Datastore", VsphereDataStore.class);
        if (null == dataStoreList || dataStoreList.isEmpty()) {
            LOGGER.info((Object)"Cannot find datastore from recovery context");
            return this.success();
        }
        Set<RecoveryProcessor> subTasks = this.createSubTask(context);
        this.setChildProc(subTasks);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return this.executeSubProcessor(context);
    }

    private Set<RecoveryProcessor> createSubTask(RecoveryProcessorContext context) {
        List dataStoreList = context.getObjects("Target_Datastore", VsphereDataStore.class);
        HashSet<RecoveryProcessor> subTasks = new HashSet<RecoveryProcessor>();
        for (VsphereDataStore dataStore : dataStoreList) {
            UmountDatastoreSubTask task = new UmountDatastoreSubTask(dataStore, (RecoveryProcessor)this);
            subTasks.add((RecoveryProcessor)task);
        }
        return subTasks;
    }
}

