/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task.disaster;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.recovery.framework.process.BeginRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Set;

public class DisasterRecoveryPrepareTask
extends BeginRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(DisasterRecoveryPrepareTask.class);

    public void beforeExecRecoveryProcessor() {
        this.setRecoveryVirtualMachineMetadata(this.getContextRef());
        super.beforeExecRecoveryProcessor();
    }

    private boolean setRecoveryVirtualMachineMetadata(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        Set protectObjectReplicaSet = replica.getReplicas();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaSet) {
            String protectObjectUuid = protectObjectReplica.getPoId();
            if (null == protectObjectUuid) {
                logger.error((Object)"Protect object uuid is not set in the protect object replica");
                return false;
            }
            ProtectObject po = protectGroup.getPolist().stream().filter(protectObject -> protectObjectUuid.equals(protectObject.getUuid())).findFirst().orElse(null);
            if (null == po) {
                logger.error((Object)"ProtectObject uuid is null in the protect obejct replica");
                return false;
            }
            protectObjectReplica.setProtectObject(po);
        }
        return true;
    }
}

