/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.utils;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.protect.action.ProtectVsphereVMSnapshotUtils;
import com.huawei.ism.drm.vsphere.recovery.process.VsInitVmSubProcessor;
import com.huawei.ism.drm.vsphere.sdk.model.RecoveryNetwork;
import com.huawei.ism.drm.vsphere.sdk.model.VmDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsNetWork;
import com.huawei.ism.drm.vsphere.sdk.model.VsVirtualEthernetCard;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;

public final class VsphereRecoveryUtils {
    public static final String STOP_VM_URI = "/ws/vcenters/{vcenterId}/action/stopVm?planId={planId}&vmSn={vmSn}";
    public static final String REMOVE_NAS_DS_URI = "/ws/vcenters/{vcenterUuid}/action/removeNasDatastore?compResUuid={compResUuid}&dsUuid={dsUuid}&dsName={dsName}";
    public static final String UNMOUNT_DS_URI = "/ws/vcenters/{vcenterId}/action/unmountDatastore?planId={planId}&datastoreSn={datastoreSn}";
    public static final String DETACH_LUN_URI = "/ws/vcenters/{vcenterId}/action/unmountScsiLun?planId={planId}&lunWwn={lunWwn}&hostSn={hostSn}";
    public static final String GET_COMPRESOURCE_BY_VCENTERUUID = "/ws/vcenters/{vCenterUuid}/action/getAllHostOrCluster";
    public static final String GET_REMOTENETWORKS = "/ws/vcenters/networks?vcenterUuid={vcenterUuid}&hostOrClusterId={hostOrClusterId}";
    public static final String GET_AVAILABLE_VMS = "/ws/vcenters/vms/action/getCriticalVm?vcenterUuid={vcenterUuid}&hostOrClusterId={hostOrClusterId}";
    private static final String UNKNOWN_GUEST_FAMILY_KEY = "UNKNOW";
    private static final String GUEST_FAMILY_KEY = "GUESTOSTYPE";
    private static final String HOSTNAME_KEY = "GUESTHOSTNAME";
    private static final Log logger = LogFactory.getInstance(VsphereRecoveryUtils.class);
    private static final VsphereRecoveryUtils INSTANCE = new VsphereRecoveryUtils();

    private VsphereRecoveryUtils() {
    }

    public static VsphereRecoveryUtils getInstance() {
        return INSTANCE;
    }

    public static Map<String, VsNetWork> getOneVMNetWork(ProtectObject po, String networkSetting) {
        String vmNetCardsInfo = (String)po.getProps().get("VirtualEthernetCard");
        JSONArray vmNetCfgJsonArr = JSONArray.fromObject((Object)vmNetCardsInfo);
        JSONArray hostNetMapJsonArr = JSONArray.fromObject((Object)networkSetting);
        HashMap<String, VsNetWork> vmNetworkMap = new HashMap<String, VsNetWork>();
        for (int i = 0; i < vmNetCfgJsonArr.size(); ++i) {
            JSONObject vmNetCfgJson = vmNetCfgJsonArr.getJSONObject(i);
            if (!vmNetCfgJson.containsKey((Object)"ethernetCardName")) {
                logger.error((Object)"ethernetCardName did not exist");
                throw new LegoCheckedException(1073947393L);
            }
            String vmNetName = vmNetCfgJson.getString("ethernetCardName");
            if (!vmNetCfgJson.containsKey((Object)"netWorkUuid")) {
                logger.error((Object)"netWorkUuid did not exist");
                throw new LegoCheckedException(1073947393L);
            }
            String hostNetUuid = vmNetCfgJson.getString("netWorkUuid");
            VsNetWork remoteNetwork = VsphereRecoveryUtils.getRemoteNetwork(hostNetMapJsonArr, hostNetUuid);
            vmNetworkMap.put(vmNetName, remoteNetwork);
        }
        return vmNetworkMap;
    }

    private static VsNetWork getRemoteNetwork(JSONArray jsonArray, String hostNetUuid) {
        logger.debug((Object)"getRemoteNetwork start");
        VsNetWork network = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            if (!json.containsKey((Object)"srcNetworkId")) {
                logger.error((Object)"srcNetworkId did not exist");
                throw new LegoCheckedException(1073947393L);
            }
            String srcNetUuid = json.getString("srcNetworkId");
            if (!hostNetUuid.equals(srcNetUuid)) continue;
            String remoteNetworkId = json.getString("remoteNetworkId");
            network = (VsNetWork)CommonDAOLocator.getMoDao().getMo(VsNetWork.class, "uuid", (Object)remoteNetworkId);
            break;
        }
        return network;
    }

    public static boolean optNetAutoConn(List<RecoveryProcessor> processors, RecoveryProcessorContext contextRef, int procType, String vcenterUuid, boolean isAuto) {
        ProtectGroup protectGroup = RecoveryToolsUtil.getInstance().getHistoryProtectGroupFromContext(contextRef);
        Set pos = protectGroup.getPolist();
        HashMap<String, ProtectObject> uuidAndPoMap = new HashMap<String, ProtectObject>();
        for (ProtectObject protectObject : pos) {
            uuidAndPoMap.put(protectObject.getUuid(), protectObject);
        }
        RecoveryPlan plan = contextRef.getRecoveryPlan();
        VMAction action = new VMAction();
        boolean disableAutoConn = true;
        String key = "";
        if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()) {
            key = "testNetwork";
        } else if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            key = "recoveryNetwork";
        }
        for (RecoveryProcessor proc : processors) {
            VsInitVmSubProcessor initSubProc = (VsInitVmSubProcessor)proc;
            if (initSubProc.isTemplateFlag()) continue;
            ProtectObject po = (ProtectObject)uuidAndPoMap.get(initSubProc.getPoId());
            if (null == po) {
                logger.error((Object)"po is empty");
                throw new LegoCheckedException(1073947393L);
            }
            String networkSetting = (String)plan.getGlobalSettings().get(key);
            if (!VerifyUtil.isEmpty((String)networkSetting)) {
                Map<String, VsNetWork> vmNetworkMap = VsphereRecoveryUtils.getOneVMNetWork(po, networkSetting);
                boolean bl = disableAutoConn = disableAutoConn && action.configVMNetWorks(vcenterUuid, initSubProc.getVmMoId(), vmNetworkMap, isAuto);
            }
            if (disableAutoConn) continue;
            logger.error((Object)("opt Auto connect failed ,  opt type : " + isAuto + "po name : " + po.getName()));
            return disableAutoConn;
        }
        return disableAutoConn;
    }

    public static Map<String, VsNetWork> buildRecoveryNetworkInfo(VsphereVirtualMachine virtualMachine, RecoveryProcessorContext context) {
        String key = (String)context.getAttribute("recoverynetworktype");
        logger.debug((Object)"Recovery Network type is %s", new Object[]{key});
        RecoveryPlan plan = context.getRecoveryPlan();
        String networkSetting = (String)plan.getProperty(key, String.class);
        Collection recoveryNetworks = plan.getProperties(key, RecoveryNetwork.class);
        String vmName = virtualMachine.getName();
        if (VerifyUtil.isEmpty((Collection)recoveryNetworks)) {
            logger.error((Object)(vmName + " get net configuration failed "), 90160758786989L);
            return null;
        }
        logger.info((Object)"Virtaul machine[%s] recovery network is %s", new Object[]{vmName, networkSetting});
        Map<String, VsNetWork> vmNetworkMap = VsphereRecoveryUtils.buildNetWorkInfo(virtualMachine, recoveryNetworks);
        return vmNetworkMap;
    }

    public static Map<String, String> buildRecoveryMacInfo(VsphereVirtualMachine virtualMachine) {
        HashMap<String, String> vmNetworkMap = new HashMap<String, String>();
        Collection list = virtualMachine.getVirtualEthernetCardList();
        for (VsVirtualEthernetCard vsVirtualEthernetCard : list) {
            vmNetworkMap.put(vsVirtualEthernetCard.getEthernetCardName(), vsVirtualEthernetCard.getMacAddress());
        }
        return vmNetworkMap;
    }

    public static boolean getKeepMacParam(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Map globalSettings = recoveryPlan.getGlobalSettings();
        if (globalSettings.containsKey("keepMac")) {
            return Boolean.parseBoolean((String)globalSettings.get("keepMac"));
        }
        return false;
    }

    private static Map<String, VsNetWork> buildNetWorkInfo(VsphereVirtualMachine virtualMachine, Collection<RecoveryNetwork> recoveryNetworks) {
        Collection vmNetCardsInfo = virtualMachine.getVirtualEthernetCardList();
        HashMap<String, VsNetWork> vmNetworkMap = new HashMap<String, VsNetWork>();
        for (VsVirtualEthernetCard virtualEthernetCard : vmNetCardsInfo) {
            String vmNetworAdapaterName = virtualEthernetCard.getEthernetCardName();
            String hostNetUuid = virtualEthernetCard.getNetWorkUuid();
            VsNetWork remoteNetwork = VsphereRecoveryUtils.getRecoveryNetwork(recoveryNetworks, hostNetUuid);
            vmNetworkMap.put(vmNetworAdapaterName, remoteNetwork);
        }
        return vmNetworkMap;
    }

    private static VsNetWork getRecoveryNetwork(Collection<RecoveryNetwork> recoveryNetworks, String hostNetUuid) {
        logger.debug((Object)"getRemoteNetwork hostNetUuid=%s", new Object[]{hostNetUuid});
        VsNetWork network = null;
        for (RecoveryNetwork recoveryNetwork : recoveryNetworks) {
            String srcNetUuid = recoveryNetwork.getSrcNetworkId();
            if (!hostNetUuid.equals(srcNetUuid)) continue;
            String remoteNetworkId = recoveryNetwork.getRemoteNetworkId();
            network = (VsNetWork)CommonDAOLocator.getMoDao().getMo(VsNetWork.class, "uuid", (Object)remoteNetworkId);
            break;
        }
        return network;
    }

    public List<StorageResource> getStorageResourceByDsg(String dsgId) {
        VirtualDataStoreGroup dataStoreGroup = (VirtualDataStoreGroup)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(VirtualDataStoreGroup.class, (Serializable)((Object)dsgId));
        ArrayList<StorageResource> result = new ArrayList<StorageResource>();
        if (null == dataStoreGroup) {
            return result;
        }
        Set vmUuidSet = dataStoreGroup.getVmUuidSet();
        List<VmDataStore> vmDataStores = this.getVmDataStorageInfoByVmuuids(vmUuidSet);
        if (VerifyUtil.isEmpty(vmDataStores)) {
            return result;
        }
        HashSet<String> lunWwns = new HashSet<String>();
        HashSet nfsWwn = new HashSet();
        for (VmDataStore vmStorageInfo : vmDataStores) {
            String[] lunValue = vmStorageInfo.getId().getLunWwn().split(":");
            if (lunValue.length == 2) {
                List nasFileSystems;
                if (nfsWwn.contains(vmStorageInfo.getId().getLunWwn()) || VerifyUtil.isEmpty((Collection)(nasFileSystems = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getFileSystemsByNFSShare(lunValue[0], lunValue[1], false)))) continue;
                result.addAll(nasFileSystems);
                continue;
            }
            lunWwns.add(vmStorageInfo.getId().getLunWwn());
        }
        if (VerifyUtil.isEmpty(lunWwns)) {
            return result;
        }
        List<Lun> luns = this.getLunByWwns(lunWwns);
        if (null != luns) {
            result.addAll(luns);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Lun> getLunByWwns(Set<String> lunWwns) {
        List luns = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String hqls = "from Lun where wwn in (:wwns)";
            luns = session.createQuery(hqls).setParameterList("wwns", lunWwns).list();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("query lun error.wwn is " + lunWwns.toString() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return luns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VmDataStore> getVmDataStorageInfoByVmuuids(Set<String> vmUuidSet) {
        Session session = null;
        List vmDataStores = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String hqls = "from VmDataStore as vds where vds.id.vmUuid in (:uuids)";
            vmDataStores = session.createQuery(hqls).setParameterList("uuids", vmUuidSet).list();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("query datastore error.vms is " + vmUuidSet.toString() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return vmDataStores;
    }

    public String sendRestToRemoteSite(Site remoteSite, String restUri, Map<String, Object> params) {
        String result;
        if (null == remoteSite || VerifyUtil.isEmpty((String)restUri) || null == params) {
            throw new LegoCheckedException(1073947393L);
        }
        RestClient client = SiteUtil.initClient((Site)remoteSite);
        logger.debug((Object)("sended request " + params.keySet()), 90160758786988L);
        try {
            result = client.invoke(restUri, params, HttpMethod.PUT);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"lego exception when sending rest request to prod site", (Throwable)e, -1L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"exception when sending rest request to prod site", (long)-1L, null, (Log)logger);
            result = "";
        }
        return result;
    }

    public String getInfoFromRemoteSite(Site remoteSite, String restUri, Map<String, Object> params) {
        if (null == remoteSite || VerifyUtil.isEmpty((String)restUri) || null == params) {
            throw new LegoCheckedException(1073947393L);
        }
        RestClient client = SiteUtil.initClient((Site)remoteSite);
        logger.debug((Object)("sended request " + params.keySet()), 90160758786988L);
        String result = "";
        try {
            result = client.invoke(restUri, params, HttpMethod.GET);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"lego exception when sending rest request to prod site", (Throwable)e, -1L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"exception when sending rest request to prod site", (long)-1L, null, (Log)logger);
        }
        return result;
    }

    public Site getProductSite(RecoveryProcessorContext context) {
        RecoveryPlan rp = context.getRecoveryPlan();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        String prodSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)rp);
        Site prodSite = siteService.getSiteById(prodSiteId);
        return prodSite;
    }

    public String getDisVcenterUuid(RecoveryProcessorContext context, int procType) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        VirtualizationCommonUtil util = VirtualizationCommonUtil.getInstance();
        ProtectGroup pg = (ProtectGroup)util.getElementFromCollection((Collection)recoveryPlan.getProtectGroups());
        if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
            return pg.getPoProviderSN();
        }
        RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)pg.getUuid(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
        return setting.getValue();
    }

    public boolean isDeviceInSite(String deviceSn, String siteId) {
        if (VerifyUtil.isEmpty((String)deviceSn) || VerifyUtil.isEmpty((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        List drResources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where deviceSn=?", new Object[]{deviceSn});
        if (VerifyUtil.isEmpty((Collection)drResources)) {
            logger.error((Object)("device is not registed in site, sn=" + deviceSn), 90160758787071L);
            return false;
        }
        return siteId.equals(((DrResource)drResources.get(0)).getSiteId());
    }

    public int getBatchStartCeiling(boolean isCluster) {
        int startNumOnHost = (int)LegoConfig.getInstance().getNumber("recovery.host.batchstartvmnum", 4L);
        int startNumOnCluster = (int)LegoConfig.getInstance().getNumber("recovery.cluster.batchstartvmnum", 24L);
        startNumOnHost = 0 == startNumOnHost ? 4 : startNumOnHost;
        startNumOnCluster = 0 == startNumOnHost ? 24 : startNumOnCluster;
        return isCluster ? startNumOnCluster : startNumOnHost;
    }

    public Boolean isPoNeedStart(String poId, RecoveryPlan plan) {
        RecoverySetting startSetting = RecoveryUtil.getRecoverySetting((String)plan.getPlanId(), (String)poId, (String)"isStart", (Set)plan.getRecoverySettings());
        Boolean startedFlag = true;
        if (!VerifyUtil.isEmpty((Object)startSetting)) {
            startedFlag = Boolean.valueOf(startSetting.getValue());
        }
        return startedFlag;
    }

    public JSONObject getWindowsVmAuthJson(String poId, RecoveryPlan plan) {
        JSONObject osObj = new JSONObject();
        RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)plan.getPlanId(), (String)poId, (String)"PO_OS_NAMEPASSWORD", (Set)plan.getRecoverySettings());
        if (!VerifyUtil.isEmpty((Object)setting)) {
            try {
                osObj = JSONObject.fromObject((Object)setting.getValue());
            }
            catch (Exception e) {
                logger.error((Object)("Fail to parse JSON String." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
        return osObj;
    }

    public boolean isVmHasSnapShotConfig(RecoveryProcessorContext context) {
        PolicyTemplate template = context.getProtectGroup().getTemplate();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        boolean hasVmSnap = false;
        if (null == replica) {
            logger.debug((Object)"replica is not found.", 90160758786989L);
            return hasVmSnap;
        }
        hasVmSnap = ProtectVsphereVMSnapshotUtils.isNeedHandleVMSnapshot(replica, template);
        return hasVmSnap;
    }

    public void resetProtectObjectAfterRefresh(RecoveryProcessorContext context, int procType, int appType) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(context.getProtectGroup().getUuid(), false);
        RecoveryToolsUtil.getInstance().resetProtectObject(context, procType, appType, pg);
        this.resetVirtualMachineInfo(context, pg);
    }

    private void resetVirtualMachineInfo(RecoveryProcessorContext context, ProtectGroup pg) {
        Set protectObjects = context.getRecoveryProtectObjects();
        if (VerifyUtil.isEmpty((Collection)protectObjects)) {
            logger.error((Object)"protectObjects in replica is empty.");
            return;
        }
        HashMap<String, ProtectObject> oldProtectObjectMap = new HashMap<String, ProtectObject>();
        for (ProtectObject object : protectObjects) {
            oldProtectObjectMap.put(object.getUuid(), object);
        }
        for (ProtectObject protectObject : pg.getPolist()) {
            String hostName;
            ProtectObject oldProtectObject = (ProtectObject)oldProtectObjectMap.get(protectObject.getUuid());
            String guestFamily = protectObject.getProperty(GUEST_FAMILY_KEY);
            if (UNKNOWN_GUEST_FAMILY_KEY.equals(guestFamily) || VerifyUtil.isEmpty((String)guestFamily)) {
                this.setNewPropertyValue(GUEST_FAMILY_KEY, oldProtectObject, protectObject);
            }
            if (!VerifyUtil.isEmpty((String)(hostName = protectObject.getProperty(HOSTNAME_KEY)))) continue;
            this.setNewPropertyValue(HOSTNAME_KEY, oldProtectObject, protectObject);
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)pg);
    }

    private void setNewPropertyValue(String key, ProtectObject oldProtectObject, ProtectObject newProtectObject) {
        if (null == oldProtectObject) {
            return;
        }
        String value = oldProtectObject.getProperty(key);
        if (!VerifyUtil.isEmpty((String)value)) {
            newProtectObject.setProperty(key, (Object)value);
        }
    }
}

