/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.topology;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.topo.sdk.poll.ITopoPoller;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoPollerManager", properties="type:topoPoller-vsphere")
public class TopovSpherePoller
implements ITopoPoller {
    private final Log logger = LogFactory.getInstance(TopovSpherePoller.class);

    public void pollResource(String sourceSn) {
        if (VerifyUtil.isEmpty((String)sourceSn)) {
            this.logger.warn((Object)"sn is empty.", 90160758787071L);
            return;
        }
        VsphereCenter vc = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)sourceSn);
        if (null == vc) {
            this.logger.warn((Object)("vcenter(" + sourceSn + ") is null."), 90160758787071L);
            return;
        }
        try {
            this.updateEsxHost(vc.getUuid(), vc);
        }
        catch (Exception e) {
            this.logger.error((Object)("update Esx Host error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateEsxStatusUnKnown(vc.getMoId());
        }
    }

    public void pollResource(String ipAddress, String port) {
    }

    public String getResourceType() {
        return "vsphere";
    }

    public String getResourceSN() {
        return null;
    }

    private void updateEsxHost(String vcenterUuid, VsphereCenter vCenter) {
        HostSystemAction hostSystemAction = new HostSystemAction();
        List<VsphereHostSystem> hosts = hostSystemAction.queryAllHosts(vcenterUuid);
        if (VerifyUtil.isEmpty(hosts)) {
            return;
        }
        List existHosts = CommonDAOLocator.getMoDao().getAllSubMo(vCenter.getMoId().longValue(), VsphereHostSystem.class);
        ArrayList<VsphereHostSystem> updateList = new ArrayList<VsphereHostSystem>();
        block0: for (VsphereHostSystem host : hosts) {
            for (VsphereHostSystem existHost : existHosts) {
                if (!host.getUuid().equals(existHost.getUuid()) || 0 == existHost.getHealthStatus().compareTo(host.getHealthStatus()) && 0 == existHost.getStatus().compareTo(host.getStatus())) continue;
                existHost.setHealthStatus(host.getHealthStatus());
                existHost.setStatus(host.getStatus());
                updateList.add(existHost);
                continue block0;
            }
        }
        if (VerifyUtil.isEmpty(updateList)) {
            return;
        }
        hosts.clear();
        existHosts.clear();
        CommonDAOLocator.getMoDao().saveOrUpdateMoList(updateList);
    }

    private void updateEsxStatusUnKnown(Long vcMoid) {
        List existHosts = CommonDAOLocator.getMoDao().getAllSubMo(vcMoid.longValue(), VsphereHostSystem.class);
        if (VerifyUtil.isEmpty((Collection)existHosts)) {
            return;
        }
        for (VsphereHostSystem existHost : existHosts) {
            existHost.setStatus(Integer.valueOf(4));
        }
        ArrayList updateList = new ArrayList();
        updateList.addAll(existHosts);
        existHosts.clear();
        try {
            CommonDAOLocator.getMoDao().saveOrUpdateMoList(updateList);
        }
        catch (Exception e) {
            this.logger.error((Object)("update Esx Host status unkonwn error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }
}

