/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.topology;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.topo.builder.AbstractTopoBuilder;
import com.huawei.ism.drm.topo.element.SiteElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.skin.LinkFromAtLeftSkin;
import com.huawei.ism.drm.topo.skin.Theme;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.drm.vsphere.sdk.model.DrVsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.drm.vsphere.topo.sdk.element.DataStoreElement;
import com.huawei.ism.drm.vsphere.topo.sdk.element.VCenterElement;
import com.huawei.ism.drm.vsphere.topo.sdk.element.VMElement;
import com.huawei.ism.drm.vsphere.topology.model.LunTopoInfo;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.IData;
import com.huawei.twaver.IElement;
import com.huawei.twaver.Node;
import com.huawei.twaver.SubNetwork;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:ProtectGroup-10")
public class VsphereTopoBuilder
extends AbstractTopoBuilder {
    private static final Log logger = LogFactory.getInstance(VsphereTopoBuilder.class);
    private static final String APP_TYPE_LABEL = "vCenter";
    private static final int SUB_NETWORK_FILL_CORLOR = 0xF1F1FF;
    private static final int SUB_NETWORK_LABEL_CORLOR = 35020;
    private static final double VCENTER_INNER_LEFT_GAP = 11.0;
    private static final double VCENTER_INNER_TOP_GAP = 11.0;
    private static final double VCENTER_INNER_SONS_GAP = 11.0;
    private static final List<Integer> SAN_ACTIVE_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(15, 18, 23, 28, 19, 26, 31, 32));
    private static final List<Integer> HYPER_METRO_REPLICATION_RING = Arrays.asList(26);
    private Site productSite;
    private final Map<String, SubNetwork> dataStoreNetMap = new HashMap<String, SubNetwork>();
    private final Map<String, LunTopoInfo> lunInfos = new HashMap<String, LunTopoInfo>();

    public void buildTopo(TopoBaseContext context) {
        VCenterElement vcenterNode;
        logger.debug((Object)"Vsphere protect group  topo builder starts to build", 90160758786988L);
        this.dataStoreNetMap.clear();
        this.lunInfos.clear();
        this.initialize(context);
        ProtectGroup protectGroup = context.getProtectGroup();
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            return;
        }
        String productSiteId = protectGroup.getProductSiteId();
        this.productSite = context.getSiteService().getSiteById(productSiteId);
        this.prepareLunTopoData(context);
        ArrayList<String> siteIdList = new ArrayList<String>();
        Node productSiteNode = this.generateProductSiteNode(context, siteIdList);
        context.addChild((IData)context.getRootNode(), (IData)productSiteNode);
        String vcenterSN = protectGroup.getPoProviderSN();
        DrResource drResource = this.getDrResource(vcenterSN);
        if (drResource == null) {
            return;
        }
        VCenterElement fatherNode = vcenterNode = new VCenterElement((DrVsphereCenter)drResource);
        context.addChild((IData)productSiteNode, (IData)vcenterNode);
        Node poStyleNode = TopoServiceUtil.createProtectObjStyleNode((TopoBaseContext)context, (String)APP_TYPE_LABEL, (String)(vcenterSN + this.getTopoType()));
        poStyleNode.setStyle("vector.fill", false);
        poStyleNode.setName(null);
        poStyleNode.setStyle("vector.outline.alpha", 0.0);
        poStyleNode.setClient("leftGap", 11.0);
        poStyleNode.setClient("topGap", 11.0);
        poStyleNode.setClient("sonsGap", 11.0);
        context.addChild((IData)vcenterNode, (IData)poStyleNode);
        this.generatePoNodes(context, (Node)fatherNode, poStyleNode, siteIdList);
        this.dataStoreNetMap.clear();
        this.lunInfos.clear();
    }

    private void prepareLunTopoData(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        Set poSet = protectGroup.getPolist();
        for (ProtectObject po : poSet) {
            Set hostStorageInfoSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo hostStorageInfo : hostStorageInfoSet) {
                LunTopoInfo info = new LunTopoInfo();
                info.setLunId(hostStorageInfo.getResourceId());
                info.setLunWwn(hostStorageInfo.getLunWWN());
                info.setDevSn(hostStorageInfo.getResourceProviderSN());
                this.lunInfos.put(hostStorageInfo.getLunWWN(), info);
            }
        }
    }

    private Node generateProductSiteNode(TopoBaseContext context, List<String> siteIdList) {
        int protectTemplateType = this.getProtectTemplateType(context.getProtectGroup());
        if (SAN_ACTIVE_TEMPLATE_TYPE_LIST.contains(protectTemplateType) || PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(protectTemplateType) && ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)context.getProtectGroup())) {
            ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)((ProtectObject)context.getProtectGroup().getPolist().iterator().next()).getUsedStorageResourceSet().iterator().next();
            siteIdList.addAll(this.getHyperMetroSiteIds(context, poStorageInfo));
            this.productSite.setSiteId(this.productSite.getSiteId() + ":hypermetro");
            SiteElement productSiteNode = new SiteElement(this.productSite);
            productSiteNode.setStyle("vector.fill", false);
            productSiteNode.setName(null);
            productSiteNode.setToolTip(null);
            productSiteNode.setStyle("vector.outline.alpha", 0.0);
            return productSiteNode;
        }
        return new SiteElement(this.productSite);
    }

    private void generatePoNodes(TopoBaseContext context, Node fatherNode, Node poStyleNode, List<String> siteIdList) {
        ProtectGroup protectGroup = context.getProtectGroup();
        Set poSet = protectGroup.getPolist();
        Map dataMap = new HashMap();
        int protectTemplateType = this.getProtectTemplateType(context.getProtectGroup());
        if (DrmEnumDefine.ResourceTypeE.NAS.getValue() == this.getStorageResourceType(protectGroup) && SAN_ACTIVE_TEMPLATE_TYPE_LIST.contains(protectTemplateType)) {
            dataMap = this.getHyperMetroPairMap(context, protectGroup);
        }
        for (ProtectObject po : poSet) {
            String poMoUuid = po.getMoUuid();
            VMElement poNode = new VMElement((Object)("vm:" + poMoUuid), po);
            TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)poNode);
            Node poStyleNodeOfDataStore = this.createDiskGroupStyleNode(context, poNode.getID().toString(), poStyleNode);
            String netWorkId = "subNetwork:more:" + poMoUuid;
            SubNetwork subNetwork = this.dataStoreNetMap.get(poMoUuid);
            if (null == subNetwork) {
                subNetwork = new SubNetwork((Object)netWorkId);
                this.initSubNetwork(subNetwork);
                this.dataStoreNetMap.put(poMoUuid, subNetwork);
            }
            if (poStyleNodeOfDataStore.getChildren().size() == 2) {
                context.addChild((IData)poStyleNodeOfDataStore, (IData)subNetwork);
                context.setSubNetWork(true);
            }
            if (poStyleNodeOfDataStore.getChildren().size() < 2) {
                poStyleNodeOfDataStore.addChild((IData)poNode);
                poNode.setLayerID((Object)"layer0");
                VMElement node = new VMElement((Object)("vminnetwork:" + poMoUuid), po);
                subNetwork.addChild((IData)node);
            } else {
                subNetwork.addChild((IData)poNode);
                poNode.setLayerID((Object)"layer0");
            }
            Set hostStorageInfoSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo hostStorageInfo : hostStorageInfoSet) {
                String pairId = (String)dataMap.get(this.getUuidKey(hostStorageInfo));
                this.buildHostStorageTopo(context, pairId, fatherNode, (Node)poNode, hostStorageInfo, siteIdList);
            }
        }
    }

    private Node createDiskGroupStyleNode(TopoBaseContext context, String hostSN, Node poStyleNode) {
        String nodeID = hostSN + ":poStyle";
        Node group = (Node)context.getElementBox().getElementByID((Object)nodeID);
        if (group == null) {
            group = TopoServiceUtil.createGroupStyleNode((String)nodeID);
            group.setClient("leftGap", 11.0);
            group.setClient("topGap", 11.0);
            group.setClient("sonsGap", 7.0);
            context.addChild((IData)poStyleNode, (IData)group);
        }
        Theme.GRAY.apply((IElement)group);
        return group;
    }

    private void initSubNetwork(SubNetwork subNetwork) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        subNetwork.setName(resourceManager.getText("ism.drm.topo.subnetwork.seemore"));
        subNetwork.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        subNetwork.setStyle("label.color", 35020);
        subNetwork.setStyle("label.bold", false);
        subNetwork.setClient("layout", (Object)"leftright");
        subNetwork.setClient("leftGap", (Object)10.0);
        subNetwork.setClient("topGap", (Object)10.0);
        subNetwork.setClient("sonsGap", (Object)15.0);
        subNetwork.setStyle("content.type", (Object)"vector");
        subNetwork.setStyle("label.position", (Object)"bottom.top");
        subNetwork.setClient("TopoModel", (Object)"StyleGroup");
        subNetwork.setStyle("vector.shape", (Object)"roundrect");
        subNetwork.setStyle("vector.fill.color", 0xFCFCFC);
        subNetwork.setStyle("background.type", (Object)"vector");
        subNetwork.setStyle("background.vector.fill.color", 0xF1F1FF);
        subNetwork.setStyle("select.style", (Object)"none");
        subNetwork.setLayerID((Object)"layer0");
        subNetwork.setToolTip(resourceManager.getText("ism.drm.topo.subnetwork.doubleclick.seemore"));
    }

    protected void buildHostStorageTopo(TopoBaseContext context, String pairId, Node fatherNode, Node poNode, ProtectObjectStorageInfo hostStorageInfo, List<String> siteIdList) {
        ProtectGroup pg = context.getProtectGroup();
        String vcenterSN = pg.getPoProviderSN();
        Node dataStoreStyleNode = TopoServiceUtil.createDataStoreStyleNode((TopoBaseContext)context, (String)vcenterSN);
        context.addChild((IData)fatherNode, (IData)dataStoreStyleNode);
        String dataStoreNodeID = vcenterSN + hostStorageInfo.getMountPoint();
        DataStoreElement dataStoreNode = new DataStoreElement((Object)dataStoreNodeID, this.resolveDatastoreName(hostStorageInfo));
        dataStoreNode = (Node)context.addChild((IData)dataStoreStyleNode, (IData)dataStoreNode);
        Node from = (Node)context.getElementBox().getElementByID((Object)(poNode.getID() + ":poStyle"));
        if (from != null) {
            context.linkTo(from, (Node)dataStoreNode, new Skin[]{new LinkFromAtLeftSkin()});
        }
        String lunWWN = hostStorageInfo.getLunWWN();
        int protectTemplateType = this.getProtectTemplateType(context.getProtectGroup());
        if (SAN_ACTIVE_TEMPLATE_TYPE_LIST.contains(protectTemplateType) || PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(protectTemplateType) && ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)context.getProtectGroup())) {
            String tStr = DrmEnumDefine.ResourceTypeE.NAS.getValue() == this.getStorageResourceType(pg) ? pairId : lunWWN;
            for (String siteId : siteIdList) {
                HashMap<String[], DataStoreElement> endings;
                if (!HYPER_METRO_REPLICATION_RING.contains(protectTemplateType)) {
                    context.linkTo((Node)dataStoreNode, (Object)(siteId + tStr.toUpperCase(Locale.getDefault())), new Skin[0]);
                    context.linkTo((Node)dataStoreNode, (Object)(siteId + tStr), new Skin[0]);
                    this.linkeNodeToLunByWwn(context, (Node)dataStoreNode, lunWWN);
                    continue;
                }
                if (26 == protectTemplateType) {
                    context.linkTo((Node)dataStoreNode, (Object)(siteId + tStr), new Skin[0]);
                }
                if ((endings = (HashMap<String[], DataStoreElement>)context.find((Object)"endings")) == null) {
                    endings = new HashMap<String[], DataStoreElement>();
                    context.bind((Object)"endings", endings);
                }
                endings.put(new String[]{tStr, siteId}, dataStoreNode);
            }
            return;
        }
        if (2 == protectTemplateType) {
            String lunNodeID = pg.getProductSiteId() + lunWWN;
            context.linkTo((Node)dataStoreNode, (Object)lunNodeID, new Skin[0]);
            return;
        }
        LunTopoInfo lunInfo = this.lunInfos.get(lunWWN);
        if (null == lunInfo) {
            logger.error((Object)("cant get luninfo,lunwwn=" + lunWWN));
            return;
        }
        String lunNodeID = lunInfo.getDevSn() + lunInfo.getLunId();
        context.linkTo((Node)dataStoreNode, (Object)lunNodeID, new Skin[0]);
    }

    private String resolveDatastoreName(ProtectObjectStorageInfo hostStorageInfo) {
        Integer storageType = hostStorageInfo.getStorageType();
        if (storageType.intValue() == DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue() || storageType.intValue() == DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue()) {
            String deviceName = hostStorageInfo.getDeviceName();
            int left = deviceName.indexOf("[");
            int right = deviceName.indexOf("]");
            if (left > -1 && left < right) {
                return deviceName.substring(left + 1, right);
            }
        }
        return hostStorageInfo.getDeviceName();
    }

    public String getTopoType() {
        return "ProtectGroup-10";
    }

    private int getProtectTemplateType(ProtectGroup pg) {
        return pg.getTemplate().getType();
    }
}

