/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdm.usedata.sdk.job;

import com.huawei.cdm.usedata.sdk.model.UseCopyDataTask;
import com.huawei.cdm.usedata.sdk.service.IUseCopyDataService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.quartz.Trigger;

public class UseCopyDataJob
implements StatefulJob {
    private static final Log logger = LogFactory.getInstance(UseCopyDataJob.class);
    private static final String HOST_LOCK_PREFIX = "HOST_LOCK_PREFIX_";
    private Trigger quartzTrigger;
    private UseCopyDataTask task;
    private RecoveryPlan recoveryPlan;

    public static String getClassName() {
        String className = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            Object[] element = e.getStackTrace();
            if (!VerifyUtil.isEmpty((Object[])element)) {
                className = ((StackTraceElement)element[0]).getClassName();
                logger.debug((Object)("getClassName:" + className));
            }
            return className;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        logger.debug((Object)("start use copy data job. now timestamp :" + new Date().getTime()));
        this.quartzTrigger = jobExecutionContext.getTrigger();
        this.task = (UseCopyDataTask)this.quartzTrigger.getJobDataMap().get((Object)"TASK");
        this.recoveryPlan = this.task.getRecoveryPlan();
        String mountHost = (String)this.recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        if (VerifyUtil.isEmpty((String)mountHost)) {
            logger.error((Object)"mountHost is null");
            throw new LegoCheckedException(1073947393L);
        }
        String hostLockId = HOST_LOCK_PREFIX + mountHost;
        ProtectionJobUtil.getInstance().checkIsNeedLock(hostLockId);
        try {
            if (VerifyUtil.isEmpty((Object)this.task)) {
                logger.error((Object)"get task got error,task is null!");
                throw new LegoCheckedException(2117645L);
            }
            this.recoveryPlan = this.task.getRecoveryPlan();
            this.mountReplica(this.recoveryPlan);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            logger.error((Object)("Mount the replication failed,planId:" + this.recoveryPlan.getPlanId()));
            throw new LegoCheckedException(errorCode, (Throwable)e);
        }
        catch (Exception e) {
            String errorMsg = "Mount the replication failed,planId:" + this.recoveryPlan.getPlanId();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.postMount();
            ProtectionJobUtil.getInstance().releaseLockPg(hostLockId);
        }
    }

    private void mountReplica(RecoveryPlan plan) {
        logger.debug((Object)("start mountReplica.planId:" + plan.getPlanId()));
        IUseCopyDataService copyDataService = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        copyDataService.mountReplica(plan.getPlanId(), RecoveryTaskUtil.getAdminUser());
        logger.debug((Object)("finished mountReplica.planId:" + plan.getPlanId()));
    }

    private void postMount() {
        try {
            this.task.setStatus(2);
            this.task.setLastExecTime(String.valueOf(new Date().getTime()));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.task);
        }
        catch (Exception e) {
            logger.error((Object)("Finally update status failed,taskId:" + this.task.getTaskId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }
}

