/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.observer;

import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailSlaManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSLA;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSlaManager;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AntiBlackmailProtectGroupObserver
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailProtectGroupObserver.class);

    public void before(MessageEvent event) {
        this.checkParams(event);
    }

    public void after(MessageEvent event) {
        if (!this.checkParams(event)) {
            return;
        }
        if (event.getMessageType() == 4) {
            this.processDeletedProtectObject(event);
            return;
        }
        if (event.getMessageType() == 2) {
            this.processDeletedProtectGroup(event);
        }
    }

    private boolean checkParams(MessageEvent event) {
        int messageType = event.getMessageType();
        switch (messageType) {
            case 4: {
                return this.checkParamsForRemoving(event);
            }
            case 2: {
                return this.checkParamsForDeleting(event);
            }
        }
        return false;
    }

    private boolean checkParamsForRemoving(MessageEvent event) {
        Object removedProtectObjects = event.getMessageMap().get("TASK_RESULT_REMOVED_ITEM_LIST_KEY");
        if (VerifyUtil.isEmpty(removedProtectObjects) || !(removedProtectObjects instanceof Set)) {
            LOGGER.info((Object)"Param is not match.");
            return false;
        }
        Set removedPoSet = (Set)removedProtectObjects;
        boolean isMatch = removedPoSet.stream().map(ProtectObject::getProtectGroup).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).anyMatch(AntiBlackMailConstant.ANTI_BLACKMAIL_TEMPLATE::contains);
        if (!isMatch) {
            LOGGER.info((Object)"Policy template is not match.");
            return false;
        }
        String devSn = ((ProtectObject)removedPoSet.stream().findFirst().get()).getProviderSN();
        this.checkConnectionValid(devSn);
        return true;
    }

    private boolean checkParamsForDeleting(MessageEvent event) {
        List<ProtectGroup> protectGroupList = this.getDeletingProtectGroups(event);
        if (VerifyUtil.isEmpty(protectGroupList)) {
            LOGGER.info((Object)"No protect group need to operate.");
            return false;
        }
        ProtectGroup protectGroup = protectGroupList.get(0);
        String devSn = protectGroup.getPoProviderSN();
        this.checkConnectionValid(devSn);
        return true;
    }

    private void checkConnectionValid(String devSn) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn + "oceanProtectConnection");
        if (VerifyUtil.isEmpty((Object)connection) || !connection.isValid()) {
            LOGGER.error((Object)"The connection of ProtectManager is not existing or valid, dev sn: %s.", new Object[]{devSn});
            throw new LegoCheckedException(1677929495L, new String[]{devSn});
        }
    }

    private List<ProtectGroup> getDeletingProtectGroups(MessageEvent event) {
        List deletedProtectGroups = event.getObjectList();
        return Optional.ofNullable(deletedProtectGroups).orElseGet(ArrayList::new).stream().filter(drmObject -> drmObject instanceof ProtectGroup).map(drmObject -> (ProtectGroup)drmObject).filter(protectGroup -> AntiBlackMailConstant.ANTI_BLACKMAIL_TEMPLATE.contains(protectGroup.getTemplate().getType())).collect(Collectors.toList());
    }

    private void processDeletedProtectObject(MessageEvent event) {
        Object removedProtectObjects = event.getMessageMap().get("TASK_RESULT_REMOVED_ITEM_LIST_KEY");
        Set removedPoSet = (Set)removedProtectObjects;
        List<String> operatedResourceList = removedPoSet.stream().filter(protectObject -> !VerifyUtil.isEmpty((String)protectObject.getProperty("antiBlackmailResourceUuid"))).map(protectObject -> protectObject.getProperty("antiBlackmailResourceUuid")).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(operatedResourceList)) {
            LOGGER.info((Object)"Removed protect objects were not associated with antiBlackmail resource.");
            return;
        }
        String devSn = ((ProtectObject)removedPoSet.stream().findFirst().get()).getProviderSN();
        this.removeSlaProtectionForResources(devSn, operatedResourceList);
    }

    private void processDeletedProtectGroup(MessageEvent event) {
        List<ProtectGroup> protectGroupList = this.getDeletingProtectGroups(event);
        List<String> operatedResourceList = protectGroupList.stream().flatMap(protectGroup -> protectGroup.getPolist().stream()).map(protectObject -> protectObject.getProperty("antiBlackmailResourceUuid")).filter(resourceUuid -> !VerifyUtil.isEmpty((String)resourceUuid)).collect(Collectors.toList());
        String devSn = protectGroupList.get(0).getPoProviderSN();
        this.removeSlaProtectionForResources(devSn, operatedResourceList);
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        if (!protectGroupService.existsAntiBlackmailPg(devSn)) {
            this.deleteBCManagerSla(devSn);
        }
        protectGroupList.forEach(protectGroup -> {
            if (AntiBlackmailUtil.checkVstoreBindNoSla(protectGroup)) {
                Set<String> vstoreIdSet = Optional.of(protectGroup).map(ProtectGroup::getPolist).orElseGet(Collections::emptySet).stream().map(protectObject -> protectObject.getProperty("PROP_KEY_VSTORE_ID")).collect(Collectors.toSet());
                AntiBlackmailUtil.configVstoreSmartDetection(protectGroup.getPoProviderSN(), vstoreIdSet, false);
            }
        });
    }

    private void removeSlaProtectionForResources(String devSn, List<String> operatedResourceList) {
        LOGGER.info((Object)"Start to remove sla protection for resources(%s), dev sn: %s.", new Object[]{operatedResourceList, devSn});
        IAntiBlackmailSlaManager slaManager = AntiBlackmailSlaManagerProxy.getInstance().getSlaManager(devSn);
        slaManager.removeSlaProtection(devSn, operatedResourceList);
        LOGGER.info((Object)"Removed sla protection completed.");
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private void deleteBCManagerSla(String devSn) {
        IAntiBlackmailSlaManager slaManager = AntiBlackmailSlaManagerProxy.getInstance().getSlaManager(devSn);
        Optional slaOptional = slaManager.querySlaByName(devSn, "BCManagerNASAirGapSLA");
        if (!slaOptional.isPresent()) {
            LOGGER.info((Object)"No sla named %s was found on dev(sn: %s).", new Object[]{"BCManagerNASAirGapSLA", devSn});
            return;
        }
        AntiBlackmailSLA antiBlackmailSLA = (AntiBlackmailSLA)slaOptional.get();
        try {
            slaManager.deleteSla(devSn, antiBlackmailSLA.getUuid());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Delete sla failed.sla id: %s, dev sn: %s, error msg: %s", new Object[]{antiBlackmailSLA.getUuid(), devSn, e.getMessage()});
            this.sendSlaDeletedErrorAlarm(devSn, antiBlackmailSLA);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Delete sla failed.sla id: %s, dev sn: %s, error msg: %s", new Object[]{antiBlackmailSLA.getUuid(), devSn, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.sendSlaDeletedErrorAlarm(devSn, antiBlackmailSLA);
        }
    }

    private void sendSlaDeletedErrorAlarm(String devSn, AntiBlackmailSLA sla) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn + "oceanProtectConnection");
        String ip = Optional.ofNullable(connection).map(RestConnection::getIpAddress).orElse("");
        String[] alarmParams = new String[]{ip, devSn, "BCManagerNASAirGapSLA"};
        AlarmUtil.sendNetworkEntityAlarm((String)"0x3230076", (String)ip, (String)(devSn + sla.getUuid()), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alarmParams);
    }
}

