/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.service;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailResourceManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailTaskManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailResourceManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailTaskManager;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.base.util.ResourceLockUtil;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageLicenseManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AntiBlackmailResourceScanTask
extends AbstractBackTask {
    public static final Set<String> CONNECTION_TYPE_SET = ImmutableSet.of((Object)"oceanProtectConnection");
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailUtil.class);
    private static final long TASK_QUERY_INTERVAL = 15000L;
    private static final Map<String, Long> RESOURCE_SCANNING_MAP = new ConcurrentHashMap<String, Long>();
    private final String devSn;
    private final String connectionType;

    public AntiBlackmailResourceScanTask(String devSn, String connectionType, String ip, int timeout) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)ip, (String)"oceanProtect_scanResource_operateName", (String)"System", (String)"", null), timeout, true);
        this.devSn = devSn;
        this.connectionType = connectionType;
    }

    public void scanResource() {
        this.doWork();
    }

    protected void doWork() {
        if (VerifyUtil.isEmpty((String)this.devSn) || !CONNECTION_TYPE_SET.contains(this.connectionType)) {
            LOGGER.error((Object)"Error param, dev sn: %s, connection type: %s.", new Object[]{this.devSn, this.connectionType});
            throw new LegoCheckedException(1073947393L);
        }
        String key = this.devSn + this.connectionType;
        if (RESOURCE_SCANNING_MAP.containsKey(key)) {
            LOGGER.error((Object)"Resource scanning task already exists, dev sn: %s. connection type: %s.", new Object[]{this.devSn, this.connectionType});
            throw new LegoCheckedException(1073948489L, (Throwable)new SecurityException(this.devSn));
        }
        IAntiBlackmailResourceManager resourceManager = AntiBlackmailResourceManagerProxy.getInstance().getResourceManager(this.devSn);
        IAntiBlackmailTaskManager taskManager = AntiBlackmailTaskManagerProxy.getInstance().getTaskManager(this.devSn);
        long startTime = System.currentTimeMillis();
        String lockId = ResourceLockUtil.lockRes((String)this.devSn, (String)this.connectionType, (long)((long)super.getTimeout() * 1000L));
        try {
            RESOURCE_SCANNING_MAP.put(key, System.currentTimeMillis());
            this.scanResource(resourceManager, taskManager, startTime);
            this.updateDrResourceInfo();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Scan resource error, error msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.updateDrResourceFailInfo();
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Scan resource error, error msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.updateDrResourceFailInfo();
            throw new LegoCheckedException(1073948491L);
        }
        finally {
            RESOURCE_SCANNING_MAP.remove(key);
            ResourceLockUtil.unlockRes((String)lockId);
        }
    }

    private void updateDrResourceFailInfo() {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.devSn);
        drResource.setEnabledAntiBlackmail(Boolean.valueOf(false));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)drResource);
    }

    private void updateDrResourceInfo() {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.devSn);
        if (!drResource.getIsAirGapResource().booleanValue()) {
            LOGGER.info((Object)"The storage has determined whether it has the anti blackmail feature, dev sn: %s.", new Object[]{this.devSn});
            return;
        }
        StorageLicense arrayLicense = StorageLicenseManagerProxy.getInstance().getArrayLicense(this.devSn);
        boolean enabledAntiBlackmail = Optional.ofNullable(arrayLicense).map(license -> license.isSupportFeature("647")).orElse(false);
        drResource.setEnabledAntiBlackmail(Boolean.valueOf(enabledAntiBlackmail));
        if (!enabledAntiBlackmail) {
            String[] alarmParams = new String[]{drResource.getIpAddress(), this.devSn};
            AlarmUtil.sendCommonAlarm((String)"0x3230090", (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])alarmParams);
            LOGGER.error((Object)"The storage has no hyper detect licence. dev sn: %s.", new Object[]{this.devSn});
        } else {
            LOGGER.error((Object)"Clear hyper detect licence alarm. dev sn: %s.", new Object[]{this.devSn});
            AlarmUtil.restoreAlarm((String)"0x3230090", (String[])new String[]{this.devSn});
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)drResource);
    }

    private void scanResource(IAntiBlackmailResourceManager resourceManager, IAntiBlackmailTaskManager taskManager, long startTime) {
        String taskId = this.triggerResourceScanning(resourceManager, taskManager).getJobId();
        long timeout = (long)super.getTimeout() * 1000L;
        do {
            CommUtil.pauseThread((long)15000L);
            Optional taskOptional = taskManager.querySpecificTask(this.devSn, taskId);
            if (!taskOptional.isPresent()) {
                LOGGER.error((Object)"The resource scanning task was deleted, dev sn: %s, task id: %s", new Object[]{this.devSn, taskId});
                throw new LegoCheckedException(1073948490L, new String[]{this.devSn});
            }
            AntiBlackmailPlatformTask scanResourceTask = (AntiBlackmailPlatformTask)taskOptional.get();
            String currentStatus = scanResourceTask.getStatus();
            if (AntiBlackMailConstant.OP_TASK_RUNNING_STATUS_LIST.contains(currentStatus)) continue;
            if (!AntiBlackMailEnumDefine.OceanProtectTaskStatusEnum.SUCCESS.getValue().equals(currentStatus) || scanResourceTask.getProgress() != 100) {
                LOGGER.error((Object)"The resource scanning task execution failed, dev sn: %s, task id: %s", new Object[]{this.devSn, taskId});
                throw new LegoCheckedException(1073948491L);
            }
            LOGGER.info((Object)"The resource scanning task executed successfully, dev sn: %s.", new Object[]{this.devSn});
            return;
        } while (System.currentTimeMillis() - startTime <= timeout);
        LOGGER.error((Object)"Resource scan execution timeout, dev sn: %s", new Object[]{this.devSn});
        throw new LegoCheckedException(1073947433L);
    }

    private AntiBlackmailPlatformTask triggerResourceScanning(IAntiBlackmailResourceManager resourceManager, IAntiBlackmailTaskManager taskManager) {
        String taskType = AntiBlackMailEnumDefine.OceanProtectTaskTypeEnum.MANUAL_SCAN_RESOURCE.getValue();
        List runningTaskList = taskManager.queryRunningTask(this.devSn, taskType);
        if (!VerifyUtil.isEmpty((Collection)runningTaskList)) {
            String jobId = ((AntiBlackmailPlatformTask)runningTaskList.get(0)).getJobId();
            LOGGER.error((Object)"Already exists a resource scanning task, task id: %s, dev sn: %s", new Object[]{jobId, this.devSn});
            throw new LegoCheckedException(1073948489L, new String[]{this.devSn});
        }
        OperationResult operationResult = resourceManager.scanResources(this.devSn);
        if (!operationResult.isSuccess()) {
            LOGGER.error((Object)"Trigger resource scanning error, dev sn: %s.", new Object[]{this.devSn});
            throw new LegoCheckedException(Long.parseLong(operationResult.getErrorCode()), operationResult.getArgs());
        }
        Optional scanResourceTask = taskManager.queryTheLatestTask(this.devSn, taskType, null);
        if (!scanResourceTask.isPresent()) {
            LOGGER.error((Object)"No resource scanning task is found, dev sn: %s", new Object[]{this.devSn});
            throw new LegoCheckedException(1073948490L, new String[]{this.devSn});
        }
        return (AntiBlackmailPlatformTask)scanResourceTask.get();
    }
}

