/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.job.AbstractDrmQuartzJob;
import com.huawei.ism.drm.base.service.IConfigSyncRateService;
import com.huawei.ism.drm.base.service.ISyncRatePolicyClassifer;
import com.huawei.ism.drm.protection.checker.job.ProtectionSyncRateJob;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class ConfigSyncRateServiceImpl
implements IConfigSyncRateService,
ISyncRatePolicyClassifer {
    private static Log logger = LogFactory.getInstance(ConfigSyncRateServiceImpl.class);
    private ISyncRatePolicyClassifer classifier;
    private Scheduler quartzScheduler;
    private List<AbstractDrmQuartzJob> jobs;

    private static String getCronExpression(List<ProtectGroupSyncRatePolicy> protectGroupSyncRatePolicy) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("00").append(' ').append("00").append(' ');
        ConfigSyncRateServiceImpl.constructCronStartHours(strBuf, protectGroupSyncRatePolicy);
        strBuf.append(" * * ?");
        String timestrBuff = strBuf.toString();
        return timestrBuff;
    }

    private static void constructCronStartHours(StringBuffer strBuf, List<ProtectGroupSyncRatePolicy> protectGroupSyncRatePolicy) {
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < protectGroupSyncRatePolicy.size(); ++i) {
            StringBuffer startTimeBuffer = new StringBuffer();
            startTimeBuffer.append(protectGroupSyncRatePolicy.get(i).getStartTime());
            startTimeBuffer.replace(startTimeBuffer.length() - 3, startTimeBuffer.length(), "");
            StringBuffer endTimeBuffer = new StringBuffer();
            endTimeBuffer.append(protectGroupSyncRatePolicy.get(i).getEndTime());
            hs.add(startTimeBuffer.toString().trim());
            endTimeBuffer.replace(endTimeBuffer.length() - 3, endTimeBuffer.length(), "");
            hs.add(endTimeBuffer.toString().trim());
        }
        ArrayList<String> li = new ArrayList<String>();
        for (String value : hs) {
            li.add(value);
        }
        Collections.sort(li);
        for (String s : li) {
            strBuf.append(s).append(',');
        }
        strBuf.replace(strBuf.length() - 1, strBuf.length(), "");
    }

    public ISyncRatePolicyClassifer getClassifer() {
        return this.classifier;
    }

    public void setClassifer(ISyncRatePolicyClassifer classifer) {
        this.classifier = classifer;
    }

    public List<AbstractDrmQuartzJob> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<AbstractDrmQuartzJob> jobs) {
        this.jobs = jobs;
    }

    public void initialize() {
        try {
            this.quartzScheduler = StdSchedulerFactory.getDefaultScheduler();
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            logger.error((Object)"start quartz failed", (Throwable)e, 90160758784001L);
            return;
        }
        for (AbstractDrmQuartzJob job : this.jobs) {
            this.scheduleJob(job);
        }
    }

    private void scheduleJob(AbstractDrmQuartzJob job) {
        SimpleTriggerImpl trigger = new SimpleTriggerImpl(job.getTriggerName(), job.getTriggerGroupName(), new Date(), null, -1, job.getInterval());
        try {
            JobDetailImpl jobDetail = new JobDetailImpl(job.getJobName(), job.getJobGroupName(), job.getClass());
            jobDetail.setDurability(true);
            this.quartzScheduler.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)("Schedule job failed. JobName:" + job.getJobName()), (Throwable)e, 90160758784001L);
        }
    }

    public void createSyncRateTask(ProtectGroup pg, List<ProtectGroupSyncRatePolicy> pgsrps) {
        if (null == pg) {
            logger.error((Object)"pg is null", 90160758784001L);
            return;
        }
        if (VerifyUtil.isEmpty(pgsrps)) {
            logger.error((Object)"pgsrps is null or empty", 90160758784001L);
            return;
        }
        try {
            pgsrps.get(0).setProtectGroup(pg);
            this.updateTrigger(pg, pgsrps);
        }
        catch (Exception e) {
            logger.error((Object)("createSyncRateTask failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public void resumeTask(ProtectGroup protectGroup, List<ProtectGroupSyncRatePolicy> pgsrps) {
        if (null == protectGroup) {
            logger.error((Object)"protectGroup is null", 90160758784001L);
            return;
        }
        if (VerifyUtil.isEmpty(pgsrps)) {
            logger.error((Object)"pgsrps is null or empty", 90160758784001L);
            return;
        }
        try {
            pgsrps.get(0).setProtectGroup(protectGroup);
            this.updateTrigger(protectGroup, pgsrps);
            this.runAtOnce(protectGroup, pgsrps);
        }
        catch (Exception e) {
            logger.error((Object)("resumeTask failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public void updateSyncRateTask(String protectGroupId, List<ProtectGroupSyncRatePolicy> pgsrps) {
        if (VerifyUtil.isEmpty(pgsrps)) {
            logger.error((Object)"pgsrps is null or empty", 90160758784001L);
            return;
        }
        try {
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId);
            if (null == pg) {
                logger.error((Object)("protectGroupId =" + protectGroupId + " get pg is null"), 90160758784001L);
                return;
            }
            pgsrps.get(0).setProtectGroup(pg);
            this.updateTrigger(pg, pgsrps);
        }
        catch (Exception e) {
            logger.error((Object)("updateSyncRateTask failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public void deleteSyncRateTask(String pgId) {
        try {
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pgId);
            if (null == pg) {
                logger.error((Object)("pgId =" + pgId + " get pg is null"), 90160758784001L);
                return;
            }
            List pgsrps = ProtectGroupUtil.convertToSyncRatePolicy((PolicyTemplate)pg.getTemplate());
            HashSet<Integer> protectLoctions = new HashSet<Integer>();
            for (int i = 0; i < pgsrps.size(); ++i) {
                int pl = ((ProtectGroupSyncRatePolicy)pgsrps.get(i)).getProtectLocation();
                protectLoctions.add(pl);
            }
            Iterator it = protectLoctions.iterator();
            while (it.hasNext()) {
                int protectLocation = (Integer)it.next();
                this.unschedule(pg, pgsrps, protectLocation);
            }
        }
        catch (Exception e) {
            logger.error((Object)("deleteSyncRateTask pgId=" + pgId + " failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public void deleteOldSyncRateTask(String pgId, PolicyTemplate pt) {
        try {
            if (null == pt) {
                logger.error((Object)"deleteOldSyncRateTask,pt is null", 90160758784001L);
                return;
            }
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pgId);
            if (null == pg) {
                logger.error((Object)("pgId =" + pgId + " get pg is null"), 90160758784001L);
                return;
            }
            List pgsrps = ProtectGroupUtil.convertToSyncRatePolicy((PolicyTemplate)pt);
            if (VerifyUtil.isEmpty((Collection)pgsrps)) {
                return;
            }
            HashSet<Integer> protectLoctions = new HashSet<Integer>();
            for (int i = 0; i < pgsrps.size(); ++i) {
                int pl = ((ProtectGroupSyncRatePolicy)pgsrps.get(i)).getProtectLocation();
                protectLoctions.add(pl);
            }
            Iterator it = protectLoctions.iterator();
            while (it.hasNext()) {
                int protectLocation = (Integer)it.next();
                this.unschedule(pg, pgsrps, protectLocation);
            }
        }
        catch (Exception e) {
            logger.error((Object)("deleteOldSyncRateTask pgId=" + pgId + " failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    private void unschedule(ProtectGroup pg, List<ProtectGroupSyncRatePolicy> pgsrps, int protectLocation) {
        List<ProtectGroupSyncRatePolicy> protectGroupSyncRatePolicys = this.createGroup(pg, pgsrps, protectLocation);
        for (Collection<ProtectGroupSyncRatePolicy> policys : this.classify(pg, protectGroupSyncRatePolicys)) {
            this.unschedule(new ArrayList<ProtectGroupSyncRatePolicy>(policys));
        }
    }

    private List<ProtectGroupSyncRatePolicy> createGroup(ProtectGroup pg, List<ProtectGroupSyncRatePolicy> pgsrps, int protectLocation) {
        List<ProtectGroupSyncRatePolicy> protectGroupSyncRatePolicys = this.createGroup(pgsrps, protectLocation);
        protectGroupSyncRatePolicys.get(0).setProtectGroup(pg);
        return protectGroupSyncRatePolicys;
    }

    public void runAtOnce(ProtectGroup protectGroup, List<ProtectGroupSyncRatePolicy> pgsrps, boolean isFirstTime) {
        if (null == protectGroup) {
            logger.error((Object)"protectGroup is null", 90160758784001L);
            return;
        }
        if (VerifyUtil.isEmpty(pgsrps)) {
            logger.error((Object)"pgsrps is null or empty", 90160758784001L);
            return;
        }
        try {
            HashSet<Integer> protectLoctions = new HashSet<Integer>();
            for (int i = 0; i < pgsrps.size(); ++i) {
                int pl = pgsrps.get(i).getProtectLocation();
                protectLoctions.add(pl);
            }
            Iterator it = protectLoctions.iterator();
            while (it.hasNext()) {
                int protectLocation = (Integer)it.next();
                this.runAtOnce(protectGroup, pgsrps, isFirstTime, protectLocation);
            }
        }
        catch (Exception e) {
            logger.error((Object)"runAtOnce failed.", (Throwable)e, 90160758784001L);
        }
    }

    private void runAtOnce(ProtectGroup protectGroup, List<ProtectGroupSyncRatePolicy> pgsrps, boolean isFirstTime, int protectLocation) {
        List<ProtectGroupSyncRatePolicy> protectGroupSyncRatePolicys = this.createGroup(protectGroup, pgsrps, protectLocation);
        for (Collection<ProtectGroupSyncRatePolicy> policys : this.classify(protectGroup, protectGroupSyncRatePolicys)) {
            this.runAtOnceTrigger(new ArrayList<ProtectGroupSyncRatePolicy>(policys), protectLocation, isFirstTime);
        }
    }

    public void runAtOnce(ProtectGroup protectGroup, List<ProtectGroupSyncRatePolicy> pgsrps) {
        this.runAtOnce(protectGroup, pgsrps, false);
    }

    private void runAtOnceTrigger(List<ProtectGroupSyncRatePolicy> pgsrps, int protectLocation, boolean isFirst) {
        block5: {
            this.checkParam(pgsrps);
            String triggerName = this.getSimpleTriggerName(pgsrps);
            String triggerGroupName = this.getSimpleTriggerGroupName(pgsrps);
            TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
            String jobName = this.getManualJobName(pgsrps);
            String jobGroupName = this.getManualJobGroupName(pgsrps);
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            JobDetailImpl quartzJobDetail = new JobDetailImpl(jobName, jobGroupName, ProtectionSyncRateJob.class);
            quartzJobDetail.setDurability(true);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("SyncRateTask" + protectLocation, pgsrps);
            jobDataMap.put("isFirstTime", isFirst);
            try {
                SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl(triggerName, triggerGroupName);
                simpleTrigger.setJobDataMap(jobDataMap);
                JobDetail job = this.quartzScheduler.getJobDetail(jobKey);
                if (null == job) {
                    logger.info((Object)("First schedule job:" + jobGroupName), 90160758786988L);
                    this.quartzScheduler.scheduleJob((JobDetail)quartzJobDetail, (Trigger)simpleTrigger);
                    break block5;
                }
                Trigger.TriggerState state = this.quartzScheduler.getTriggerState(triggerKey);
                if (state == null) {
                    logger.error((Object)"schedule get trigger state is null !");
                    throw new LegoCheckedException(1073947393L);
                }
                String stateName = state.name();
                if (Trigger.TriggerState.PAUSED.name().equals(stateName) || Trigger.TriggerState.COMPLETE.name().equals(stateName) || Trigger.TriggerState.ERROR.name().equals(stateName) || Trigger.TriggerState.BLOCKED.name().equals(stateName) || Trigger.TriggerState.NONE.name().equals(stateName)) {
                    logger.info((Object)("Reschedule job is:" + jobGroupName + " QuartzScheduler state is:" + state.name()), 90160758786988L);
                    this.quartzScheduler.deleteJob(jobKey);
                    this.quartzScheduler.scheduleJob((JobDetail)quartzJobDetail, (Trigger)simpleTrigger);
                    state = this.quartzScheduler.getTriggerState(triggerKey);
                    logger.info((Object)("Rescheduled job is:" + jobGroupName + " QuartzScheduler state is:" + state.name()), 90160758786988L);
                    break block5;
                }
                logger.error((Object)("QuartzScheduler state is:" + state), 90160758786989L);
                throw new LegoCheckedException(1073948200L);
            }
            catch (SchedulerException e) {
                logger.error((Object)"schedule volatile trigger failed", (Throwable)e, 90160758784001L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
    }

    private void updateTrigger(ProtectGroup pg, List<ProtectGroupSyncRatePolicy> pgsrps) {
        HashSet<Integer> protectLoctions = new HashSet<Integer>();
        for (int i = 0; i < pgsrps.size(); ++i) {
            int pl = pgsrps.get(i).getProtectLocation();
            protectLoctions.add(pl);
        }
        Iterator it = protectLoctions.iterator();
        while (it.hasNext()) {
            int protectLocation = (Integer)it.next();
            this.updateTrigger(pg, pgsrps, protectLocation);
        }
    }

    private void updateTrigger(ProtectGroup pg, List<ProtectGroupSyncRatePolicy> pgsrps, int protectLocation) {
        List<ProtectGroupSyncRatePolicy> protectGroupSyncRatePolicys = this.createGroup(pg, pgsrps, protectLocation);
        for (Collection<ProtectGroupSyncRatePolicy> policys : this.classify(pg, protectGroupSyncRatePolicys)) {
            this.updateTrigger(new ArrayList<ProtectGroupSyncRatePolicy>(policys), protectLocation);
        }
    }

    private void updateTrigger(List<ProtectGroupSyncRatePolicy> protectGroupSyncRatePolicys, int protectLocation) {
        String triggerName = this.getTriggerName(protectGroupSyncRatePolicys);
        String triggerGroupName = this.getTriggerGroupName(protectGroupSyncRatePolicys);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("SyncRateTask" + protectLocation, protectGroupSyncRatePolicys);
        CronTriggerImpl newTrigger = this.createCronTrigger(protectGroupSyncRatePolicys);
        newTrigger.setJobDataMap(jobDataMap);
        try {
            Trigger t = this.quartzScheduler.getTrigger(triggerKey);
            if (null == t) {
                logger.debug((Object)"updateTrigger the Trigger is null, recreate.", 90160758784001L);
                String jobName = this.getJobName(protectGroupSyncRatePolicys);
                String jobGroupName = this.getJobGroupName(protectGroupSyncRatePolicys);
                JobKey jobKey = new JobKey(jobName, jobGroupName);
                JobDetail quartzJobDetail = this.quartzScheduler.getJobDetail(jobKey);
                if (null == quartzJobDetail) {
                    quartzJobDetail = new JobDetailImpl(jobName, jobGroupName, ProtectionSyncRateJob.class);
                    ((JobDetailImpl)quartzJobDetail).setDurability(true);
                    logger.debug((Object)("updateTrigger create new jobdetail, job class name=" + jobName), 90160758784001L);
                    this.quartzScheduler.addJob(quartzJobDetail, true);
                }
                this.quartzScheduler.scheduleJob((Trigger)newTrigger);
            } else {
                this.quartzScheduler.rescheduleJob(triggerKey, (Trigger)newTrigger);
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"update trigger failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private List<ProtectGroupSyncRatePolicy> createGroup(List<ProtectGroupSyncRatePolicy> pgsrps, int protectLocation) {
        ArrayList<ProtectGroupSyncRatePolicy> protectGroupSyncRatePolicys = new ArrayList<ProtectGroupSyncRatePolicy>();
        for (int i = 0; i < pgsrps.size(); ++i) {
            if (pgsrps.get(i).getProtectLocation() != protectLocation) continue;
            protectGroupSyncRatePolicys.add(pgsrps.get(i));
        }
        return protectGroupSyncRatePolicys;
    }

    private void unschedule(List<ProtectGroupSyncRatePolicy> pgsrps) {
        this.checkParam(pgsrps);
        String triggerName = this.getTriggerName(pgsrps);
        String triggerGroupName = this.getTriggerGroupName(pgsrps);
        logger.debug((Object)("unschedule task, trigger name=" + triggerName + " ,trigger group name=" + triggerGroupName), 90160758784001L);
        try {
            this.quartzScheduler.unscheduleJob(new TriggerKey(triggerName, triggerGroupName));
        }
        catch (SchedulerException e) {
            logger.error((Object)"unschedule job failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private String getJobName(List<ProtectGroupSyncRatePolicy> pgsrps) {
        return "JOB_" + this.getJobNameSuffix(pgsrps);
    }

    private String getJobGroupName(List<ProtectGroupSyncRatePolicy> pgsrps) {
        return "JOB_GROUP" + this.getJobNameSuffix(pgsrps);
    }

    private void checkParam(Object param) {
        if (null == param) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private String getTriggerName(List<ProtectGroupSyncRatePolicy> pgsrps) {
        return "Trigger_" + this.getJobNameSuffix(pgsrps);
    }

    private String getTriggerGroupName(List<ProtectGroupSyncRatePolicy> pgsrps) {
        return "TriggerGroup_" + this.getJobNameSuffix(pgsrps);
    }

    private String getSimpleTriggerName(List<ProtectGroupSyncRatePolicy> pgsrps) {
        return "SimpleTrigger_" + this.getJobNameSuffix(pgsrps);
    }

    private String getSimpleTriggerGroupName(List<ProtectGroupSyncRatePolicy> pgsrps) {
        return "SimpleTriggerGROUP_" + this.getJobNameSuffix(pgsrps);
    }

    private String getManualJobName(List<ProtectGroupSyncRatePolicy> pgsrps) {
        return "JOB_SIMPLE" + this.getJobNameSuffix(pgsrps);
    }

    private String getJobNameSuffix(List<ProtectGroupSyncRatePolicy> pgsrps) {
        ProtectGroupSyncRatePolicy policy = pgsrps.get(0);
        String pgid = policy.getProtectGroup().getUuid();
        String storage = policy.getStorage();
        int location = policy.getProtectLocation();
        return pgid + '-' + storage + '-' + location;
    }

    private CronTriggerImpl createCronTrigger(List<ProtectGroupSyncRatePolicy> pgsrps) {
        String triggerName = this.getTriggerName(pgsrps);
        String triggerGroupName = this.getTriggerGroupName(pgsrps);
        String jobName = this.getJobName(pgsrps);
        String jobGroupName = this.getJobGroupName(pgsrps);
        CronTriggerImpl quartzCronTrigger = null;
        try {
            quartzCronTrigger = new CronTriggerImpl(triggerName, triggerGroupName, jobName, jobGroupName, ConfigSyncRateServiceImpl.getCronExpression(pgsrps));
        }
        catch (ParseException e) {
            logger.error((Object)"parse crontab expression failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return quartzCronTrigger;
    }

    private String getManualJobGroupName(List<ProtectGroupSyncRatePolicy> pgsrps) {
        return "JOB_GROUP_SIMPLE" + this.getJobNameSuffix(pgsrps);
    }

    public Collection<Collection<ProtectGroupSyncRatePolicy>> classify(ProtectGroup pg, Collection<ProtectGroupSyncRatePolicy> policies) {
        if (this.classifier != null) {
            return this.classifier.classify(pg, policies);
        }
        return Arrays.asList(policies);
    }
}

