/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeDefTemplate;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeStep;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectCustomStepHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CustomStepUtil {
    private static Log logger = LogFactory.getInstance(CustomStepUtil.class);

    private CustomStepUtil() {
    }

    public static boolean isUserDefined(Object flag) {
        if (flag instanceof Boolean) {
            return (Boolean)flag;
        }
        return flag != null ? "true".equals(flag) : Boolean.TRUE.booleanValue();
    }

    public static boolean isSystemDefined(Object flag) {
        return !CustomStepUtil.isUserDefined(flag);
    }

    public static boolean hasSystemDefinedCustomStep(String procId, int procType, String position) {
        List items = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from RecoveryProcessor where planId = ? and procType = ?", new Object[]{procId, procType});
        if (VerifyUtil.isEmpty((Collection)items)) {
            return false;
        }
        for (Object item : items) {
            RecoveryProcessor processor = (RecoveryProcessor)item;
            Map props = processor.getProps();
            String stepPosition = (String)props.get("position");
            if (!position.equals(stepPosition) || CustomStepUtil.isUserDefined(props.get("isUserDefined"))) continue;
            return true;
        }
        return false;
    }

    public static PolicyTemplate getPolicyTemplateByPgId(String pgId) {
        List results = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("From ProtectGroup where uuid = ?", new Object[]{pgId});
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.error((Object)("protect group is not exists. id: " + pgId));
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroup protectGroup = (ProtectGroup)results.get(0);
        return protectGroup.getTemplate();
    }

    public static JSONObject checkStepParams(DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, Object> params, RecoveryPlan recoveryPlan, RecoveryProcessor processor) {
        Map lastProps = processor.getProps();
        String position = (String)lastProps.get("position");
        if (position == null) {
            logger.error((Object)"get position from custom processor failed");
            throw new LegoCheckedException(1073947393L);
        }
        IHostScriptSchemeService schemeService = (IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class);
        JSONObject publicParams = null;
        Boolean isUserDefined = CustomStepUtil.isUserDefined(params.get("isUserDefined"));
        boolean isUserDefinedAtLast = CustomStepUtil.isUserDefined(lastProps.get("isUserDefined"));
        if (!isUserDefined.booleanValue() && !isUserDefinedAtLast) {
            String schemeId = (String)lastProps.get("recoveryScriptSchemeId");
            if (VerifyUtil.isEmpty((String)schemeId)) {
                logger.error((Object)("incorrect scheme id: " + schemeId));
                throw new LegoCheckedException(1073947393L);
            }
            ScriptSchemeDefTemplate scheme = schemeService.queryScriptSchemeById(schemeId);
            String pgId = recoveryPlan.getProtectGroup().getUuid();
            PolicyTemplate template = CustomStepUtil.getPolicyTemplateByPgId(pgId);
            publicParams = CustomStepUtil.checkSchedule(params, processor, lastProps, position, scheme, template);
        } else if (isUserDefined.booleanValue() && isUserDefinedAtLast) {
            JSONObject stepParams = JSONObject.fromObject((Object)params.get("STEP_PARAMS"));
            for (Object item : stepParams.entrySet()) {
                Map.Entry entry = (Map.Entry)item;
                if (!VerifyUtil.isEmpty(entry.getValue())) continue;
                throw new LegoCheckedException(1073947393L);
            }
        } else if (isUserDefinedAtLast && !isUserDefined.booleanValue()) {
            String schemeId = (String)params.get("recoveryScriptSchemeId");
            boolean valid = ProtectCustomStepHelper.checkSchemeIdConsistency((String)recoveryPlan.getProtectGroup().getUuid(), (String)schemeId);
            if (!valid) {
                logger.error((Object)"script scheme id is incorrect");
                throw new LegoCheckedException(1073947393L);
            }
            ScriptSchemeStep step = schemeService.queryScriptSchemeStep(schemeId, position);
            if (step == null) {
                logger.error((Object)"script scheme step position is incorrect");
                throw new LegoCheckedException(1073947393L);
            }
            params.put("CUSTOM_PROCESSOR_NAME", JSONObject.fromObject((Object)step.getName()).toString());
            params.put("EXECUTE_SCRIPT_NAME", step.getScript());
            if (CustomStepUtil.hasSystemDefinedCustomStep(recoveryPlan.getPlanId(), procType.getValue(), position)) {
                logger.error((Object)"not allow switch custom script to system script");
                throw new LegoCheckedException(0x300001L);
            }
            CustomStepUtil.validateStepParams(step, params.get("STEP_PARAMS"));
        }
        return publicParams;
    }

    private static JSONObject checkSchedule(Map<String, Object> params, RecoveryProcessor processor, Map<String, String> lastProps, String position, ScriptSchemeDefTemplate scheme, PolicyTemplate template) {
        JSONObject publicParams = null;
        if (null == template) {
            logger.error((Object)"check schedule, template is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)template.getSchedules())) {
            logger.info((Object)("template hasn't schedule, type: " + template.getType()));
            return new JSONObject();
        }
        for (Schedule schedule : template.getSchedules()) {
            logger.info((Object)("check schedule, type: " + schedule.getProtectedType() + ", name: " + schedule.getName()));
            if (ScheduleProtectedType.SNAPSHOT.getValue() != schedule.getProtectedType()) {
                logger.debug((Object)"schedule is not snapshot.");
                continue;
            }
            JSONObject oldPublicParams = JSONObject.fromObject(schedule.getExtParameters().get("publicParam"));
            JSONObject newPublicParams = JSONObject.fromObject((Object)params.get("publicParam"));
            if (ProtectCustomStepHelper.isParamChanged((JSONObject)newPublicParams, (JSONObject)oldPublicParams)) {
                ScriptParamsUtils.decryptSensitiveParam((JSONObject)oldPublicParams, (List)scheme.getPublicParams());
                oldPublicParams.putAll((Map)newPublicParams);
                ScriptParamsUtils.validateScriptParams((JSONObject)oldPublicParams, (List)scheme.getPublicParams());
                publicParams = oldPublicParams;
            }
            ScriptSchemeStep step = scheme.getSteps().stream().filter(s -> position.equals(s.getPosition())).findFirst().orElseThrow(() -> {
                LegoCheckedException e = new LegoCheckedException(1073947393L);
                logger.error((Object)("unkown step at position " + position), (Throwable)e);
                return e;
            });
            JSONObject args = JSONObject.fromObject((Object)params.get("STEP_PARAMS"));
            ScriptParamsUtils.ecryptScriptParams((JSONObject)args, (List)step.getParams(), (boolean)false);
            JSONObject data = CustomStepUtil.getStepOwnedParams(lastProps.get("STEP_PARAMS"), step);
            CustomStepUtil.validateStepParams(step, data, args);
            data.putAll((Map)args);
            params.put("STEP_PARAMS", data.toString());
            params.put("CUSTOM_PROCESSOR_NAME", processor.getProcName());
            params.remove("EXECUTE_SCRIPT_NAME");
        }
        return publicParams;
    }

    private static JSONObject getStepOwnedParams(String params, ScriptSchemeStep step) {
        JSONObject data = JSONObject.fromObject((Object)params);
        Iterator it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            for (Map param : step.getParams()) {
                if (param.get("name").equals(entry.getKey())) continue;
                it.remove();
            }
        }
        return data;
    }

    private static void validateStepParams(ScriptSchemeStep step, Object params) {
        JSONObject json = !VerifyUtil.isEmpty((Object)params) ? JSONObject.fromObject((Object)params) : new JSONObject();
        CustomStepUtil.validateStepParams(step, json, null);
    }

    private static void validateStepParams(ScriptSchemeStep step, JSONObject newParams, JSONObject oldParams) {
        JSONObject params = new JSONObject();
        if (oldParams != null) {
            oldParams = JSONObject.fromObject((Object)oldParams.toString());
            ScriptParamsUtils.decryptSensitiveParam((JSONObject)oldParams, (List)step.getParams());
            params.putAll((Map)oldParams);
        }
        params.putAll((Map)newParams);
        ScriptParamsUtils.validateScriptParams((JSONObject)params, (List)step.getParams());
    }
}

