/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.sdk.constant.ContextParamConstant;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.CustomStepUtil;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeDefTemplate;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeStep;
import com.huawei.ism.drm.common.sdk.service.IScriptSchemeInfoService;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCreateEventHandler;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCustomStepService;
import com.huawei.ism.drm.drp.service.impl.RecoveryPlanServiceImpl;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;

@Service(name="com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCustomStepService", desc="", interfaceClass=IRecoveryPlanCustomStepService.class)
public class RecoveryPlanCustomStepServiceImpl
extends BaseService
implements IRecoveryPlanCustomStepService,
IRecoveryPlanCreateEventHandler {
    private static Log logger = LogFactory.getInstance(RecoveryPlanCustomStepServiceImpl.class);
    private IProtectGroupService protectGroupService;
    private RecoveryPlanServiceImpl recoveryPlanService;

    public IProtectGroupService getProtectGroupService() {
        return this.protectGroupService;
    }

    public void setProtectGroupService(IProtectGroupService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public RecoveryPlanServiceImpl getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public void setRecoveryPlanService(RecoveryPlanServiceImpl recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public String addCustomRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, Object> params, String indexProcId, boolean isBefore) {
        return this.createCustomRecoveryProcessor(planId, procType, params, indexProcId, isBefore);
    }

    public String addCustomRecoveryProcessor(RecoveryPlan recoveryPlan, String schemeId) {
        return (String)HibernateUtil.execute(() -> this.addCustomRecoveryProcessor(HibernateUtil.getSession(), recoveryPlan, schemeId, true));
    }

    public String addCustomRecoveryProcessor(Session session, RecoveryPlan recoveryPlan, String schemeId) {
        return this.addCustomRecoveryProcessor(session, recoveryPlan, schemeId, true);
    }

    public String addCustomRecoveryProcessor(Session session, RecoveryPlan recoveryPlan, String schemeId, boolean save) {
        IScriptSchemeInfoService service = (IScriptSchemeInfoService)ServiceLocator.getInstance().getService(IScriptSchemeInfoService.class);
        ScriptSchemeDefTemplate schemeInfo = service.getScriptSchemeInfo(schemeId);
        List steps = schemeInfo.getSteps();
        for (ScriptSchemeStep step : steps) {
            if (!step.getPosition().startsWith("recovery")) continue;
            JSONObject stepName = JSONObject.fromObject((Object)step.getName());
            String scriptName = step.getScript();
            String position = step.getPosition();
            String[] positions = position.split("-");
            DrmEnumDefine.RecoveryPlanExecuteTypeE procType = RecoveryProcessUtil.getProcType(positions[1]);
            Set processes = this.recoveryPlanService.getRecoveryProcesses(session, recoveryPlan, procType);
            List recoveryProcessors = processes.stream().filter(item -> procType.getValue() == item.getProcType()).map(item -> new ArrayList(item.getRecoveryProcessors())).collect(Collectors.toList());
            if (VerifyUtil.isEmpty(recoveryProcessors)) {
                logger.error((Object)"adding custom recovery step, but get recovery processor failed.");
                continue;
            }
            List processDefinitions = ((List)recoveryProcessors.get(0)).stream().filter(process -> positions[2].equals(process.getStepPosition())).collect(Collectors.toList());
            if (processDefinitions == null || processDefinitions.size() == 0) {
                logger.info((Object)"processor not found when add custom recovery step.");
                continue;
            }
            String indexProcId = ((RecoveryProcessor)processDefinitions.get(0)).getProcId();
            boolean isBefore = "before".equals(positions[3]);
            boolean execPolicy = "continue-when-failed".equals(step.getPolicy());
            HashMap privateParamsMap = new HashMap();
            HashMap<String, Object> stepParams = new HashMap<String, Object>();
            stepParams.put("CUSTOM_PROCESSOR_NAME", stepName.toString());
            stepParams.put("EXECUTE_SCRIPT_NAME", scriptName);
            stepParams.put("EXECUTE_POLICY", execPolicy);
            stepParams.put("STEP_PARAMS", privateParamsMap);
            stepParams.put("isUserDefined", String.valueOf(Boolean.FALSE));
            stepParams.put("recoveryScriptSchemeId", schemeId);
            stepParams.put("scriptSchemeId", schemeId);
            stepParams.put("position", position);
            this.createCustomRecoveryProcessor(recoveryPlan, procType, stepParams, indexProcId, session, isBefore, save);
        }
        return recoveryPlan.getPlanId();
    }

    private String createCustomRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, Object> params, String indexProcId, boolean isBefore) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.recoveryPlanService.queryRecoveryPlan(planId, true);
        if (recoveryPlan == null) {
            throw new LegoCheckedException(201L);
        }
        return this.createCustomRecoveryProcessor(recoveryPlan, procType, params, indexProcId, isBefore);
    }

    private String createCustomRecoveryProcessor(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, Object> params, String indexProcId, boolean isBefore) {
        return (String)HibernateUtil.execute(() -> this.createCustomRecoveryProcessor(recoveryPlan, procType, params, indexProcId, HibernateUtil.getSession(), isBefore));
    }

    private String createCustomRecoveryProcessor(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, Object> params, String indexProcId, Session session, boolean ... opts) {
        boolean isNeedUpdateDb;
        boolean isBefore = opts[0];
        boolean bl = isNeedUpdateDb = opts.length <= 1 || opts[1];
        if (VerifyUtil.isEmpty((String)indexProcId) || procType == null) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR);
        params.put("CustomProcId", UUIDGenerator.getUUID());
        Set processes = this.recoveryPlanService.getRecoveryProcesses(session, recoveryPlan, procType);
        if (processes == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = processes.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = (RecoveryProcessDefinition)iterator.next();
        RecoveryProcessor indexProcessor = this.getIndexRecoveryProcessor(rpDefinition, indexProcId, isBefore);
        if (indexProcessor == null) {
            logger.error((Object)("The index processor does not exist. ProcId:" + indexProcId + ", IsBefore:" + isBefore), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (provider == null) {
            logger.error((Object)("provider is null. ProcId:" + recoveryPlan.getPlanId()));
            throw new LegoCheckedException(1073947394L);
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)indexProcessor.getProcType());
        RecoveryProcessor currentProcessor = isBefore ? indexProcessor.getNextProcessor() : indexProcessor;
        String position = currentProcessor.getStepPosition();
        String prefix = "recovery-";
        if (position != null && !position.startsWith(prefix)) {
            position = "recovery-" + type.name().toLowerCase(Locale.US) + '-' + position + '-' + (isBefore ? "before" : "after");
        }
        params.put("position", position);
        return provider.addCustomRecoveryProcessor(rpDefinition, indexProcessor, params, true, isNeedUpdateDb);
    }

    private RecoveryProcessor getIndexRecoveryProcessor(RecoveryProcessDefinition rpDefinition, String indexProcId, boolean isBefore) {
        RecoveryProcessor indexProcessor = null;
        List sortedRecoveryProcessors = null;
        sortedRecoveryProcessors = RecoveryServiceUtil.sortRecoveryProcessors((Set)rpDefinition.getRecoveryProcessors());
        for (RecoveryProcessor processor : sortedRecoveryProcessors) {
            if (!processor.getProcId().equals(indexProcId)) continue;
            if (!isBefore) {
                indexProcessor = processor;
                if (indexProcessor.getNextProcessor() != null) break;
                throw new LegoCheckedException(1073948733L);
            }
            indexProcessor = processor.getPreviousProcessor();
            if (indexProcessor != null) break;
            throw new LegoCheckedException(1073948734L);
        }
        return indexProcessor;
    }

    public JSONObject modifyCustomRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId, Map<String, Object> params) {
        return this.modifyCustomRecoveryProcessInfos(planId, procType, procId, params);
    }

    private JSONObject modifyCustomRecoveryProcessInfos(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId, Map<String, Object> params) {
        Set processes;
        if (VerifyUtil.isEmpty((String)planId) || procType == null || VerifyUtil.isEmpty((String)procId) || VerifyUtil.isEmpty(params)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.addPrefixToStepParams(params);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.queryRecoveryPlan(planId, false);
        if (recoveryPlan == null) {
            throw new LegoCheckedException(201L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR);
        JSONObject publicParams = null;
        if (12 != recoveryPlan.getProtectGroup().getPoType()) {
            RecoveryProcessor processor = this.getRecoveryProcessorById(procId);
            publicParams = CustomStepUtil.checkStepParams(procType, params, recoveryPlan, processor);
        }
        if ((processes = this.recoveryPlanService.getRecoveryProcesses(planId, procType.getValue())) == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = processes.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = (RecoveryProcessDefinition)iterator.next();
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (provider != null) {
            provider.modifyCustomRecoveryProcessor(rpDefinition, procId, params);
        }
        return publicParams != null ? this.updatePublicParams(recoveryPlan, publicParams) : new JSONObject();
    }

    private void addPrefixToStepParams(Map<String, Object> params) {
        Object paramObj = params.get("STEP_PARAMS");
        if (!(paramObj instanceof Map)) {
            logger.info((Object)"Illegal type of step params: %s", new Object[]{paramObj.getClass().getName()});
            return;
        }
        Map stepParams = (Map)paramObj;
        HashMap tempMap = new HashMap();
        for (Map.Entry entry : stepParams.entrySet()) {
            if (ContextParamConstant.RESERVED_PARAM_NAMES.contains(entry.getKey()) || ((String)entry.getKey()).startsWith("BCM_")) {
                tempMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            tempMap.put("BCM_" + (String)entry.getKey(), entry.getValue());
        }
        stepParams.clear();
        stepParams.putAll(tempMap);
    }

    public RecoveryProcessor getRecoveryProcessorById(String procId) {
        List results = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from RecoveryProcessor where procId = ?", new Object[]{procId});
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.error((Object)("incorrect step id: " + procId));
            throw new LegoCheckedException(2117645L);
        }
        return (RecoveryProcessor)results.get(0);
    }

    private JSONObject updatePublicParams(RecoveryPlan recoveryPlan, JSONObject publicParams) {
        JSONObject result = new JSONObject();
        String protectGroupId = recoveryPlan.getProtectGroup().getUuid();
        List scheduleList = this.protectGroupService.getAllSchedule(protectGroupId);
        Optional<Schedule> scheduleOptional = scheduleList.stream().filter(s -> ScheduleProtectedType.SNAPSHOT.getValue() == s.getProtectedType()).findFirst();
        if (!scheduleOptional.isPresent()) {
            return result;
        }
        Schedule schedule = scheduleOptional.get();
        Map scheduleExtParameters = schedule.getExtParameters();
        String publicScriptParam = (String)scheduleExtParameters.get("publicParam");
        JSONObject oldPublicParams = JSONObject.fromObject((Object)publicScriptParam);
        oldPublicParams.putAll((Map)publicParams);
        scheduleExtParameters.put("publicParam", oldPublicParams.toString());
        schedule.setExtParameterDatas(JSONObject.fromObject((Object)scheduleExtParameters).toString());
        this.protectGroupService.updateSchedule(protectGroupId, schedule);
        return result;
    }

    public Map<String, Object> getCustomRecoveryProcessorInfos(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        if (VerifyUtil.isEmpty((String)planId) || procType == null || VerifyUtil.isEmpty((String)procId)) {
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = this.recoveryPlanService.isRecoveryPlanExisted(planId);
        if (!isExisted) {
            throw new LegoCheckedException(201L);
        }
        Set protectGroups = this.recoveryPlanService.getProtectGroupsByPlanId(planId, false);
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            throw new LegoCheckedException(201L);
        }
        Set processes = this.recoveryPlanService.getRecoveryProcesses(planId, procType.getValue());
        if (VerifyUtil.isEmpty((Collection)processes)) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = processes.iterator();
        Iterator pgIterator = protectGroups.iterator();
        if (!iterator.hasNext() || !pgIterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = (RecoveryProcessDefinition)iterator.next();
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((ProtectGroup)((ProtectGroup)pgIterator.next()));
        if (provider == null) {
            throw new LegoCheckedException(-1L);
        }
        return provider.getCustomRecoveryProcessorInfos(rpDefinition, procType, procId);
    }

    public void syncPtPropsToRp(String recoveryPlanId) {
        RecoveryPlan plan = this.recoveryPlanService.getRecoveryPlan(recoveryPlanId);
        if (plan == null) {
            logger.error((Object)"Recovery plan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = plan.getProtectGroup();
        if (pg.getPoType() != 11) {
            logger.error((Object)"po type isn't lun.");
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate template = pg.getTemplate();
        if (template == null) {
            logger.error((Object)"template is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (pg.getPoType() != 11 && pg.getTemplate().getType() != 2) {
            logger.info((Object)"snapshot lun support.");
            return;
        }
        for (Schedule schedule : template.getSchedules()) {
            logger.info((Object)("check schedule, type: " + schedule.getProtectedType() + ", name: " + schedule.getName()));
            if (ScheduleProtectedType.SNAPSHOT.getValue() != schedule.getProtectedType()) {
                logger.debug((Object)"schedule is not snapshot.");
                continue;
            }
            Map props = schedule.getExtParameters();
            String isUserDefined = (String)props.get("isUserDefined");
            if (Boolean.TRUE.equals(schedule.isAppConsistent()) && "0".equals(isUserDefined)) {
                this.deleteAllSchemeRecoveryProcessor(recoveryPlanId);
                String schemeId = (String)props.get("scriptSchemeId");
                if (VerifyUtil.isEmpty((String)schemeId)) {
                    logger.info((Object)"user do not choose any script scheme.");
                    return;
                }
                this.addCustomRecoveryProcessor(plan, schemeId);
                this.modifyStatusAllSchemeRecoveryProcessor(recoveryPlanId, false);
                return;
            }
            this.deleteAllSchemeRecoveryProcessor(recoveryPlanId);
        }
    }

    public void modifyStatusAllSchemeRecoveryProcessor(String planId, boolean enable) {
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlan(planId, true);
        Set recoveryProcessDefinitions = recoveryPlan.getRecoveryProcesses();
        for (RecoveryProcessDefinition definition : recoveryProcessDefinitions) {
            for (RecoveryProcessor processor : definition.getRecoveryProcessors()) {
                boolean isUserDefined = Boolean.valueOf((String)processor.getProps().get("isUserDefined"));
                if (processor.getIsPreset().booleanValue() || isUserDefined) continue;
                this.recoveryPlanService.updateRecoveryProcessorEnableStatus(planId, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)processor.getProcType()), processor.getProcId(), enable);
            }
        }
    }

    public boolean needSyncPtPropsToRp(String recoveryPlanId) {
        RecoveryPlan plan = this.recoveryPlanService.getRecoveryPlan(recoveryPlanId, true, false);
        if (plan == null) {
            throw new LegoCheckedException(201L);
        }
        PolicyTemplate template = plan.getProtectGroup().getTemplate();
        Set defs = plan.getRecoveryProcesses();
        String pgScriptSchemeId = (String)template.getProps().get("scriptSchemeId");
        String recoveryScriptSchemeId = this.getRecoverySchemeId(defs);
        return !(pgScriptSchemeId != null && pgScriptSchemeId.equals(recoveryScriptSchemeId) || pgScriptSchemeId == null && recoveryScriptSchemeId == null);
    }

    private String getRecoverySchemeId(Set<RecoveryProcessDefinition> defs) {
        for (RecoveryProcessDefinition recoveryProcessDefinition : defs) {
            Set processors = recoveryProcessDefinition.getRecoveryProcessors();
            for (RecoveryProcessor recoveryProcessor : processors) {
                String temp = (String)recoveryProcessor.getProps().get("recoveryScriptSchemeId");
                if (VerifyUtil.isEmpty((String)temp)) continue;
                return temp;
            }
        }
        return null;
    }

    public void syncModifyCustomRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId, Map<String, Object> params) {
        this.modifyCustomRecoveryProcessInfos(planId, procType, procId, params);
    }

    public void deleteAllSchemeRecoveryProcessor(String planId) {
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlan(planId, true);
        Set recoveryProcessDefinitions = recoveryPlan.getRecoveryProcesses();
        for (RecoveryProcessDefinition definition : recoveryProcessDefinitions) {
            for (RecoveryProcessor processor : definition.getRecoveryProcessors()) {
                boolean isUserDefined = Boolean.valueOf((String)processor.getProps().get("isUserDefined"));
                if (processor.getIsPreset().booleanValue() || isUserDefined) continue;
                this.deleteRecoveryProcessor(processor.getPlanId(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)processor.getProcType()), processor.getProcId());
            }
        }
    }

    public void deleteRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        this.removeRecoveryProcessor(planId, procType, procId);
    }

    private void removeRecoveryProcessor(String recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || procType == null) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.recoveryPlanService.queryRecoveryPlan(recoveryPlanId, false);
        if (recoveryPlan == null) {
            throw new LegoCheckedException(201L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR);
        Iterator iterator = this.recoveryPlanService.getRecoveryProcesses(recoveryPlanId, procType.getValue()).iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = (RecoveryProcessDefinition)iterator.next();
        if (rpDefinition == null) {
            throw new LegoCheckedException(201L);
        }
        Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor processor : recoveryProcessors) {
            if (!processor.getProcId().equals(procId) || !processor.getIsPreset().booleanValue()) continue;
            throw new LegoCheckedException(1073948732L);
        }
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (provider != null) {
            provider.deleteRecoveryProcessors(rpDefinition, procId, true);
        }
    }

    public void syncDeleteRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        this.removeRecoveryProcessor(planId, procType, procId);
    }

    public void handle(RecoveryPlan recoveryPlan) {
        HibernateUtil.execute(() -> this.addRecoveryProcessorWithScheme(HibernateUtil.getSession(), recoveryPlan));
    }

    private void addRecoveryProcessorWithScheme(Session session, RecoveryPlan recoveryPlan) {
        Schedule schedule;
        if (recoveryPlan.getProtectGroup().getPoType() == 11 && (schedule = (Schedule)recoveryPlan.getProtectGroup().getTemplate().getSchedules().stream().filter(item -> ScheduleProtectedType.SNAPSHOT.getValue() == item.getProtectedType()).findFirst().orElse(null)) != null) {
            logger.info((Object)"current type is lun, need to check snapshot schedule.");
            Map props = schedule.getExtParameters();
            if (props.containsKey("scriptSchemeId")) {
                String schemeId = (String)props.get("scriptSchemeId");
                if (VerifyUtil.isEmpty((String)schemeId)) {
                    logger.info((Object)"script scheme info is empty.");
                    return;
                }
                logger.info((Object)"recovery plan will add custom steps.");
                IRecoveryPlanCustomStepService customStepService = (IRecoveryPlanCustomStepService)ServiceLocator.getInstance().getService(IRecoveryPlanCustomStepService.class);
                customStepService.addCustomRecoveryProcessor(session, recoveryPlan, schemeId, false);
                this.disableNewCustomProcessor(recoveryPlan);
            } else {
                logger.info((Object)"recovery plan do not need to add custom steps.");
            }
        }
    }

    private void disableNewCustomProcessor(RecoveryPlan recoveryPlan) {
        for (RecoveryProcessDefinition definition : recoveryPlan.getRecoveryProcesses()) {
            for (RecoveryProcessor processor : definition.getRecoveryProcessors()) {
                if (processor.getIsPreset().booleanValue()) continue;
                processor.setIsEnabled(Boolean.valueOf(false));
            }
        }
    }
}

