/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.replication.service.impl.AbstractReplicationService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public class RecoveryResourceServiceImpl
extends AbstractReplicationService
implements IRecoveryResourceService {
    private IMoDao moDao;

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public String getStorageType(String deviceId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceId);
        List storageUnits = this.moDao.findMoBy(StorageUnit.class, props);
        if (null == storageUnits || storageUnits.isEmpty()) {
            return null;
        }
        String storageType = ((StorageUnit)storageUnits.iterator().next()).getClass().getName();
        return storageType;
    }

    public Lun getTargetLunByPair(String replicationPairId, String srcDeviceId, String tgtDeviceId) {
        if (replicationPairId == null || srcDeviceId == null || tgtDeviceId == null) {
            return null;
        }
        ReplicationTargetLun targetLun = this.getTargetLun(tgtDeviceId, replicationPairId, srcDeviceId);
        if (null == targetLun) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", tgtDeviceId);
        props.put("lunId", targetLun.getTgtLunId());
        List luns = this.moDao.findMoBy(Lun.class, props);
        Lun lun = null;
        if (null != luns && !luns.isEmpty()) {
            lun = (Lun)luns.get(0);
        }
        return lun;
    }

    public ReplicationRelation queryReplication(String deviceSN, String replicationId, boolean isConsistentGroup) {
        return super.queryReplication(deviceSN, replicationId, isConsistentGroup);
    }

    public Site getStorageRegisteredSite(String deviceSN) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(deviceSN);
        if (null == drResource) {
            logger.error((Object)("The device does not exist. DevSN:" + deviceSN), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        return siteService.getSiteById(drResource.getSiteId());
    }

    public ReplicationRelation queryReplication(String srcDeviceId, String tgtDeviceId, String replicationId, boolean isConsistentGroup) {
        String queryArrayId = RecoveryTaskUtil.getAirGapQueryArrayId((String)srcDeviceId, (String)tgtDeviceId);
        if (!VerifyUtil.isEmpty((String)queryArrayId)) {
            return this.queryReplication(queryArrayId, replicationId, isConsistentGroup);
        }
        ReplicationRelation replication = this.queryReplication(srcDeviceId, replicationId, isConsistentGroup);
        if (null == replication) {
            replication = this.queryReplication(tgtDeviceId, replicationId, isConsistentGroup);
        }
        return replication;
    }

    public Lun getTargetLunById(String tgtDeviceId, String lunId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", tgtDeviceId);
        props.put("lunId", lunId);
        List groups = this.moDao.findMoBy(Lun.class, props);
        if (null == groups || groups.isEmpty() || groups.size() != 1) {
            return null;
        }
        return (Lun)groups.get(0);
    }

    public Host getHostByUuid(String hostUuid) {
        ManagedObject mObject = this.moDao.getMoByUuid(hostUuid, Boolean.valueOf(true));
        Host host = null;
        if (null != mObject && mObject instanceof Host) {
            host = (Host)mObject;
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrResource getDrResourceByID(String hostOrGroupId) {
        Session session;
        DrResource drResource;
        block4: {
            drResource = null;
            session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String queryHQL = "from DrResource where deviceSn=:deviceSn";
                Query query = session.createQuery(queryHQL);
                query.setString("deviceSn", hostOrGroupId);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) break block4;
                drResource = (DrResource)results.get(0);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting drresource failed. Id:" + hostOrGroupId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return drResource;
    }

    public List<DrHost> getDrHostsByDrHostOrGroupId(String drHostOrGroupId) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drResource = recoveryService.getDrResourceByID(drHostOrGroupId);
        ArrayList<DrHost> drHosts = new ArrayList<DrHost>();
        if (drResource instanceof DrHostGroup) {
            for (DrResource drHost : drResource.getChildResources()) {
                drHosts.add((DrHost)drHost);
            }
        } else if (drResource instanceof DrHost) {
            drHosts.add((DrHost)drResource);
        }
        return drHosts;
    }

    public List<DatabaseInstance> getDatabaseInstancesByHostSN(String hostSN) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hostSN", hostSN);
        return this.moDao.findMoBy(DatabaseInstance.class, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DatabaseInstance> getDatabaseInstancesByDbName(String dbName, int dbType) {
        Session session;
        List<DatabaseInstance> matcheddbInstances;
        block4: {
            matcheddbInstances = new ArrayList<DatabaseInstance>();
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("select distinct dbInst.HOSTSN, dbInst.instanceName ");
            strBuilder.append("from ti_DatabaseInstance dbInst, ");
            strBuilder.append("(select db.name, mo.parent_id ");
            strBuilder.append("from ti_Database db, T_managedobject mo ");
            strBuilder.append("where db.MOID = mo.moid and db.name=:dbName) dbtemp ");
            strBuilder.append("where dbInst.moId=dbtemp.parent_id and dbInst.dbType=:dbType");
            session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                NativeQuery query = session.createSQLQuery(strBuilder.toString());
                query.setString("dbName", dbName);
                query.setInteger("dbType", dbType);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block4;
                matcheddbInstances = this.constructDatabaseInstances(results);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting database instances by db name failed. DBName:" + dbName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return matcheddbInstances;
    }

    private List<DatabaseInstance> constructDatabaseInstances(List<?> results) {
        ArrayList<DatabaseInstance> matchedDbInstances = new ArrayList<DatabaseInstance>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
            DatabaseInstance dbInstance = new DatabaseInstance();
            dbInstance.setHostSN(String.valueOf(values[0]));
            dbInstance.setInstanceName(String.valueOf(values[1]));
            matchedDbInstances.add(dbInstance);
        }
        return matchedDbInstances;
    }

    public ReplicationRelation queryReplication(Site site, String srcDeviceId, String tgtDeviceId, String replicationId, boolean isConsistentGroup) {
        ReplicationRelation replication;
        if (null == site) {
            logger.error((Object)"The site is null");
        }
        if (null == (replication = this.queryReplication(srcDeviceId, replicationId, isConsistentGroup))) {
            replication = this.queryReplication(tgtDeviceId, replicationId, isConsistentGroup);
        }
        return replication;
    }

    public VstoreReplicationPair queryVstoreReplicationPair(String srcDeviceId, String tgtDeviceId, String replicationId) {
        VstoreReplicationPair vstoreReplicationPair = null;
        vstoreReplicationPair = this.queryVstoreReplicationPair(srcDeviceId, replicationId);
        if (null == vstoreReplicationPair) {
            vstoreReplicationPair = this.queryVstoreReplicationPair(tgtDeviceId, replicationId);
        }
        return vstoreReplicationPair;
    }

    private VstoreReplicationPair queryVstoreReplicationPair(String deviceSN, String replicationId) {
        if (null == deviceSN || null == replicationId) {
            logger.error((Object)("Parameter is invalid. DeviceId:" + deviceSN + ",RepId:" + replicationId), 90160758784001L);
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("remoteDeviceSn", deviceSN);
        props.put("vstorePairId", replicationId);
        List groups = this.moDao.findMoBy(VstoreReplicationPair.class, props);
        if (null != groups && groups.size() == 1) {
            return (VstoreReplicationPair)groups.get(0);
        }
        logger.error((Object)("The replication does not exist. DeviceId:" + deviceSN + ",RepId:" + replicationId), 90160758784001L);
        return null;
    }

    public <T extends ManagedObject> List<T> queryMoList(Class<T> t, Map<String, Object> queryCondition) {
        if (VerifyUtil.isEmpty(t)) {
            throw new LegoCheckedException(1073947393L);
        }
        return CommonDAOLocator.getMoDao().findMoBy(t, queryCondition);
    }
}

