/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.morphological.service.impl;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.base.sdk.model.AbstractEntity;
import com.huawei.ism.cbb.base.dao.impl.MoDao;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.morphological.sdk.model.MorphologicalInfo;
import com.huawei.ism.drm.morphological.sdk.service.IMorphologicalInfoBuilder;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractMorphologicalInfoImpl
implements IMorphologicalInfoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(AbstractMorphologicalInfoImpl.class);
    public static final String COLON = ":";
    public static final String ARROW = "->";
    private IStorageService storageService;
    private IResourceService resourceService;
    private ISiteService siteService;

    protected Collection<RecoveryTask> getRecoveryTasks(RecoveryProcessorContext context) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks", Collection.class);
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            LOGGER.error((Object)"RecoveryTasks is empty.");
            throw new LegoCheckedException(1677929530L);
        }
        return recoveryTasks;
    }

    protected static List<String> getHyperMetroDevSnListFromContext(RecoveryProcessorContext context) {
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)context.getAttribute("Recovery_PgReplica", ProtectGroupReplica.class);
        List<String> wwnList = protectGroupReplica.getReplicas().stream().flatMap(replica -> replica.getStorageInfos().stream()).map(RelicaStorageInfo::getProtectObjectStorageWwn).collect(Collectors.toList());
        return AbstractMorphologicalInfoImpl.doGetHyperMetroPairs(wwnList).stream().map(AbstractEntity::getDevSn).collect(Collectors.toList());
    }

    protected Set<Site> getAllHyperMetroPairSites(List<String> hyperMetroDevSnList) {
        return hyperMetroDevSnList.stream().map(devSn -> this.getSiteService().getSiteByDeviceSn(devSn)).collect(Collectors.toSet());
    }

    protected static List<String> getHyperMetroDevSnListByContext(RecoveryProcessorContext context) {
        List hyperMetroPairs = (List)context.getAttribute("hyperMetroPairs", List.class);
        if (!VerifyUtil.isEmpty((Collection)hyperMetroPairs)) {
            List<String> wwnList = hyperMetroPairs.stream().map(HyperMetroPair::getResourceWwn).distinct().collect(Collectors.toList());
            return AbstractMorphologicalInfoImpl.doGetHyperMetroPairs(wwnList).stream().map(AbstractEntity::getDevSn).collect(Collectors.toList());
        }
        HyperMetroConsistentGroup hyperMetroConsistentGroup = (HyperMetroConsistentGroup)context.getAttribute("hyperMetroConsistentGroup", HyperMetroConsistentGroup.class);
        if (!VerifyUtil.isEmpty((Object)hyperMetroConsistentGroup)) {
            return AbstractMorphologicalInfoImpl.doGetHyperMetroConsistentGroups(hyperMetroConsistentGroup.getId()).stream().map(AbstractEntity::getDevSn).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private static List<HyperMetroPair> doGetHyperMetroPairs(List<String> wwnList) {
        HashMap<String, String[]> conditions = new HashMap<String, String[]>();
        conditions.put("resourceWwn", wwnList.toArray(new String[0]));
        return ((MoDao)ServiceLocator.getInstance().getService(MoDao.class)).findMoBy(HyperMetroPair.class, conditions);
    }

    private static List<HyperMetroConsistentGroup> doGetHyperMetroConsistentGroups(String cgId) {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("id", cgId);
        return ((MoDao)ServiceLocator.getInstance().getService(MoDao.class)).findMoBy(HyperMetroConsistentGroup.class, conditions);
    }

    protected static ProtectGroupReplica filterPgrByRecoverySiteId(Set<ProtectGroupReplica> replicaList, String siteId) {
        Optional<ProtectGroupReplica> optionalReplica = replicaList.stream().filter(e -> e.getRecoverySite().equals(siteId)).findFirst();
        if (!optionalReplica.isPresent()) {
            LOGGER.error((Object)"Can not get protect group replica by disaster site id.");
            throw new LegoCheckedException(1677929530L);
        }
        return optionalReplica.get();
    }

    protected MorphologicalInfo build3DCMorphologicalInfo(Set<Site> hyperMetroSites, Site disasterSite, Site productSite) {
        this.checkHyperMetroSitesNum(hyperMetroSites);
        Iterator<Site> iterator = hyperMetroSites.iterator();
        Site siteA = iterator.next();
        Site siteB = iterator.next();
        String morphologicalInfo = productSite.getSiteId().equals(siteA.getSiteId()) ? siteB.getName() + COLON + siteA.getName() + ARROW + disasterSite.getName() : siteA.getName() + COLON + siteB.getName() + ARROW + disasterSite.getName();
        return new MorphologicalInfo(morphologicalInfo);
    }

    protected MorphologicalInfo build3DCReserveMorphologicalInfo(Set<Site> hyperMetroSites, Site disasterSite, Site productSite) {
        this.checkHyperMetroSitesNum(hyperMetroSites);
        Iterator<Site> iterator = hyperMetroSites.iterator();
        Site siteA = iterator.next();
        Site siteB = iterator.next();
        String morphologicalInfo = disasterSite.getSiteId().equals(siteA.getSiteId()) ? productSite.getName() + ARROW + siteA.getName() + COLON + siteB.getName() : productSite.getName() + ARROW + siteB.getName() + COLON + siteA.getName();
        return new MorphologicalInfo(morphologicalInfo);
    }

    protected void checkHyperMetroSitesNum(Set<Site> hyperMetroSites) {
        if (hyperMetroSites.size() != 2) {
            LOGGER.error((Object)"Hyper metro contains more or less than two devices.");
            throw new LegoCheckedException(1677929530L);
        }
    }

    public IStorageService getStorageService() {
        return this.storageService;
    }

    public IResourceService getResourceService() {
        return this.resourceService;
    }

    public ISiteService getSiteService() {
        return this.siteService;
    }

    public void setStorageService(IStorageService storageService) {
        this.storageService = storageService;
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }
}

