/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ProtectionTaskConstant;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobExtendUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTaskList;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ArraySynMonitorSubAction
extends AbstractBaseProtectExtendAction {
    private static final Log logger = LogFactory.getInstance(ArraySynMonitorSubAction.class);
    private static final String SYN_COMPLETE = "com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Synchronization.Complete";
    private static final String SYN_GOING_ON = "com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Synchronization";
    private static final String SYN_PROGRESS = "com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Synchronization.Progress";
    private final ReplicationRelationBo rrb;
    private final long overTime;

    public ArraySynMonitorSubAction(ReplicationRelationBo rrb, long overTime) {
        this.rrb = rrb;
        this.overTime = overTime;
    }

    public void preExcute(ActionContext context) {
        super.preExcute(context);
        if (this.rrb.isConsistentGroup()) {
            this.setName("com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.ReplicationGroup");
        } else {
            this.setName("com.huawei.ism.drm.protection.framework.engine.action.ArraySynMonitorSubAction.Replication");
        }
        this.setNameParams(this.rrb.getReplicationId());
    }

    public boolean doExecute(ActionContext context) {
        boolean res = this.doMonitor(context);
        if (!res) {
            EnablePortTaskList tasks = (EnablePortTaskList)context.getObject("linkPortTaskInfo", EnablePortTaskList.class);
            Integer executionMode = (Integer)context.getObject("PG_EXECUTION_MODE", Integer.class);
            AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
            tasks.getEnablePortTasks().forEach(task -> portUtil.consumeFailedAirGapTask(task, executionMode.intValue()));
            if (this.isScheduleFirst(context)) {
                this.splitReplication(context);
            }
        }
        return res;
    }

    private void splitReplication(ActionContext context) {
        String srcDeviceSn = this.rrb.getSrcDeviceSn();
        String tgtDeviceSn = this.rrb.getTgtDeviceSn();
        StorageReplicationManagerProxy managerProxy = StorageReplicationManagerProxy.getInstance();
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        if (this.rrb.isConsistentGroup()) {
            results.add(managerProxy.splitReplication(srcDeviceSn, tgtDeviceSn, this.rrb.getReplicationId(), true));
        } else {
            List repPairs = (List)context.getObject("REPLICATION_PARIS", List.class);
            repPairs = Optional.ofNullable(repPairs).orElseGet(Collections::emptyList);
            for (ReplicationPair repPair : repPairs) {
                results.add(managerProxy.splitReplication(repPair.getSrcDevSN(), repPair.getTgtDevSN(), repPair.getReplicationId(), false));
            }
        }
        List failedResults = results.stream().filter(result -> !result.isSuccess()).collect(Collectors.toList());
        if (!failedResults.isEmpty()) {
            logger.error((Object)"Errors happened when splitting pairs: failed=%s, total=%s", new Object[]{failedResults.size(), results.size()});
        }
    }

    private boolean doMonitor(ActionContext context) {
        List<ReplicationPair> replicationPair;
        if (this.rrb.isConsistentGroup()) {
            return this.monitorArrayReplicationProgress(false, context);
        }
        ArrayList<String> queryLunIds = new ArrayList<String>(this.rrb.getTgtLuns().keySet());
        Integer resourceType = this.rrb.getResourceType();
        if (!this.isAirGap(context)) {
            replicationPair = this.getReplicationPairs(queryLunIds, this.rrb.getSrcDeviceSn(), resourceType);
        } else {
            ArrayList tgtLunIds = new ArrayList(this.rrb.getTgtLuns().values());
            String queryDevSn = RecoveryTaskUtil.getAirGapQueryArrayId((String)this.rrb.getSrcDeviceSn(), (String)this.rrb.getTgtDeviceSn());
            ArrayList<String> queryLunIdList = queryDevSn.equals(this.rrb.getTgtDeviceSn()) ? tgtLunIds : queryLunIds;
            replicationPair = this.getReplicationPairs(queryLunIdList, queryDevSn, resourceType);
        }
        if (CollectionUtils.isEmpty(replicationPair)) {
            logger.error((Object)"ReplicationPair is empty, all masterLunIds :%s, resourceType=%s", new Object[]{queryLunIds, resourceType});
            this.setDetail("lego.err.1073947394");
            return false;
        }
        context.addObject("REPLICATION_PARIS", replicationPair);
        Integer localResType = replicationPair.iterator().next().getLocalResType();
        if (Integer.valueOf(XveMOType.LUN.getValue()).equals(localResType) || localResType == null) {
            return this.monitorArrayReplicationProgress(false, context);
        }
        if (Integer.valueOf(XveMOType.FILESYSTEM.getValue()).equals(localResType)) {
            return this.monitorArrayReplicationProgress(true, context);
        }
        logger.error((Object)"Cannot find the device type, localResType: %s", new Object[]{String.valueOf(localResType)});
        this.setDetail("lego.err.1073948444");
        this.setDetailParams(this.constructParams(new String[]{this.rrb.getSrcDeviceSn()}));
        return false;
    }

    private boolean isAirGap(ActionContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        return PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType());
    }

    private List<ReplicationPair> getReplicationPairs(List<String> getLunIds, String queryDevSn, Integer resourceType) {
        List<ReplicationPair> replicationPair;
        String luns = StringUtil.arrayToStrWithSplit((Object[])getLunIds.toArray(), (String)";");
        try {
            replicationPair = this.getPairsByLun(queryDevSn, getLunIds, resourceType);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Get replication pair failed, deviceSn: %s, luns: %s, errorMsg: %s", new Object[]{this.rrb.getSrcDeviceSn(), luns, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return Collections.emptyList();
        }
        catch (Exception e) {
            logger.error((Object)"Get replication pair failed, deviceSn: %s, luns: %s, errorMsg: %s", new Object[]{this.rrb.getSrcDeviceSn(), luns, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setDetail("lego.err.-1");
            return Collections.emptyList();
        }
        return replicationPair;
    }

    private boolean monitorArrayReplicationProgress(boolean isNas, ActionContext context) {
        while (true) {
            if (ProtectionJobUtil.checkWhetherTerminateTask((ActionContext)context)) {
                this.terminateTask();
                this.setDetail("lego.err." + (context.isShouldTerminate() ? 1073948470L : 1073948226L));
                return false;
            }
            CommUtil.pauseThread((long)5000L);
            Optional<AbstractBaseProtectAction.ReplicationProgress> progressOpt = this.getReplicationProgress();
            if (!progressOpt.isPresent()) {
                return false;
            }
            AbstractBaseProtectAction.ReplicationProgress progress = progressOpt.get();
            if (progress.isCompleted()) {
                logger.info((Object)"Synchronize replication success. ");
                this.setDetail(SYN_COMPLETE);
                return true;
            }
            long curTime = System.currentTimeMillis();
            if (curTime > this.overTime && this.isScheduleFirst(context)) {
                logger.error((Object)"Synchronize replication time out.");
                this.terminateTask();
                this.setDetail("lego.err.1073948744");
                return false;
            }
            if (isNas) {
                this.setDetail(SYN_GOING_ON);
                continue;
            }
            this.setDetail(SYN_PROGRESS);
            this.setDetailParams(progress.getProgress() + "%");
        }
    }

    private boolean isScheduleFirst(ActionContext context) {
        if (this.isAirGap(context)) {
            return true;
        }
        Schedule schedule = this.getSchedule(context);
        String execMode = (String)schedule.getExtParameters().get("executionMode");
        return !ProtectionTaskConstant.SyncExecutionMode.SYNC_FIRST.getMode().equals(execMode);
    }

    private Optional<AbstractBaseProtectAction.ReplicationProgress> getReplicationProgress() {
        AbstractBaseProtectAction.ReplicationProgress progress;
        try {
            progress = this.syncProgress(this.rrb);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Synchronize replication failed. SrcStorageProviderSN: %s, TgtStorageProviderSN: %s", new Object[]{this.rrb.getSrcDeviceSn(), this.rrb.getTgtDeviceSn(), e});
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return Optional.empty();
        }
        catch (Exception e) {
            logger.error((Object)"Synchronize replication failed. SrcStorageProviderSN: %s,TgtStorageProviderSN: %s, errorMsg: %s", new Object[]{this.rrb.getSrcDeviceSn(), this.rrb.getTgtDeviceSn(), ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setDetail("lego.err.1073948448");
            return Optional.empty();
        }
        return Optional.of(progress);
    }

    private void terminateTask() {
        try {
            ProtectionJobExtendUtil.terminateTask(this.rrb);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
        }
    }

    private List<ReplicationPair> getPairsByLun(String deviceSn, List<String> masterLunIds, Integer resourceType) {
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteByDeviceSn(deviceSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"GetPairsByLun error, site is null, deviceSN: %s", new Object[]{deviceSn});
            return null;
        }
        String srcLunId = null;
        if (!masterLunIds.isEmpty()) {
            srcLunId = (String)masterLunIds.stream().findFirst().get();
        }
        return StorageReplicationManagerProxy.getInstance().queryReplications(deviceSn, srcLunId, resourceType);
    }
}

