/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;

public class BaseAsyncEndAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(BaseAsyncEndAction.class);

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BaseAsyncEndAction begin to execute,pgId:" + protectGroup.getUuid()), 90160758786988L);
        return this.checkSyncResultWithWait(context);
    }

    private boolean checkSyncResultWithWait(ActionContext context) {
        long sleepTimes = 5000L;
        return this.checkSyncIsCompleted(this.getReplicationRelationBos(context), sleepTimes);
    }

    protected boolean checkSyncIsCompleted(List<ReplicationRelationBo> objs, long timeSleep) {
        long curTime;
        long startTime = System.currentTimeMillis();
        do {
            CommUtil.pauseThread((long)timeSleep);
            boolean isAllCompleted = true;
            for (ReplicationRelationBo obj : objs) {
                try {
                    boolean isCompleted = this.isSyncCompleted(obj);
                    isAllCompleted = isAllCompleted && isCompleted;
                }
                catch (LegoCheckedException e) {
                    logger.error((Object)("Synchronize replication failed. SrcStorageProviderSN:" + obj.getSrcDeviceSn() + ",TgtStorageProviderSN:" + obj.getTgtDeviceSn()), (Throwable)e, 90160758784001L);
                    this.setDetail(e.getErrorMessageKey());
                    this.setDetailParams(this.constructParams(e.getParameters()));
                    return false;
                }
                catch (Exception e) {
                    logger.error((Object)("Synchronize replication failed. SrcStorageProviderSN:" + obj.getSrcDeviceSn() + ",TgtStorageProviderSN:" + obj.getTgtDeviceSn() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                    this.setDetail("lego.err.1073948448");
                    return false;
                }
            }
            if (!isAllCompleted) continue;
            logger.info((Object)"Synchronize replication success. ", 90160758784000L);
            return true;
        } while (0x6DDD00L > (curTime = System.currentTimeMillis()) - startTime);
        logger.error((Object)"Synchronize replication time out. ", 90160758784001L);
        this.setDetail("lego.err.1073948744");
        return false;
    }

    protected boolean isSyncCompleted(ReplicationRelationBo obj) {
        IRecoveryProcessHandler recoveryProcHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        List targetLuns = recoveryProcHandler.querySyncStatus(obj.getSrcDeviceSn(), obj.getTgtDeviceSn(), obj.getReplicationId(), obj.isConsistentGroup());
        if (VerifyUtil.isEmpty((Collection)targetLuns)) {
            logger.error((Object)"Query Replication Target Lun error when check isSyncCompleted state.", 1073948461L);
            throw new LegoCheckedException(1073948461L, "query Replication Target Lun error when check isSyncCompleted state.");
        }
        boolean isCompleted = true;
        for (ReplicationTargetLun repTargetLun : targetLuns) {
            int pairStatus = repTargetLun.getPairStatus();
            if (2 != pairStatus && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != pairStatus) continue;
            isCompleted = false;
            break;
        }
        return isCompleted;
    }
}

