/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTaskList;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class EnableAirGapPortAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(EnableAirGapPortAction.class);
    protected static final String ENABLE_PORTS_COMPLETE = "com.huawei.ism.drm.protection.framework.engine.action.EnableAirGapPortAction.EnablePorts.Complete";
    protected static final String ENABLE_PORTS_ALREADY = "com.huawei.ism.drm.protection.framework.engine.action.EnableAirGapPortAction.EnablePorts.Enabled";

    public boolean doExecute(ActionContext context) {
        boolean ret = this.getEnablePortResult(context);
        if (!ret) {
            EnablePortTaskList tasks = (EnablePortTaskList)context.getObject("linkPortTaskInfo", EnablePortTaskList.class);
            Integer executionMode = (Integer)context.getObject("PG_EXECUTION_MODE", Integer.class);
            logger.error((Object)"Enable port failed, begin to to consume failed taskId: %s.", new Object[]{((EnablePortTask)tasks.getEnablePortTasks().get(0)).getTaskId()});
            AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
            tasks.getEnablePortTasks().forEach(task -> portUtil.consumeFailedAirGapTask(task, executionMode.intValue()));
        } else {
            ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY", ProtectGroup.class);
            AirGapLinkPortUtil.runAirGapSyncRateAtOnce((ProtectGroup)pg);
        }
        return ret;
    }

    protected boolean getEnablePortResult(ActionContext context) {
        logger.info((Object)"EnableAirGapPortAction begin to execute.");
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
            return true;
        }
        List linkPorts = AirGapLinkPortUtil.getAirGapPortList((ProtectGroup)pg);
        if (CollectionUtils.isEmpty((Collection)linkPorts)) {
            logger.error((Object)"Error: not find pg ports. PgName: %s", new Object[]{pg.getName()});
            this.setDetail("lego.err.1073948475");
            return false;
        }
        HashSet<String> failedPortNames = new HashSet<String>();
        long startTime = System.currentTimeMillis();
        try {
            if (!this.checkAndEnableAirGapLinkPort(context, linkPorts, pg, failedPortNames)) {
                boolean shouldTerminate = context.isShouldTerminate();
                logger.error((Object)"checkAirGapLinkPort failed, shouldTerminate: %s", new Object[]{shouldTerminate});
                this.setDetail("lego.err." + (shouldTerminate ? 1073948470L : 1073948390L));
                if (!shouldTerminate) {
                    this.setDetailParams(AirGapLinkPortUtil.getPortNames(failedPortNames));
                }
                return false;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Enable port exception.", (Throwable)e);
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        long endTime = System.currentTimeMillis();
        HashSet enabledPortNames = new HashSet();
        linkPorts.forEach(linkPort -> {
            if (CollectionUtils.isEmpty((Collection)failedPortNames) || !failedPortNames.contains(linkPort.getPortName())) {
                enabledPortNames.add(linkPort.getPortName());
            }
        });
        if (endTime - startTime <= 30000L) {
            this.setDetail(ENABLE_PORTS_ALREADY);
        } else {
            this.setDetail(ENABLE_PORTS_COMPLETE);
        }
        this.setDetailParams(AirGapLinkPortUtil.getPortNames(enabledPortNames));
        return true;
    }

    private boolean checkAndEnableAirGapLinkPort(ActionContext context, List<StorageLinkPort> linkPorts, ProtectGroup pg, Set<String> failedPortNames) {
        List portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(portIds)) {
            logger.error((Object)"Error: not find pg portIds. PgName: %s", new Object[]{pg.getName()});
            throw new LegoCheckedException(201L);
        }
        ArrayList<StorageLinkPort> needEnablePorts = new ArrayList<StorageLinkPort>();
        int execMode = (Integer)context.getObject("PG_EXECUTION_MODE");
        String taskId = UUIDGenerator.getUUID();
        for (StorageLinkPort linkPort : linkPorts) {
            StorageLinkPort portInDb = this.getPortInDb(linkPort);
            if (VerifyUtil.isEmpty((Object)portInDb)) {
                logger.error((Object)"Not get port in db by id: %s. please check.", new Object[]{linkPort.getPortId()});
                throw new LegoCheckedException(201L);
            }
            DrmEnumDefine.ExecTypeEnum execTypeEnum = AirGapLinkPortUtil.getExecTypeEnum((ProtectGroup)pg, (int)execMode);
            portInDb.setExecTypeEnum(execTypeEnum);
            portInDb.setScheduleModeType(execMode == 1 ? DrmEnumDefine.ExecTypeEnum.MANUAL : DrmEnumDefine.ExecTypeEnum.AUTO);
            portInDb.setTaskId(taskId);
            portInDb.setOperator(pg.getName());
            portInDb.setPgWorkPorts(portIds);
            portInDb.setOperateType(1);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)portInDb);
            logger.info((Object)"Need to enable portName: %s", new Object[]{portInDb.getPortName()});
            needEnablePorts.add(portInDb);
        }
        ProtectGroupReplica replica = pg.getAnyoneReplicationReplica();
        EnablePortTaskList portTasks = new EnablePortTaskList();
        EnablePortTask task = new EnablePortTask();
        task.setPortList(needEnablePorts);
        task.setDevSn(((StorageLinkPort)needEnablePorts.get(0)).getDevSn());
        task.setTaskId(taskId);
        task.setRemoteDevSn(replica.getProductArray());
        task.setProtectGroup(pg);
        portTasks.addEnablePortTask(task);
        context.addObject("linkPortTaskInfo", (Object)portTasks);
        AirGapLinkProcessor linkProcessor = AirGapLinkProcessor.getInstance();
        linkProcessor.addEnablePortsToProcessor(task);
        if (CollectionUtils.isEmpty(needEnablePorts)) {
            return true;
        }
        AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
        HashSet waitPortsSet = new HashSet(needEnablePorts);
        return portUtil.isHasPortEnable(waitPortsSet, failedPortNames);
    }

    protected StorageLinkPort getPortInDb(StorageLinkPort linkPort) {
        return (StorageLinkPort)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(StorageLinkPort.class, (Serializable)((Object)linkPort.getPortId()));
    }
}

