/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class SecondStageSitePrepareAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(SecondStageSitePrepareAction.class);
    private ProtectGroup protectGroup = null;
    private int location;

    public void preExcute(ActionContext context) {
        this.protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        TreeSet<Integer> allProtectLocation = new TreeSet<Integer>();
        for (Schedule schedule : this.protectGroup.getTemplate().getSchedules()) {
            if (schedule.getProtectedType() == 2 || schedule.getProtectedType() == 100) continue;
            allProtectLocation.add(schedule.getProtectLocation());
        }
        if (VerifyUtil.isEmpty(allProtectLocation) || allProtectLocation.size() != 2) {
            return;
        }
        Iterator locationIter = allProtectLocation.iterator();
        locationIter.next();
        this.location = (Integer)locationIter.next();
        context.addObject("PG_EXECUTE_LOCATION", (Object)this.location);
        Site recoverSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(this.getRecoverSiteIdBySchedule(this.location, this.protectGroup));
        this.setNameParams(recoverSite.getName() == null ? recoverSite.getSiteId() : recoverSite.getName());
    }

    public boolean doExecute(ActionContext context) {
        ProtectGroupReplica pgReplica = ExecuteReplicaManager.getInstance().calculateExecuteReplica(this.protectGroup, this.location);
        return !VerifyUtil.isEmpty((Object)pgReplica) && this.prepare(context, pgReplica);
    }

    protected boolean prepare(ActionContext context, ProtectGroupReplica replica) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("SecondStageSitePrepareAction begin to execute:" + pg.getName()), 90160758786988L);
        context.addObject("SECOND_STAGE_REPLICA", (Object)replica);
        if (DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus() != pg.getStatus()) {
            logger.error((Object)"pg'status is not Running.", 90160758786989L);
            this.setDetail("lego.err.1073948458");
            return false;
        }
        HashSet pos = new HashSet();
        pos.addAll(pg.getPolist());
        HashSet poReplicas = new HashSet();
        poReplicas.addAll(replica.getReplicas());
        context.addObject("PO_ENTITY", pos);
        context.addObject("PG_REPLICA_ENTITY", (Object)replica);
        context.addObject("PO_REPLICA_ENTITY", poReplicas);
        logger.info((Object)("SecondStageSitePrepareAction end to execute:" + pg.getName()), 90160758786988L);
        try {
            ProtectionJobUtil.getInstance().checkHyperMetro(pg, context, replica);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        return true;
    }
}

