/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupSynchronizer;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ProtectionJobExtendUtil {
    private static final Log logger = LogFactory.getInstance(ProtectionJobExtendUtil.class);
    private static final List<Integer> CHECK_HYPERMETRO_MASTER_LUN = Arrays.asList(19, 18, 28, 31, 26);
    private static ProtectionJobExtendUtil jobExtendUtil = new ProtectionJobExtendUtil();

    private ProtectionJobExtendUtil() {
    }

    public static ProtectionJobExtendUtil getInstance() {
        return jobExtendUtil;
    }

    public static void terminateTask(ReplicationRelationBo replicationRelationBo) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)replicationRelationBo)) {
            logger.error((Object)"replicationRelationBo is null!");
            return;
        }
        try {
            logger.info((Object)"start to abort task successful!");
            StorageReplicationManagerProxy.getInstance().splitReplication(replicationRelationBo.getSrcDeviceSn(), replicationRelationBo.getTgtDeviceSn(), replicationRelationBo.getReplicationId(), replicationRelationBo.isConsistentGroup());
            logger.info((Object)"abort task successful!");
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"terminateTask split replication failed. SrcStorageProviderSN:%s,TgtStorageProviderSN:%s.", new Object[]{replicationRelationBo.getSrcDeviceSn(), replicationRelationBo.getTgtDeviceSn()});
            throw ex;
        }
        catch (Exception ex) {
            String errorMsg = "terminateTask split replication failed. SrcStorageProviderSN:" + replicationRelationBo.getSrcDeviceSn() + ",TgtStorageProviderSN:" + replicationRelationBo.getTgtDeviceSn();
            ExceptionUtil.rethrowException((Throwable)ex, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public static boolean isHyperMetroInFirstSite(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            logger.error((Object)"pg is null!", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        String siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO");
        if (null != siteInfoListStr) {
            List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
            return siteInfoList.size() > 0 && ((SiteInfo)siteInfoList.get(0)).getSiteIdSet().size() >= 2;
        }
        return false;
    }

    public static List<ResourceTimeWindowRange> getTimeRangesByPg(ProtectGroup protectGroup) {
        if (!protectGroup.isAirGapType()) {
            logger.info((Object)"The site of the protectGroup{name:%s} is not a Air Gap resource.", new Object[]{protectGroup.getName()});
            return Collections.emptyList();
        }
        List linkPorts = AirGapLinkPortUtil.getAirGapPortList((ProtectGroup)protectGroup);
        Optional opt = linkPorts.stream().findAny();
        if (!opt.isPresent()) {
            logger.error((Object)"Not find StorageLinkPort by pgName: %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        List portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        AirGapLinkPortUtil linkPortUtil = AirGapLinkPortUtil.getInstance();
        List rangeList = linkPortUtil.getTimeRangesByPgPortIds(portIds, ((StorageLinkPort)opt.get()).getDevSn());
        logger.info((Object)"Get Air Gap time window: %s", new Object[]{rangeList.toString()});
        return rangeList;
    }

    public static Optional<ResourceTimeWindowRange> findSpecificTimeWindow(List<ResourceTimeWindowRange> timeWindowRanges, long timeMills) {
        return timeWindowRanges.stream().filter(range -> timeMills >= range.getStartTime().getTime() && timeMills <= range.getEndTime().getTime()).findAny();
    }

    public Integer getBackupTypeExcuteSync(Map<String, Object> parameter) {
        if (null == parameter) {
            return null;
        }
        return (Integer)parameter.get("backupTypeAfterSync");
    }

    public void checkHyperMetro(ProtectGroup protectGroup, ActionContext context) {
        this.checkHyperMetro(protectGroup, context, (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY"));
    }

    public void checkHyperMetro(ProtectGroup protectGroup, ActionContext context, ProtectGroupReplica pgReplica) {
        int templateType = protectGroup.getTemplate().getType();
        boolean is4DC = PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(templateType);
        if (is4DC && !ProtectionJobExtendUtil.isHyperMetroInFirstSite(protectGroup)) {
            return;
        }
        if (!CHECK_HYPERMETRO_MASTER_LUN.contains(templateType)) {
            return;
        }
        int resourcetype = this.getResourcetype(protectGroup);
        if (resourcetype == DrmEnumDefine.ResourceTypeE.NAS.getValue()) {
            if (templateType == 28) {
                List relationList = (List)context.getObject("VAULT_PATH");
                this.checkNasHyperMetro(relationList);
            } else {
                this.checkNasHyperMetro(pgReplica);
            }
            return;
        }
        pgReplica = this.getProtectGroupReplica(protectGroup, templateType, pgReplica);
        ArrayList<String> allWWN = new ArrayList<String>();
        allWWN.addAll(this.getAllStorageWWN(pgReplica));
        List<HyperMetroPair> pairList = this.getHyperMetroPairs(protectGroup, allWWN);
        this.checkSyncDirection(pgReplica, pairList);
    }

    private void checkSyncDirection(ProtectGroupReplica pgReplica, List<HyperMetroPair> pairList) {
        for (HyperMetroPair pair : pairList) {
            if (!pair.getDevSn().equals(pgReplica.getProductArray())) continue;
            Integer syncDirection = pair.getSyncDirection();
            if (VerifyUtil.isEmpty((Object)syncDirection)) {
                logger.error((Object)("The syncDirection is null! pairId:" + pair.getId()));
                throw new LegoCheckedException(-1L);
            }
            if (!String.valueOf(XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_REMOTE_TO_LOCAL.getValue()).equals(String.valueOf(syncDirection)) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState())) continue;
            logger.warn((Object)("hyper metro pair :" + pair.getId() + " pair devsn :" + pair.getDevSn() + " ,execute pg array :" + pgReplica.getProductArray() + ", syncDirection:" + syncDirection));
            throw new LegoCheckedException(1073948228L);
        }
    }

    private List<HyperMetroPair> getHyperMetroPairs(ProtectGroup protectGroup, List<String> allWWN) {
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List pairList = null;
        try {
            pairList = storageResourceService.getHyperMetroPairByWwn(allWWN, null, true);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all wwns:" + allWWN + ",errorCode:" + e.getErrorCode()), e.getErrorCode());
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("RealTime to query hyperMetro pair error! , all wwns:" + allWWN), (long)-1L, null, (Log)logger);
        }
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)("pairList is empty! pgName:" + protectGroup.getName() + ", allWWN:" + allWWN));
            throw new LegoCheckedException(-1L);
        }
        return pairList;
    }

    private Set<String> getAllStorageWWN(ProtectGroupReplica pgReplica) {
        HashSet<String> result = new HashSet<String>();
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                result.add(storage.getProtectObjectStorageWwn());
            }
        }
        return result;
    }

    private ProtectGroupReplica getProtectGroupReplica(ProtectGroup protectGroup, int templateType, ProtectGroupReplica pgReplica) {
        ProtectGroupReplica replica;
        if (templateType == 31 && null != (replica = protectGroup.getAnyoneReplicationReplica())) {
            return replica;
        }
        return pgReplica;
    }

    protected int getResourcetype(ProtectGroup protectGroup) {
        int type;
        block2: {
            Set polist = protectGroup.getPolist();
            if (VerifyUtil.isEmpty((Collection)polist)) {
                logger.error((Object)"The Set<ProtectObject> is null!");
                throw new LegoCheckedException(-1L);
            }
            Set allStorageInfo = ((ProtectObject)CommonUtil.getFirstElement((Collection)polist)).getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)allStorageInfo)) {
                logger.error((Object)"The Set<ProtectObjectStorageInfo> is null!");
                throw new LegoCheckedException(-1L);
            }
            type = 1;
            Iterator iterator = allStorageInfo.iterator();
            if (!iterator.hasNext()) break block2;
            ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)iterator.next();
            type = posi.getResourceType();
        }
        return type;
    }

    private void checkNasHyperMetro(List<ProtectionRelation> relationList) {
        HashSet<String> result = new HashSet<String>();
        String devSn = ((ProtectionRelation)CommonUtil.getFirstElement(relationList)).getSrcResourceProviderSn();
        for (ProtectionRelation relation : relationList) {
            result.add(relation.getSrcResourceId());
        }
        this.checkNasHyperMetro(devSn, devSn, new ArrayList<String>(result));
    }

    private void checkNasHyperMetro(String storageDevSn, String productDevSn, List<String> fileSystemIds) {
        HyperMetroPair pair;
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List pairList = null;
        try {
            pairList = storageResourceService.getHyperMetroPairByFileSystems(storageDevSn, fileSystemIds, null, Boolean.valueOf(true));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all fileSystemIds:" + fileSystemIds + ",errorCode:" + e.getErrorCode()), e.getErrorCode());
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("RealTime to query hyperMetro pair error! , all fileSystemIds:" + fileSystemIds), (long)-1L, null, (Log)logger);
        }
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)("pairList is empty!  fileSystemIds:" + fileSystemIds));
            throw new LegoCheckedException(-1L);
        }
        Iterator iterator = pairList.iterator();
        while (iterator.hasNext() && (pair = (HyperMetroPair)iterator.next()).getDevSn().equals(productDevSn)) {
            Integer syncDirection = pair.getSyncDirection();
            if (VerifyUtil.isEmpty((Object)syncDirection)) {
                logger.error((Object)("The syncDirection is null! pairId:" + pair.getId()));
                throw new LegoCheckedException(-1L);
            }
            if (!String.valueOf(XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_REMOTE_TO_LOCAL.getValue()).equals(String.valueOf(syncDirection)) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState())) continue;
            logger.warn((Object)("hyper metro pair :" + pair.getId() + " pair devsn :" + pair.getDevSn() + " ,execute pg array :" + productDevSn + ", syncDirection:" + syncDirection));
            throw new LegoCheckedException(1073948228L);
        }
    }

    private void checkNasHyperMetro(ProtectGroupReplica pgReplica) {
        ArrayList<String> fileSystemIds = new ArrayList<String>();
        HashSet<String> result = new HashSet<String>();
        String srcDevsn = this.getSrcDevSN(pgReplica, result);
        fileSystemIds.addAll(result);
        this.checkNasHyperMetro(srcDevsn, pgReplica.getProductArray(), fileSystemIds);
    }

    private String getSrcDevSN(ProtectGroupReplica pgReplica, Set<String> result) {
        String srcDevSn = null;
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                result.add(storage.getSrcStorageId());
                srcDevSn = storage.getSrcStorageProviderSN();
            }
        }
        return srcDevSn;
    }

    public void checkLunPairStatus(ProtectGroup protectGroup) {
        logger.debug((Object)"checkLunPairStatus when create lun snapshot");
        Set protectObjects = protectGroup.getPolist();
        if (11 != ((ProtectObject)protectObjects.iterator().next()).getPoType()) {
            return;
        }
        String tgtDeviceSn = protectGroup.getPoProviderSN();
        List<String> lunIds = this.getLunIdsByPO(protectObjects);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("tgtDevSN", tgtDeviceSn);
        props.put("tgtLunId", lunIds.toArray());
        List tgtLuns = moDao.findMoBy(ReplicationTargetLun.class, props);
        if (VerifyUtil.isEmpty((Collection)tgtLuns)) {
            return;
        }
        for (ProtectObject po : protectObjects) {
            Set resourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : resourceSet) {
                ReplicationTargetLun lun;
                List<ReplicationTargetLun> luns;
                String lunId = storageInfo.getResourceId();
                ReplicationTargetLun tgtLun = this.getTargetLuns(tgtLuns, lunId, tgtDeviceSn);
                if (null == tgtLun || VerifyUtil.isEmpty(luns = this.querySyncStatus(tgtLun, tgtDeviceSn)) || 2 != (lun = luns.get(0)).getPairStatus() && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != lun.getPairStatus().intValue()) continue;
                logger.info((Object)("lun is synchronizing, can not create snapshot. lunId=" + lunId));
                throw new LegoCheckedException(1073948248L);
            }
        }
    }

    private List<String> getLunIdsByPO(Set<ProtectObject> protectObjects) {
        ArrayList<String> lunIds = new ArrayList<String>();
        for (ProtectObject po : protectObjects) {
            Set resourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : resourceSet) {
                lunIds.add(storageInfo.getResourceId());
            }
        }
        return lunIds;
    }

    private ReplicationTargetLun getTargetLuns(List<ReplicationTargetLun> tgtLuns, String tgtLunId, String tgtDevSn) {
        for (ReplicationTargetLun tgtLun : tgtLuns) {
            if (!tgtLunId.equals(tgtLun.getTgtLunId()) || !tgtDevSn.equals(tgtLun.getTgtDevSN()) || !tgtLun.getTgtDevSN().equals(tgtLun.getDevSn())) continue;
            return tgtLun;
        }
        return null;
    }

    private List<ReplicationTargetLun> querySyncStatus(ReplicationTargetLun tgtLun, String tgtDeviceSn) {
        try {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            return proxy.querySyncStatus(tgtLun.getDevSn(), tgtDeviceSn, tgtLun.getReplicationPairId(), false);
        }
        catch (LegoCheckedException e) {
            return null;
        }
    }

    public void checkReplicationPair(ProtectGroup protectGroup, ActionContext context) {
        int templateType = protectGroup.getTemplate().getType();
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(templateType)) {
            return;
        }
        int location = NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION"));
        if (location == DrmEnumDefine.ProtectLocation.A_A.getValue() || location == DrmEnumDefine.ProtectLocation.A_B.getValue()) {
            return;
        }
        ProtectGroupReplica pgReplica = Optional.ofNullable((ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY")).map(replica -> protectGroup.getReplicationReplicaByRecoverySiteId(replica.getRecoverySite())).orElse(null);
        if (Objects.isNull(pgReplica)) {
            return;
        }
        boolean isAirGap = RecoveryTaskUtil.isAirGapSite((String)protectGroup.getPoProviderSN());
        List<ReplicationPair> pairList = this.getReplicationPairs(pgReplica, isAirGap);
        if (VerifyUtil.isEmpty(pairList)) {
            logger.error((Object)("pairList size error! pgName:" + protectGroup.getName()));
            throw new LegoCheckedException(1073948677L, new String[]{this.getLostPairId(pgReplica, pairList)});
        }
        Set<String> pairIds = this.getReplicationPairIds(pgReplica);
        for (ReplicationPair pair : pairList) {
            if (!pairIds.contains(pair.getReplicationId()) || this.isReplicationPairHealthStatusOK(pair)) continue;
            logger.error((Object)"pair status is not allowed.");
            throw new LegoCheckedException(1073948729L);
        }
    }

    private boolean isReplicationPairHealthStatusOK(ReplicationPair pair) {
        try {
            Integer runningState = Integer.valueOf(pair.getRunningState());
            ArrayList<Integer> errorRunningStateList = new ArrayList<Integer>();
            errorRunningStateList.add(XveEuumDefineParent.RUNNING_STATUS_E.INVALID.getValue());
            errorRunningStateList.add(ReplicationConstantDefine.PairStatus.INVALID.getValue());
            errorRunningStateList.add(2);
            errorRunningStateList.add(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue());
            if (errorRunningStateList.contains(runningState)) {
                logger.info((Object)"Pair running state error: %s, ID:%s", new Object[]{runningState.toString(), pair.getReplicationId()});
                return false;
            }
            Integer healthState = Integer.valueOf(pair.getHealthState());
            if (healthState.equals(6) || healthState.equals(XveEuumDefineParent.HEALTH_STATUS_E.FAULT.getValue())) {
                logger.info((Object)"Pair health state error: %s, ID:%s", new Object[]{healthState.toString(), pair.getReplicationId()});
                return false;
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Lun's healthState is error. healthState:%s, runningState:%s", new Object[]{pair.getHealthState(), pair.getRunningState()});
        }
        return true;
    }

    private String getLostPairId(ProtectGroupReplica pgReplica, List<ReplicationPair> pairList) {
        HashSet<String> pairIdList = new HashSet<String>();
        if (pairList != null) {
            for (ReplicationPair replicationPair : pairList) {
                pairIdList.add(replicationPair.getReplicationId());
            }
        }
        StringBuilder lostPairIds = new StringBuilder();
        for (ProtectObjectReplica replica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : replica.getStorageInfos()) {
                String pairId = ((RemoteStorageReplica)storageInfo).getReplicationPairId();
                if (pairIdList.contains(pairId)) continue;
                lostPairIds.append(lostPairIds.length() == 0 ? pairId : ", " + pairId);
            }
        }
        return lostPairIds.toString();
    }

    private Set<String> getReplicationPairIds(ProtectGroupReplica pgReplica) {
        HashSet<String> set = new HashSet<String>();
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                if (!(storage instanceof RemoteStorageReplica)) continue;
                RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)storage;
                set.add(remoteStorageReplica.getReplicationPairId());
            }
        }
        return set;
    }

    private List<ReplicationPair> getReplicationPairs(ProtectGroupReplica pgReplica, boolean isAirGap) {
        List pairList;
        HashSet<String> lunIds = new HashSet<String>();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        if (isAirGap) {
            String devSn = this.getProviderInfoByPgReplica(pgReplica, lunIds);
            pairList = storageService.getReplicationPairsByResourceIds(devSn, lunIds, false, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        } else {
            String devSn = this.getSrcDevSN(pgReplica, lunIds);
            pairList = storageService.getReplicationPairsByResourceIds(devSn, new ArrayList<String>(lunIds), Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        }
        return pairList;
    }

    private String getProviderInfoByPgReplica(ProtectGroupReplica pgReplica, Set<String> result) {
        String srcDevSn = null;
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                result.add(storage.getStorageId());
                srcDevSn = storage.getStorageProviderSN();
            }
        }
        return srcDevSn;
    }

    public long invokeProductSiteMethod(String productSiteId, String url, String message, Map<String, String> uriVariables, HttpMethod method) {
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productSiteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"Recovery Site is not exsit", 90160758786989L);
            throw new LegoCheckedException(1073947440L);
        }
        String errorMsg = "To invoke product site method failed, name: " + site.getName() + " ,id: " + site.getSiteId() + " error";
        String responseStr = ProtectGroupSynchronizer.getInstance().protectGroupInvokeMethod(site, url, message, uriVariables, method, errorMsg);
        return this.extractTaskId(responseStr);
    }

    private long extractTaskId(String responseStr) {
        if (responseStr == null) {
            LegoCheckedException err = new LegoCheckedException(-1L);
            logger.error((Object)"extract taskId failed!", (Throwable)err, 90160758787071L);
            throw err;
        }
        JSONObject object = JSONObject.fromObject((Object)responseStr);
        Object taskId = object.get("taskId");
        if (taskId == null) {
            LegoCheckedException err = new LegoCheckedException(-1L);
            logger.error((Object)"taskId is null!", (Throwable)err, 90160758787071L);
            throw err;
        }
        try {
            long backtaskId = Long.parseLong(taskId.toString());
            return backtaskId;
        }
        catch (NumberFormatException e) {
            logger.error((Object)"string type format to long type error!", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException("string type format to long type error!", (Throwable)e);
        }
    }

    public boolean isFullBackup(Map<String, Object> parameter) {
        if (null == parameter) {
            return false;
        }
        Boolean result = (Boolean)parameter.get("fullBackup");
        return null != result && result != false;
    }
}

