/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshot;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailResourceLockUtil;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.protection.framework.service.group.RefreshProtectGroupBackTask;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ApplicationRefreshProtectGroupBackTask
extends RefreshProtectGroupBackTask {
    private static final Log LOGGER = LogFactory.getInstance(ApplicationRefreshProtectGroupBackTask.class);
    private static final String STORAGE_IDS = "StorageIds";

    public ApplicationRefreshProtectGroupBackTask(IProtectGroupBaseService service, ProtectGroup protectGroup) {
        super(service, protectGroup);
    }

    protected void doInTransaction(HibernateTemplate template) {
        this.service.getProtectObjectProvider((Object)this.protectGroup.getPoType()).refreshProtectGroup(this.protectGroup);
        if (supportPtTransferList.contains(this.protectGroup.getTemplate().getType())) {
            template.saveOrUpdate((Object)this.protectGroup.getTemplate());
        }
        template.saveOrUpdate((Object)this.protectGroup);
        this.refreshSnapshots(this.protectGroup.getPoProviderSN());
    }

    private void refreshSnapshots(String devSn) {
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (!resource.getIsAirGapResource().booleanValue()) {
            return;
        }
        IStorageSnapshotScheduleManager manager = this.getSnapshotScheduleManager(devSn);
        if (manager.getSnapshotType() == SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue()) {
            LOGGER.info((Object)"Refresh snapshots by hyperCDP consistent group.");
            this.updateSnapshotsByHyperCdpCg(devSn, manager);
        } else {
            LOGGER.info((Object)"Refresh other snapshots.");
            this.updateSnapshots(devSn, manager);
        }
    }

    private IStorageSnapshotScheduleManager getSnapshotScheduleManager(String devSn) {
        int snapshotType = ScheduleProtectedType.SNAPSHOT.getValue();
        String lunConsistentGroupId = (String)this.protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn);
        if (!VerifyUtil.isEmpty((String)lunConsistentGroupId)) {
            snapshotType = ScheduleProtectedType.HYPERCDP.getValue();
        }
        return StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, snapshotType);
    }

    private void updateSnapshots(String devSn, IStorageSnapshotScheduleManager manager) {
        HashSet<String> storageSnapshotIds = new HashSet<String>();
        Set schedules = this.protectGroup.getTemplate().getSchedules();
        for (Schedule schedule : schedules) {
            Set snapshotIds = manager.getProtectGroupSnapshotIds(this.protectGroup, devSn, schedule);
            if (VerifyUtil.isEmpty((Collection)snapshotIds)) continue;
            storageSnapshotIds.addAll(snapshotIds);
        }
        int templateType = this.protectGroup.getTemplate().getType();
        if (templateType == 46) {
            this.updateAntiBlackmailSnapshots(storageSnapshotIds);
        } else {
            this.updateSnapshotsInDb(storageSnapshotIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAntiBlackmailSnapshots(Set<String> storageSnapshotIds) {
        Map<String, List<AntiBlackmailSnapshot>> replicaSnapshotsMap = AntiBlackmailUtil.queryPgAntiBlackmailSnapshot(this.protectGroup, storageSnapshotIds);
        LOGGER.info((Object)"Lock replicas for refreshing protect group(name: %s).", new Object[]{this.protectGroup.getName()});
        Set<String> lockedReplicaIdSet = AntiBlackmailResourceLockUtil.lockReplicasInPg(this.protectGroup);
        try {
            this.refreshAntiBlackmailReplicas(replicaSnapshotsMap, lockedReplicaIdSet);
        }
        catch (Throwable throwable) {
            LOGGER.info((Object)"Unlock replicas for refreshing protect group(name: %s).", new Object[]{this.protectGroup.getName()});
            AntiBlackmailResourceLockUtil.unlockReplicas(lockedReplicaIdSet);
            throw throwable;
        }
        LOGGER.info((Object)"Unlock replicas for refreshing protect group(name: %s).", new Object[]{this.protectGroup.getName()});
        AntiBlackmailResourceLockUtil.unlockReplicas(lockedReplicaIdSet);
    }

    private void refreshAntiBlackmailReplicas(Map<String, List<AntiBlackmailSnapshot>> replicaSnapshotsMap, Set<String> lockedReplicaIdSet) {
        Set pgReplicas = this.protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)pgReplicas)) {
            LOGGER.error((Object)"No replicas need to refresh, pg name: %s.", new Object[]{this.protectGroup.getName()});
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        Set<String> currentPoIdSet = this.protectGroup.getPolist().stream().map(DRMObject::getUuid).collect(Collectors.toSet());
        for (ProtectGroupReplica replica : pgReplicas) {
            if (!lockedReplicaIdSet.contains(replica.getId()) || !replica.isStorageSnapshotReplica()) continue;
            String replicaId = replica.getId();
            if (!replicaSnapshotsMap.containsKey(replicaId)) {
                AntiBlackmailUtil.dealNonExistentReplica(replica, currentPoIdSet, replicaService);
                continue;
            }
            AntiBlackmailUtil.refreshSinglePgReplica(replica, replicaSnapshotsMap, currentPoIdSet);
        }
    }

    private void updateSnapshotsInDb(Set<String> storageSnapshotIds) {
        Set pgReplicas = this.protectGroup.getReplicaList();
        for (ProtectGroupReplica replica : pgReplicas) {
            if (!replica.isStorageSnapshotReplica()) continue;
            if (!this.checkReplicaIsValid(replica, storageSnapshotIds)) {
                LOGGER.info((Object)"Delete invalid protectGroup Replica(ReplicaName: %s).", new Object[]{replica.getName()});
                ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).deleteProtectGroupReplicaById(replica.getId());
                continue;
            }
            ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).saveOrUpdateReplica(replica);
        }
    }

    private boolean checkReplicaIsValid(ProtectGroupReplica replica, Set<String> storageSnapshotIds) {
        boolean isValid = false;
        Set poReplicas = replica.getReplicas();
        Iterator iterator = poReplicas.iterator();
        while (iterator.hasNext()) {
            ProtectObjectReplica poReplica = (ProtectObjectReplica)iterator.next();
            Set replicaStorageInfos = poReplica.getStorageInfos();
            replicaStorageInfos.removeIf(replicaStorageInfo -> !storageSnapshotIds.contains(replicaStorageInfo.getStorageId()));
            if (replicaStorageInfos.size() > 0) {
                isValid = true;
                continue;
            }
            iterator.remove();
        }
        if (!isValid) {
            LOGGER.info((Object)"ReplicaName: %s is not valid because its snapshots in storage are not exits.", new Object[]{replica.getName()});
        }
        return isValid;
    }

    private void updateSnapshotsByHyperCdpCg(String devSn, IStorageSnapshotScheduleManager manager) {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("pageNum", String.valueOf(1));
        conditions.put("pageSize", String.valueOf(1000));
        conditions.put("startTime", "null");
        conditions.put("endTime", "null");
        Set schedules = this.protectGroup.getTemplate().getSchedules();
        ArrayList<ProtectGroupReplica> replicasInStorage = new ArrayList<ProtectGroupReplica>();
        for (Schedule schedule : schedules) {
            List tmpReplicas = manager.getProtectGroupReplica(this.protectGroup, devSn, schedule, conditions);
            replicasInStorage.addAll(tmpReplicas);
        }
        List pgReplicas = ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).queryProtectGroupReplicaByGroup(this.protectGroup.getUuid(), "TIME_STAMP", false, true);
        this.updateSecureSnapshotInDb(pgReplicas, replicasInStorage);
    }

    private void updateSecureSnapshotInDb(List<ProtectGroupReplica> pgReplicas, List<ProtectGroupReplica> replicasInStorage) {
        if (VerifyUtil.isEmpty(pgReplicas)) {
            return;
        }
        Set<String> storageIds = this.getStorageSnapshotIds(replicasInStorage);
        for (ProtectGroupReplica replica : pgReplicas) {
            if (replica.getType() != 102) continue;
            Map props = replica.getProps();
            if (!props.containsKey(STORAGE_IDS)) {
                LOGGER.error((Object)"Error not find StorageId");
                return;
            }
            String storageId = (String)props.get(STORAGE_IDS);
            if (!CollectionUtils.isEmpty(storageIds) && storageIds.contains(storageId)) continue;
            LOGGER.info((Object)"replicaName: %s, storageId: %s is not matched secure snapshot in storage.", new Object[]{storageId, replica.getName()});
            ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).deleteProtectGroupReplicaById(replica.getId());
        }
    }

    private Set<String> getStorageSnapshotIds(List<ProtectGroupReplica> replicas) {
        if (CollectionUtils.isEmpty(replicas)) {
            LOGGER.info((Object)"Not find secure snapshot.");
            return Collections.emptySet();
        }
        HashSet<String> storageIds = new HashSet<String>();
        for (ProtectGroupReplica replica : replicas) {
            Map props = replica.getProps();
            if (!props.containsKey(STORAGE_IDS)) continue;
            String storageId = (String)props.get(STORAGE_IDS);
            storageIds.add(storageId);
        }
        return storageIds;
    }
}

