/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupSynchronizer;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ProtectGroupExtendUtil {
    private static Log logger = LogFactory.getInstance(ProtectGroupExtendUtil.class);
    private static ProtectGroupExtendUtil instance = new ProtectGroupExtendUtil();
    private static List<Integer> asynReplicationRelatedTemplateTypeList = Arrays.asList(20, 4, 3, 6, 5, 18, 1, 30, 31, 32, 35, 36, 58, 59, 40, 41, 42, 43, 44, 48, 45, 46);

    public static ProtectGroupExtendUtil getInstance() {
        return instance;
    }

    public static Set<RemoteStorageReplica> getAllRemoteStorageReplica(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList())) {
            return Collections.emptySet();
        }
        return protectGroup.getReplicaList().stream().flatMap(pgReplica -> pgReplica.getReplicas().stream()).flatMap(poReplica -> poReplica.getStorageInfos().stream()).filter(storageInfo -> storageInfo instanceof RemoteStorageReplica).map(storageInfo -> (RemoteStorageReplica)storageInfo).collect(Collectors.toSet());
    }

    public static boolean isReplicationTemplate(int type) {
        return asynReplicationRelatedTemplateTypeList.contains(type);
    }

    public long invokeProductSiteMethod(String productSiteId, String url, String message, Map<String, String> uriVariables, HttpMethod method) {
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productSiteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"Recovery Site is not exsit", 90160758786989L);
            throw new LegoCheckedException(1073947440L);
        }
        String errorMsg = "To invoke product site method failed, name: " + site.getName() + " ,id: " + site.getSiteId() + " error";
        String responseStr = ProtectGroupSynchronizer.getInstance().protectGroupInvokeMethod(site, url, message, uriVariables, method, errorMsg);
        return this.extractTaskId(responseStr);
    }

    public static boolean isSanAirGapPg(ProtectGroup protectGroup) {
        return Optional.ofNullable(protectGroup).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).map(template -> template == 44 || template == 48).orElse(false);
    }

    public static boolean isSecureSnapshot(ProtectGroup protectGroup) {
        Set schedules = Optional.ofNullable(protectGroup).map(ProtectGroup::getTemplate).map(PolicyTemplate::getSchedules).orElse(Collections.emptySet());
        return schedules.stream().map(Schedule::getProtectedType).anyMatch(type -> type == 102);
    }

    private long extractTaskId(String responseStr) {
        if (responseStr == null) {
            LegoCheckedException err = new LegoCheckedException(-1L);
            logger.error((Object)"extract taskId failed!", (Throwable)err, 90160758787071L);
            throw err;
        }
        JSONObject object = JSONObject.fromObject((Object)responseStr);
        Object taskId = object.get("taskId");
        if (taskId == null) {
            LegoCheckedException err = new LegoCheckedException(-1L);
            logger.error((Object)"taskId is null!", (Throwable)err, 90160758787071L);
            throw err;
        }
        try {
            long backtaskId = Long.parseLong(taskId.toString());
            return backtaskId;
        }
        catch (NumberFormatException e) {
            logger.error((Object)"string type format to long type error!", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException("string type format to long type error!", (Throwable)e);
        }
    }
}

