/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.provider;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.provider.AbstractProtectObjectProviderDelegateImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderBaseDelegate;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Service(name="com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderBaseDelegate", desc="", interfaceClass=IProtectObjectProviderBaseDelegate.class)
public class ProtectObjectProviderBaseDelegateImpl
extends AbstractProtectObjectProviderDelegateImpl
implements IProtectObjectProviderBaseDelegate {
    private static final Log logger = LogFactory.getInstance(ProtectObjectProviderBaseDelegateImpl.class);

    public ProtectObjectProviderBaseDelegateImpl() {
        this.providerList = new ConcurrentHashMap();
    }

    public void discoveryProtectObjectStorageInfo(int applicationType, ProtectObject po, Map<String, String> condition) {
        IProtectObjectBaseProvider provider = this.getProviderByAppType(applicationType);
        provider.updateProtectObjectProps(po, po.getProps());
        List storageInfoList = provider.getProtectObjectStorageInfo(po);
        this.checkAndInitStorageInfo(storageInfoList);
        if (null != storageInfoList && !storageInfoList.isEmpty()) {
            HashSet storageInfoSet = new HashSet();
            storageInfoSet.addAll(storageInfoList);
            po.setUsedStorageResourceSet(storageInfoSet);
            ProtectGroupHelper.getInstance().saveProtectObjectStorageInfo(new ProtectObject[]{po});
        }
    }

    private void checkAndInitStorageInfo(List<ProtectObjectStorageInfo> storageInfoList) {
        if (VerifyUtil.isEmpty(storageInfoList)) {
            logger.info((Object)"storageInfoList is null or empty");
            return;
        }
        int resourceProviderSNSize = storageInfoList.stream().map(ProtectObjectStorageInfo::getResourceProviderSN).collect(Collectors.toSet()).size();
        if (resourceProviderSNSize == 1) {
            logger.info((Object)"resourceProviderSNSize = 1");
            return;
        }
        Map<String, List<ProtectObjectStorageInfo>> lunWWNStorageInfoMap = this.initLunWWNStorageInfoMap(storageInfoList);
        String[] lunWWNStrs = new String[lunWWNStorageInfoMap.size()];
        lunWWNStorageInfoMap.keySet().toArray(lunWWNStrs);
        List lunResourcesList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(lunWWNStrs);
        if (VerifyUtil.isEmpty((Collection)lunResourcesList)) {
            logger.info((Object)"lunResourcesList is null or empty");
            return;
        }
        Map<String, List<Lun>> lunWWNLunListMap = this.initLunWWNLunListMap(lunResourcesList);
        this.initResourceProSNAndResourceId(lunWWNStorageInfoMap, lunWWNLunListMap);
    }

    private void initResourceProSNAndResourceId(Map<String, List<ProtectObjectStorageInfo>> lunWWNStorageInfoMap, Map<String, List<Lun>> lunWWNLunListMap) {
        Set providers = lunWWNLunListMap.values().stream().filter(e -> e.size() == 1).map(e -> ((Lun)e.get(0)).getDevSn()).collect(Collectors.toSet());
        List<List> lunsCollection = lunWWNLunListMap.values().stream().filter(e -> e.size() > 1).collect(Collectors.toList());
        lunsCollection.forEach(items -> {
            Lun lun = items.stream().filter(item -> providers.contains(item.getDevSn())).findFirst().orElseGet(() -> {
                Lun item = (Lun)items.get(0);
                providers.add(item.getDevSn());
                return item;
            });
            this.setResourceProSNAndResourceId((List)lunWWNStorageInfoMap.get(lun.getWwn()), lun);
        });
    }

    private void setResourceProSNAndResourceId(List<ProtectObjectStorageInfo> storageInfoList, Lun lun) {
        for (ProtectObjectStorageInfo storageInfo : storageInfoList) {
            storageInfo.setResourceProviderSN(lun.getDevSn());
            storageInfo.setResourceId(lun.getResourceId());
        }
    }

    private Map<String, List<ProtectObjectStorageInfo>> initLunWWNStorageInfoMap(List<ProtectObjectStorageInfo> storageInfoList) {
        HashMap<String, List<ProtectObjectStorageInfo>> lunWWNStorageInfoMap = new HashMap<String, List<ProtectObjectStorageInfo>>();
        for (ProtectObjectStorageInfo storageInfo : storageInfoList) {
            List<ProtectObjectStorageInfo> storageInfoListIn;
            String lunWWN = storageInfo.getLunWWN();
            if (!lunWWNStorageInfoMap.containsKey(lunWWN)) {
                storageInfoListIn = new ArrayList();
                lunWWNStorageInfoMap.put(lunWWN, storageInfoListIn);
            } else {
                storageInfoListIn = (List)lunWWNStorageInfoMap.get(lunWWN);
            }
            storageInfoListIn.add(storageInfo);
        }
        return lunWWNStorageInfoMap;
    }

    private Map<String, List<Lun>> initLunWWNLunListMap(List<StorageResource> lunResourcesList) {
        HashMap<String, List<Lun>> lunWWNLunListMap = new HashMap<String, List<Lun>>();
        for (StorageResource storageResources : lunResourcesList) {
            List<Lun> lunList;
            if (!Lun.class.isInstance(storageResources)) {
                logger.info((Object)"storageResources is not Lun");
                continue;
            }
            Lun lun = (Lun)Lun.class.cast(storageResources);
            String lunWWN = lun.getWwn();
            if (!lunWWNLunListMap.containsKey(lunWWN)) {
                lunList = new ArrayList();
                lunWWNLunListMap.put(lunWWN, lunList);
            } else {
                lunList = (List)lunWWNLunListMap.get(lunWWN);
            }
            lunList.add(lun);
        }
        return lunWWNLunListMap;
    }
}

