/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.impl;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.drm.protection.framework.service.replica.retention.impl.AbstractReplicaRetentionHandler;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class CountReplicaRetentionHandler
extends AbstractReplicaRetentionHandler {
    private static final Log LOGGER = LogFactory.getInstance(CountReplicaRetentionHandler.class);
    private static final Set<Integer> RETENTION_FILTER = ImmutableSet.of((Object)2, (Object)14, (Object)19, (Object)17, (Object)28, (Object)30, (Object[])new Integer[]{31, 32, 33, 40, 41, 42, 43, 44, 48, 45});

    public boolean checkReplicaStrategy(ProtectGroup pg) {
        if (!RETENTION_FILTER.contains(pg.getTemplate().getType())) {
            LOGGER.info((Object)"Template type not support: %s", new Object[]{String.valueOf(pg.getTemplate().getType())});
            return false;
        }
        return true;
    }

    public List<ProtectGroupReplica> getToReactivateReplicas(ProtectGroup protectGroup, int i, Integer integer, Integer integer1) {
        return null;
    }

    @Override
    protected List<ProtectGroupReplica> getToDeleteReplicas(RetentionPolicy strategy, Schedule schedule, Set<ProtectGroupReplica> replicas, Set<String> usedReplicaIds, Integer differ) {
        if (schedule.getProtectedType() == 102 || schedule.isNeedSecureSnapshot().booleanValue()) {
            return this.getToDeleteSecureReplicas(replicas, usedReplicaIds, schedule);
        }
        return this.getToDeleteNormalReplicas(strategy, schedule, replicas, usedReplicaIds, differ);
    }

    @Override
    protected List<ProtectGroupReplica> getToDeleteSecureReplicas(Set<ProtectGroupReplica> replicas, Set<String> usedReplicaIds, Schedule schedule) {
        ArrayList<ProtectGroupReplica> toDeleteReplicas = new ArrayList<ProtectGroupReplica>();
        long curTime = System.currentTimeMillis();
        for (ProtectGroupReplica replica : replicas) {
            long timeStamp;
            if (!replica.isStorageSnapshotReplica() || !this.isSecureReplica(replica, schedule) || VerifyUtil.isEmpty((String)replica.getDeadlineTimeStamp()) || curTime < (timeStamp = Long.parseLong(replica.getDeadlineTimeStamp()))) continue;
            toDeleteReplicas.add(replica);
        }
        this.handleUsedReplicas(usedReplicaIds, toDeleteReplicas);
        return toDeleteReplicas;
    }

    private boolean isSecureReplica(ProtectGroupReplica replica, Schedule schedule) {
        boolean isNasAirGap = Optional.ofNullable(replica.getPg()).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).equals(Optional.of(45));
        if (isNasAirGap && schedule.isNeedSecureSnapshot().booleanValue()) {
            return true;
        }
        return replica.getType() == 102;
    }
}

