/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.template.manager;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager", desc="", interfaceClass=IPolicyTemplateManager.class)
public class PolicyTemplateManagerImpl
extends BaseService
implements IPolicyTemplateManager {
    private static final Log logger = LogFactory.getInstance(PolicyTemplateManagerImpl.class);
    private static final Map<Integer, String[]> SKETCH_FOR_4DC = new HashMap<Integer, String[]>(){
        {
            this.put(35, new String[]{"policy_template_35_cascaded_aa_0.png", "policy_template_35_cascaded_aa_1.png", "policy_template_35_cascaded_aa_2.png"});
            this.put(36, new String[]{"policy_template_36_concurrent_aa_0.png", "policy_template_36_concurrent_aa_1.png", "policy_template_36_concurrent_aa_2.png"});
            this.put(58, new String[]{"policy_template_58_cascaded_aa_0.png", "policy_template_58_cascaded_aa_1.png", "policy_template_58_cascaded_aa_2.png"});
            this.put(59, new String[]{"policy_template_59_concurrent_aa_0.png", "policy_template_59_concurrent_aa_1.png", "policy_template_59_concurrent_aa_2.png"});
        }
    };
    private IBaseDao<Object, Serializable> baseDao;

    public IBaseDao<Object, Serializable> getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(IBaseDao<Object, Serializable> baseDao) {
        this.baseDao = baseDao;
    }

    public void addTemplate(PolicyTemplate policyTemplate) {
        if (null == policyTemplate) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (this.isSystemDefinePtExsist(policyTemplate) && policyTemplate.getIsSystemDefine().booleanValue()) {
            logger.error((Object)("addSystemDefineTemplate failed policytemplate already Exist ptId" + policyTemplate.getPtId()), 90160758784001L);
            return;
        }
        try {
            this.baseDao.save((Object)policyTemplate);
        }
        catch (DataAccessException e) {
            logger.error((Object)"addSystemDefineTemplate failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public List<PolicyTemplate> getAllTemplate(long userId) {
        List list;
        String hql = "from PolicyTemplate as pt  where pt.isSystemDefine=? order by pt.type";
        Session session = null;
        try {
            List templates;
            session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
            Query query = session.createQuery(hql);
            query.setParameter(0, (Object)true);
            list = templates = query.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"get all PolicyTemplate failed", 90160758784001L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return list;
    }

    public void updateTemplate(PolicyTemplate policyTemplate) {
        if (null == policyTemplate) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        for (Schedule schedule : policyTemplate.getSchedules()) {
            PolicyTemplateTools.getInstance().checkSchedule(schedule);
        }
        try {
            if (policyTemplate.getType() == 11) {
                this.baseDao.getHibernateTemplate().saveOrUpdate((Object)policyTemplate);
            } else {
                this.baseDao.getHibernateTemplate().merge((Object)policyTemplate);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"update PolicyTemplate failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public Page pageQueryPolicyTemplate(int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props, long userId) {
        List criterionList = this.getBaseDao().translatePropsToCriterions(props);
        List list = this.getBaseDao().createCriteria(PolicyTemplate.class, orderBy, isAsc, criterionList.toArray(new Criterion[criterionList.size()]));
        return Page.createPage((int)pageNo, (int)pageSize, (List)list);
    }

    public boolean isSystemDefinePtExsist(PolicyTemplate policyTemplate) {
        List policyTemplates = null;
        String hql = "from PolicyTemplate as pt where pt.type=? and pt.isSystemDefine=?";
        try {
            policyTemplates = this.baseDao.getHibernateTemplate().find(hql, new Object[]{policyTemplate.getType(), true});
        }
        catch (DataAccessException e) {
            logger.error((Object)"get isSystemDefinePt failed", 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return !VerifyUtil.isEmpty((Collection)policyTemplates);
    }

    public PolicyTemplate getPtByUuid(String uuid) {
        if (null == uuid) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate dbPolicyTemplate = null;
        try {
            dbPolicyTemplate = (PolicyTemplate)this.baseDao.getHibernateTemplate().get(PolicyTemplate.class, (Serializable)((Object)uuid));
        }
        catch (DataAccessException e) {
            logger.error((Object)("get PolicyTemplate by uuid failed, PolicyTemplate uuid=" + uuid), (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        this.fillProps(dbPolicyTemplate);
        this.filterSensitiveParam(dbPolicyTemplate);
        this.resetSketch(uuid, dbPolicyTemplate);
        return dbPolicyTemplate;
    }

    private void resetSketch(String uuid, PolicyTemplate dbPolicyTemplate) {
        List siteInfoList;
        Optional<SiteInfo> hyperOptional;
        String siteInfoListStr;
        List valueList;
        boolean is4DCAsyncAndAsync;
        if (dbPolicyTemplate == null) {
            logger.debug((Object)"dbPolicyTemplate is null,not resetSketch.");
            return;
        }
        boolean is4DCAsyncAndSync = dbPolicyTemplate.getType() == 58 || dbPolicyTemplate.getType() == 59;
        boolean bl = is4DCAsyncAndAsync = dbPolicyTemplate.getType() == 35 || dbPolicyTemplate.getType() == 36;
        if ((is4DCAsyncAndAsync || is4DCAsyncAndSync) && !VerifyUtil.isEmpty((Collection)(valueList = CommonDAOLocator.getMoDao().executeNativeSql("select p.PROPVALUE from ti_policytemplate t left join ti_protectgroup g  on g.PTID = t.PTID left join ti_protectgroup_prop p on p.PGID = g.PGID where t.PTID = ?  and p.PROPNAME = 'PROP_KEY_SITE_INFO'", new Object[]{uuid}))) && null != (siteInfoListStr = (String)valueList.stream().findFirst().orElse(null)) && (hyperOptional = (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).stream().filter(siteInfo -> siteInfo.getSiteIdSet().size() >= 2).findFirst()).isPresent()) {
            SiteInfo hyperSiteInfo = hyperOptional.get();
            int index = siteInfoList.indexOf(hyperSiteInfo);
            int addIndex = this.addIndex(dbPolicyTemplate);
            dbPolicyTemplate.setSketch(SKETCH_FOR_4DC.get(dbPolicyTemplate.getType())[index += addIndex]);
        }
    }

    private int addIndex(PolicyTemplate dbPolicyTemplate) {
        Optional<Schedule> asyncSchedule;
        String replicationMode;
        if (dbPolicyTemplate.getType() == 58 && !VerifyUtil.isEmpty((String)(replicationMode = (String)(asyncSchedule = dbPolicyTemplate.getSchedules().stream().filter(s -> s.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_B.getValue()).findFirst()).map(s -> (String)s.getExtParameters().get("replicationMode")).orElse(null))) && Objects.equals(replicationMode, String.valueOf(2))) {
            return 1;
        }
        return 0;
    }

    private void fillProps(PolicyTemplate dbPolicyTemplate) {
        if (dbPolicyTemplate == null) {
            logger.debug((Object)"dbPolicyTemplate is null,not fillProps.");
            return;
        }
        Map props = dbPolicyTemplate.getProps();
        String prStr = (String)props.get("protectionRelation");
        if (!VerifyUtil.isEmpty((String)prStr)) {
            if (dbPolicyTemplate.getType() == 28) {
                List<ProtectionRelation> protectionRelations = ProtectionRelationJsonConverter.toProtectionRelationList(prStr);
                props.put("protectionRelation", ProtectionRelationJsonConverter.toJsonStr(protectionRelations, false));
            } else {
                ProtectionRelation protectionRelation = ProtectionRelationJsonConverter.toProtectionRelation(prStr);
                props.put("protectionRelation", ProtectionRelationJsonConverter.toJsonStr(protectionRelation, false));
            }
        }
    }

    public void deleteTemplate(String uuid) {
        PolicyTemplate pt = this.getPtByUuid(uuid);
        if (null == pt) {
            logger.error((Object)"template does not exist", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        if (pt.getIsSystemDefine().booleanValue()) {
            logger.error((Object)("can't delete isSystemDefinePt, ptId=" + pt.getPtId() + "ptName" + pt.getName()), 90160758784001L);
        }
        try {
            this.getBaseDao().getHibernateTemplate().delete((Object)pt);
        }
        catch (DataAccessException e) {
            logger.error((Object)("delete policytemplate failed ptId=" + pt.getPtId()), (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void filterSensitiveParam(PolicyTemplate dbPolicyTemplate) {
        if (dbPolicyTemplate == null) {
            logger.debug((Object)"dbPolicyTemplate is null,not fillProps.");
            return;
        }
        dbPolicyTemplate.getSchedules().forEach(ScriptParamsUtils::filterSensitiveParams);
    }

    public PolicyTemplate clonePolicyTemlate(int type) {
        logger.debug((Object)("clonePolicyTemlate type:" + type));
        for (PolicyTemplate pt : this.getAllTemplate(0L)) {
            if (pt.getType() != type) continue;
            try {
                return (PolicyTemplate)pt.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)("Cloning template failed. Type:" + type), 90160758784001L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        logger.error((Object)("Cloning template failed. Type:" + type), 90160758784001L);
        throw new LegoCheckedException(-1L);
    }

    public String getPtByTemplateType(int templateType) {
        if (templateType < 0) {
            logger.error((Object)"invalid parameter, templateType less than 0", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        List policyTemplates = null;
        String hql = "from PolicyTemplate as pt where pt.type=?";
        try {
            policyTemplates = this.baseDao.getHibernateTemplate().find(hql, new Object[]{templateType});
        }
        catch (DataAccessException e) {
            logger.error((Object)("get PolicyTemplate by templateType failed, PolicyTemplate templateType=" + templateType), 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return !VerifyUtil.isEmpty((Collection)policyTemplates) ? ((PolicyTemplate)policyTemplates.get(0)).getUuid() : null;
    }
}

